/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea;

import com.intellij.util.Consumer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidTextUtils {
    private AndroidTextUtils() {
    }

    @NotNull
    public static String generateCommaSeparatedList(@NotNull Collection<String> items, @NotNull String lastSeparator) {
        int n = items.size();
        if (n == 0) {
            return "";
        }
        int i = 0;
        StringBuilder result = new StringBuilder();
        for (String word : items) {
            result.append(word);
            if (i < n - 2) {
                result.append(", ");
            } else if (i == n - 2) {
                result.append(" ").append(lastSeparator).append(" ");
            }
            ++i;
        }
        return result.toString();
    }

    public static void forEachOccurrence(@NotNull String haystack, char needle, @NotNull Consumer<Integer> callback) {
        AndroidTextUtils.forEachOccurrence(haystack, needle, 0, callback);
    }

    public static void forEachOccurrence(@NotNull String haystack, char needle, int startIndex, @NotNull Consumer<Integer> callback) {
        int curr = haystack.indexOf(needle, startIndex);
        while (curr != -1) {
            callback.consume((Object)curr);
            curr = haystack.indexOf(needle, curr + 1);
        }
    }

    @Nullable
    @Contract(pure=true)
    public static String trimEndOrNullize(@NotNull String haystack, @NotNull String needle) {
        if (haystack.endsWith(needle)) {
            return haystack.substring(0, haystack.length() - needle.length());
        }
        return null;
    }

    @NotNull
    public static List<String> splitKeepDelimiter(@NotNull String string, @NotNull String delimiter) {
        return Arrays.asList(string.split(String.format("((?<=%1$s)|(?=%1$s))", delimiter)));
    }
}

