/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.references;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.tree.injected.InjectedReferenceVisitor;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.TemporaryPlacesRegistry;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectedReferencesContributor
extends PsiReferenceContributor {
    public static boolean isInjected(@Nullable PsiReference reference) {
        if (reference == null) {
            return false;
        }
        return InjectedReferencesContributor.getInjectedReferences(reference.getElement()) != null;
    }

    public static PsiReference @Nullable [] getInjectedReferences(PsiElement element) {
        if (!(element instanceof ContributedReferenceHost) && !(element instanceof PsiLanguageInjectionHost)) {
            return null;
        }
        Pair<PsiReference[], Boolean> info = InjectedReferencesContributor.getInjectionInfo(element);
        if (!((Boolean)info.second).booleanValue()) {
            return null;
        }
        return (PsiReference[])info.first;
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(), new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                return (PsiReference[])InjectedReferencesContributor.getInjectionInfo((PsiElement)element).first;
            }
        });
    }

    private static Pair<PsiReference[], Boolean> getInjectionInfo(@NotNull PsiElement element) {
        return (Pair)CachedValuesManager.getCachedValue((PsiElement)element, () -> CachedValueProvider.Result.create(InjectedReferencesContributor.doGetReferencesByElement(element, new ProcessingContext()), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static Pair<PsiReference[], Boolean> doGetReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
        SmartList references = new SmartList();
        Project project = element.getProject();
        Configuration configuration = Configuration.getProjectInstance(project);
        final Ref injected = new Ref((Object)Boolean.FALSE);
        for (ReferenceInjector injector : ReferenceInjector.EXTENSION_POINT_NAME.getExtensionList()) {
            Collection<BaseInjection> injections = configuration.getInjectionsByLanguageId(injector.getId());
            for (BaseInjection injection : injections) {
                if (!injection.acceptForReference(element)) continue;
                injected.set((Object)Boolean.TRUE);
                LanguageInjectionSupport support = InjectorUtils.findInjectionSupport(injection.getSupportId());
                element.putUserData(LanguageInjectionSupport.INJECTOR_SUPPORT, (Object)support);
                List<TextRange> area = injection.getInjectedArea(element);
                for (TextRange range : area) {
                    references.addAll(Arrays.asList(injector.getReferences(element, context, range)));
                }
            }
        }
        if (element instanceof PsiLanguageInjectionHost) {
            final TemporaryPlacesRegistry registry = TemporaryPlacesRegistry.getInstance(project);
            InjectedLanguage language = registry.getLanguageFor((PsiLanguageInjectionHost)element, element.getContainingFile());
            if (language != null) {
                ReferenceInjector injector = ReferenceInjector.findById((String)language.getID());
                if (injector != null) {
                    injected.set((Object)Boolean.TRUE);
                    element.putUserData(LanguageInjectionSupport.INJECTOR_SUPPORT, (Object)registry.getLanguageInjectionSupport());
                    TextRange range = ElementManipulators.getValueTextRange((PsiElement)element);
                    references.addAll(Arrays.asList(injector.getReferences(element, context, range)));
                }
            } else {
                PsiFile containingFile = element.getContainingFile();
                InjectedLanguageManager.getInstance((Project)containingFile.getProject()).enumerateEx(element, containingFile, false, (PsiLanguageInjectionHost.InjectedPsiVisitor)new InjectedReferenceVisitor((List)references, context){
                    final /* synthetic */ List val$references;
                    final /* synthetic */ ProcessingContext val$context;
                    {
                        this.val$references = list;
                        this.val$context = processingContext;
                    }

                    public void visitInjectedReference(@NotNull ReferenceInjector injector, @NotNull List<? extends PsiLanguageInjectionHost.Shred> places) {
                        injected.set((Object)Boolean.TRUE);
                        element.putUserData(LanguageInjectionSupport.INJECTOR_SUPPORT, (Object)registry.getLanguageInjectionSupport());
                        for (PsiLanguageInjectionHost.Shred shred : places) {
                            if (shred.getHost() != element) continue;
                            this.val$references.addAll(Arrays.asList(injector.getReferences(element, this.val$context, shred.getRangeInsideHost())));
                        }
                    }
                });
            }
        }
        return Pair.create((Object)references.toArray(PsiReference.EMPTY_ARRAY), (Object)((Boolean)injected.get()));
    }
}

