/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.StringSearcher;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.TemporaryLanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InjectorUtils {
    public static final Comparator<TextRange> RANGE_COMPARATOR = (o1, o2) -> {
        if (o1.intersects(o2)) {
            return 0;
        }
        return o1.getStartOffset() - o2.getStartOffset();
    };
    private static final Pattern MAP_ENTRY_PATTERN = Pattern.compile("([\\S&&[^=]]+)=(\"(?:[^\"]|\\\\\")*\"|\\S*)");

    private InjectorUtils() {
    }

    @Nullable
    public static Language getLanguage(@NotNull BaseInjection injection) {
        return InjectorUtils.getLanguageByString(injection.getInjectedLanguageId());
    }

    @Nullable
    public static Language getLanguageByString(@NotNull String languageId) {
        Language language = InjectedLanguage.findLanguageById(languageId);
        if (language != null) {
            return language;
        }
        ReferenceInjector injector = ReferenceInjector.findById((String)languageId);
        if (injector != null) {
            return injector.toLanguage();
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        FileType fileType = fileTypeManager.getFileTypeByExtension(languageId);
        if (fileType instanceof LanguageFileType) {
            return ((LanguageFileType)fileType).getLanguage();
        }
        LightVirtualFile lightVirtualFile = new LightVirtualFile(languageId);
        for (FileType registeredFileType : fileTypeManager.getRegisteredFileTypes()) {
            if (!(registeredFileType instanceof FileTypeIdentifiableByVirtualFile) || !(registeredFileType instanceof LanguageFileType) || !((FileTypeIdentifiableByVirtualFile)registeredFileType).isMyFileType((VirtualFile)lightVirtualFile)) continue;
            return ((LanguageFileType)registeredFileType).getLanguage();
        }
        return null;
    }

    public static boolean registerInjectionSimple(@NotNull PsiLanguageInjectionHost host, @NotNull BaseInjection injection, @Nullable LanguageInjectionSupport support, @NotNull MultiHostRegistrar registrar) {
        Language language = InjectorUtils.getLanguage(injection);
        if (language == null) {
            return false;
        }
        InjectedLanguage injectedLanguage = InjectedLanguage.create(injection.getInjectedLanguageId(), injection.getPrefix(), injection.getSuffix(), false);
        List<TextRange> ranges = injection.getInjectedArea((PsiElement)host);
        ArrayList<InjectionInfo> list = new ArrayList<InjectionInfo>(ranges.size());
        for (TextRange range : ranges) {
            list.add(new InjectionInfo(host, injectedLanguage, range));
        }
        InjectorUtils.registerInjection(language, host.getContainingFile(), list, registrar);
        if (support != null) {
            InjectorUtils.registerSupport(support, true, (PsiElement)host, language);
        }
        return !ranges.isEmpty();
    }

    @Deprecated(forRemoval=true)
    public static void registerInjection(@Nullable Language language, @NotNull List<? extends Trinity<PsiLanguageInjectionHost, InjectedLanguage, TextRange>> list, @NotNull PsiFile containingFile, @NotNull MultiHostRegistrar registrar) {
        InjectorUtils.registerInjection(language, containingFile, ContainerUtil.map(list, trinity -> new InjectionInfo((PsiLanguageInjectionHost)trinity.first, (InjectedLanguage)trinity.second, (TextRange)trinity.third)), registrar);
    }

    public static void registerInjection(@Nullable Language language, @NotNull PsiFile containingFile, @NotNull List<InjectionInfo> list, @NotNull MultiHostRegistrar registrar) {
        if (language == null) {
            return;
        }
        ParserDefinition parser = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        ReferenceInjector injector = ReferenceInjector.findById((String)language.getID());
        if (parser == null && injector != null) {
            Iterator<InjectionInfo> iterator = list.iterator();
            if (iterator.hasNext()) {
                InjectionInfo trinity = iterator.next();
                String prefix = trinity.language().getPrefix();
                String suffix = trinity.language().getSuffix();
                PsiLanguageInjectionHost host = trinity.host();
                TextRange textRange = trinity.range();
                InjectedLanguageUtil.injectReference((MultiHostRegistrar)registrar, (Language)language, (String)prefix, (String)suffix, (PsiLanguageInjectionHost)host, (TextRange)textRange);
                return;
            }
            return;
        }
        boolean injectionStarted = false;
        for (InjectionInfo t : list) {
            PsiLanguageInjectionHost host = t.host();
            if (host.getContainingFile() != containingFile || !host.isValidHost()) continue;
            TextRange textRange = t.range();
            InjectedLanguage injectedLanguage = t.language();
            if (!injectionStarted) {
                if (!StringUtil.equalsIgnoreCase((CharSequence)language.getID(), (CharSequence)t.language().getID())) {
                    registrar.startInjecting(language, StringUtil.toLowerCase((String)t.language().getID()));
                } else {
                    registrar.startInjecting(language);
                }
                injectionStarted = true;
            }
            registrar.addPlace(injectedLanguage.getPrefix(), injectedLanguage.getSuffix(), host, textRange);
        }
        if (injectionStarted) {
            registrar.doneInjecting();
        }
    }

    @NotNull
    public static Collection<String> getActiveInjectionSupportIds() {
        return ContainerUtil.map((Collection)LanguageInjectionSupport.EP_NAME.getExtensionList(), LanguageInjectionSupport::getId);
    }

    @NotNull
    public static Collection<LanguageInjectionSupport> getActiveInjectionSupports() {
        return LanguageInjectionSupport.EP_NAME.getExtensionList();
    }

    @Nullable
    public static LanguageInjectionSupport findInjectionSupport(@NotNull String id) {
        if ("temp".equals(id)) {
            return new TemporaryLanguageInjectionSupport();
        }
        for (LanguageInjectionSupport support : LanguageInjectionSupport.EP_NAME.getExtensionList()) {
            if (!id.equals(support.getId())) continue;
            return support;
        }
        return null;
    }

    public static Class<?> @NotNull [] getPatternClasses(@NotNull String supportId) {
        LanguageInjectionSupport support = InjectorUtils.findInjectionSupport(supportId);
        return support == null ? ArrayUtil.EMPTY_CLASS_ARRAY : support.getPatternClasses();
    }

    @NotNull
    public static LanguageInjectionSupport findNotNullInjectionSupport(@NotNull String id) {
        LanguageInjectionSupport result = InjectorUtils.findInjectionSupport(id);
        if (result == null) {
            throw new IllegalStateException(id + " injector not found");
        }
        return result;
    }

    @NotNull
    public static StringBuilder appendStringPattern(@NotNull StringBuilder sb, @NotNull String prefix, @NotNull String text, @NotNull String suffix) {
        sb.append(prefix).append("string().");
        String[] parts = text.split("[,|\\s]+");
        boolean useMatches = false;
        for (String part : parts) {
            if (!InjectorUtils.isRegexp(part)) continue;
            useMatches = true;
            break;
        }
        if (useMatches) {
            sb.append("matches(\"").append(text).append("\")");
        } else if (parts.length > 1) {
            sb.append("oneOf(");
            boolean first = true;
            for (String part : parts) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append("\"").append(part).append("\"");
            }
            sb.append(")");
        } else {
            sb.append("equalTo(\"").append(text).append("\")");
        }
        sb.append(suffix);
        return sb;
    }

    public static boolean isRegexp(@NotNull String s) {
        boolean hasReChars = false;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == ' ' || c == '_' || c == '-' || Character.isLetterOrDigit(c)) continue;
            hasReChars = true;
            break;
        }
        if (hasReChars) {
            try {
                new URL(s);
            }
            catch (MalformedURLException e) {
                return true;
            }
        }
        return false;
    }

    public static void registerSupport(@NotNull LanguageInjectionSupport support, boolean settingsAvailable, @NotNull PsiElement element, @NotNull Language language) {
        InjectorUtils.putInjectedFileUserData(element, language, LanguageInjectionSupport.INJECTOR_SUPPORT, support);
        if (settingsAvailable) {
            InjectorUtils.putInjectedFileUserData(element, language, LanguageInjectionSupport.SETTINGS_EDITOR, support);
        }
    }

    public static <T> void putInjectedFileUserData(@NotNull PsiElement element, @NotNull Language language, @NotNull Key<T> key, @Nullable T value) {
        InjectedLanguageUtil.putInjectedFileUserData((PsiElement)element, (Language)language, key, value);
    }

    public static Configuration getEditableInstance(@NotNull Project project) {
        return Configuration.getInstance();
    }

    public static boolean canBeRemoved(@NotNull BaseInjection injection) {
        if (injection.isEnabled()) {
            return false;
        }
        if (StringUtil.isNotEmpty((String)injection.getPrefix()) || StringUtil.isNotEmpty((String)injection.getSuffix())) {
            return false;
        }
        return !StringUtil.isNotEmpty((String)injection.getValuePattern());
    }

    @Nullable
    private static CommentInjectionData findCommentInjectionData(@NotNull PsiElement context, @Nullable Ref<? super PsiElement> causeRef) {
        return InjectorUtils.findCommentInjectionData(context, true, causeRef);
    }

    @Nullable
    public static Pair.NonNull<PsiComment, CommentInjectionData> findClosestCommentInjectionData(@NotNull PsiElement context) {
        PsiFile file = context.getContainingFile();
        if (file == null) {
            return null;
        }
        TreeMap<TextRange, CommentInjectionData> map = InjectorUtils.getInjectionMap(file);
        if (map == null) {
            return null;
        }
        Map.Entry<TextRange, CommentInjectionData> entry = map.lowerEntry(context.getTextRange());
        if (entry == null) {
            return null;
        }
        PsiComment psiComment = (PsiComment)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)entry.getKey().getStartOffset(), PsiComment.class, (boolean)false);
        if (psiComment == null) {
            return null;
        }
        return Pair.createNonNull((Object)psiComment, (Object)entry.getValue());
    }

    @Nullable
    public static CommentInjectionData findCommentInjectionData(@NotNull PsiElement context, boolean treeElementsIncludeComment, @Nullable Ref<? super PsiElement> causeRef) {
        PsiElement target = CompletionUtil.getOriginalOrSelf((PsiElement)context);
        Pair.NonNull<PsiComment, CommentInjectionData> pair = InjectorUtils.findClosestCommentInjectionData(target);
        if (pair == null) {
            return null;
        }
        PsiComment psiComment = (PsiComment)pair.first;
        CommentInjectionData injectionData = (CommentInjectionData)pair.second;
        TextRange r0 = psiComment.getTextRange();
        PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)psiComment, (PsiElement)target);
        if (commonParent == null) {
            return null;
        }
        PsiElement topmostElement = target;
        for (PsiElement parent = target; parent != null && (treeElementsIncludeComment ? parent : parent.getParent()) != commonParent; parent = parent.getParent()) {
            topmostElement = parent;
        }
        int off1 = r0.getEndOffset();
        int off2 = topmostElement.getTextRange().getStartOffset();
        if (off2 - off1 > 120) {
            return null;
        }
        if (off2 - off1 > 2) {
            PsiElement e;
            Supplier<PsiElement> producer = InjectorUtils.prevWalker(topmostElement, commonParent);
            while ((e = producer.get()) != null && e != psiComment) {
                if (!(e instanceof PsiLanguageInjectionHost) || !((PsiLanguageInjectionHost)e).isValidHost() || StringUtil.isEmptyOrSpaces((String)e.getText())) continue;
                return null;
            }
        }
        if (causeRef != null) {
            causeRef.set((Object)psiComment);
        }
        return injectionData;
    }

    @Nullable
    public static BaseInjection findCommentInjection(@NotNull PsiElement context, @NotNull String supportId, @Nullable Ref<? super PsiElement> causeRef) {
        CommentInjectionData data = InjectorUtils.findCommentInjectionData(context, causeRef);
        if (data == null) {
            return null;
        }
        BaseInjection injection = new BaseInjection(supportId);
        injection.setPrefix(data.getPrefix());
        injection.setSuffix(data.getSuffix());
        injection.setInjectedLanguageId(data.getInjectedLanguageId());
        injection.setDisplayName(data.getDisplayName());
        return injection;
    }

    @Nullable
    private static TreeMap<TextRange, CommentInjectionData> getInjectionMap(@NotNull PsiFile file) {
        return (TreeMap)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            TreeMap<TextRange, CommentInjectionData> map = InjectorUtils.calcInjections(file);
            return CachedValueProvider.Result.create(map.isEmpty() ? null : map, (Object[])new Object[]{file});
        });
    }

    @NotNull
    private static TreeMap<TextRange, CommentInjectionData> calcInjections(@NotNull PsiFile file) {
        TreeMap<TextRange, CommentInjectionData> injectionMap = new TreeMap<TextRange, CommentInjectionData>(RANGE_COMPARATOR);
        StringSearcher searcher = new StringSearcher("language=", true, true, false);
        CharSequence contents = file.getViewProvider().getContents();
        char[] contentsArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)contents);
        int s0 = 0;
        int s1 = contents.length();
        int idx = searcher.scan(contents, contentsArray, s0, s1);
        while (idx != -1) {
            PsiComment element = (PsiComment)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)idx, PsiComment.class, (boolean)false);
            if (element != null) {
                CommentInjectionData injection;
                String str = ElementManipulators.getValueText((PsiElement)element).trim();
                CommentInjectionData commentInjectionData = injection = str.startsWith("language=") ? new CommentInjectionData(InjectorUtils.decodeMap(str), str) : null;
                if (injection != null) {
                    injectionMap.put(element.getTextRange(), injection);
                }
            }
            idx = searcher.scan(contents, contentsArray, idx + 1, s1);
        }
        return injectionMap;
    }

    @NotNull
    private static Map<String, String> decodeMap(@NotNull CharSequence charSequence) {
        if (StringUtil.isEmpty((CharSequence)charSequence)) {
            return Collections.emptyMap();
        }
        Matcher matcher = MAP_ENTRY_PATTERN.matcher(charSequence);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        while (matcher.find()) {
            map.put(StringUtil.unescapeStringCharacters((String)matcher.group(1)), StringUtil.unescapeStringCharacters((String)StringUtil.unquoteString((String)matcher.group(2))));
        }
        return map;
    }

    @NotNull
    private static Supplier<PsiElement> prevWalker(final @NotNull PsiElement element, final @NotNull PsiElement scope) {
        return new Supplier<PsiElement>(){
            PsiElement e;
            {
                this.e = element;
            }

            @Override
            @Nullable
            public PsiElement get() {
                if (this.e == null || this.e == scope) {
                    return null;
                }
                PsiElement prev = this.e.getPrevSibling();
                if (prev != null) {
                    this.e = PsiTreeUtil.getDeepestLast((PsiElement)prev);
                    return this.e;
                }
                PsiElement parent = this.e.getParent();
                this.e = parent == scope || parent instanceof PsiFile ? null : parent;
                return this.e;
            }
        };
    }

    public record InjectionInfo(@NotNull PsiLanguageInjectionHost host, @NotNull InjectedLanguage language, @NotNull TextRange range) {
    }

    public static class CommentInjectionData {
        private final String myDisplayName;
        private final Map<String, String> myMap;

        CommentInjectionData(@NotNull Map<String, String> map, @NotNull String displayName) {
            this.myMap = Collections.unmodifiableMap(map);
            this.myDisplayName = displayName;
        }

        @NotNull
        public String getPrefix() {
            return (String)ObjectUtils.notNull((Object)this.myMap.get("prefix"), (Object)"");
        }

        @NotNull
        public String getSuffix() {
            return (String)ObjectUtils.notNull((Object)this.myMap.get("suffix"), (Object)"");
        }

        @NotNull
        public String getInjectedLanguageId() {
            return (String)ObjectUtils.notNull((Object)this.myMap.get("language"), (Object)"");
        }

        @NlsSafe
        @NotNull
        public String getDisplayName() {
            return this.myDisplayName;
        }

        @NotNull
        public Map<String, String> getValues() {
            return this.myMap;
        }
    }
}

