/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.uielement;

import android.graphics.RectF;
import android.os.Bundle;
import android.os.Parcelable;
import android.os._Original_Build;
import android.util.Size;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.TextView;
import androidx.annotation.RequiresApi;
import com.google.android.apps.common.testing.accessibility.framework.replacements.Rect;
import com.google.android.apps.common.testing.accessibility.framework.replacements.TextUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.checkerframework.checker.nullness.qual.Nullable;

class AccessibilityNodeInfoExtraDataExtractor {
    static final String EXTRA_DATA_TEST_TAG = "androidx.compose.ui.semantics.testTag";
    private final boolean obtainCharacterLocations;
    @VisibleForTesting
    final boolean obtainRenderingInfo;
    @VisibleForTesting
    final boolean obtainTestTag;
    private final @Nullable Integer characterLocationArgMaxLength;

    AccessibilityNodeInfoExtraDataExtractor(boolean obtainCharacterLocations, boolean obtainRenderingInfo, boolean obtainTestTag, @Nullable Integer characterLocationArgMaxLength) {
        this.obtainCharacterLocations = obtainCharacterLocations;
        this.obtainRenderingInfo = obtainRenderingInfo;
        this.obtainTestTag = obtainTestTag;
        this.characterLocationArgMaxLength = characterLocationArgMaxLength;
    }

    ExtraData getExtraData(AccessibilityNodeInfo fromInfo) {
        ExtraData extraData = new ExtraData();
        if (this.obtainCharacterLocations && _Original_Build.VERSION.SDK_INT >= 26) {
            AccessibilityNodeInfoExtraDataExtractor.fetchTextCharacterLocations(fromInfo, extraData, this.characterLocationArgMaxLength);
        }
        if (this.obtainRenderingInfo && _Original_Build.VERSION.SDK_INT >= 30) {
            AccessibilityNodeInfoExtraDataExtractor.fetchRenderingInfo(fromInfo, extraData);
        }
        if (this.obtainTestTag && _Original_Build.VERSION.SDK_INT >= 26) {
            AccessibilityNodeInfoExtraDataExtractor.fetchTestTag(fromInfo, extraData);
        }
        return extraData;
    }

    ImmutableList<Rect> getTextCharacterLocations(TextView textView) {
        return this.getTextCharacterLocations(textView, this.characterLocationArgMaxLength);
    }

    @VisibleForTesting
    @RequiresApi(value=26)
    ImmutableList<Rect> getTextCharacterLocations(TextView textView, @Nullable Integer characterLocationArgMaxLength) {
        return this.obtainCharacterLocations && _Original_Build.VERSION.SDK_INT >= 26 ? AccessibilityNodeInfoExtraDataExtractor.getTextCharacterLocationsAux(textView, characterLocationArgMaxLength) : ImmutableList.of();
    }

    @RequiresApi(value=26)
    private static ImmutableList<Rect> getTextCharacterLocationsAux(TextView textView, @Nullable Integer maxCharacterLocationLength) {
        CharSequence text = textView.getText();
        if (TextUtils.isEmpty(text) || textView.getLayout() == null) {
            return ImmutableList.of();
        }
        AccessibilityNodeInfo nodeInfo = AccessibilityNodeInfo.obtain();
        Bundle args = AccessibilityNodeInfoExtraDataExtractor.createTextCharacterLocationsRequestBundle(text, maxCharacterLocationLength);
        textView.addExtraDataToAccessibilityNodeInfo(nodeInfo, "android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_KEY", args);
        ImmutableList<Rect> locations = AccessibilityNodeInfoExtraDataExtractor.parseCharacterLocationsFromExtras(nodeInfo.getExtras());
        return locations == null ? ImmutableList.of() : locations;
    }

    @RequiresApi(value=30)
    private static void fetchRenderingInfo(AccessibilityNodeInfo fromInfo, ExtraData extraData) {
        block6: {
            Bundle args = new Bundle();
            try {
                AccessibilityNodeInfo.ExtraRenderingInfo extraRenderingInfo;
                if (fromInfo.refreshWithExtraData("android.view.accessibility.extra.DATA_RENDERING_INFO_KEY", args) && (extraRenderingInfo = fromInfo.getExtraRenderingInfo()) != null) {
                    Size layoutSize;
                    int textSizeUnit;
                    float size = extraRenderingInfo.getTextSizeInPx();
                    if (size >= 0.0f) {
                        extraData.setTextSize(Float.valueOf(size));
                    }
                    if ((textSizeUnit = extraRenderingInfo.getTextSizeUnit()) >= 0) {
                        extraData.setTextSizeUnit(textSizeUnit);
                    }
                    if ((layoutSize = extraRenderingInfo.getLayoutSize()) != null) {
                        extraData.setLayoutSize(layoutSize);
                    }
                }
            }
            catch (IllegalStateException e) {
                if (AccessibilityNodeInfoExtraDataExtractor.isRobolectric()) break block6;
                throw e;
            }
        }
    }

    @RequiresApi(value=26)
    private static void fetchTextCharacterLocations(AccessibilityNodeInfo fromInfo, ExtraData extraData, @Nullable Integer maxCharacterLocationLength) {
        CharSequence text = fromInfo.getText();
        if (TextUtils.isEmpty(text)) {
            extraData.setTextCharacterLocations((ImmutableList<Rect>)ImmutableList.of());
        } else {
            ImmutableList<Rect> locations;
            Bundle args = AccessibilityNodeInfoExtraDataExtractor.createTextCharacterLocationsRequestBundle(text, maxCharacterLocationLength);
            if (fromInfo.refreshWithExtraData("android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_KEY", args) && (locations = AccessibilityNodeInfoExtraDataExtractor.parseCharacterLocationsFromExtras(fromInfo.getExtras())) != null) {
                extraData.setTextCharacterLocations(locations);
            }
        }
    }

    @RequiresApi(value=26)
    private static @Nullable ImmutableList<Rect> parseCharacterLocationsFromExtras(Bundle extras) {
        Parcelable[] data = extras.getParcelableArray("android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_KEY");
        if (data == null) {
            return null;
        }
        ImmutableList.Builder charLocations = ImmutableList.builder();
        for (Parcelable item : data) {
            if (!(item instanceof RectF)) continue;
            RectF rectF = (RectF)item;
            charLocations.add((Object)new Rect((int)Math.floor(rectF.left), (int)Math.floor(rectF.top), (int)Math.ceil(rectF.right), (int)Math.ceil(rectF.bottom)));
        }
        return charLocations.build();
    }

    @RequiresApi(value=26)
    private static Bundle createTextCharacterLocationsRequestBundle(CharSequence text, @Nullable Integer maxCharacterLocationLength) {
        Bundle args = new Bundle();
        args.putInt("android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_ARG_START_INDEX", 0);
        args.putInt("android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_ARG_LENGTH", maxCharacterLocationLength == null ? text.length() : Math.min(maxCharacterLocationLength, text.length()));
        return args;
    }

    @RequiresApi(value=26)
    private static void fetchTestTag(AccessibilityNodeInfo fromInfo, ExtraData extraData) {
        CharSequence testTag;
        if (fromInfo.getAvailableExtraData().contains(EXTRA_DATA_TEST_TAG) && fromInfo.refreshWithExtraData(EXTRA_DATA_TEST_TAG, new Bundle()) && (testTag = fromInfo.getExtras().getCharSequence(EXTRA_DATA_TEST_TAG)) != null) {
            extraData.setTestTag(testTag);
        }
    }

    private static boolean isRobolectric() {
        return "robolectric".equals(_Original_Build.FINGERPRINT);
    }

    static class ExtraData {
        private @Nullable Float textSize = null;
        private @Nullable Integer textSizeUnit = null;
        private @Nullable Size layoutSize = null;
        private @Nullable ImmutableList<Rect> textCharacterLocations = null;
        private @Nullable CharSequence testTag = null;

        ExtraData() {
        }

        @Nullable Float getTextSize() {
            return this.textSize;
        }

        @CanIgnoreReturnValue
        @VisibleForTesting
        ExtraData setTextSize(Float textSize) {
            this.textSize = textSize;
            return this;
        }

        @Nullable Integer getTextSizeUnit() {
            return this.textSizeUnit;
        }

        @CanIgnoreReturnValue
        @VisibleForTesting
        ExtraData setTextSizeUnit(Integer textSizeUnit) {
            this.textSizeUnit = textSizeUnit;
            return this;
        }

        @Nullable Size getLayoutSize() {
            return this.layoutSize;
        }

        @CanIgnoreReturnValue
        @VisibleForTesting
        ExtraData setLayoutSize(Size layoutSize) {
            this.layoutSize = layoutSize;
            return this;
        }

        @Nullable ImmutableList<Rect> getTextCharacterLocations() {
            return this.textCharacterLocations;
        }

        @CanIgnoreReturnValue
        @VisibleForTesting
        ExtraData setTextCharacterLocations(ImmutableList<Rect> textCharacterLocations) {
            this.textCharacterLocations = textCharacterLocations;
            return this;
        }

        @Nullable CharSequence getTestTag() {
            return this.testTag;
        }

        @CanIgnoreReturnValue
        @VisibleForTesting
        ExtraData setTestTag(CharSequence testTag) {
            this.testTag = testTag;
            return this;
        }
    }
}

