/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.uielement;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Parcel;
import android.os.Parcelable;
import android.os._Original_Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import androidx.annotation.ChecksSdkIntAtLeast;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.google.android.apps.common.testing.accessibility.framework.ViewAccessibilityUtils;
import com.google.android.apps.common.testing.accessibility.framework.replacements.TextUtils;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityNodeInfoExtraDataExtractor;
import com.google.android.apps.common.testing.accessibility.framework.uielement.CustomViewBuilderAndroid;
import com.google.android.apps.common.testing.accessibility.framework.uielement.DefaultCustomViewBuilderAndroid;
import com.google.android.apps.common.testing.accessibility.framework.uielement.DeviceStateAndroid;
import com.google.android.apps.common.testing.accessibility.framework.uielement.Origin;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElementAndroid;
import com.google.android.apps.common.testing.accessibility.framework.uielement.WindowHierarchyElementAndroid;
import com.google.android.apps.common.testing.accessibility.framework.uielement.proto.AccessibilityHierarchyProtos;
import com.google.android.libraries.accessibility.utils.log.LogUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AccessibilityHierarchyAndroid
extends AccessibilityHierarchy
implements Parcelable {
    public static @Nullable Boolean viewOverlayEnabled;
    private static final String TAG = "A11yHierarchyAndroid";
    @ChecksSdkIntAtLeast(api=33)
    private static final boolean AT_33;
    @ChecksSdkIntAtLeast(api=29)
    private static final boolean AT_29;
    @ChecksSdkIntAtLeast(api=22)
    private static final boolean AT_22;
    @ChecksSdkIntAtLeast(api=17)
    private static final boolean AT_17;
    private final DeviceStateAndroid deviceState;
    private final List<WindowHierarchyElementAndroid> windowHierarchyElements;
    private final WindowHierarchyElementAndroid activeWindow;
    public static final Parcelable.Creator<AccessibilityHierarchyAndroid> CREATOR;

    private AccessibilityHierarchyAndroid(DeviceStateAndroid deviceState, Origin origin, List<WindowHierarchyElementAndroid> windowHierarchyElements, WindowHierarchyElementAndroid activeWindow, ViewElementClassNamesAndroid viewElementClassNames) {
        super(deviceState, origin, windowHierarchyElements, activeWindow, viewElementClassNames);
        this.deviceState = deviceState;
        this.windowHierarchyElements = windowHierarchyElements;
        this.activeWindow = activeWindow;
    }

    @Override
    public DeviceStateAndroid getDeviceState() {
        return this.deviceState;
    }

    public Collection<WindowHierarchyElementAndroid> getAllWindows() {
        return Collections.unmodifiableCollection(this.windowHierarchyElements);
    }

    @Override
    public WindowHierarchyElementAndroid getActiveWindow() {
        return this.activeWindow;
    }

    @Override
    public WindowHierarchyElementAndroid getWindowById(int id2) {
        if (id2 < 0 || id2 >= this.windowHierarchyElements.size()) {
            throw new NoSuchElementException();
        }
        return this.windowHierarchyElements.get(id2);
    }

    @Override
    public ViewHierarchyElementAndroid getViewById(long condensedUniqueId) {
        int windowId = (int)(condensedUniqueId >>> 32);
        int viewId = (int)condensedUniqueId;
        return this.getWindowById(windowId).getViewById(viewId);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        this.deviceState.writeToParcel(out, flags);
        ArrayList<WindowHierarchyElementAndroid> rootWindows = new ArrayList<WindowHierarchyElementAndroid>();
        for (WindowHierarchyElementAndroid window : this.windowHierarchyElements) {
            if (window.getParentWindow() != null) continue;
            rootWindows.add(window);
        }
        out.writeInt(this.windowHierarchyElements.size());
        out.writeInt(rootWindows.size());
        for (WindowHierarchyElementAndroid window : rootWindows) {
            AccessibilityHierarchyAndroid.writeWindowHierarchyToParcel(window, out);
        }
        AccessibilityHierarchyAndroid.writeMapToParcel(this.viewElementClassNames.getMap(), out);
    }

    private static void writeWindowHierarchyToParcel(WindowHierarchyElementAndroid element, Parcel out) {
        element.writeToParcel(out);
        int childCount = element.getChildWindowCount();
        out.writeInt(childCount);
        for (int i = 0; i < childCount; ++i) {
            AccessibilityHierarchyAndroid.writeWindowHierarchyToParcel(element.getChildWindow(i), out);
        }
    }

    private static void writeMapToParcel(Map<String, Integer> map, Parcel out) {
        out.writeInt(map.size());
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            out.writeString(entry.getKey());
            out.writeInt(entry.getValue());
        }
    }

    private static Map<String, Integer> readMapFromParcel(Parcel in) {
        HashBiMap viewElementsMap = HashBiMap.create();
        int mapSize = in.readInt();
        for (int i = 0; i < mapSize; ++i) {
            viewElementsMap.put((Object)in.readString(), (Object)in.readInt());
        }
        return viewElementsMap;
    }

    private static AccessibilityHierarchyAndroid readFromParcel(Parcel in) {
        DeviceStateAndroid deviceState = DeviceStateAndroid.newBuilder(in).build();
        int totalWindows = in.readInt();
        int rootWindows = in.readInt();
        ArrayList<WindowHierarchyElementAndroid> windowHierarchyElements = new ArrayList<WindowHierarchyElementAndroid>(totalWindows);
        for (int i = 0; i < rootWindows; ++i) {
            AccessibilityHierarchyAndroid.buildWindowHierarchy(in, windowHierarchyElements, null);
        }
        Preconditions.checkState((windowHierarchyElements.size() == totalWindows ? 1 : 0) != 0, (Object)"Window hierarchy failed consistency check.");
        WindowHierarchyElementAndroid activeWindow = null;
        for (WindowHierarchyElementAndroid window : windowHierarchyElements) {
            if (!Boolean.TRUE.equals(window.isActive())) continue;
            Preconditions.checkState((activeWindow == null ? 1 : 0) != 0, (Object)"More than one active window detected.");
            activeWindow = window;
        }
        Preconditions.checkNotNull(activeWindow, (Object)"No active windows detected.");
        ViewElementClassNamesAndroid viewElementClassNames = new ViewElementClassNamesAndroid(AccessibilityHierarchyAndroid.readMapFromParcel(in));
        AccessibilityHierarchyAndroid hierarchy = new AccessibilityHierarchyAndroid(deviceState, Origin.UNKNOWN, windowHierarchyElements, activeWindow, viewElementClassNames);
        hierarchy.setAccessibilityHierarchy();
        return hierarchy;
    }

    private static WindowHierarchyElementAndroid buildWindowHierarchy(AccessibilityWindowInfo info, List<WindowHierarchyElementAndroid> elementList, @Nullable WindowHierarchyElementAndroid parent, BiMap<Long, AccessibilityNodeInfo> originMap, AccessibilityNodeInfoExtraDataExtractor extraDataExtractor) {
        WindowHierarchyElementAndroid element = WindowHierarchyElementAndroid.newBuilder(elementList.size(), info, extraDataExtractor).setParent(parent).setNodeInfoOriginMap((Map<Long, AccessibilityNodeInfo>)originMap).build();
        elementList.add(element);
        for (int i = 0; i < info.getChildCount(); ++i) {
            AccessibilityWindowInfo child = info.getChild(i);
            if (child == null) continue;
            element.addChild(AccessibilityHierarchyAndroid.buildWindowHierarchy(child, elementList, element, originMap, extraDataExtractor));
        }
        return element;
    }

    private static WindowHierarchyElementAndroid buildWindowHierarchy(Parcel fromParcel, List<WindowHierarchyElementAndroid> elementList, @Nullable WindowHierarchyElementAndroid parent) {
        WindowHierarchyElementAndroid element = WindowHierarchyElementAndroid.newBuilder(elementList.size(), fromParcel).setParent(parent).build();
        elementList.add(element);
        int childWindowCount = fromParcel.readInt();
        for (int i = 0; i < childWindowCount; ++i) {
            element.addChild(AccessibilityHierarchyAndroid.buildWindowHierarchy(fromParcel, elementList, element));
        }
        return element;
    }

    @RequiresApi(value=17)
    private void resolveLabelForRelationshipsAmongInfos(BiMap<Long, AccessibilityNodeInfo> originMap) {
        for (Map.Entry entry : originMap.entrySet()) {
            Long labeledElementId;
            AccessibilityNodeInfo labeledNode = ((AccessibilityNodeInfo)entry.getValue()).getLabelFor();
            if (labeledNode == null || (labeledElementId = (Long)originMap.inverse().get((Object)labeledNode)) == null) continue;
            ViewHierarchyElementAndroid labelElement = this.getViewById((Long)entry.getKey());
            ViewHierarchyElementAndroid labeledElement = this.getViewById(labeledElementId);
            labeledElement.setLabeledBy(labelElement);
        }
    }

    @RequiresApi(value=17)
    private void resolveLabelForRelationshipsAmongViews(Context context, BiMap<Long, View> originMap) {
        for (Map.Entry entry : originMap.entrySet()) {
            int labeledViewId = ((View)entry.getValue()).getLabelFor();
            if (labeledViewId == -1) continue;
            ViewHierarchyElementAndroid labelElement = this.getViewById((Long)entry.getKey());
            ViewHierarchyElementAndroid labeledElement = this.findElementByViewId(labeledViewId, originMap);
            if (labeledElement == null) {
                LogUtils.w(TAG, "View not found for labelFor = %1$s", AccessibilityHierarchyAndroid.resourceName(context, labeledViewId));
                continue;
            }
            labeledElement.setLabeledBy(labelElement);
        }
    }

    @RequiresApi(value=22)
    private void resolveAccessibilityTraversalRelationshipsAmongInfos(BiMap<Long, AccessibilityNodeInfo> originMap) {
        for (Map.Entry entry : originMap.entrySet()) {
            AccessibilityNodeInfo beforeNode = ((AccessibilityNodeInfo)entry.getValue()).getTraversalBefore();
            AccessibilityNodeInfo afterNode = ((AccessibilityNodeInfo)entry.getValue()).getTraversalAfter();
            if (beforeNode == null && afterNode == null) continue;
            ViewHierarchyElementAndroid currentElement = this.getViewById((Long)entry.getKey());
            if (beforeNode != null) {
                ViewHierarchyElementAndroid beforeElement = this.findElementByNodeInfo(beforeNode, originMap);
                if (beforeElement == null) {
                    LogUtils.w(TAG, "Element not found for accessibilityTraversalBefore.", new Object[0]);
                } else {
                    currentElement.setAccessibilityTraversalBefore(beforeElement);
                }
            }
            if (afterNode == null) continue;
            ViewHierarchyElementAndroid afterElement = this.findElementByNodeInfo(afterNode, originMap);
            if (afterElement == null) {
                LogUtils.w(TAG, "Element not found for accessibilityTraversalAfter.", new Object[0]);
                continue;
            }
            currentElement.setAccessibilityTraversalAfter(afterElement);
        }
    }

    @RequiresApi(value=22)
    private void resolveAccessibilityTraversalRelationshipsAmongViews(Context context, BiMap<Long, View> originMap) {
        for (Map.Entry entry : originMap.entrySet()) {
            ViewHierarchyElementAndroid matchingElement;
            int beforeViewId = ((View)entry.getValue()).getAccessibilityTraversalBefore();
            int afterViewId = ((View)entry.getValue()).getAccessibilityTraversalAfter();
            ViewHierarchyElementAndroid viewElement = this.getViewById((Long)entry.getKey());
            if (beforeViewId != -1) {
                matchingElement = this.findElementByViewId(beforeViewId, originMap);
                if (matchingElement == null) {
                    LogUtils.w(TAG, "View not found for accessibilityTraversalBefore = %1$s", AccessibilityHierarchyAndroid.resourceName(context, beforeViewId));
                } else {
                    viewElement.setAccessibilityTraversalBefore(matchingElement);
                }
            }
            if (afterViewId == -1) continue;
            matchingElement = this.findElementByViewId(afterViewId, originMap);
            if (matchingElement == null) {
                LogUtils.w(TAG, "View not found for accessibilityTraversalAfter = %1$s", AccessibilityHierarchyAndroid.resourceName(context, afterViewId));
                continue;
            }
            viewElement.setAccessibilityTraversalAfter(matchingElement);
        }
    }

    @RequiresApi(value=29)
    private void resolveTouchDelegateRelationshipsAmongInfos(BiMap<Long, AccessibilityNodeInfo> originMap) {
        for (Map.Entry entry : originMap.entrySet()) {
            AccessibilityNodeInfo nodeInfo = (AccessibilityNodeInfo)entry.getValue();
            AccessibilityNodeInfo.TouchDelegateInfo delegateInfo = nodeInfo.getTouchDelegateInfo();
            if (delegateInfo == null) continue;
            Rect boundsInScreen = new Rect();
            nodeInfo.getBoundsInScreen(boundsInScreen);
            for (int i = 0; i < delegateInfo.getRegionCount(); ++i) {
                ViewHierarchyElementAndroid delegatee;
                Region hitRegion = delegateInfo.getRegionAt(i);
                if (hitRegion == null || !hitRegion.isRect()) continue;
                AccessibilityNodeInfo delegateeNode = delegateInfo.getTargetForRegion(hitRegion);
                ViewHierarchyElementAndroid viewHierarchyElementAndroid = delegatee = delegateeNode != null ? this.findElementByNodeInfo(delegateeNode, originMap) : null;
                if (delegatee == null) continue;
                Rect hitRect = hitRegion.getBounds();
                delegatee.addTouchDelegateBounds(new com.google.android.apps.common.testing.accessibility.framework.replacements.Rect(hitRect.left + boundsInScreen.left, hitRect.top + boundsInScreen.top, hitRect.right + boundsInScreen.left, hitRect.bottom + boundsInScreen.top));
            }
        }
    }

    private @Nullable ViewHierarchyElementAndroid findElementByNodeInfo(AccessibilityNodeInfo targetNode, BiMap<Long, AccessibilityNodeInfo> originMap) {
        Long viewId = (Long)originMap.inverse().get((Object)targetNode);
        if (viewId == null) {
            return null;
        }
        return this.getViewById(viewId);
    }

    private @Nullable ViewHierarchyElementAndroid findElementByViewId(int targetViewId, BiMap<Long, View> originMap) {
        for (Map.Entry matchingEntry : originMap.entrySet()) {
            if (((View)matchingEntry.getValue()).getId() != targetViewId) continue;
            return this.getViewById((Long)matchingEntry.getKey());
        }
        return null;
    }

    private static String resourceName(Context context, int viewId) {
        if (!ViewAccessibilityUtils.isViewIdGenerated(viewId)) {
            try {
                String resourceName = context.getResources().getResourceEntryName(viewId);
                if (resourceName != null) {
                    return "\"" + resourceName + "\"";
                }
            }
            catch (Resources.NotFoundException notFoundException) {
                // empty catch block
            }
        }
        return Integer.toString(viewId);
    }

    private void setAccessibilityHierarchy() {
        for (WindowHierarchyElementAndroid window : this.windowHierarchyElements) {
            window.setAccessibilityHierarchy(this);
        }
    }

    public static BuilderAndroid newBuilder(View view) {
        BuilderAndroid builder = new BuilderAndroid();
        builder.fromRootView = (View)Preconditions.checkNotNull((Object)view);
        return builder;
    }

    @RequiresApi(value=21)
    public static BuilderAndroid newBuilder(List<AccessibilityWindowInfo> fromWindowList, Context context) {
        BuilderAndroid builder = new BuilderAndroid();
        builder.fromWindowList = (List)Preconditions.checkNotNull(fromWindowList);
        builder.context = (Context)Preconditions.checkNotNull((Object)context);
        return builder;
    }

    public static BuilderAndroid newBuilder(AccessibilityNodeInfo fromRootNode, Context context) {
        BuilderAndroid builder = new BuilderAndroid();
        builder.fromRootNode = (AccessibilityNodeInfo)Preconditions.checkNotNull((Object)fromRootNode);
        builder.context = (Context)Preconditions.checkNotNull((Object)context);
        return builder;
    }

    static {
        AT_33 = _Original_Build.VERSION.SDK_INT >= 33;
        AT_29 = _Original_Build.VERSION.SDK_INT >= 29;
        AT_22 = _Original_Build.VERSION.SDK_INT >= 22;
        AT_17 = _Original_Build.VERSION.SDK_INT >= 17;
        CREATOR = new Parcelable.Creator<AccessibilityHierarchyAndroid>(){

            @Override
            public AccessibilityHierarchyAndroid createFromParcel(Parcel in) {
                return AccessibilityHierarchyAndroid.readFromParcel((Parcel)Preconditions.checkNotNull((Object)in));
            }

            public AccessibilityHierarchyAndroid[] newArray(int size) {
                return new AccessibilityHierarchyAndroid[size];
            }
        };
    }

    protected static class ViewElementClassNamesAndroid
    extends AccessibilityHierarchy.ViewElementClassNames {
        public ViewElementClassNamesAndroid(List<WindowHierarchyElementAndroid> windowHierarchyElements, CustomViewBuilderAndroid customViewBuilder) {
            super(ViewElementClassNamesAndroid.createClassIdMap(windowHierarchyElements, customViewBuilder));
        }

        public ViewElementClassNamesAndroid(Map<String, Integer> viewElementsMap) {
            super(viewElementsMap);
        }

        public ViewElementClassNamesAndroid(AccessibilityHierarchyProtos.ViewElementClassNamesProto proto) {
            super(proto.getClassNameMap());
        }

        private static @Nullable Class<?> getClassByName(ViewHierarchyElementAndroid view, String className, CustomViewBuilderAndroid customViewBuilder) {
            return customViewBuilder.getClassByName(view, className);
        }

        private static Map<String, Integer> createClassIdMap(List<WindowHierarchyElementAndroid> windowHierarchyElements, CustomViewBuilderAndroid customViewBuilder) {
            HashMap<String, Integer> classIdMap = new HashMap<String, Integer>();
            for (WindowHierarchyElementAndroid window : windowHierarchyElements) {
                for (ViewHierarchyElementAndroid view : window.getAllViews()) {
                    ImmutableSet<String> classReferenceSet = ViewElementClassNamesAndroid.getSuperclassSet(view, customViewBuilder);
                    for (String className : classReferenceSet) {
                        Integer classNameId = (Integer)classIdMap.get(className);
                        if (classNameId == null) {
                            classNameId = classIdMap.size();
                            classIdMap.put(className, classNameId);
                        }
                        view.addIdToSuperclassViewList(classNameId);
                    }
                }
            }
            return classIdMap;
        }

        private static ImmutableSet<String> getSuperclassSet(ViewHierarchyElementAndroid view, CustomViewBuilderAndroid customViewBuilder) {
            CharSequence className = view.getClassName();
            CharSequence accessibilityClassName = view.getAccessibilityClassName();
            if (className == null && accessibilityClassName == null) {
                return ImmutableSet.of();
            }
            if (accessibilityClassName == null || TextUtils.equals(className, accessibilityClassName)) {
                return ViewElementClassNamesAndroid.getSuperclassSet(view, className, customViewBuilder);
            }
            return new ImmutableSet.Builder().addAll(ViewElementClassNamesAndroid.getSuperclassSet(view, accessibilityClassName, customViewBuilder)).addAll(ViewElementClassNamesAndroid.getSuperclassSet(view, className, customViewBuilder)).build();
        }

        private static ImmutableSet<String> getSuperclassSet(ViewHierarchyElementAndroid view, CharSequence className, CustomViewBuilderAndroid customViewBuilder) {
            ImmutableSet.Builder builder = new ImmutableSet.Builder();
            for (Class<?> viewClass = ViewElementClassNamesAndroid.getClassByName(view, className.toString(), customViewBuilder); viewClass != null && !viewClass.equals(Object.class); viewClass = viewClass.getSuperclass()) {
                builder.add((Object)viewClass.getName());
                ViewElementClassNamesAndroid.addAllSuperinterfacesRecursivelyToSetBuilder(viewClass, (ImmutableSet.Builder<String>)builder);
            }
            return builder.build();
        }

        private static void addAllSuperinterfacesRecursivelyToSetBuilder(Class<?> viewClass, ImmutableSet.Builder<String> builder) {
            Class<?>[] interfaces;
            for (Class<?> element : interfaces = viewClass.getInterfaces()) {
                builder.add((Object)element.getName());
                ViewElementClassNamesAndroid.addAllSuperinterfacesRecursivelyToSetBuilder(element, builder);
            }
        }
    }

    public static class BuilderAndroid {
        private static final CustomViewBuilderAndroid DEFAULT_CUSTOM_VIEW_BUILDER = new DefaultCustomViewBuilderAndroid();
        private @Nullable View fromRootView;
        private CustomViewBuilderAndroid customViewBuilder = DEFAULT_CUSTOM_VIEW_BUILDER;
        private @Nullable List<AccessibilityWindowInfo> fromWindowList;
        private @Nullable AccessibilityNodeInfo fromRootNode;
        private @Nullable Context context;
        private @Nullable BiMap<Long, AccessibilityNodeInfo> nodeInfoOriginMap;
        private @Nullable BiMap<Long, View> viewOriginMap;
        private boolean obtainCharacterLocations = false;
        private boolean obtainRenderingInfo = true;
        private boolean testTagsAsResourceId = false;
        private @Nullable Integer characterLocationArgMaxLength;

        @CanIgnoreReturnValue
        public BuilderAndroid setObtainCharacterLocations(boolean obtainCharacterLocations) {
            this.obtainCharacterLocations = obtainCharacterLocations;
            return this;
        }

        @CanIgnoreReturnValue
        public BuilderAndroid setTestTagsAsResourceId(boolean testTagsAsResourceId) {
            this.testTagsAsResourceId = testTagsAsResourceId;
            return this;
        }

        @CanIgnoreReturnValue
        public BuilderAndroid setCharacterLocationArgMaxLength(int characterLocationArgMaxLength) {
            Preconditions.checkArgument((characterLocationArgMaxLength > 0 ? 1 : 0) != 0, (Object)"characterLocationArgMaxLength must be positive.");
            this.characterLocationArgMaxLength = characterLocationArgMaxLength;
            return this;
        }

        @CanIgnoreReturnValue
        public BuilderAndroid setCustomViewBuilder(CustomViewBuilderAndroid customViewBuilder) {
            this.customViewBuilder = customViewBuilder;
            return this;
        }

        @CanIgnoreReturnValue
        public BuilderAndroid setObtainRenderingInfo(boolean enabled) {
            this.obtainRenderingInfo = enabled;
            return this;
        }

        @CanIgnoreReturnValue
        public BuilderAndroid setNodeInfoOriginMap(BiMap<Long, AccessibilityNodeInfo> originMap) {
            this.nodeInfoOriginMap = originMap;
            return this;
        }

        @CanIgnoreReturnValue
        public BuilderAndroid setViewOriginMap(BiMap<Long, View> originMap) {
            this.viewOriginMap = originMap;
            return this;
        }

        public AccessibilityHierarchyAndroid build() {
            AccessibilityHierarchyAndroid result;
            if (this.fromRootView != null) {
                result = AT_33 && Boolean.TRUE.equals(viewOverlayEnabled) ? this.buildHierarchyFromViewAndItsNodeInfo(this.fromRootView, this.getAccessibilityNodeInfoExtraDataExtractor()) : this.buildHierarchyFromView(this.fromRootView, this.getAccessibilityNodeInfoExtraDataExtractor());
            } else if (this.fromRootNode != null && this.context != null) {
                result = this.buildHierarchyFromNodeInfo(this.fromRootNode, this.context, this.getAccessibilityNodeInfoExtraDataExtractor());
            } else if (this.fromWindowList != null && this.context != null) {
                result = this.buildHierarchyFromWindowList(this.fromWindowList, this.context, this.getAccessibilityNodeInfoExtraDataExtractor());
            } else {
                throw new IllegalStateException("Nothing from which to build");
            }
            this.disposeOfMaps();
            return result;
        }

        @VisibleForTesting
        AccessibilityNodeInfoExtraDataExtractor getAccessibilityNodeInfoExtraDataExtractor() {
            return new AccessibilityNodeInfoExtraDataExtractor(this.obtainCharacterLocations, this.obtainRenderingInfo, this.testTagsAsResourceId, this.characterLocationArgMaxLength);
        }

        @RequiresApi(value=33)
        private AccessibilityHierarchyAndroid buildHierarchyFromViewAndItsNodeInfo(View fromRootView, AccessibilityNodeInfoExtraDataExtractor extraDataExtractor) {
            if (this.nodeInfoOriginMap == null) {
                this.nodeInfoOriginMap = HashBiMap.create();
            }
            AccessibilityNodeInfo fromRootNode = fromRootView.createAccessibilityNodeInfo();
            fromRootNode.setQueryFromAppProcessEnabled(fromRootView, true);
            HashMap<AccessibilityNodeInfo, View> nodeToViewMap = new HashMap<AccessibilityNodeInfo, View>();
            BuilderAndroid.mapNodesToViews(fromRootView, nodeToViewMap);
            WindowHierarchyElementAndroid.BuilderAndroid activeWindowBuilder = WindowHierarchyElementAndroid.newBuilder(0, fromRootNode, extraDataExtractor).setNodeInfoOriginMap((Map)Preconditions.checkNotNull(this.nodeInfoOriginMap)).setNodeToViewMap(nodeToViewMap);
            if (this.viewOriginMap != null) {
                activeWindowBuilder.setViewOriginMap((Map)Preconditions.checkNotNull(this.viewOriginMap));
            }
            WindowHierarchyElementAndroid activeWindow = activeWindowBuilder.build();
            ArrayList windowHierarchyElements = Lists.newArrayList((Object[])new WindowHierarchyElementAndroid[]{activeWindow});
            this.context = fromRootView.getContext();
            DeviceStateAndroid deviceState = DeviceStateAndroid.newBuilder(this.context).build();
            ViewElementClassNamesAndroid viewElementClassNames = new ViewElementClassNamesAndroid(windowHierarchyElements, this.customViewBuilder);
            AccessibilityHierarchyAndroid hierarchy = new AccessibilityHierarchyAndroid(deviceState, Origin.ACCESSIBILITY_NODE_INFOS_AND_VIEWS, windowHierarchyElements, activeWindow, viewElementClassNames);
            hierarchy.setAccessibilityHierarchy();
            hierarchy.resolveLabelForRelationshipsAmongInfos((BiMap<Long, AccessibilityNodeInfo>)((BiMap)Preconditions.checkNotNull(this.nodeInfoOriginMap)));
            hierarchy.resolveAccessibilityTraversalRelationshipsAmongInfos((BiMap<Long, AccessibilityNodeInfo>)((BiMap)Preconditions.checkNotNull(this.nodeInfoOriginMap)));
            hierarchy.resolveTouchDelegateRelationshipsAmongInfos((BiMap<Long, AccessibilityNodeInfo>)((BiMap)Preconditions.checkNotNull(this.nodeInfoOriginMap)));
            return hierarchy;
        }

        private static void mapNodesToViews(View view, Map<AccessibilityNodeInfo, View> nodeToViewMap) {
            nodeToViewMap.put(view.createAccessibilityNodeInfo(), view);
            if (view instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)view;
                for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                    View child = viewGroup.getChildAt(i);
                    if (child.getVisibility() != 0) continue;
                    BuilderAndroid.mapNodesToViews(child, nodeToViewMap);
                }
            }
        }

        private AccessibilityHierarchyAndroid buildHierarchyFromView(View fromRootView, AccessibilityNodeInfoExtraDataExtractor extraDataExtractor) {
            if (this.viewOriginMap == null) {
                this.viewOriginMap = HashBiMap.create();
            }
            WindowHierarchyElementAndroid activeWindow = WindowHierarchyElementAndroid.newBuilder(0, fromRootView, this.customViewBuilder, extraDataExtractor).setViewOriginMap((Map)Preconditions.checkNotNull(this.viewOriginMap)).build();
            ArrayList windowHierarchyElements = Lists.newArrayList((Object[])new WindowHierarchyElementAndroid[]{activeWindow});
            Context context = fromRootView.getContext();
            DeviceStateAndroid deviceState = DeviceStateAndroid.newBuilder(context).build();
            ViewElementClassNamesAndroid viewElementClassNames = new ViewElementClassNamesAndroid(windowHierarchyElements, this.customViewBuilder);
            AccessibilityHierarchyAndroid hierarchy = new AccessibilityHierarchyAndroid(deviceState, Origin.VIEWS, windowHierarchyElements, activeWindow, viewElementClassNames);
            hierarchy.setAccessibilityHierarchy();
            if (AT_17) {
                hierarchy.resolveLabelForRelationshipsAmongViews(context, (BiMap<Long, View>)((BiMap)Preconditions.checkNotNull(this.viewOriginMap)));
            }
            if (AT_22) {
                hierarchy.resolveAccessibilityTraversalRelationshipsAmongViews(context, (BiMap<Long, View>)((BiMap)Preconditions.checkNotNull(this.viewOriginMap)));
            }
            return hierarchy;
        }

        private AccessibilityHierarchyAndroid buildHierarchyFromNodeInfo(AccessibilityNodeInfo fromRootNode, Context context, AccessibilityNodeInfoExtraDataExtractor extraDataExtractor) {
            if (this.nodeInfoOriginMap == null) {
                this.nodeInfoOriginMap = HashBiMap.create();
            }
            WindowHierarchyElementAndroid activeWindow = WindowHierarchyElementAndroid.newBuilder(0, fromRootNode, extraDataExtractor).setNodeInfoOriginMap((Map)Preconditions.checkNotNull(this.nodeInfoOriginMap)).build();
            ArrayList windowHierarchyElements = Lists.newArrayList((Object[])new WindowHierarchyElementAndroid[]{activeWindow});
            DeviceStateAndroid deviceState = DeviceStateAndroid.newBuilder(context).build();
            ViewElementClassNamesAndroid viewElementClassNames = new ViewElementClassNamesAndroid(windowHierarchyElements, this.customViewBuilder);
            AccessibilityHierarchyAndroid hierarchy = new AccessibilityHierarchyAndroid(deviceState, Origin.ACCESSIBILITY_NODE_INFOS, windowHierarchyElements, activeWindow, viewElementClassNames);
            hierarchy.setAccessibilityHierarchy();
            if (AT_17) {
                hierarchy.resolveLabelForRelationshipsAmongInfos((BiMap<Long, AccessibilityNodeInfo>)((BiMap)Preconditions.checkNotNull(this.nodeInfoOriginMap)));
            }
            if (AT_22) {
                hierarchy.resolveAccessibilityTraversalRelationshipsAmongInfos((BiMap<Long, AccessibilityNodeInfo>)((BiMap)Preconditions.checkNotNull(this.nodeInfoOriginMap)));
            }
            if (AT_29) {
                hierarchy.resolveTouchDelegateRelationshipsAmongInfos((BiMap<Long, AccessibilityNodeInfo>)((BiMap)Preconditions.checkNotNull(this.nodeInfoOriginMap)));
            }
            return hierarchy;
        }

        @RequiresApi(value=21)
        private AccessibilityHierarchyAndroid buildHierarchyFromWindowList(List<AccessibilityWindowInfo> fromWindowList, Context context, AccessibilityNodeInfoExtraDataExtractor extraDataExtractor) {
            if (this.nodeInfoOriginMap == null) {
                this.nodeInfoOriginMap = HashBiMap.create();
            }
            ArrayList<WindowHierarchyElementAndroid> windowHierarchyElements = new ArrayList<WindowHierarchyElementAndroid>(fromWindowList.size());
            for (AccessibilityWindowInfo accessibilityWindowInfo : fromWindowList) {
                if (accessibilityWindowInfo.getParent() != null) continue;
                AccessibilityHierarchyAndroid.buildWindowHierarchy(accessibilityWindowInfo, windowHierarchyElements, null, (BiMap<Long, AccessibilityNodeInfo>)((BiMap)Preconditions.checkNotNull(this.nodeInfoOriginMap)), extraDataExtractor);
            }
            WindowHierarchyElementAndroid activeWindow = null;
            for (WindowHierarchyElementAndroid window : windowHierarchyElements) {
                if (!Boolean.TRUE.equals(window.isActive())) continue;
                Preconditions.checkState((activeWindow == null ? 1 : 0) != 0, (Object)"More than one active window detected.");
                activeWindow = window;
            }
            Preconditions.checkNotNull(activeWindow, (Object)"No active windows detected.");
            DeviceStateAndroid deviceStateAndroid = DeviceStateAndroid.newBuilder(context).build();
            ViewElementClassNamesAndroid viewElementClassNames = new ViewElementClassNamesAndroid(windowHierarchyElements, this.customViewBuilder);
            AccessibilityHierarchyAndroid hierarchy = new AccessibilityHierarchyAndroid(deviceStateAndroid, Origin.WINDOW_LIST, windowHierarchyElements, activeWindow, viewElementClassNames);
            hierarchy.setAccessibilityHierarchy();
            if (AT_17) {
                hierarchy.resolveLabelForRelationshipsAmongInfos((BiMap<Long, AccessibilityNodeInfo>)((BiMap)Preconditions.checkNotNull(this.nodeInfoOriginMap)));
            }
            if (AT_22) {
                hierarchy.resolveAccessibilityTraversalRelationshipsAmongInfos((BiMap<Long, AccessibilityNodeInfo>)((BiMap)Preconditions.checkNotNull(this.nodeInfoOriginMap)));
            }
            if (AT_29) {
                hierarchy.resolveTouchDelegateRelationshipsAmongInfos((BiMap<Long, AccessibilityNodeInfo>)((BiMap)Preconditions.checkNotNull(this.nodeInfoOriginMap)));
            }
            return hierarchy;
        }

        private void disposeOfMaps() {
            this.viewOriginMap = null;
            this.nodeInfoOriginMap = null;
        }
    }
}

