/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.suggestions;

import com.google.common.annotations.Beta;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

@Beta
public class ViewAttribute {
    public static final String NAMESPACE_ANDROID = "android";
    public static final String NAMESPACE_APP = "app";
    public static final String ANDROID_URI = "http://schemas.android.com/apk/res/android";
    public static final String APP_URI = "http://schemas.android.com/apk/res-auto";
    private final String namespaceUri;
    private final String namespace;
    private final String attributeName;

    public ViewAttribute(String namespaceUri, String namespace, String attributeName) {
        this.namespaceUri = namespaceUri;
        this.namespace = namespace;
        this.attributeName = attributeName;
    }

    public ViewAttribute(String attributeName) {
        this(ANDROID_URI, NAMESPACE_ANDROID, attributeName);
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getFullyQualifiedName() {
        return this.namespace + ":" + this.attributeName;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ViewAttribute) {
            ViewAttribute attribute = (ViewAttribute)o;
            return Objects.equals(this.attributeName, attribute.getAttributeName()) && Objects.equals(this.namespace, attribute.namespace);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.attributeName);
    }
}

