/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.integrations.espresso;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.os.StrictMode;
import android.os._Original_Build;
import android.util.Log;
import android.view.View;
import androidx.test.services.storage.TestStorage;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckPreset;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckPresetAndroid;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResultDescriptor;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResultUtils;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.ViewChecker;
import com.google.android.apps.common.testing.accessibility.framework.integrations.espresso.AccessibilityViewCheckException;
import com.google.android.apps.common.testing.accessibility.framework.integrations.espresso.CheckResultsCallback;
import com.google.android.apps.common.testing.accessibility.framework.integrations.espresso.Screenshotter;
import com.google.android.apps.common.testing.accessibility.framework.utils.contrast.BitmapImage;
import com.google.android.apps.common.testing.accessibility.framework.utils.contrast.Image;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.Matcher;

public class AccessibilityValidator {
    private static final String TAG = "AccessibilityValidator";
    private AccessibilityCheckPreset preset = AccessibilityCheckPreset.LATEST;
    private boolean runChecksFromRootView = false;
    @VisibleForTesting
    Screenshotter screenshotter = new Screenshotter();
    private boolean captureScreenshots = false;
    private boolean saveScreenshots = false;
    private @Nullable Boolean saveViewImages;
    private int screenshotsCaptured = 0;
    private @Nullable AccessibilityCheckResult.AccessibilityCheckResultType throwExceptionFor = AccessibilityCheckResult.AccessibilityCheckResultType.ERROR;
    private AccessibilityCheckResultDescriptor resultDescriptor = new AccessibilityCheckResultDescriptor();
    private static final ViewChecker viewChecker = new ViewChecker().setObtainCharacterLocations(!AccessibilityValidator.isRobolectric());
    private @Nullable Matcher<? super AccessibilityViewCheckResult> suppressingMatcher = null;
    private final List<AccessibilityCheckListener> checkListeners = new ArrayList<AccessibilityCheckListener>();
    private final List<CheckResultsListener> checkResultsListeners = new ArrayList<CheckResultsListener>();

    public void check(View view) {
        Preconditions.checkNotNull((Object)view);
        this.checkAndReturnResults(view);
    }

    public List<AccessibilityViewCheckResult> checkAndReturnResults(View view) {
        if (view != null) {
            View viewToCheck = this.runChecksFromRootView ? view.getRootView() : view;
            return this.runAccessibilityChecks(viewToCheck);
        }
        return ImmutableList.of();
    }

    @CanIgnoreReturnValue
    public AccessibilityValidator setCheckPreset(AccessibilityCheckPreset preset) {
        this.preset = preset;
        return this;
    }

    @CanIgnoreReturnValue
    public AccessibilityValidator setRunChecksFromRootView(boolean runChecksFromRootView) {
        this.runChecksFromRootView = runChecksFromRootView;
        return this;
    }

    @CanIgnoreReturnValue
    public AccessibilityValidator setCaptureScreenshots(boolean capture) {
        this.captureScreenshots = capture;
        return this;
    }

    @CanIgnoreReturnValue
    public AccessibilityValidator setSaveImages(boolean save) {
        return this.setSaveImages(save, save);
    }

    @CanIgnoreReturnValue
    public AccessibilityValidator setSaveImages(boolean saveScreenshots, boolean saveViewImages) {
        this.saveScreenshots = saveScreenshots;
        this.saveViewImages = saveViewImages;
        return this;
    }

    @CanIgnoreReturnValue
    public AccessibilityValidator setSuppressingResultMatcher(@Nullable Matcher<? super AccessibilityViewCheckResult> resultMatcher) {
        this.suppressingMatcher = resultMatcher;
        return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public AccessibilityValidator setThrowExceptionForErrors(boolean throwExceptionForErrors) {
        return this.setThrowExceptionFor(throwExceptionForErrors ? AccessibilityCheckResult.AccessibilityCheckResultType.ERROR : null);
    }

    @CanIgnoreReturnValue
    public AccessibilityValidator setThrowExceptionFor(@Nullable AccessibilityCheckResult.AccessibilityCheckResultType throwFor) {
        Preconditions.checkArgument((throwFor == AccessibilityCheckResult.AccessibilityCheckResultType.ERROR || throwFor == AccessibilityCheckResult.AccessibilityCheckResultType.WARNING || throwFor == AccessibilityCheckResult.AccessibilityCheckResultType.INFO || throwFor == null ? 1 : 0) != 0, (String)"Argument was %s but expected ERROR, WARNING, INFO or null.", (Object)((Object)throwFor));
        this.throwExceptionFor = throwFor;
        return this;
    }

    @CanIgnoreReturnValue
    public AccessibilityValidator setResultDescriptor(AccessibilityCheckResultDescriptor resultDescriptor) {
        this.resultDescriptor = (AccessibilityCheckResultDescriptor)Preconditions.checkNotNull((Object)resultDescriptor);
        return this;
    }

    @CanIgnoreReturnValue
    public AccessibilityValidator addCheckListener(AccessibilityCheckListener listener) {
        Preconditions.checkNotNull((Object)listener);
        this.checkListeners.add(listener);
        return this;
    }

    @CanIgnoreReturnValue
    public AccessibilityValidator addCheckListener(CheckResultsListener listener) {
        this.checkResultsListeners.add(listener);
        return this;
    }

    private ImmutableList<AccessibilityViewCheckResult> runAccessibilityChecks(View view) {
        Parameters parameters = new Parameters();
        String screenshotPath = null;
        if (this.captureScreenshots) {
            ScreenshotAndPath screenshotAndPath = this.createPseudoScreenshot(view.getRootView());
            Bitmap screenshot = screenshotAndPath.screenshot;
            if (screenshot != null) {
                parameters.putScreenCapture(new BitmapImage(screenshot));
                if (!Boolean.FALSE.equals(this.saveViewImages)) {
                    parameters.setSaveViewImages(true);
                }
                ++this.screenshotsCaptured;
                screenshotPath = screenshotAndPath.path;
            }
        }
        return this.processResults(view.getContext(), viewChecker.runViewChecksOnView(AccessibilityCheckPresetAndroid.getViewChecksForPreset(this.preset), view, parameters), screenshotPath);
    }

    private ScreenshotAndPath createPseudoScreenshot(View root) {
        Bitmap screenshot = this.screenshotter.getScreenshot(root);
        if (screenshot != null && this.saveScreenshots) {
            String path = String.format(Locale.ENGLISH, "pseudo_screenshot_%d.png", this.screenshotsCaptured + 1);
            boolean written = AccessibilityValidator.writeBitmapToFile(root.getContext(), screenshot, path);
            return new ScreenshotAndPath(screenshot, written ? path : null);
        }
        return new ScreenshotAndPath(screenshot, null);
    }

    private static boolean isRobolectric() {
        return "robolectric".equals(_Original_Build.FINGERPRINT);
    }

    @VisibleForTesting
    int getScreenshotsCaptured() {
        return this.screenshotsCaptured;
    }

    private void saveResultImages(Context context, List<AccessibilityViewCheckResult> results) {
        HashMap<String, Integer> resourceIdCounts = new HashMap<String, Integer>();
        for (AccessibilityViewCheckResult result : results) {
            Image viewImage = result.getViewImage();
            if (!(viewImage instanceof BitmapImage)) continue;
            Bitmap bitmap = ((BitmapImage)viewImage).getBitmap();
            String resourceId = AccessibilityValidator.getResourceIdentifier(result);
            Integer resourceIdCount = (Integer)resourceIdCounts.get(resourceId);
            resourceIdCount = resourceIdCount == null ? 0 : resourceIdCount + 1;
            resourceIdCounts.put(resourceId, resourceIdCount);
            String outputPath = String.format(Locale.ENGLISH, "View-%s%s-%d.png", resourceId, resourceIdCount > 0 && resourceIdCount < 26 ? Character.toString((char)(97 + resourceIdCount)) : "", this.screenshotsCaptured);
            AccessibilityValidator.writeBitmapToFile(context, bitmap, outputPath);
        }
    }

    private static String getResourceIdentifier(AccessibilityViewCheckResult result) {
        View view = result.getView();
        if (view == null) {
            return "NO_VIEW";
        }
        int viewId = view.getId();
        if (viewId == -1 || viewId == 0) {
            return "NO_ID";
        }
        if (view.getResources() != null && !AccessibilityValidator.isViewIdGenerated(viewId)) {
            try {
                return view.getResources().getResourceEntryName(viewId);
            }
            catch (Resources.NotFoundException notFoundException) {
                // empty catch block
            }
        }
        return Integer.toString(viewId);
    }

    private static boolean isViewIdGenerated(int id2) {
        return (id2 & 0xFF000000) == 0 && (id2 & 0xFFFFFF) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CanIgnoreReturnValue
    private static boolean writeBitmapToFile(Context context, Bitmap bitmap, String path) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.getThreadPolicy();
        StrictMode.setThreadPolicy(new StrictMode.ThreadPolicy.Builder(oldPolicy).permitCustomSlowCalls().build());
        try {
            boolean bl;
            BufferedOutputStream stream = new BufferedOutputStream(new TestStorage(context.getContentResolver()).openOutputFile(path));
            try {
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, stream);
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Log.w(TAG, "Error writing bitmap to file", e);
                    boolean bl2 = false;
                    return bl2;
                }
            }
            stream.close();
            return bl;
        }
        finally {
            StrictMode.setThreadPolicy(oldPolicy);
        }
    }

    @VisibleForTesting
    ImmutableList<AccessibilityViewCheckResult> processResults(Context context, ImmutableList<AccessibilityViewCheckResult> results, @Nullable String screenshotPath) {
        ImmutableList<AccessibilityViewCheckResult> processedResults = AccessibilityValidator.suppressMatchingResults(results, this.suppressingMatcher);
        CheckResultsCallback checkResultsCallback = CheckResultsCallback.builder().setAccessibilityViewCheckResults(processedResults).setScreenshotPath(screenshotPath).build();
        for (AccessibilityCheckListener checkListener : this.checkListeners) {
            checkListener.onResults(context, (List<? extends AccessibilityViewCheckResult>)processedResults);
        }
        for (CheckResultsListener checkResultsListener : this.checkResultsListeners) {
            checkResultsListener.onResults(checkResultsCallback);
        }
        List<AccessibilityViewCheckResult> infos = AccessibilityCheckResultUtils.getResultsForType(processedResults, AccessibilityCheckResult.AccessibilityCheckResultType.INFO);
        List<AccessibilityViewCheckResult> warnings = AccessibilityCheckResultUtils.getResultsForType(processedResults, AccessibilityCheckResult.AccessibilityCheckResultType.WARNING);
        List<AccessibilityViewCheckResult> errors = AccessibilityCheckResultUtils.getResultsForType(processedResults, AccessibilityCheckResult.AccessibilityCheckResultType.ERROR);
        List<AccessibilityViewCheckResult> severeResults = this.getSevereResults(errors, warnings, infos);
        if (this.captureScreenshots) {
            if (this.saveViewImages == null) {
                this.saveResultImages(context, severeResults);
            } else if (Boolean.TRUE.equals(this.saveViewImages)) {
                this.saveResultImages(context, (List<AccessibilityViewCheckResult>)results);
            }
        }
        if (!severeResults.isEmpty()) {
            throw new AccessibilityViewCheckException(severeResults, this.resultDescriptor);
        }
        for (AccessibilityViewCheckResult result : infos) {
            Log.i(TAG, this.describeResult(result));
        }
        for (AccessibilityViewCheckResult result : warnings) {
            Log.w(TAG, this.describeResult(result));
        }
        for (AccessibilityViewCheckResult result : errors) {
            Log.w(TAG, this.describeResult(result));
        }
        return processedResults;
    }

    private String describeResult(AccessibilityViewCheckResult result) {
        return this.resultDescriptor.describeResult(result);
    }

    @VisibleForTesting
    static ImmutableList<AccessibilityViewCheckResult> suppressMatchingResults(ImmutableList<AccessibilityViewCheckResult> results, @Nullable Matcher<? super AccessibilityViewCheckResult> matcher) {
        if (matcher == null) {
            return results;
        }
        return FluentIterable.from(results).transform(result -> matcher.matches(result) ? result.getSuppressedResultCopy() : result).toList();
    }

    private List<AccessibilityViewCheckResult> getSevereResults(List<AccessibilityViewCheckResult> errors, List<AccessibilityViewCheckResult> warnings, List<AccessibilityViewCheckResult> infos) {
        if (this.throwExceptionFor != null) {
            switch (this.throwExceptionFor) {
                case ERROR: {
                    if (errors.isEmpty()) break;
                    return errors;
                }
                case WARNING: {
                    if (errors.isEmpty() && warnings.isEmpty()) break;
                    return new ImmutableList.Builder().addAll(errors).addAll(warnings).build();
                }
                case INFO: {
                    if (errors.isEmpty() && warnings.isEmpty() && infos.isEmpty()) break;
                    return new ImmutableList.Builder().addAll(errors).addAll(warnings).addAll(infos).build();
                }
            }
        }
        return ImmutableList.of();
    }

    private static class ScreenshotAndPath {
        final @Nullable Bitmap screenshot;
        final @Nullable String path;

        ScreenshotAndPath(@Nullable Bitmap screenshot, @Nullable String path) {
            this.screenshot = screenshot;
            this.path = path;
        }
    }

    public static interface AccessibilityCheckListener {
        public void onResults(Context var1, List<? extends AccessibilityViewCheckResult> var2);
    }

    public static interface CheckResultsListener {
        public void onResults(CheckResultsCallback var1);
    }
}

