/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.checks;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheck;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityHierarchyCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.Parameters;
import com.google.android.apps.common.testing.accessibility.framework.ResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.strings.StringManager;
import com.google.android.apps.common.testing.accessibility.framework.uielement.AccessibilityHierarchy;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TraversalOrderCheck
extends AccessibilityHierarchyCheck {
    public static final int RESULT_ID_NOT_VISIBLE = 1;
    public static final int RESULT_ID_NOT_IMPORTANT_FOR_ACCESSIBILITY = 2;
    public static final int RESULT_ID_TRAVERSAL_BEFORE_CYCLE = 3;
    public static final int RESULT_ID_TRAVERSAL_AFTER_CYCLE = 4;
    public static final int RESULT_ID_TRAVERSAL_OVER_CONSTRAINED = 5;

    @Override
    protected @Nullable String getHelpTopic() {
        return "7664232";
    }

    @Override
    public AccessibilityCheck.Category getCategory() {
        return AccessibilityCheck.Category.IMPLEMENTATION;
    }

    @Override
    public List<AccessibilityHierarchyCheckResult> runCheckOnHierarchy(AccessibilityHierarchy hierarchy, @Nullable ViewHierarchyElement fromRoot, @Nullable Parameters parameters) {
        ArrayList<AccessibilityHierarchyCheckResult> results = new ArrayList<AccessibilityHierarchyCheckResult>();
        List<? extends ViewHierarchyElement> viewsToEval = TraversalOrderCheck.getElementsToEvaluate(fromRoot, hierarchy);
        for (ViewHierarchyElement viewHierarchyElement : viewsToEval) {
            List<ViewHierarchyElement> afterChain;
            List<ViewHierarchyElement> beforeChain;
            if (!Boolean.TRUE.equals(viewHierarchyElement.isVisibleToUser())) {
                results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 1, null));
                continue;
            }
            if (!viewHierarchyElement.isImportantForAccessibility()) {
                results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.NOT_RUN, viewHierarchyElement, 2, null));
                continue;
            }
            try {
                beforeChain = TraversalOrderCheck.buildNodeChain(viewHierarchyElement, el -> el.getAccessibilityTraversalBefore());
            }
            catch (CycleException e) {
                results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.WARNING, viewHierarchyElement, 3, null));
                continue;
            }
            try {
                afterChain = TraversalOrderCheck.buildNodeChain(viewHierarchyElement, el -> el.getAccessibilityTraversalAfter());
            }
            catch (CycleException e) {
                results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.WARNING, viewHierarchyElement, 4, null));
                continue;
            }
            Set<ViewHierarchyElement> intersection = TraversalOrderCheck.intersectionOf(beforeChain, afterChain);
            intersection.remove(viewHierarchyElement);
            if (intersection.isEmpty()) continue;
            results.add(new AccessibilityHierarchyCheckResult(this.getClass(), AccessibilityCheckResult.AccessibilityCheckResultType.WARNING, viewHierarchyElement, 5, null));
        }
        return results;
    }

    @Override
    public String getMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        return TraversalOrderCheck.generateMessageForResultId(locale, resultId);
    }

    @Override
    public String getShortMessageForResultData(Locale locale, int resultId, @Nullable ResultMetadata metadata) {
        switch (resultId) {
            case 1: {
                return StringManager.getString(locale, "result_message_not_visible");
            }
            case 2: {
                return StringManager.getString(locale, "result_message_not_important_for_accessibility");
            }
        }
        return StringManager.getString(locale, "result_message_brief_unpredictable_traversal");
    }

    @Override
    public String getTitleMessage(Locale locale) {
        return StringManager.getString(locale, "check_title_accessibility_traversal");
    }

    private static String generateMessageForResultId(Locale locale, int resultId) {
        switch (resultId) {
            case 1: {
                return StringManager.getString(locale, "result_message_not_visible");
            }
            case 2: {
                return StringManager.getString(locale, "result_message_not_important_for_accessibility");
            }
            case 3: {
                return String.format(locale, StringManager.getString(locale, "result_message_traversal_cycle"), "android:accessibilityTraversalBefore");
            }
            case 4: {
                return String.format(locale, StringManager.getString(locale, "result_message_traversal_cycle"), "android:accessibilityTraversalAfter");
            }
            case 5: {
                return StringManager.getString(locale, "result_message_traversal_over_constrained");
            }
        }
        throw new IllegalStateException("Unsupported result id");
    }

    private static List<ViewHierarchyElement> buildNodeChain(ViewHierarchyElement start, NextElementFunction nextElementFunction) throws CycleException {
        ArrayList<ViewHierarchyElement> chain = new ArrayList<ViewHierarchyElement>();
        chain.add(start);
        ViewHierarchyElement ptr = start;
        while ((ptr = nextElementFunction.apply(ptr)) != null) {
            if (chain.contains(ptr)) {
                throw new CycleException(chain);
            }
            chain.add(ptr);
        }
        return chain;
    }

    private static <T> Set<T> intersectionOf(List<T> list1, List<T> list2) {
        HashSet<T> intersection = new HashSet<T>(list1);
        intersection.retainAll(new HashSet<T>(list2));
        return intersection;
    }

    private static interface NextElementFunction {
        public @Nullable ViewHierarchyElement apply(ViewHierarchyElement var1);
    }

    private static class CycleException
    extends Exception {
        private final List<ViewHierarchyElement> elements;

        CycleException(List<ViewHierarchyElement> elements) {
            this.elements = elements;
        }

        List<ViewHierarchyElement> getElements() {
            return this.elements;
        }
    }
}

