/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.pm.FeatureInfo;
import android.internal.modules.utils.build.UnboundedSdkLevel;
import android.os.CarrierAssociatedAppEntry;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Process;
import android.os.SystemProperties;
import android.os.VintfRuntimeInfo;
import android.os._Original_Build;
import android.os.incremental.IncrementalManager;
import android.os.storage.StorageManager;
import android.permission.PermissionManager;
import android.sysprop.ApexProperties;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TimingsTraceLog;
import android.util.Xml;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.XmlUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import libcore.io.IoUtils;
import libcore.util.EmptyArray;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class SystemConfig {
    static final String TAG = "SystemConfig";
    static SystemConfig sInstance;
    private static final int ALLOW_FEATURES = 1;
    private static final int ALLOW_LIBS = 2;
    private static final int ALLOW_PERMISSIONS = 4;
    private static final int ALLOW_APP_CONFIGS = 8;
    private static final int ALLOW_PRIVAPP_PERMISSIONS = 16;
    private static final int ALLOW_OEM_PERMISSIONS = 32;
    private static final int ALLOW_HIDDENAPI_WHITELISTING = 64;
    private static final int ALLOW_ASSOCIATIONS = 128;
    private static final int ALLOW_OVERRIDE_APP_RESTRICTIONS = 256;
    private static final int ALLOW_IMPLICIT_BROADCASTS = 512;
    private static final int ALLOW_VENDOR_APEX = 1024;
    private static final int ALLOW_ALL = -1;
    private static final String SKU_PROPERTY = "ro.boot.product.hardware.sku";
    private static final String VENDOR_SKU_PROPERTY = "ro.boot.product.vendor.sku";
    private static final ArrayMap<String, ArraySet<String>> EMPTY_PERMISSIONS;
    int[] mGlobalGids = EmptyArray.INT;
    final SparseArray<ArraySet<String>> mSystemPermissions = new SparseArray();
    final ArrayList<PermissionManager.SplitPermissionInfo> mSplitPermissions = new ArrayList();
    final ArrayMap<String, SharedLibraryEntry> mSharedLibraries = new ArrayMap();
    final ArrayMap<String, FeatureInfo> mAvailableFeatures = new ArrayMap();
    final ArraySet<String> mUnavailableFeatures = new ArraySet();
    final ArrayMap<String, PermissionEntry> mPermissions = new ArrayMap();
    final ArraySet<String> mAllowInPowerSaveExceptIdle = new ArraySet();
    final ArraySet<String> mAllowInPowerSave = new ArraySet();
    final ArraySet<String> mAllowInDataUsageSave = new ArraySet();
    final ArraySet<String> mAllowUnthrottledLocation = new ArraySet();
    final ArrayMap<String, ArraySet<String>> mAllowAdasSettings = new ArrayMap();
    final ArrayMap<String, ArraySet<String>> mAllowIgnoreLocationSettings = new ArrayMap();
    final ArraySet<String> mAllowImplicitBroadcasts = new ArraySet();
    final ArraySet<String> mBgRestrictionExemption = new ArraySet();
    final ArraySet<String> mLinkedApps = new ArraySet();
    final ArraySet<ComponentName> mDefaultVrComponents = new ArraySet();
    final ArraySet<ComponentName> mBackupTransportWhitelist = new ArraySet();
    final ArrayMap<String, ArrayMap<String, Boolean>> mPackageComponentEnabledState = new ArrayMap();
    final ArraySet<String> mHiddenApiPackageWhitelist = new ArraySet();
    final ArraySet<String> mDisabledUntilUsedPreinstalledCarrierApps = new ArraySet();
    final ArrayMap<String, List<CarrierAssociatedAppEntry>> mDisabledUntilUsedPreinstalledCarrierAssociatedApps = new ArrayMap();
    final ArrayMap<String, ArraySet<String>> mPrivAppPermissions = new ArrayMap();
    final ArrayMap<String, ArraySet<String>> mPrivAppDenyPermissions = new ArrayMap();
    final ArrayMap<String, ArraySet<String>> mVendorPrivAppPermissions = new ArrayMap();
    final ArrayMap<String, ArraySet<String>> mVendorPrivAppDenyPermissions = new ArrayMap();
    final ArrayMap<String, ArraySet<String>> mProductPrivAppPermissions = new ArrayMap();
    final ArrayMap<String, ArraySet<String>> mProductPrivAppDenyPermissions = new ArrayMap();
    final ArrayMap<String, ArraySet<String>> mSystemExtPrivAppPermissions = new ArrayMap();
    final ArrayMap<String, ArraySet<String>> mSystemExtPrivAppDenyPermissions = new ArrayMap();
    final ArrayMap<String, ArrayMap<String, ArraySet<String>>> mApexPrivAppPermissions = new ArrayMap();
    final ArrayMap<String, ArrayMap<String, ArraySet<String>>> mApexPrivAppDenyPermissions = new ArrayMap();
    final ArrayMap<String, ArrayMap<String, Boolean>> mOemPermissions = new ArrayMap();
    final ArrayMap<String, ArraySet<String>> mAllowedAssociations = new ArrayMap();
    private final ArraySet<String> mBugreportWhitelistedPackages = new ArraySet();
    private final ArraySet<String> mAppDataIsolationWhitelistedApps = new ArraySet();
    private ArrayMap<String, Set<String>> mPackageToUserTypeWhitelist = new ArrayMap();
    private ArrayMap<String, Set<String>> mPackageToUserTypeBlacklist = new ArrayMap();
    private final ArraySet<String> mRollbackWhitelistedPackages = new ArraySet();
    private final ArraySet<String> mWhitelistedStagedInstallers = new ArraySet();
    private final ArrayMap<String, String> mAllowedVendorApexes = new ArrayMap();
    private String mModulesInstallerPackageName;
    private Map<String, Map<String, String>> mNamedActors = null;
    private String mOverlayConfigSignaturePackage;

    private static boolean isAtLeastSdkLevel(String version) {
        try {
            return UnboundedSdkLevel.isAtLeast(version);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static boolean isAtMostSdkLevel(String version) {
        try {
            return UnboundedSdkLevel.isAtMost(version);
        }
        catch (IllegalArgumentException e) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SystemConfig getInstance() {
        if (!SystemConfig.isSystemProcess()) {
            Slog.wtf(TAG, "SystemConfig is being accessed by a process other than system_server.");
        }
        Class<SystemConfig> clazz = SystemConfig.class;
        synchronized (SystemConfig.class) {
            if (sInstance == null) {
                sInstance = new SystemConfig();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public int[] getGlobalGids() {
        return this.mGlobalGids;
    }

    public SparseArray<ArraySet<String>> getSystemPermissions() {
        return this.mSystemPermissions;
    }

    public ArrayList<PermissionManager.SplitPermissionInfo> getSplitPermissions() {
        return this.mSplitPermissions;
    }

    public ArrayMap<String, SharedLibraryEntry> getSharedLibraries() {
        return this.mSharedLibraries;
    }

    public ArrayMap<String, FeatureInfo> getAvailableFeatures() {
        return this.mAvailableFeatures;
    }

    public ArrayMap<String, PermissionEntry> getPermissions() {
        return this.mPermissions;
    }

    public ArraySet<String> getAllowImplicitBroadcasts() {
        return this.mAllowImplicitBroadcasts;
    }

    public ArraySet<String> getAllowInPowerSaveExceptIdle() {
        return this.mAllowInPowerSaveExceptIdle;
    }

    public ArraySet<String> getAllowInPowerSave() {
        return this.mAllowInPowerSave;
    }

    public ArraySet<String> getAllowInDataUsageSave() {
        return this.mAllowInDataUsageSave;
    }

    public ArraySet<String> getAllowUnthrottledLocation() {
        return this.mAllowUnthrottledLocation;
    }

    public ArrayMap<String, ArraySet<String>> getAllowAdasLocationSettings() {
        return this.mAllowAdasSettings;
    }

    public ArrayMap<String, ArraySet<String>> getAllowIgnoreLocationSettings() {
        return this.mAllowIgnoreLocationSettings;
    }

    public ArraySet<String> getBgRestrictionExemption() {
        return this.mBgRestrictionExemption;
    }

    public ArraySet<String> getLinkedApps() {
        return this.mLinkedApps;
    }

    public ArraySet<String> getHiddenApiWhitelistedApps() {
        return this.mHiddenApiPackageWhitelist;
    }

    public ArraySet<ComponentName> getDefaultVrComponents() {
        return this.mDefaultVrComponents;
    }

    public ArraySet<ComponentName> getBackupTransportWhitelist() {
        return this.mBackupTransportWhitelist;
    }

    public ArrayMap<String, Boolean> getComponentsEnabledStates(String packageName) {
        return this.mPackageComponentEnabledState.get(packageName);
    }

    public ArraySet<String> getDisabledUntilUsedPreinstalledCarrierApps() {
        return this.mDisabledUntilUsedPreinstalledCarrierApps;
    }

    public ArrayMap<String, List<CarrierAssociatedAppEntry>> getDisabledUntilUsedPreinstalledCarrierAssociatedApps() {
        return this.mDisabledUntilUsedPreinstalledCarrierAssociatedApps;
    }

    public ArraySet<String> getPrivAppPermissions(String packageName) {
        return this.mPrivAppPermissions.get(packageName);
    }

    public ArraySet<String> getPrivAppDenyPermissions(String packageName) {
        return this.mPrivAppDenyPermissions.get(packageName);
    }

    public ArraySet<String> getApexPrivAppPermissions(String apexName, String apkPackageName) {
        return this.mApexPrivAppPermissions.getOrDefault(apexName, EMPTY_PERMISSIONS).get(apkPackageName);
    }

    public ArraySet<String> getApexPrivAppDenyPermissions(String apexName, String apkPackageName) {
        return this.mApexPrivAppDenyPermissions.getOrDefault(apexName, EMPTY_PERMISSIONS).get(apkPackageName);
    }

    public ArraySet<String> getVendorPrivAppPermissions(String packageName) {
        return this.mVendorPrivAppPermissions.get(packageName);
    }

    public ArraySet<String> getVendorPrivAppDenyPermissions(String packageName) {
        return this.mVendorPrivAppDenyPermissions.get(packageName);
    }

    public ArraySet<String> getProductPrivAppPermissions(String packageName) {
        return this.mProductPrivAppPermissions.get(packageName);
    }

    public ArraySet<String> getProductPrivAppDenyPermissions(String packageName) {
        return this.mProductPrivAppDenyPermissions.get(packageName);
    }

    public ArraySet<String> getSystemExtPrivAppPermissions(String packageName) {
        return this.mSystemExtPrivAppPermissions.get(packageName);
    }

    public ArraySet<String> getSystemExtPrivAppDenyPermissions(String packageName) {
        return this.mSystemExtPrivAppDenyPermissions.get(packageName);
    }

    public Map<String, Boolean> getOemPermissions(String packageName) {
        Map oemPermissions = this.mOemPermissions.get(packageName);
        if (oemPermissions != null) {
            return oemPermissions;
        }
        return Collections.emptyMap();
    }

    public ArrayMap<String, ArraySet<String>> getAllowedAssociations() {
        return this.mAllowedAssociations;
    }

    public ArraySet<String> getBugreportWhitelistedPackages() {
        return this.mBugreportWhitelistedPackages;
    }

    public Set<String> getRollbackWhitelistedPackages() {
        return this.mRollbackWhitelistedPackages;
    }

    public Set<String> getWhitelistedStagedInstallers() {
        return this.mWhitelistedStagedInstallers;
    }

    public Map<String, String> getAllowedVendorApexes() {
        return this.mAllowedVendorApexes;
    }

    public String getModulesInstallerPackageName() {
        return this.mModulesInstallerPackageName;
    }

    public ArraySet<String> getAppDataIsolationWhitelistedApps() {
        return this.mAppDataIsolationWhitelistedApps;
    }

    public ArrayMap<String, Set<String>> getAndClearPackageToUserTypeWhitelist() {
        ArrayMap<String, Set<String>> r = this.mPackageToUserTypeWhitelist;
        this.mPackageToUserTypeWhitelist = new ArrayMap(0);
        return r;
    }

    public ArrayMap<String, Set<String>> getAndClearPackageToUserTypeBlacklist() {
        ArrayMap<String, Set<String>> r = this.mPackageToUserTypeBlacklist;
        this.mPackageToUserTypeBlacklist = new ArrayMap(0);
        return r;
    }

    public Map<String, Map<String, String>> getNamedActors() {
        return this.mNamedActors != null ? this.mNamedActors : Collections.emptyMap();
    }

    public String getOverlayConfigSignaturePackage() {
        return TextUtils.isEmpty(this.mOverlayConfigSignaturePackage) ? null : this.mOverlayConfigSignaturePackage;
    }

    @VisibleForTesting
    public SystemConfig(boolean readPermissions) {
        if (readPermissions) {
            Slog.w(TAG, "Constructing a test SystemConfig");
            this.readAllPermissions();
        } else {
            Slog.w(TAG, "Constructing an empty test SystemConfig");
        }
    }

    SystemConfig() {
        TimingsTraceLog log = new TimingsTraceLog(TAG, 524288L);
        log.traceBegin("readAllPermissions");
        try {
            this.readAllPermissions();
            this.readPublicNativeLibrariesList();
        }
        finally {
            log.traceEnd();
        }
    }

    private void readAllPermissions() {
        XmlPullParser parser = Xml.newPullParser();
        this.readPermissions(parser, Environment.buildPath(Environment.getRootDirectory(), "etc", "sysconfig"), -1);
        this.readPermissions(parser, Environment.buildPath(Environment.getRootDirectory(), "etc", "permissions"), -1);
        int vendorPermissionFlag = 1171;
        if (_Original_Build.VERSION.DEVICE_INITIAL_SDK_INT <= 27) {
            vendorPermissionFlag |= 0xC;
        }
        this.readPermissions(parser, Environment.buildPath(Environment.getVendorDirectory(), "etc", "sysconfig"), vendorPermissionFlag);
        this.readPermissions(parser, Environment.buildPath(Environment.getVendorDirectory(), "etc", "permissions"), vendorPermissionFlag);
        String vendorSkuProperty = SystemProperties.get(VENDOR_SKU_PROPERTY, "");
        if (!vendorSkuProperty.isEmpty()) {
            String vendorSkuDir = "sku_" + vendorSkuProperty;
            this.readPermissions(parser, Environment.buildPath(Environment.getVendorDirectory(), "etc", "sysconfig", vendorSkuDir), vendorPermissionFlag);
            this.readPermissions(parser, Environment.buildPath(Environment.getVendorDirectory(), "etc", "permissions", vendorSkuDir), vendorPermissionFlag);
        }
        int odmPermissionFlag = vendorPermissionFlag;
        this.readPermissions(parser, Environment.buildPath(Environment.getOdmDirectory(), "etc", "sysconfig"), odmPermissionFlag);
        this.readPermissions(parser, Environment.buildPath(Environment.getOdmDirectory(), "etc", "permissions"), odmPermissionFlag);
        String skuProperty = SystemProperties.get(SKU_PROPERTY, "");
        if (!skuProperty.isEmpty()) {
            String skuDir = "sku_" + skuProperty;
            this.readPermissions(parser, Environment.buildPath(Environment.getOdmDirectory(), "etc", "sysconfig", skuDir), odmPermissionFlag);
            this.readPermissions(parser, Environment.buildPath(Environment.getOdmDirectory(), "etc", "permissions", skuDir), odmPermissionFlag);
        }
        int oemPermissionFlag = 1185;
        this.readPermissions(parser, Environment.buildPath(Environment.getOemDirectory(), "etc", "sysconfig"), oemPermissionFlag);
        this.readPermissions(parser, Environment.buildPath(Environment.getOemDirectory(), "etc", "permissions"), oemPermissionFlag);
        int productPermissionFlag = 2015;
        if (_Original_Build.VERSION.DEVICE_INITIAL_SDK_INT <= 30) {
            productPermissionFlag = -1;
        }
        this.readPermissions(parser, Environment.buildPath(Environment.getProductDirectory(), "etc", "sysconfig"), productPermissionFlag);
        this.readPermissions(parser, Environment.buildPath(Environment.getProductDirectory(), "etc", "permissions"), productPermissionFlag);
        this.readPermissions(parser, Environment.buildPath(Environment.getSystemExtDirectory(), "etc", "sysconfig"), -1);
        this.readPermissions(parser, Environment.buildPath(Environment.getSystemExtDirectory(), "etc", "permissions"), -1);
        if (!SystemConfig.isSystemProcess()) {
            return;
        }
        int apexPermissionFlag = 19;
        for (File f : FileUtils.listFilesOrEmpty(Environment.getApexDirectory())) {
            if (f.isFile() || f.getPath().contains("@")) continue;
            this.readPermissions(parser, Environment.buildPath(f, "etc", "permissions"), apexPermissionFlag);
        }
    }

    @VisibleForTesting
    public void readPermissions(XmlPullParser parser, File libraryDir, int permissionFlag) {
        if (!libraryDir.exists() || !libraryDir.isDirectory()) {
            if (permissionFlag == -1) {
                Slog.w(TAG, "No directory " + libraryDir + ", skipping");
            }
            return;
        }
        if (!libraryDir.canRead()) {
            Slog.w(TAG, "Directory " + libraryDir + " cannot be read");
            return;
        }
        File platformFile = null;
        for (File f : libraryDir.listFiles()) {
            if (!f.isFile()) continue;
            if (f.getPath().endsWith("etc/permissions/platform.xml")) {
                platformFile = f;
                continue;
            }
            if (!f.getPath().endsWith(".xml")) {
                Slog.i(TAG, "Non-xml file " + f + " in " + libraryDir + " directory, ignoring");
                continue;
            }
            if (!f.canRead()) {
                Slog.w(TAG, "Permissions library file " + f + " cannot be read");
                continue;
            }
            this.readPermissionsFromXml(parser, f, permissionFlag);
        }
        if (platformFile != null) {
            this.readPermissionsFromXml(parser, platformFile, permissionFlag);
        }
    }

    private void logNotAllowedInPartition(String name, File permFile, XmlPullParser parser) {
        Slog.w(TAG, "<" + name + "> not allowed in partition of " + permFile + " at " + parser.getPositionDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void readPermissionsFromXml(XmlPullParser parser, File permFile, int permissionFlag) {
        try {
            permReader = new FileReader(permFile);
        }
        catch (FileNotFoundException e) {
            Slog.w("SystemConfig", "Couldn't find or open permissions file " + permFile);
            return;
        }
        Slog.i("SystemConfig", "Reading permissions from " + permFile);
        lowRam = ActivityManager.isLowRamDeviceStatic();
        try {
            parser.setInput((Reader)permReader);
            do {
                type = parser.next();
                if (type == 2) break;
            } while (type != 1);
            if (type != 2) {
                throw new XmlPullParserException("No start tag found");
            }
            if (!parser.getName().equals("permissions") && !parser.getName().equals("config")) {
                throw new XmlPullParserException("Unexpected start tag in " + permFile + ": found " + parser.getName() + ", expected 'permissions' or 'config'");
            }
            allowAll = permissionFlag == -1;
            allowLibs = (permissionFlag & 2) != 0;
            allowFeatures = (permissionFlag & 1) != 0;
            allowPermissions = (permissionFlag & 4) != 0;
            allowAppConfigs = (permissionFlag & 8) != 0;
            allowPrivappPermissions = (permissionFlag & 16) != 0;
            allowOemPermissions = (permissionFlag & 32) != 0;
            allowApiWhitelisting = (permissionFlag & 64) != 0;
            allowAssociations = (permissionFlag & 128) != 0;
            allowOverrideAppRestrictions = (permissionFlag & 256) != 0;
            allowImplicitBroadcasts = (permissionFlag & 512) != 0;
            allowVendorApex = (permissionFlag & 1024) != 0;
            while (true) {
                XmlUtils.nextElement(parser);
                if (parser.getEventType() == 1) {
                    break;
                }
                name = parser.getName();
                if (name == null) {
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                var20_25 = name;
                var21_26 = -1;
                switch (var20_25.hashCode()) {
                    case 98629247: {
                        if (!var20_25.equals("group")) break;
                        var21_26 = 0;
                        break;
                    }
                    case -517618225: {
                        if (!var20_25.equals("permission")) break;
                        var21_26 = 1;
                        break;
                    }
                    case 953292141: {
                        if (!var20_25.equals("assign-permission")) break;
                        var21_26 = 2;
                        break;
                    }
                    case 1269564002: {
                        if (!var20_25.equals("split-permission")) break;
                        var21_26 = 3;
                        break;
                    }
                    case 1005096720: {
                        if (!var20_25.equals("apex-library")) break;
                        var21_26 = 4;
                        break;
                    }
                    case 166208699: {
                        if (!var20_25.equals("library")) break;
                        var21_26 = 5;
                        break;
                    }
                    case -979207434: {
                        if (!var20_25.equals("feature")) break;
                        var21_26 = 6;
                        break;
                    }
                    case -828905863: {
                        if (!var20_25.equals("unavailable-feature")) break;
                        var21_26 = 7;
                        break;
                    }
                    case -642819164: {
                        if (!var20_25.equals("allow-in-power-save-except-idle")) break;
                        var21_26 = 8;
                        break;
                    }
                    case -1882490007: {
                        if (!var20_25.equals("allow-in-power-save")) break;
                        var21_26 = 9;
                        break;
                    }
                    case 802332808: {
                        if (!var20_25.equals("allow-in-data-usage-save")) break;
                        var21_26 = 10;
                        break;
                    }
                    case -2040330235: {
                        if (!var20_25.equals("allow-unthrottled-location")) break;
                        var21_26 = 11;
                        break;
                    }
                    case -1582324217: {
                        if (!var20_25.equals("allow-adas-location-settings")) break;
                        var21_26 = 12;
                        break;
                    }
                    case -560717308: {
                        if (!var20_25.equals("allow-ignore-location-settings")) break;
                        var21_26 = 13;
                        break;
                    }
                    case 1954925533: {
                        if (!var20_25.equals("allow-implicit-broadcast")) break;
                        var21_26 = 14;
                        break;
                    }
                    case 1121420326: {
                        if (!var20_25.equals("app-link")) break;
                        var21_26 = 15;
                        break;
                    }
                    case -634266752: {
                        if (!var20_25.equals("bg-restriction-exemption")) break;
                        var21_26 = 16;
                        break;
                    }
                    case 1567330472: {
                        if (!var20_25.equals("default-enabled-vr-app")) break;
                        var21_26 = 17;
                        break;
                    }
                    case -1461465444: {
                        if (!var20_25.equals("component-override")) break;
                        var21_26 = 18;
                        break;
                    }
                    case 347247519: {
                        if (!var20_25.equals("backup-transport-whitelisted-service")) break;
                        var21_26 = 19;
                        break;
                    }
                    case 1633270165: {
                        if (!var20_25.equals("disabled-until-used-preinstalled-carrier-associated-app")) break;
                        var21_26 = 20;
                        break;
                    }
                    case -1005864890: {
                        if (!var20_25.equals("disabled-until-used-preinstalled-carrier-app")) break;
                        var21_26 = 21;
                        break;
                    }
                    case 1723146313: {
                        if (!var20_25.equals("privapp-permissions")) break;
                        var21_26 = 22;
                        break;
                    }
                    case 1044015374: {
                        if (!var20_25.equals("oem-permissions")) break;
                        var21_26 = 23;
                        break;
                    }
                    case 180165796: {
                        if (!var20_25.equals("hidden-api-whitelisted-app")) break;
                        var21_26 = 24;
                        break;
                    }
                    case -980620291: {
                        if (!var20_25.equals("allow-association")) break;
                        var21_26 = 25;
                        break;
                    }
                    case 1347585732: {
                        if (!var20_25.equals("app-data-isolation-whitelisted-app")) break;
                        var21_26 = 26;
                        break;
                    }
                    case 1723586945: {
                        if (!var20_25.equals("bugreport-whitelisted")) break;
                        var21_26 = 27;
                        break;
                    }
                    case -150068154: {
                        if (!var20_25.equals("install-in-user-type")) break;
                        var21_26 = 28;
                        break;
                    }
                    case -1554938271: {
                        if (!var20_25.equals("named-actor")) break;
                        var21_26 = 29;
                        break;
                    }
                    case 1793277898: {
                        if (!var20_25.equals("overlay-config-signature")) break;
                        var21_26 = 30;
                        break;
                    }
                    case 968751633: {
                        if (!var20_25.equals("rollback-whitelisted-app")) break;
                        var21_26 = 31;
                        break;
                    }
                    case 1046683496: {
                        if (!var20_25.equals("whitelisted-staged-installer")) break;
                        var21_26 = 32;
                        break;
                    }
                    case 414198242: {
                        if (!var20_25.equals("allowed-vendor-apex")) break;
                        var21_26 = 33;
                    }
                }
                switch (var21_26) {
                    case 0: {
                        if (allowAll) {
                            gidStr = parser.getAttributeValue(null, "gid");
                            if (gidStr != null) {
                                gid = Process.getGidForName(gidStr);
                                this.mGlobalGids = ArrayUtils.appendInt(this.mGlobalGids, gid);
                            } else {
                                Slog.w("SystemConfig", "<" + name + "> without gid in " + permFile + " at " + parser.getPositionDescription());
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 1: {
                        if (allowPermissions) {
                            perm = parser.getAttributeValue(null, "name");
                            if (perm == null) {
                                Slog.w("SystemConfig", "<" + name + "> without name in " + permFile + " at " + parser.getPositionDescription());
                                XmlUtils.skipCurrentTag(parser);
                                break;
                            }
                            perm = perm.intern();
                            this.readPermission(parser, perm);
                            break;
                        }
                        this.logNotAllowedInPartition(name, permFile, parser);
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 2: {
                        if (allowPermissions) {
                            perm = parser.getAttributeValue(null, "name");
                            if (perm == null) {
                                Slog.w("SystemConfig", "<" + name + "> without name in " + permFile + " at " + parser.getPositionDescription());
                                XmlUtils.skipCurrentTag(parser);
                                break;
                            }
                            uidStr = parser.getAttributeValue(null, "uid");
                            if (uidStr == null) {
                                Slog.w("SystemConfig", "<" + name + "> without uid in " + permFile + " at " + parser.getPositionDescription());
                                XmlUtils.skipCurrentTag(parser);
                                break;
                            }
                            uid = Process.getUidForName(uidStr);
                            if (uid < 0) {
                                Slog.w("SystemConfig", "<" + name + "> with unknown uid \"" + uidStr + "  in " + permFile + " at " + parser.getPositionDescription());
                                XmlUtils.skipCurrentTag(parser);
                                break;
                            }
                            perm = perm.intern();
                            perms /* !! */  = this.mSystemPermissions.get(uid);
                            if (perms /* !! */  == null) {
                                perms /* !! */  = new ArraySet<E>();
                                this.mSystemPermissions.put(uid, perms /* !! */ );
                            }
                            perms /* !! */ .add(perm);
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 3: {
                        if (allowPermissions) {
                            this.readSplitPermission(parser, permFile);
                            break;
                        }
                        this.logNotAllowedInPartition(name, permFile, parser);
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 4: 
                    case 5: {
                        if (allowLibs) {
                            lname = parser.getAttributeValue(null, "name");
                            lfile = parser.getAttributeValue(null, "file");
                            ldependency = parser.getAttributeValue(null, "dependency");
                            minDeviceSdk = parser.getAttributeValue(null, "min-device-sdk");
                            maxDeviceSdk = parser.getAttributeValue(null, "max-device-sdk");
                            if (lname == null) {
                                Slog.w("SystemConfig", "<" + name + "> without name in " + permFile + " at " + parser.getPositionDescription());
                            } else if (lfile == null) {
                                Slog.w("SystemConfig", "<" + name + "> without file in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                allowedMinSdk = minDeviceSdk == null || SystemConfig.isAtLeastSdkLevel(minDeviceSdk) != false;
                                allowedMaxSdk = maxDeviceSdk == null || SystemConfig.isAtMostSdkLevel(maxDeviceSdk) != false;
                                exists = new File(lfile).exists();
                                if (allowedMinSdk && allowedMaxSdk && exists) {
                                    bcpSince = parser.getAttributeValue(null, "on-bootclasspath-since");
                                    bcpBefore = parser.getAttributeValue(null, "on-bootclasspath-before");
                                    entry = new SharedLibraryEntry(lname, lfile, ldependency == null ? new String[]{} : ldependency.split(":"), bcpSince, bcpBefore);
                                    this.mSharedLibraries.put(lname, entry);
                                } else {
                                    msg = new StringBuilder("Ignore shared library ").append(lname).append(":");
                                    if (!allowedMinSdk) {
                                        msg.append(" min-device-sdk=").append(minDeviceSdk);
                                    }
                                    if (!allowedMaxSdk) {
                                        msg.append(" max-device-sdk=").append(maxDeviceSdk);
                                    }
                                    if (!exists) {
                                        msg.append(" ").append(lfile).append(" does not exist");
                                    }
                                    Slog.i("SystemConfig", msg.toString());
                                }
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 6: {
                        if (allowFeatures) {
                            fname = parser.getAttributeValue(null, "name");
                            fversion = XmlUtils.readIntAttribute(parser, "version", 0);
                            if (!lowRam) {
                                allowed = true;
                            } else {
                                notLowRam = parser.getAttributeValue(null, "notLowRam");
                                v0 = allowed = "true".equals(notLowRam) == false;
                            }
                            if (fname == null) {
                                Slog.w("SystemConfig", "<" + name + "> without name in " + permFile + " at " + parser.getPositionDescription());
                            } else if (allowed) {
                                this.addFeature(fname, fversion);
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 7: {
                        if (allowFeatures) {
                            fname = parser.getAttributeValue(null, "name");
                            if (fname == null) {
                                Slog.w("SystemConfig", "<" + name + "> without name in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                this.mUnavailableFeatures.add(fname);
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 8: {
                        if (allowOverrideAppRestrictions) {
                            pkgname = parser.getAttributeValue(null, "package");
                            if (pkgname == null) {
                                Slog.w("SystemConfig", "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                this.mAllowInPowerSaveExceptIdle.add(pkgname);
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 9: {
                        if (allowOverrideAppRestrictions) {
                            pkgname = parser.getAttributeValue(null, "package");
                            if (pkgname == null) {
                                Slog.w("SystemConfig", "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                this.mAllowInPowerSave.add(pkgname);
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 10: {
                        if (allowOverrideAppRestrictions) {
                            pkgname = parser.getAttributeValue(null, "package");
                            if (pkgname == null) {
                                Slog.w("SystemConfig", "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                this.mAllowInDataUsageSave.add(pkgname);
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 11: {
                        if (allowOverrideAppRestrictions) {
                            pkgname = parser.getAttributeValue(null, "package");
                            if (pkgname == null) {
                                Slog.w("SystemConfig", "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                this.mAllowUnthrottledLocation.add(pkgname);
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 12: {
                        if (allowOverrideAppRestrictions) {
                            pkgname = parser.getAttributeValue(null, "package");
                            attributionTag = parser.getAttributeValue(null, "attributionTag");
                            if (pkgname == null) {
                                Slog.w("SystemConfig", "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                tags = this.mAllowAdasSettings.get(pkgname);
                                if (tags == null || !tags.isEmpty()) {
                                    if (tags == null) {
                                        tags = new ArraySet<E>(1);
                                        this.mAllowAdasSettings.put(pkgname, tags);
                                    }
                                    if (!"*".equals(attributionTag)) {
                                        if ("null".equals(attributionTag)) {
                                            attributionTag = null;
                                        }
                                        tags.add(attributionTag);
                                    }
                                }
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 13: {
                        if (allowOverrideAppRestrictions) {
                            pkgname = parser.getAttributeValue(null, "package");
                            attributionTag = parser.getAttributeValue(null, "attributionTag");
                            if (pkgname == null) {
                                Slog.w("SystemConfig", "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                tags = this.mAllowIgnoreLocationSettings.get(pkgname);
                                if (tags == null || !tags.isEmpty()) {
                                    if (tags == null) {
                                        tags = new ArraySet<E>(1);
                                        this.mAllowIgnoreLocationSettings.put(pkgname, tags);
                                    }
                                    if (!"*".equals(attributionTag)) {
                                        if ("null".equals(attributionTag)) {
                                            attributionTag = null;
                                        }
                                        tags.add(attributionTag);
                                    }
                                }
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 14: {
                        if (allowImplicitBroadcasts) {
                            action = parser.getAttributeValue(null, "action");
                            if (action == null) {
                                Slog.w("SystemConfig", "<" + name + "> without action in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                this.mAllowImplicitBroadcasts.add(action);
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 15: {
                        if (allowAppConfigs) {
                            pkgname = parser.getAttributeValue(null, "package");
                            if (pkgname == null) {
                                Slog.w("SystemConfig", "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                this.mLinkedApps.add(pkgname);
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 16: {
                        if (allowOverrideAppRestrictions) {
                            pkgname = parser.getAttributeValue(null, "package");
                            if (pkgname == null) {
                                Slog.w("SystemConfig", "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                this.mBgRestrictionExemption.add(pkgname);
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 17: {
                        if (allowAppConfigs) {
                            pkgname = parser.getAttributeValue(null, "package");
                            clsname = parser.getAttributeValue(null, "class");
                            if (pkgname == null) {
                                Slog.w("SystemConfig", "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                            } else if (clsname == null) {
                                Slog.w("SystemConfig", "<" + name + "> without class in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                this.mDefaultVrComponents.add(new ComponentName(pkgname, clsname));
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 18: {
                        this.readComponentOverrides(parser, permFile);
                        break;
                    }
                    case 19: {
                        if (allowFeatures) {
                            serviceName = parser.getAttributeValue(null, "service");
                            if (serviceName == null) {
                                Slog.w("SystemConfig", "<" + name + "> without service in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                cn = ComponentName.unflattenFromString(serviceName);
                                if (cn == null) {
                                    Slog.w("SystemConfig", "<" + name + "> with invalid service name " + serviceName + " in " + permFile + " at " + parser.getPositionDescription());
                                } else {
                                    this.mBackupTransportWhitelist.add(cn);
                                }
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 20: {
                        if (allowAppConfigs) {
                            pkgname = parser.getAttributeValue(null, "package");
                            carrierPkgname = parser.getAttributeValue(null, "carrierAppPackage");
                            if (pkgname == null || carrierPkgname == null) {
                                Slog.w("SystemConfig", "<" + name + "> without package or carrierAppPackage in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                addedInSdk = -1;
                                addedInSdkStr = parser.getAttributeValue(null, "addedInSdk");
                                if (!TextUtils.isEmpty(addedInSdkStr)) {
                                    try {
                                        addedInSdk = Integer.parseInt(addedInSdkStr);
                                    }
                                    catch (NumberFormatException e) {
                                        Slog.w("SystemConfig", "<" + name + "> addedInSdk not an integer in " + permFile + " at " + parser.getPositionDescription());
                                        XmlUtils.skipCurrentTag(parser);
                                        break;
                                    }
                                }
                                if ((associatedPkgs = this.mDisabledUntilUsedPreinstalledCarrierAssociatedApps.get(carrierPkgname)) == null) {
                                    associatedPkgs = new ArrayList<CarrierAssociatedAppEntry>();
                                    this.mDisabledUntilUsedPreinstalledCarrierAssociatedApps.put(carrierPkgname, associatedPkgs);
                                }
                                associatedPkgs.add(new CarrierAssociatedAppEntry(pkgname, addedInSdk));
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 21: {
                        if (allowAppConfigs) {
                            pkgname = parser.getAttributeValue(null, "package");
                            if (pkgname == null) {
                                Slog.w("SystemConfig", "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                this.mDisabledUntilUsedPreinstalledCarrierApps.add(pkgname);
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 22: {
                        if (allowPrivappPermissions) {
                            vendor = permFile.toPath().startsWith(Environment.getVendorDirectory().toPath() + "/") != false || permFile.toPath().startsWith(Environment.getOdmDirectory().toPath() + "/") != false;
                            product = permFile.toPath().startsWith(Environment.getProductDirectory().toPath() + "/");
                            systemExt = permFile.toPath().startsWith(Environment.getSystemExtDirectory().toPath() + "/");
                            v1 = apex = permFile.toPath().startsWith(Environment.getApexDirectory().toPath() + "/") != false && ApexProperties.updatable().orElse(false) != false;
                            if (vendor) {
                                this.readPrivAppPermissions(parser, this.mVendorPrivAppPermissions, this.mVendorPrivAppDenyPermissions);
                                break;
                            }
                            if (product) {
                                this.readPrivAppPermissions(parser, this.mProductPrivAppPermissions, this.mProductPrivAppDenyPermissions);
                                break;
                            }
                            if (systemExt) {
                                this.readPrivAppPermissions(parser, this.mSystemExtPrivAppPermissions, this.mSystemExtPrivAppDenyPermissions);
                                break;
                            }
                            if (apex) {
                                this.readApexPrivAppPermissions(parser, permFile, Environment.getApexDirectory().toPath());
                                break;
                            }
                            this.readPrivAppPermissions(parser, this.mPrivAppPermissions, this.mPrivAppDenyPermissions);
                            break;
                        }
                        this.logNotAllowedInPartition(name, permFile, parser);
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 23: {
                        if (allowOemPermissions) {
                            this.readOemPermissions(parser);
                            break;
                        }
                        this.logNotAllowedInPartition(name, permFile, parser);
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 24: {
                        if (allowApiWhitelisting) {
                            pkgname = parser.getAttributeValue(null, "package");
                            if (pkgname == null) {
                                Slog.w("SystemConfig", "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                this.mHiddenApiPackageWhitelist.add(pkgname);
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 25: {
                        if (allowAssociations) {
                            target = parser.getAttributeValue(null, "target");
                            if (target == null) {
                                Slog.w("SystemConfig", "<" + name + "> without target in " + permFile + " at " + parser.getPositionDescription());
                                XmlUtils.skipCurrentTag(parser);
                                break;
                            }
                            allowed = parser.getAttributeValue(null, "allowed");
                            if (allowed == null) {
                                Slog.w("SystemConfig", "<" + name + "> without allowed in " + permFile + " at " + parser.getPositionDescription());
                                XmlUtils.skipCurrentTag(parser);
                                break;
                            }
                            target = target.intern();
                            allowed = allowed.intern();
                            associations = this.mAllowedAssociations.get(target);
                            if (associations == null) {
                                associations = new ArraySet<E>();
                                this.mAllowedAssociations.put(target, associations);
                            }
                            Slog.i("SystemConfig", "Adding association: " + target + " <- " + allowed);
                            associations.add(allowed);
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 26: {
                        pkgname = parser.getAttributeValue(null, "package");
                        if (pkgname == null) {
                            Slog.w("SystemConfig", "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                        } else {
                            this.mAppDataIsolationWhitelistedApps.add(pkgname);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 27: {
                        pkgname = parser.getAttributeValue(null, "package");
                        if (pkgname == null) {
                            Slog.w("SystemConfig", "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                        } else {
                            this.mBugreportWhitelistedPackages.add(pkgname);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 28: {
                        this.readInstallInUserType(parser, this.mPackageToUserTypeWhitelist, this.mPackageToUserTypeBlacklist);
                        break;
                    }
                    case 29: {
                        namespace = TextUtils.safeIntern(parser.getAttributeValue(null, "namespace"));
                        actorName = parser.getAttributeValue(null, "name");
                        pkgName = TextUtils.safeIntern(parser.getAttributeValue(null, "package"));
                        if (TextUtils.isEmpty(namespace)) {
                            Slog.wtf("SystemConfig", "<" + name + "> without namespace in " + permFile + " at " + parser.getPositionDescription());
                        } else if (TextUtils.isEmpty(actorName)) {
                            Slog.wtf("SystemConfig", "<" + name + "> without actor name in " + permFile + " at " + parser.getPositionDescription());
                        } else if (TextUtils.isEmpty(pkgName)) {
                            Slog.wtf("SystemConfig", "<" + name + "> without package name in " + permFile + " at " + parser.getPositionDescription());
                        } else {
                            if ("android".equalsIgnoreCase(namespace)) {
                                throw new IllegalStateException("Defining " + actorName + " as " + pkgName + " for the android namespace is not allowed");
                            }
                            if (this.mNamedActors == null) {
                                this.mNamedActors = new ArrayMap<String, Map<String, String>>();
                            }
                            if ((nameToPkgMap = this.mNamedActors.get(namespace)) == null) {
                                nameToPkgMap = new ArrayMap<String, String>();
                                this.mNamedActors.put(namespace, nameToPkgMap);
                            } else if (nameToPkgMap.containsKey(actorName)) {
                                existing = nameToPkgMap.get(actorName);
                                throw new IllegalStateException("Duplicate actor definition for " + namespace + "/" + actorName + "; defined as both " + existing + " and " + pkgName);
                            }
                            nameToPkgMap.put(actorName, pkgName);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 30: {
                        if (!allowAll) ** GOTO lbl677
                        pkgName = parser.getAttributeValue(null, "package");
                        if (pkgName == null) {
                            Slog.w("SystemConfig", "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                        } else if (TextUtils.isEmpty(this.mOverlayConfigSignaturePackage)) {
                            this.mOverlayConfigSignaturePackage = pkgName.intern();
                        } else {
                            throw new IllegalStateException("Reference signature package defined as both " + this.mOverlayConfigSignaturePackage + " and " + pkgName);
lbl677:
                            // 1 sources

                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 31: {
                        pkgname = parser.getAttributeValue(null, "package");
                        if (pkgname == null) {
                            Slog.w("SystemConfig", "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                        } else {
                            this.mRollbackWhitelistedPackages.add(pkgname);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 32: {
                        if (allowAppConfigs) {
                            pkgname = parser.getAttributeValue(null, "package");
                            isModulesInstaller = XmlUtils.readBooleanAttribute(parser, "isModulesInstaller", false);
                            if (pkgname == null) {
                                Slog.w("SystemConfig", "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                            } else {
                                this.mWhitelistedStagedInstallers.add(pkgname);
                            }
                            if (isModulesInstaller) {
                                if (this.mModulesInstallerPackageName != null) {
                                    throw new IllegalStateException("Multiple modules installers");
                                }
                                this.mModulesInstallerPackageName = pkgname;
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    case 33: {
                        if (allowVendorApex) {
                            pkgName = parser.getAttributeValue(null, "package");
                            installerPkgName = parser.getAttributeValue(null, "installerPackage");
                            if (pkgName == null) {
                                Slog.w("SystemConfig", "<" + name + "> without package in " + permFile + " at " + parser.getPositionDescription());
                            }
                            if (installerPkgName == null) {
                                Slog.w("SystemConfig", "<" + name + "> without installerPackage in " + permFile + " at " + parser.getPositionDescription());
                            }
                            if (pkgName != null && installerPkgName != null) {
                                this.mAllowedVendorApexes.put(pkgName, installerPkgName);
                            }
                        } else {
                            this.logNotAllowedInPartition(name, permFile, parser);
                        }
                        XmlUtils.skipCurrentTag(parser);
                        break;
                    }
                    default: {
                        Slog.w("SystemConfig", "Tag " + name + " is unknown in " + permFile + " at " + parser.getPositionDescription());
                        XmlUtils.skipCurrentTag(parser);
                    }
                }
            }
        }
        catch (XmlPullParserException e) {
            Slog.w("SystemConfig", "Got exception parsing permissions.", e);
        }
        catch (IOException e) {
            Slog.w("SystemConfig", "Got exception parsing permissions.", e);
        }
        finally {
            IoUtils.closeQuietly(permReader);
        }
        if (StorageManager.isFileEncryptedNativeOnly()) {
            this.addFeature("android.software.file_based_encryption", 0);
            this.addFeature("android.software.securely_removes_users", 0);
        }
        if (StorageManager.hasAdoptable()) {
            this.addFeature("android.software.adoptable_storage", 0);
        }
        if (ActivityManager.isLowRamDeviceStatic()) {
            this.addFeature("android.hardware.ram.low", 0);
        } else {
            this.addFeature("android.hardware.ram.normal", 0);
        }
        incrementalVersion = IncrementalManager.getVersion();
        if (incrementalVersion > 0) {
            this.addFeature("android.software.incremental_delivery", incrementalVersion);
        }
        this.addFeature("android.software.app_enumeration", 0);
        if (_Original_Build.VERSION.DEVICE_INITIAL_SDK_INT >= 29) {
            this.addFeature("android.software.ipsec_tunnels", 0);
        }
        if (SystemConfig.isErofsSupported()) {
            if (SystemConfig.isKernelVersionAtLeast(5, 10)) {
                this.addFeature("android.software.erofs", 0);
            } else if (SystemConfig.isKernelVersionAtLeast(4, 19)) {
                this.addFeature("android.software.erofs_legacy", 0);
            }
        }
        for (String featureName : this.mUnavailableFeatures) {
            this.removeFeature(featureName);
        }
    }

    private void addFeature(String name, int version) {
        FeatureInfo fi = this.mAvailableFeatures.get(name);
        if (fi == null) {
            fi = new FeatureInfo();
            fi.name = name;
            fi.version = version;
            this.mAvailableFeatures.put(name, fi);
        } else {
            fi.version = Math.max(fi.version, version);
        }
    }

    private void removeFeature(String name) {
        if (this.mAvailableFeatures.remove(name) != null) {
            Slog.d(TAG, "Removed unavailable feature " + name);
        }
    }

    void readPermission(XmlPullParser parser, String name) throws IOException, XmlPullParserException {
        int type;
        if (this.mPermissions.containsKey(name)) {
            throw new IllegalStateException("Duplicate permission definition for " + name);
        }
        boolean perUser = XmlUtils.readBooleanAttribute(parser, "perUser", false);
        PermissionEntry perm = new PermissionEntry(name, perUser);
        this.mPermissions.put(name, perm);
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if ("group".equals(tagName)) {
                String gidStr = parser.getAttributeValue(null, "gid");
                if (gidStr != null) {
                    int gid = Process.getGidForName(gidStr);
                    perm.gids = ArrayUtils.appendInt(perm.gids, gid);
                } else {
                    Slog.w(TAG, "<group> without gid at " + parser.getPositionDescription());
                }
            }
            XmlUtils.skipCurrentTag(parser);
        }
    }

    private void readPrivAppPermissions(XmlPullParser parser, ArrayMap<String, ArraySet<String>> grantMap, ArrayMap<String, ArraySet<String>> denyMap) throws IOException, XmlPullParserException {
        String packageName = parser.getAttributeValue(null, "package");
        if (TextUtils.isEmpty(packageName)) {
            Slog.w(TAG, "package is required for <privapp-permissions> in " + parser.getPositionDescription());
            return;
        }
        ArraySet<String> permissions = grantMap.get(packageName);
        if (permissions == null) {
            permissions = new ArraySet();
        }
        ArraySet<String> denyPermissions = denyMap.get(packageName);
        int depth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, depth)) {
            String permName;
            String name = parser.getName();
            if ("permission".equals(name)) {
                permName = parser.getAttributeValue(null, "name");
                if (TextUtils.isEmpty(permName)) {
                    Slog.w(TAG, "name is required for <permission> in " + parser.getPositionDescription());
                    continue;
                }
                permissions.add(permName);
                continue;
            }
            if (!"deny-permission".equals(name)) continue;
            permName = parser.getAttributeValue(null, "name");
            if (TextUtils.isEmpty(permName)) {
                Slog.w(TAG, "name is required for <deny-permission> in " + parser.getPositionDescription());
                continue;
            }
            if (denyPermissions == null) {
                denyPermissions = new ArraySet();
            }
            denyPermissions.add(permName);
        }
        grantMap.put(packageName, permissions);
        if (denyPermissions != null) {
            denyMap.put(packageName, denyPermissions);
        }
    }

    private void readInstallInUserType(XmlPullParser parser, Map<String, Set<String>> doInstallMap, Map<String, Set<String>> nonInstallMap) throws IOException, XmlPullParserException {
        String packageName = parser.getAttributeValue(null, "package");
        if (TextUtils.isEmpty(packageName)) {
            Slog.w(TAG, "package is required for <install-in-user-type> in " + parser.getPositionDescription());
            return;
        }
        Set<String> userTypesYes = doInstallMap.get(packageName);
        Set<String> userTypesNo = nonInstallMap.get(packageName);
        int depth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, depth)) {
            String userType;
            String name = parser.getName();
            if ("install-in".equals(name)) {
                userType = parser.getAttributeValue(null, "user-type");
                if (TextUtils.isEmpty(userType)) {
                    Slog.w(TAG, "user-type is required for <install-in-user-type> in " + parser.getPositionDescription());
                    continue;
                }
                if (userTypesYes == null) {
                    userTypesYes = new ArraySet<String>();
                    doInstallMap.put(packageName, userTypesYes);
                }
                userTypesYes.add(userType);
                continue;
            }
            if ("do-not-install-in".equals(name)) {
                userType = parser.getAttributeValue(null, "user-type");
                if (TextUtils.isEmpty(userType)) {
                    Slog.w(TAG, "user-type is required for <install-in-user-type> in " + parser.getPositionDescription());
                    continue;
                }
                if (userTypesNo == null) {
                    userTypesNo = new ArraySet<String>();
                    nonInstallMap.put(packageName, userTypesNo);
                }
                userTypesNo.add(userType);
                continue;
            }
            Slog.w(TAG, "unrecognized tag in <install-in-user-type> in " + parser.getPositionDescription());
        }
    }

    void readOemPermissions(XmlPullParser parser) throws IOException, XmlPullParserException {
        String packageName = parser.getAttributeValue(null, "package");
        if (TextUtils.isEmpty(packageName)) {
            Slog.w(TAG, "package is required for <oem-permissions> in " + parser.getPositionDescription());
            return;
        }
        ArrayMap<String, Boolean> permissions = this.mOemPermissions.get(packageName);
        if (permissions == null) {
            permissions = new ArrayMap();
        }
        int depth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, depth)) {
            String permName;
            String name = parser.getName();
            if ("permission".equals(name)) {
                permName = parser.getAttributeValue(null, "name");
                if (TextUtils.isEmpty(permName)) {
                    Slog.w(TAG, "name is required for <permission> in " + parser.getPositionDescription());
                    continue;
                }
                permissions.put(permName, Boolean.TRUE);
                continue;
            }
            if (!"deny-permission".equals(name)) continue;
            permName = parser.getAttributeValue(null, "name");
            if (TextUtils.isEmpty(permName)) {
                Slog.w(TAG, "name is required for <deny-permission> in " + parser.getPositionDescription());
                continue;
            }
            permissions.put(permName, Boolean.FALSE);
        }
        this.mOemPermissions.put(packageName, permissions);
    }

    private void readSplitPermission(XmlPullParser parser, File permFile) throws IOException, XmlPullParserException {
        String splitPerm = parser.getAttributeValue(null, "name");
        if (splitPerm == null) {
            Slog.w(TAG, "<split-permission> without name in " + permFile + " at " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
            return;
        }
        String targetSdkStr = parser.getAttributeValue(null, "targetSdk");
        int targetSdk = 10001;
        if (!TextUtils.isEmpty(targetSdkStr)) {
            try {
                targetSdk = Integer.parseInt(targetSdkStr);
            }
            catch (NumberFormatException e) {
                Slog.w(TAG, "<split-permission> targetSdk not an integer in " + permFile + " at " + parser.getPositionDescription());
                XmlUtils.skipCurrentTag(parser);
                return;
            }
        }
        int depth = parser.getDepth();
        ArrayList<String> newPermissions = new ArrayList<String>();
        while (XmlUtils.nextElementWithin(parser, depth)) {
            String name = parser.getName();
            if ("new-permission".equals(name)) {
                String newName = parser.getAttributeValue(null, "name");
                if (TextUtils.isEmpty(newName)) {
                    Slog.w(TAG, "name is required for <new-permission> in " + parser.getPositionDescription());
                    continue;
                }
                newPermissions.add(newName);
                continue;
            }
            XmlUtils.skipCurrentTag(parser);
        }
        if (!newPermissions.isEmpty()) {
            this.mSplitPermissions.add(new PermissionManager.SplitPermissionInfo(splitPerm, newPermissions, targetSdk));
        }
    }

    private void readComponentOverrides(XmlPullParser parser, File permFile) throws IOException, XmlPullParserException {
        String pkgname = parser.getAttributeValue(null, "package");
        if (pkgname == null) {
            Slog.w(TAG, "<component-override> without package in " + permFile + " at " + parser.getPositionDescription());
            return;
        }
        pkgname = pkgname.intern();
        int depth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, depth)) {
            if (!"component".equals(parser.getName())) continue;
            String clsname = parser.getAttributeValue(null, "class");
            String enabled = parser.getAttributeValue(null, "enabled");
            if (clsname == null) {
                Slog.w(TAG, "<component> without class in " + permFile + " at " + parser.getPositionDescription());
                return;
            }
            if (enabled == null) {
                Slog.w(TAG, "<component> without enabled in " + permFile + " at " + parser.getPositionDescription());
                return;
            }
            if (clsname.startsWith(".")) {
                clsname = pkgname + clsname;
            }
            clsname = clsname.intern();
            ArrayMap<String, Boolean> componentEnabledStates = this.mPackageComponentEnabledState.get(pkgname);
            if (componentEnabledStates == null) {
                componentEnabledStates = new ArrayMap();
                this.mPackageComponentEnabledState.put(pkgname, componentEnabledStates);
            }
            componentEnabledStates.put(clsname, !"false".equals(enabled));
        }
    }

    private void readPublicNativeLibrariesList() {
        String[] dirs;
        this.readPublicLibrariesListFile(new File("/vendor/etc/public.libraries.txt"));
        for (String dir : dirs = new String[]{"/system/etc", "/system_ext/etc", "/product/etc"}) {
            File[] files = new File(dir).listFiles();
            if (files == null) {
                Slog.w(TAG, "Public libraries file folder missing: " + dir);
                continue;
            }
            for (File f : files) {
                String name = f.getName();
                if (!name.startsWith("public.libraries-") || !name.endsWith(".txt")) continue;
                this.readPublicLibrariesListFile(f);
            }
        }
    }

    private void readPublicLibrariesListFile(File listFile) {
        try (BufferedReader br = new BufferedReader(new FileReader(listFile));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.isEmpty() || line.startsWith("#")) continue;
                String soname = line.trim().split(" ")[0];
                SharedLibraryEntry entry = new SharedLibraryEntry(soname, soname, new String[0], true);
                this.mSharedLibraries.put(entry.name, entry);
            }
        }
        catch (IOException e) {
            Slog.w(TAG, "Failed to read public libraries file " + listFile, e);
        }
    }

    private String getApexModuleNameFromFilePath(Path path, Path apexDirectoryPath) {
        if (!path.startsWith(apexDirectoryPath)) {
            throw new IllegalArgumentException("File " + path + " is not part of an APEX.");
        }
        if (path.getNameCount() <= apexDirectoryPath.getNameCount() + 1) {
            throw new IllegalArgumentException("File " + path + " is in the APEX partition, but not inside a module.");
        }
        return path.getName(apexDirectoryPath.getNameCount()).toString();
    }

    @VisibleForTesting
    public void readApexPrivAppPermissions(XmlPullParser parser, File permFile, Path apexDirectoryPath) throws IOException, XmlPullParserException {
        ArrayMap<String, ArraySet<String>> privAppDenyPermissions;
        ArrayMap<String, ArraySet<String>> privAppPermissions;
        String moduleName = this.getApexModuleNameFromFilePath(permFile.toPath(), apexDirectoryPath);
        if (this.mApexPrivAppPermissions.containsKey(moduleName)) {
            privAppPermissions = this.mApexPrivAppPermissions.get(moduleName);
        } else {
            privAppPermissions = new ArrayMap();
            this.mApexPrivAppPermissions.put(moduleName, privAppPermissions);
        }
        if (this.mApexPrivAppDenyPermissions.containsKey(moduleName)) {
            privAppDenyPermissions = this.mApexPrivAppDenyPermissions.get(moduleName);
        } else {
            privAppDenyPermissions = new ArrayMap();
            this.mApexPrivAppDenyPermissions.put(moduleName, privAppDenyPermissions);
        }
        this.readPrivAppPermissions(parser, privAppPermissions, privAppDenyPermissions);
    }

    private static boolean isSystemProcess() {
        return Process.myUid() == 1000;
    }

    private static boolean isErofsSupported() {
        try {
            Path path = Paths.get("/sys/fs/erofs", new String[0]);
            return Files.exists(path, new LinkOption[0]);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isKernelVersionAtLeast(int major, int minor) {
        String kernelVersion = VintfRuntimeInfo.getKernelVersion();
        String[] parts = kernelVersion.split("\\.");
        if (parts.length < 2) {
            return false;
        }
        try {
            int majorVersion = Integer.parseInt(parts[0]);
            int minorVersion = Integer.parseInt(parts[1]);
            return majorVersion > major || majorVersion == major && minorVersion >= minor;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    static {
        EMPTY_PERMISSIONS = new ArrayMap();
    }

    public static class PermissionEntry {
        public final String name;
        public int[] gids;
        public boolean perUser;

        PermissionEntry(String name, boolean perUser) {
            this.name = name;
            this.perUser = perUser;
        }
    }

    public static class SharedLibraryEntry {
        public final String name;
        public final String filename;
        public final String[] dependencies;
        public final String onBootclasspathSince;
        public final String onBootclasspathBefore;
        public final boolean canBeSafelyIgnored;
        public final boolean isNative;

        @VisibleForTesting
        public SharedLibraryEntry(String name, String filename, String[] dependencies, boolean isNative) {
            this(name, filename, dependencies, null, null, isNative);
        }

        @VisibleForTesting
        public SharedLibraryEntry(String name, String filename, String[] dependencies, String onBootclasspathSince, String onBootclasspathBefore) {
            this(name, filename, dependencies, onBootclasspathSince, onBootclasspathBefore, false);
        }

        SharedLibraryEntry(String name, String filename, String[] dependencies, String onBootclasspathSince, String onBootclasspathBefore, boolean isNative) {
            this.name = name;
            this.filename = filename;
            this.dependencies = dependencies;
            this.onBootclasspathSince = onBootclasspathSince;
            this.onBootclasspathBefore = onBootclasspathBefore;
            this.isNative = isNative;
            this.canBeSafelyIgnored = this.onBootclasspathSince != null && SystemConfig.isAtLeastSdkLevel(this.onBootclasspathSince) || this.onBootclasspathBefore != null && !SystemConfig.isAtLeastSdkLevel(this.onBootclasspathBefore);
        }
    }
}

