/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.animation.PropertyValuesHolder_Accessor;
import android.content.res.Configuration;
import android.graphics.drawable.AdaptiveIconDrawable_Delegate;
import android.os.HandlerThread_Delegate;
import android.os._Original_Build;
import android.util.DisplayMetrics;
import android.view.IWindowManagerImpl;
import android.view.ViewConfiguration_Accessor;
import android.view.WindowManagerGlobal_Delegate;
import android.view.inputmethod.InputMethodManager_Accessor;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.ILayoutLog;
import com.android.ide.common.rendering.api.RenderParams;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.XmlParserFactory;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.RenderParamsFlags;
import com.android.layoutlib.bridge.impl.ParserFactory;
import com.android.resources.Density;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenRound;
import com.android.resources.ScreenSize;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public abstract class RenderAction<T extends RenderParams> {
    public static int sSimulatedSdk;
    private static final Set<String> COMPOSE_CLASS_FQNS;
    static BridgeContext sCurrentContext;
    private final T mParams;
    private BridgeContext mContext;
    private static final Object sContextLock;
    private static final Set<BridgeContext> sContexts;

    protected RenderAction(T params) {
        this.mParams = params;
        sSimulatedSdk = _Original_Build.VERSION.SDK_INT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result init(long timeout) {
        Result result = this.acquireLock(timeout);
        if (result != null) {
            return result;
        }
        HardwareConfig hardwareConfig = this.mParams.getHardwareConfig();
        DisplayMetrics metrics = new DisplayMetrics();
        metrics.densityDpi = metrics.noncompatDensityDpi = hardwareConfig.getDensity().getDpiValue();
        metrics.scaledDensity = metrics.noncompatScaledDensity = (metrics.density = (metrics.noncompatDensity = (float)metrics.densityDpi / 160.0f));
        metrics.widthPixels = metrics.noncompatWidthPixels = hardwareConfig.getScreenWidth();
        metrics.heightPixels = metrics.noncompatHeightPixels = hardwareConfig.getScreenHeight();
        metrics.xdpi = metrics.noncompatXdpi = hardwareConfig.getXdpi();
        metrics.ydpi = metrics.noncompatYdpi = hardwareConfig.getYdpi();
        RenderResources resources = this.mParams.getResources();
        AdaptiveIconDrawable_Delegate.sPath = (String)this.mParams.getFlag(RenderParamsFlags.FLAG_KEY_ADAPTIVE_ICON_MASK_PATH);
        this.mContext = new BridgeContext(this.mParams.getProjectKey(), metrics, resources, this.mParams.getAssets(), this.mParams.getLayoutlibCallback(), RenderAction.getConfiguration(this.mParams), this.mParams.getTargetSdkVersion(), this.mParams.isRtlSupported());
        Object object = sContextLock;
        synchronized (object) {
            sContexts.add(this.mContext);
        }
        this.setUp();
        return Result.Status.SUCCESS.createResult();
    }

    public Result acquire(long timeout) {
        if (this.mContext == null) {
            throw new IllegalStateException("After scene creation, #init() must be called");
        }
        Result result = this.acquireLock(timeout);
        if (result != null) {
            return result;
        }
        this.setUp();
        return Result.Status.SUCCESS.createResult();
    }

    private Result acquireLock(long timeout) {
        block5: {
            ReentrantLock lock = Bridge.getLock();
            if (!lock.isHeldByCurrentThread()) {
                try {
                    boolean acquired = lock.tryLock(timeout, TimeUnit.MILLISECONDS);
                    if (!acquired) {
                        return Result.Status.ERROR_TIMEOUT.createResult();
                    }
                    break block5;
                }
                catch (InterruptedException e) {
                    return Result.Status.ERROR_LOCK_INTERRUPTED.createResult();
                }
            }
            if (this.mContext != sCurrentContext) {
                throw new IllegalStateException("Acquiring different scenes from same thread without releases");
            }
            return Result.Status.SUCCESS.createResult();
        }
        return null;
    }

    public void release() {
        ReentrantLock lock = Bridge.getLock();
        if (lock.isHeldByCurrentThread()) {
            this.tearDown();
            lock.unlock();
        }
    }

    private void setUp() {
        ParserFactory.setParserFactory((XmlParserFactory)this.mParams.getLayoutlibCallback());
        this.mContext.initResources(this.mParams.getAssets());
        sCurrentContext = this.mContext;
        this.mContext.applyWallpaper((String)this.mParams.getFlag(RenderParamsFlags.FLAG_KEY_WALLPAPER_PATH));
        this.mContext.setUseThemedIcon(Boolean.TRUE.equals(this.mParams.getFlag(RenderParamsFlags.FLAG_KEY_USE_THEMED_ICON)));
        boolean hasNavigationBar = true;
        IWindowManagerImpl iwm = new IWindowManagerImpl(this.getContext().getConfiguration(), this.getContext().getMetrics(), 0, hasNavigationBar);
        WindowManagerGlobal_Delegate.setWindowManagerService(iwm);
        ILayoutLog currentLog = this.mParams.getLog();
        Bridge.setLog(currentLog);
        this.mContext.getRenderResources().setLogger(currentLog);
    }

    private void tearDown() {
        if (this.mContext != null) {
            this.mContext.disposeResources();
        }
        ViewConfiguration_Accessor.clearConfigurations();
        InputMethodManager_Accessor.tearDownEditMode();
        Bridge.setLog(null);
        if (this.mContext != null) {
            this.mContext.getRenderResources().setLogger(null);
        }
        ParserFactory.setParserFactory(null);
        PropertyValuesHolder_Accessor.clearClassCaches();
    }

    public static BridgeContext getCurrentContext() {
        return sCurrentContext;
    }

    protected T getParams() {
        return this.mParams;
    }

    protected BridgeContext getContext() {
        return this.mContext;
    }

    public ILayoutLog getLog() {
        if (this.mParams != null) {
            return this.mParams.getLog();
        }
        return null;
    }

    protected void checkLock() {
        ReentrantLock lock = Bridge.getLock();
        if (!lock.isHeldByCurrentThread()) {
            throw new IllegalStateException("scene must be acquired first. see #acquire(long)");
        }
        if (sCurrentContext != this.mContext) {
            throw new IllegalStateException("Thread acquired a scene but is rendering a different one");
        }
    }

    public static Configuration getConfiguration(RenderParams params) {
        Density density;
        Configuration config = new Configuration();
        HardwareConfig hardwareConfig = params.getHardwareConfig();
        ScreenSize screenSize = hardwareConfig.getScreenSize();
        if (screenSize != null) {
            switch (screenSize) {
                case SMALL: {
                    config.screenLayout |= 1;
                    break;
                }
                case NORMAL: {
                    config.screenLayout |= 2;
                    break;
                }
                case LARGE: {
                    config.screenLayout |= 3;
                    break;
                }
                case XLARGE: {
                    config.screenLayout |= 4;
                }
            }
        }
        if ((density = hardwareConfig.getDensity()) == null) {
            density = Density.MEDIUM;
        }
        config.screenWidthDp = hardwareConfig.getScreenWidth() * 160 / density.getDpiValue();
        config.screenHeightDp = hardwareConfig.getScreenHeight() * 160 / density.getDpiValue();
        config.smallestScreenWidthDp = config.screenHeightDp < config.screenWidthDp ? config.screenHeightDp : config.screenWidthDp;
        config.densityDpi = density.getDpiValue();
        config.compatScreenWidthDp = config.screenWidthDp;
        config.compatScreenHeightDp = config.screenHeightDp;
        ScreenOrientation orientation = hardwareConfig.getOrientation();
        if (orientation != null) {
            switch (orientation) {
                case PORTRAIT: {
                    config.orientation = 1;
                    break;
                }
                case LANDSCAPE: {
                    config.orientation = 2;
                    break;
                }
                case SQUARE: {
                    config.orientation = 3;
                }
            }
        } else {
            config.orientation = 0;
        }
        ScreenRound roundness = hardwareConfig.getScreenRoundness();
        if (roundness != null) {
            switch (roundness) {
                case ROUND: {
                    config.screenLayout |= 0x200;
                    break;
                }
                case NOTROUND: {
                    config.screenLayout |= 0x100;
                }
            }
        } else {
            config.screenLayout |= 0;
        }
        String locale = params.getLocale();
        if (locale != null && !locale.isEmpty()) {
            config.locale = new Locale(locale);
        }
        config.fontScale = params.getFontScale();
        config.uiMode = params.getUiMode();
        return config;
    }

    private static ClassLoader findComposeClassLoader(BridgeContext context) {
        for (String composeClassName : COMPOSE_CLASS_FQNS) {
            try {
                return context.getLayoutlibCallback().findClass(composeClassName).getClassLoader();
            }
            catch (Throwable throwable) {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BridgeContext findContextFor(ClassLoader classLoader) {
        Object object = sContextLock;
        synchronized (object) {
            for (BridgeContext c : sContexts) {
                if (c == null) continue;
                try {
                    if (RenderAction.findComposeClassLoader(c) != classLoader) continue;
                    return c;
                }
                catch (Throwable throwable) {
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        Object object = sContextLock;
        synchronized (object) {
            sContexts.remove(this.mContext);
        }
        if (sCurrentContext != null) {
            HandlerThread_Delegate.cleanUp(sCurrentContext);
        }
        sCurrentContext = null;
    }

    static {
        COMPOSE_CLASS_FQNS = Set.of("androidx.compose.ui.tooling.ComposeViewAdapter", "androidx.compose.ui.tooling.preview.ComposeViewAdapter");
        sCurrentContext = null;
        sContextLock = new Object();
        sContexts = Collections.newSetFromMap(new WeakHashMap());
    }
}

