/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.android.support;

import android.content.Context;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.common.util.ReflectionUtils;
import com.android.resources.ResourceType;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class SupportPreferencesUtil {
    private static final String[] PREFERENCES_PKG_NAMES = new String[]{"android.support.v7.preference", "androidx.preference"};

    private SupportPreferencesUtil() {
    }

    private static Object instantiateClass(LayoutlibCallback callback, String className, Class[] constructorSignature, Object[] constructorArgs) throws ReflectionUtils.ReflectionException {
        try {
            Object instance = callback.loadClass(className, constructorSignature, constructorArgs);
            if (instance == null) {
                throw new ClassNotFoundException(className + " class not found");
            }
            return instance;
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionUtils.ReflectionException(e);
        }
    }

    private static Object createPreferenceGroupAdapter(LayoutlibCallback callback, String preferenceGroupClassName, String preferenceGroupAdapterClassName, Object preferenceScreen) throws ReflectionUtils.ReflectionException {
        Class<?> preferenceGroupClass = ReflectionUtils.getClassInstance(preferenceScreen, preferenceGroupClassName);
        return SupportPreferencesUtil.instantiateClass(callback, preferenceGroupAdapterClassName, new Class[]{preferenceGroupClass}, new Object[]{preferenceScreen});
    }

    private static Object createInflatedPreference(LayoutlibCallback callback, String preferenceGroupClassName, String preferenceInflaterClassName, Context context, XmlPullParser parser, Object preferenceScreen, Object preferenceManager) throws ReflectionUtils.ReflectionException {
        Class<?> preferenceGroupClass = ReflectionUtils.getClassInstance(preferenceScreen, preferenceGroupClassName);
        Object preferenceInflater = SupportPreferencesUtil.instantiateClass(callback, preferenceInflaterClassName, new Class[]{Context.class, preferenceManager.getClass()}, new Object[]{context, preferenceManager});
        Object inflatedPreference = ReflectionUtils.invoke(ReflectionUtils.getAccessibleMethod(preferenceInflater.getClass(), "inflate", XmlPullParser.class, preferenceGroupClass), preferenceInflater, parser, null);
        if (inflatedPreference == null) {
            throw new ReflectionUtils.ReflectionException("inflate method returned null");
        }
        return inflatedPreference;
    }

    private static Context getThemedContext(BridgeContext bridgeContext) {
        int styleId;
        RenderResources resources = bridgeContext.getRenderResources();
        Object preferenceTheme = resources.findItemInTheme(bridgeContext.createAppCompatAttrReference("preferenceTheme"));
        preferenceTheme = preferenceTheme != null ? resources.resolveResValue(preferenceTheme) : resources.getStyle(bridgeContext.createAppCompatResourceReference(ResourceType.STYLE, "PreferenceThemeOverlay"));
        if (preferenceTheme instanceof StyleResourceValue && (styleId = bridgeContext.getDynamicIdByStyle((StyleResourceValue)preferenceTheme)) != 0) {
            return new ContextThemeWrapper((Context)bridgeContext, styleId);
        }
        return bridgeContext;
    }

    private static LinearLayout setUpPreferencesListView(BridgeContext bridgeContext, Context themedContext, ArrayList<Object> viewCookie, Object preferenceGroupAdapter) throws ReflectionUtils.ReflectionException {
        Integer preferencesCount;
        LinearLayout listView = new LinearLayout(themedContext);
        listView.setOrientation(1);
        listView.setLayoutParams(new LinearLayout.LayoutParams(-1, -1));
        if (!viewCookie.isEmpty()) {
            bridgeContext.addViewKey(listView, viewCookie.get(0));
        }
        if ((preferencesCount = (Integer)ReflectionUtils.invoke(ReflectionUtils.getMethod(preferenceGroupAdapter.getClass(), "getItemCount", new Class[0]), preferenceGroupAdapter, new Object[0])) == null) {
            return listView;
        }
        Method getItemId = ReflectionUtils.getMethod(preferenceGroupAdapter.getClass(), "getItemId", Integer.TYPE);
        Method getItemViewType = ReflectionUtils.getMethod(preferenceGroupAdapter.getClass(), "getItemViewType", Integer.TYPE);
        Method onCreateViewHolder = ReflectionUtils.getMethod(preferenceGroupAdapter.getClass(), "onCreateViewHolder", ViewGroup.class, Integer.TYPE);
        for (int i = 0; i < preferencesCount; ++i) {
            Long id2 = (Long)ReflectionUtils.invoke(getItemId, preferenceGroupAdapter, i);
            if (id2 == null) continue;
            Integer type = (Integer)ReflectionUtils.invoke(getItemViewType, preferenceGroupAdapter, i);
            Object viewHolder = ReflectionUtils.invoke(onCreateViewHolder, preferenceGroupAdapter, listView, type);
            if (viewHolder == null) continue;
            ReflectionUtils.invoke(ReflectionUtils.getMethod(preferenceGroupAdapter.getClass(), "onBindViewHolder", viewHolder.getClass(), Integer.TYPE), preferenceGroupAdapter, viewHolder, i);
            try {
                View itemView = (View)viewHolder.getClass().getField("itemView").get(viewHolder);
                int arrayPosition = id2.intValue() - 1;
                if (arrayPosition >= 0 && arrayPosition < viewCookie.size()) {
                    bridgeContext.addViewKey(itemView, viewCookie.get(arrayPosition));
                }
                listView.addView(itemView);
                continue;
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
        return listView;
    }

    public static View inflatePreference(BridgeContext bridgeContext, XmlPullParser parser, ViewGroup root) throws Throwable {
        String preferencePackageName = null;
        String preferenceManagerClassName = null;
        for (int i = PREFERENCES_PKG_NAMES.length - 1; i >= 0; --i) {
            preferencePackageName = PREFERENCES_PKG_NAMES[i];
            preferenceManagerClassName = preferencePackageName + ".PreferenceManager";
            try {
                bridgeContext.getLayoutlibCallback().findClass(preferenceManagerClassName);
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
        }
        assert (preferencePackageName != null);
        String preferenceGroupClassName = preferencePackageName + ".PreferenceGroup";
        String preferenceGroupAdapterClassName = preferencePackageName + ".PreferenceGroupAdapter";
        String preferenceInflaterClassName = preferencePackageName + ".PreferenceInflater";
        try {
            LayoutlibCallback callback = bridgeContext.getLayoutlibCallback();
            Context context = SupportPreferencesUtil.getThemedContext(bridgeContext);
            Object preferenceManager = SupportPreferencesUtil.instantiateClass(callback, preferenceManagerClassName, new Class[]{Context.class}, new Object[]{context});
            Object preferenceScreen = ReflectionUtils.invoke(ReflectionUtils.getMethod(preferenceManager.getClass(), "createPreferenceScreen", Context.class), preferenceManager, context);
            if (preferenceScreen == null) {
                return null;
            }
            final ArrayList<Object> viewCookie = new ArrayList<Object>();
            if (parser instanceof BridgeXmlBlockParser) {
                parser = new BridgeXmlBlockParser(parser, null, ((BridgeXmlBlockParser)parser).getFileResourceNamespace()){

                    @Override
                    public Object getViewCookie() {
                        return ((BridgeXmlBlockParser)this.getParser()).getViewCookie();
                    }

                    @Override
                    public int next() throws XmlPullParserException, IOException {
                        int ev = super.next();
                        if (ev == 2) {
                            viewCookie.add(this.getViewCookie());
                        }
                        return ev;
                    }
                };
            }
            Object inflatedPreference = SupportPreferencesUtil.createInflatedPreference(callback, preferenceGroupClassName, preferenceInflaterClassName, context, parser, preferenceScreen, preferenceManager);
            Object preferenceGroupAdapter = SupportPreferencesUtil.createPreferenceGroupAdapter(callback, preferenceGroupClassName, preferenceGroupAdapterClassName, inflatedPreference);
            LinearLayout listView = SupportPreferencesUtil.setUpPreferencesListView(bridgeContext, context, viewCookie, preferenceGroupAdapter);
            ScrollView scrollView = new ScrollView(context);
            scrollView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            scrollView.addView(listView);
            if (root != null) {
                root.addView(scrollView);
            }
            return scrollView;
        }
        catch (ReflectionUtils.ReflectionException e) {
            String message;
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            if (t instanceof ClassNotFoundException && (message = t.getMessage()) != null && !message.contains(preferencePackageName)) {
                Bridge.getLog().error("INFLATE", t.getMessage(), null, null);
                throw t;
            }
            return null;
        }
    }

    public static boolean isSupportRootTag(String rootTag) {
        if (rootTag != null) {
            for (String supportPrefix : PREFERENCES_PKG_NAMES) {
                if (!rootTag.equals(supportPrefix + ".PreferenceScreen")) continue;
                return true;
            }
        }
        return false;
    }
}

