/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Icon;
import android.text.TextUtils;
import android.util.ArrayMap;
import com.android.internal.graphics.ColorUtils;
import com.android.internal.util.ContrastColorUtil;
import com.android.internal.widget.CachingIconView;
import com.android.internal.widget.MessagingGroup;
import com.android.internal.widget.MessagingPropertyAnimator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class PeopleHelper {
    private static final float COLOR_SHIFT_AMOUNT = 60.0f;
    private static final Pattern IGNORABLE_CHAR_PATTERN = Pattern.compile("[\\p{C}\\p{Z}]");
    private static final Pattern SPECIAL_CHAR_PATTERN = Pattern.compile("[!@#$%&*()_+=|<>?{}\\[\\]~-]");
    private Context mContext;
    private int mAvatarSize;
    private Paint mPaint = new Paint(1);
    private Paint mTextPaint = new Paint();

    public void init(Context context) {
        this.mContext = context;
        this.mAvatarSize = context.getResources().getDimensionPixelSize(17105346);
        this.mTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mTextPaint.setAntiAlias(true);
    }

    public void animateViewForceHidden(CachingIconView view, boolean forceHidden) {
        boolean nowForceHidden;
        boolean bl = nowForceHidden = view.willBeForceHidden() || view.isForceHidden();
        if (forceHidden == nowForceHidden) {
            return;
        }
        view.animate().cancel();
        view.setWillBeForceHidden(forceHidden);
        view.animate().scaleX(forceHidden ? 0.5f : 1.0f).scaleY(forceHidden ? 0.5f : 1.0f).alpha(forceHidden ? 0.0f : 1.0f).setInterpolator(forceHidden ? MessagingPropertyAnimator.ALPHA_OUT : MessagingPropertyAnimator.ALPHA_IN).setDuration(160L);
        if (view.getVisibility() != 0) {
            view.setForceHidden(forceHidden);
        } else {
            view.animate().withEndAction(() -> view.setForceHidden(forceHidden));
        }
        view.animate().start();
    }

    public Icon createAvatarSymbol(CharSequence name, String symbol, int layoutColor) {
        if (symbol.isEmpty() || TextUtils.isDigitsOnly(symbol) || SPECIAL_CHAR_PATTERN.matcher(symbol).find()) {
            Icon avatarIcon = Icon.createWithResource(this.mContext, 17303075);
            avatarIcon.setTint(this.findColor(name, layoutColor));
            return avatarIcon;
        }
        Bitmap bitmap = Bitmap.createBitmap(this.mAvatarSize, this.mAvatarSize, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        float radius = (float)this.mAvatarSize / 2.0f;
        int color2 = this.findColor(name, layoutColor);
        this.mPaint.setColor(color2);
        canvas.drawCircle(radius, radius, radius, this.mPaint);
        boolean needDarkText = ColorUtils.calculateLuminance(color2) > 0.5;
        this.mTextPaint.setColor(needDarkText ? -16777216 : -1);
        this.mTextPaint.setTextSize(symbol.length() == 1 ? (float)this.mAvatarSize * 0.5f : (float)this.mAvatarSize * 0.3f);
        int yPos = (int)(radius - (this.mTextPaint.descent() + this.mTextPaint.ascent()) / 2.0f);
        canvas.drawText(symbol, radius, yPos, this.mTextPaint);
        return Icon.createWithBitmap(bitmap);
    }

    private int findColor(CharSequence senderName, int layoutColor) {
        double luminance = ContrastColorUtil.calculateLuminance(layoutColor);
        float shift = (float)(Math.abs(senderName.hashCode()) % 5) / 4.0f - 0.5f;
        shift = (float)((double)shift + Math.max((double)0.3f - luminance, 0.0));
        shift = (float)((double)shift - Math.max((double)0.3f - (1.0 - luminance), 0.0));
        return ContrastColorUtil.getShiftedColor(layoutColor, (int)(shift * 60.0f));
    }

    private String getPureName(CharSequence name) {
        return IGNORABLE_CHAR_PATTERN.matcher(name).replaceAll("");
    }

    public String findNamePrefix(CharSequence name, String fallback) {
        String pureName = this.getPureName(name);
        if (pureName.isEmpty()) {
            return fallback;
        }
        try {
            return new String(Character.toChars(pureName.codePointAt(0)));
        }
        catch (RuntimeException ignore) {
            return fallback;
        }
    }

    public String findNameSplit(CharSequence name) {
        String nameString = name instanceof String ? (String)name : name.toString();
        String[] split = nameString.trim().split("[ ]+");
        if (split.length > 1) {
            String first = this.findNamePrefix(split[0], null);
            String second = this.findNamePrefix(split[1], null);
            if (first != null && second != null) {
                return first + second;
            }
        }
        return this.findNamePrefix(name, "");
    }

    public Map<CharSequence, String> mapUniqueNamesToPrefix(List<MessagingGroup> groups) {
        ArrayMap<CharSequence, String> uniqueNames = new ArrayMap<CharSequence, String>();
        ArrayMap<String, CharSequence> uniqueCharacters = new ArrayMap<String, CharSequence>();
        for (int i = 0; i < groups.size(); ++i) {
            String charPrefix;
            MessagingGroup group = groups.get(i);
            CharSequence senderName = group.getSenderName();
            if (!group.needsGeneratedAvatar() || TextUtils.isEmpty(senderName) || uniqueNames.containsKey(senderName) || (charPrefix = this.findNamePrefix(senderName, null)) == null) continue;
            if (uniqueCharacters.containsKey(charPrefix)) {
                CharSequence existingName = (CharSequence)uniqueCharacters.get(charPrefix);
                if (existingName != null) {
                    uniqueNames.put(existingName, this.findNameSplit(existingName));
                    uniqueCharacters.put(charPrefix, null);
                }
                uniqueNames.put(senderName, this.findNameSplit(senderName));
                continue;
            }
            uniqueNames.put(senderName, charPrefix);
            uniqueCharacters.put(charPrefix, senderName);
        }
        return uniqueNames;
    }

    public void maybeHideFirstSenderName(List<MessagingGroup> groups, boolean isOneToOne, CharSequence conversationTitle) {
        for (int i = groups.size() - 1; i >= 0; --i) {
            MessagingGroup messagingGroup = groups.get(i);
            CharSequence messageSender = messagingGroup.getSenderName();
            boolean canHide = isOneToOne && TextUtils.equals(conversationTitle, messageSender);
            messagingGroup.setCanHideSenderIfFirst(canHide);
        }
    }
}

