/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.Notification;
import android.app.Person;
import android.app.RemoteInputHistoryItem;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Icon;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.Interpolator;
import android.view.animation.PathInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RemoteViews;
import com.android.internal.util.ContrastColorUtil;
import com.android.internal.widget.IMessagingLayout;
import com.android.internal.widget.ImageMessageConsumer;
import com.android.internal.widget.ImageResolver;
import com.android.internal.widget.MessagingGroup;
import com.android.internal.widget.MessagingImageMessage;
import com.android.internal.widget.MessagingLinearLayout;
import com.android.internal.widget.MessagingMessage;
import com.android.internal.widget.MessagingPropertyAnimator;
import com.android.internal.widget.PeopleHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RemoteViews.RemoteView
public class MessagingLayout
extends FrameLayout
implements ImageMessageConsumer,
IMessagingLayout {
    private static final float COLOR_SHIFT_AMOUNT = 60.0f;
    public static final Interpolator LINEAR_OUT_SLOW_IN = new PathInterpolator(0.0f, 0.0f, 0.2f, 1.0f);
    public static final Interpolator FAST_OUT_LINEAR_IN = new PathInterpolator(0.4f, 0.0f, 1.0f, 1.0f);
    public static final Interpolator FAST_OUT_SLOW_IN = new PathInterpolator(0.4f, 0.0f, 0.2f, 1.0f);
    public static final View.OnLayoutChangeListener MESSAGING_PROPERTY_ANIMATOR = new MessagingPropertyAnimator();
    private final PeopleHelper mPeopleHelper = new PeopleHelper();
    private List<MessagingMessage> mMessages = new ArrayList<MessagingMessage>();
    private List<MessagingMessage> mHistoricMessages = new ArrayList<MessagingMessage>();
    private MessagingLinearLayout mMessagingLinearLayout;
    private boolean mShowHistoricMessages;
    private ArrayList<MessagingGroup> mGroups = new ArrayList();
    private MessagingLinearLayout mImageMessageContainer;
    private ImageView mRightIconView;
    private Rect mMessagingClipRect;
    private int mLayoutColor;
    private int mSenderTextColor;
    private int mMessageTextColor;
    private Icon mAvatarReplacement;
    private boolean mIsOneToOne;
    private ArrayList<MessagingGroup> mAddedGroups = new ArrayList();
    private Person mUser;
    private CharSequence mNameReplacement;
    private boolean mIsCollapsed;
    private ImageResolver mImageResolver;
    private CharSequence mConversationTitle;
    private ArrayList<MessagingLinearLayout.MessagingChild> mToRecycle = new ArrayList();

    public MessagingLayout(Context context) {
        super(context);
    }

    public MessagingLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public MessagingLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public MessagingLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mPeopleHelper.init(this.getContext());
        this.mMessagingLinearLayout = (MessagingLinearLayout)this.findViewById(16909294);
        this.mImageMessageContainer = (MessagingLinearLayout)this.findViewById(16908928);
        this.mRightIconView = (ImageView)this.findViewById(16909431);
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        int size = Math.max(displayMetrics.widthPixels, displayMetrics.heightPixels);
        this.mMessagingClipRect = new Rect(0, 0, size, size);
        this.setMessagingClippingDisabled(false);
    }

    @RemotableViewMethod
    public void setAvatarReplacement(Icon icon) {
        this.mAvatarReplacement = icon;
    }

    @RemotableViewMethod
    public void setNameReplacement(CharSequence nameReplacement) {
        this.mNameReplacement = nameReplacement;
    }

    @RemotableViewMethod
    public void setIsCollapsed(boolean isCollapsed) {
        this.mIsCollapsed = isCollapsed;
    }

    @RemotableViewMethod
    public void setLargeIcon(Icon largeIcon) {
    }

    @RemotableViewMethod
    public void setConversationTitle(CharSequence conversationTitle) {
        this.mConversationTitle = conversationTitle;
    }

    @RemotableViewMethod
    public void setData(Bundle extras) {
        Parcelable[] messages = extras.getParcelableArray("android.messages");
        List<Notification.MessagingStyle.Message> newMessages = Notification.MessagingStyle.Message.getMessagesFromBundleArray(messages);
        Parcelable[] histMessages = extras.getParcelableArray("android.messages.historic");
        List<Notification.MessagingStyle.Message> newHistoricMessages = Notification.MessagingStyle.Message.getMessagesFromBundleArray(histMessages);
        this.setUser((Person)extras.getParcelable("android.messagingUser"));
        RemoteInputHistoryItem[] history = (RemoteInputHistoryItem[])extras.getParcelableArray("android.remoteInputHistoryItems");
        this.addRemoteInputHistoryToMessages(newMessages, history);
        boolean showSpinner = extras.getBoolean("android.remoteInputSpinner", false);
        this.bind(newMessages, newHistoricMessages, showSpinner);
    }

    @Override
    public void setImageResolver(ImageResolver resolver) {
        this.mImageResolver = resolver;
    }

    private void addRemoteInputHistoryToMessages(List<Notification.MessagingStyle.Message> newMessages, RemoteInputHistoryItem[] remoteInputHistory) {
        if (remoteInputHistory == null || remoteInputHistory.length == 0) {
            return;
        }
        for (int i = remoteInputHistory.length - 1; i >= 0; --i) {
            RemoteInputHistoryItem historyMessage = remoteInputHistory[i];
            Notification.MessagingStyle.Message message = new Notification.MessagingStyle.Message(historyMessage.getText(), 0L, null, true);
            if (historyMessage.getUri() != null) {
                message.setData(historyMessage.getMimeType(), historyMessage.getUri());
            }
            newMessages.add(message);
        }
    }

    private void bind(List<Notification.MessagingStyle.Message> newMessages, List<Notification.MessagingStyle.Message> newHistoricMessages, boolean showSpinner) {
        List<MessagingMessage> historicMessages = this.createMessages(newHistoricMessages, true);
        List<MessagingMessage> messages = this.createMessages(newMessages, false);
        ArrayList<MessagingGroup> oldGroups = new ArrayList<MessagingGroup>(this.mGroups);
        this.addMessagesToGroups(historicMessages, messages, showSpinner);
        this.removeGroups(oldGroups);
        for (MessagingMessage message : this.mMessages) {
            message.removeMessage(this.mToRecycle);
        }
        for (MessagingMessage historicMessage : this.mHistoricMessages) {
            historicMessage.removeMessage(this.mToRecycle);
        }
        this.mMessages = messages;
        this.mHistoricMessages = historicMessages;
        this.updateHistoricMessageVisibility();
        this.updateTitleAndNamesDisplay();
        this.mPeopleHelper.maybeHideFirstSenderName(this.mGroups, this.mIsOneToOne, this.mConversationTitle);
        this.updateImageMessages();
        for (MessagingLinearLayout.MessagingChild child : this.mToRecycle) {
            child.recycle();
        }
        this.mToRecycle.clear();
    }

    private void updateImageMessages() {
        View previousMessage;
        MessagingGroup messagingGroup;
        MessagingImageMessage isolatedMessage;
        View newMessage = null;
        if (this.mImageMessageContainer == null) {
            return;
        }
        if (this.mIsCollapsed && !this.mGroups.isEmpty() && (isolatedMessage = (messagingGroup = this.mGroups.get(this.mGroups.size() - 1)).getIsolatedMessage()) != null) {
            newMessage = isolatedMessage.getView();
        }
        if ((previousMessage = this.mImageMessageContainer.getChildAt(0)) != newMessage) {
            this.mImageMessageContainer.removeView(previousMessage);
            if (newMessage != null) {
                this.mImageMessageContainer.addView(newMessage);
            }
        }
        this.mImageMessageContainer.setVisibility(newMessage != null ? 0 : 8);
        if (newMessage != null && this.mRightIconView != null && this.mRightIconView.getDrawable() != null) {
            this.mRightIconView.setImageDrawable(null);
            this.mRightIconView.setVisibility(8);
        }
    }

    private void removeGroups(ArrayList<MessagingGroup> oldGroups) {
        int size = oldGroups.size();
        for (int i = 0; i < size; ++i) {
            MessagingGroup group = oldGroups.get(i);
            if (this.mGroups.contains(group)) continue;
            List<MessagingMessage> messages = group.getMessages();
            boolean wasShown = group.isShown();
            this.mMessagingLinearLayout.removeView(group);
            if (wasShown && !MessagingLinearLayout.isGone(group)) {
                this.mMessagingLinearLayout.addTransientView(group, 0);
                group.removeGroupAnimated(() -> {
                    this.mMessagingLinearLayout.removeTransientView(group);
                    group.recycle();
                });
            } else {
                this.mToRecycle.add(group);
            }
            this.mMessages.removeAll(messages);
            this.mHistoricMessages.removeAll(messages);
        }
    }

    private void updateTitleAndNamesDisplay() {
        MessagingGroup group;
        int i;
        Map<CharSequence, String> uniqueNames = this.mPeopleHelper.mapUniqueNamesToPrefix(this.mGroups);
        ArrayMap<CharSequence, Icon> cachedAvatars = new ArrayMap<CharSequence, Icon>();
        for (i = 0; i < this.mGroups.size(); ++i) {
            String symbol;
            Icon cachedIcon;
            group = this.mGroups.get(i);
            boolean isOwnMessage = group.getSender() == this.mUser;
            CharSequence senderName = group.getSenderName();
            if (!group.needsGeneratedAvatar() || TextUtils.isEmpty(senderName) || this.mIsOneToOne && this.mAvatarReplacement != null && !isOwnMessage || (cachedIcon = group.getAvatarSymbolIfMatching(senderName, symbol = uniqueNames.get(senderName), this.mLayoutColor)) == null) continue;
            cachedAvatars.put(senderName, cachedIcon);
        }
        for (i = 0; i < this.mGroups.size(); ++i) {
            group = this.mGroups.get(i);
            CharSequence senderName = group.getSenderName();
            if (!group.needsGeneratedAvatar() || TextUtils.isEmpty(senderName)) continue;
            if (this.mIsOneToOne && this.mAvatarReplacement != null && group.getSender() != this.mUser) {
                group.setAvatar(this.mAvatarReplacement);
                continue;
            }
            Icon cachedIcon = (Icon)cachedAvatars.get(senderName);
            if (cachedIcon == null) {
                cachedIcon = this.createAvatarSymbol(senderName, uniqueNames.get(senderName), this.mLayoutColor);
                cachedAvatars.put(senderName, cachedIcon);
            }
            group.setCreatedAvatar(cachedIcon, senderName, uniqueNames.get(senderName), this.mLayoutColor);
        }
    }

    public Icon createAvatarSymbol(CharSequence senderName, String symbol, int layoutColor) {
        return this.mPeopleHelper.createAvatarSymbol(senderName, symbol, layoutColor);
    }

    private int findColor(CharSequence senderName, int layoutColor) {
        double luminance = ContrastColorUtil.calculateLuminance(layoutColor);
        float shift = (float)(Math.abs(senderName.hashCode()) % 5) / 4.0f - 0.5f;
        shift = (float)((double)shift + Math.max((double)0.3f - luminance, 0.0));
        shift = (float)((double)shift - Math.max((double)0.3f - (1.0 - luminance), 0.0));
        return ContrastColorUtil.getShiftedColor(layoutColor, (int)(shift * 60.0f));
    }

    private String findNameSplit(String existingName) {
        String[] split = existingName.split(" ");
        if (split.length > 1) {
            return Character.toString(split[0].charAt(0)) + Character.toString(split[1].charAt(0));
        }
        return existingName.substring(0, 1);
    }

    @RemotableViewMethod
    public void setLayoutColor(int color2) {
        this.mLayoutColor = color2;
    }

    @RemotableViewMethod
    public void setIsOneToOne(boolean oneToOne) {
        this.mIsOneToOne = oneToOne;
    }

    @RemotableViewMethod
    public void setSenderTextColor(int color2) {
        this.mSenderTextColor = color2;
    }

    @RemotableViewMethod
    public void setNotificationBackgroundColor(int color2) {
    }

    @RemotableViewMethod
    public void setMessageTextColor(int color2) {
        this.mMessageTextColor = color2;
    }

    public void setUser(Person user) {
        this.mUser = user;
        if (this.mUser.getIcon() == null) {
            Icon userIcon = Icon.createWithResource(this.getContext(), 17303075);
            userIcon.setTint(this.mLayoutColor);
            this.mUser = this.mUser.toBuilder().setIcon(userIcon).build();
        }
    }

    private void addMessagesToGroups(List<MessagingMessage> historicMessages, List<MessagingMessage> messages, boolean showSpinner) {
        ArrayList<List<MessagingMessage>> groups = new ArrayList<List<MessagingMessage>>();
        ArrayList<Person> senders = new ArrayList<Person>();
        this.findGroups(historicMessages, messages, groups, senders);
        this.createGroupViews(groups, senders, showSpinner);
    }

    private void createGroupViews(List<List<MessagingMessage>> groups, List<Person> senders, boolean showSpinner) {
        this.mGroups.clear();
        for (int groupIndex = 0; groupIndex < groups.size(); ++groupIndex) {
            MessagingMessage message;
            List<MessagingMessage> group = groups.get(groupIndex);
            View newGroup = null;
            for (int messageIndex = group.size() - 1; messageIndex >= 0 && (newGroup = (message = group.get(messageIndex)).getGroup()) == null; --messageIndex) {
            }
            if (newGroup == null) {
                newGroup = MessagingGroup.createGroup(this.mMessagingLinearLayout);
                this.mAddedGroups.add((MessagingGroup)newGroup);
            } else if (newGroup.getParent() != this.mMessagingLinearLayout) {
                throw new IllegalStateException("group parent was " + newGroup.getParent() + " but expected " + this.mMessagingLinearLayout);
            }
            ((MessagingGroup)newGroup).setImageDisplayLocation(this.mIsCollapsed ? 2 : 0);
            ((MessagingGroup)newGroup).setIsInConversation(false);
            ((MessagingGroup)newGroup).setLayoutColor(this.mLayoutColor);
            ((MessagingGroup)newGroup).setTextColors(this.mSenderTextColor, this.mMessageTextColor);
            Person sender = senders.get(groupIndex);
            CharSequence nameOverride = null;
            if (sender != this.mUser && this.mNameReplacement != null) {
                nameOverride = this.mNameReplacement;
            }
            ((MessagingGroup)newGroup).setSingleLine(this.mIsCollapsed);
            ((MessagingGroup)newGroup).setShowingAvatar(!this.mIsCollapsed);
            ((MessagingGroup)newGroup).setSender(sender, nameOverride);
            ((MessagingGroup)newGroup).setSending(groupIndex == groups.size() - 1 && showSpinner);
            this.mGroups.add((MessagingGroup)newGroup);
            if (this.mMessagingLinearLayout.indexOfChild(newGroup) != groupIndex) {
                this.mMessagingLinearLayout.removeView(newGroup);
                this.mMessagingLinearLayout.addView(newGroup, groupIndex);
            }
            ((MessagingGroup)newGroup).setMessages(group);
        }
    }

    private void findGroups(List<MessagingMessage> historicMessages, List<MessagingMessage> messages, List<List<MessagingMessage>> groups, List<Person> senders) {
        CharSequence currentSenderKey = null;
        ArrayList<MessagingMessage> currentGroup = null;
        int histSize = historicMessages.size();
        for (int i = 0; i < histSize + messages.size(); ++i) {
            CharSequence key;
            MessagingMessage message = i < histSize ? historicMessages.get(i) : messages.get(i - histSize);
            boolean isNewGroup = currentGroup == null;
            Person sender = message.getMessage().getSenderPerson();
            CharSequence charSequence = key = sender == null ? null : (sender.getKey() == null ? sender.getName() : sender.getKey());
            if (isNewGroup |= !TextUtils.equals(key, currentSenderKey)) {
                currentGroup = new ArrayList<MessagingMessage>();
                groups.add(currentGroup);
                if (sender == null) {
                    sender = this.mUser;
                }
                senders.add(sender);
                currentSenderKey = key;
            }
            currentGroup.add(message);
        }
    }

    private List<MessagingMessage> createMessages(List<Notification.MessagingStyle.Message> newMessages, boolean historic) {
        ArrayList<MessagingMessage> result = new ArrayList<MessagingMessage>();
        for (int i = 0; i < newMessages.size(); ++i) {
            Notification.MessagingStyle.Message m = newMessages.get(i);
            MessagingMessage message = this.findAndRemoveMatchingMessage(m);
            if (message == null) {
                message = MessagingMessage.createMessage(this, m, this.mImageResolver);
            }
            message.setIsHistoric(historic);
            result.add(message);
        }
        return result;
    }

    private MessagingMessage findAndRemoveMatchingMessage(Notification.MessagingStyle.Message m) {
        MessagingMessage existing;
        int i;
        for (i = 0; i < this.mMessages.size(); ++i) {
            existing = this.mMessages.get(i);
            if (!existing.sameAs(m)) continue;
            this.mMessages.remove(i);
            return existing;
        }
        for (i = 0; i < this.mHistoricMessages.size(); ++i) {
            existing = this.mHistoricMessages.get(i);
            if (!existing.sameAs(m)) continue;
            this.mHistoricMessages.remove(i);
            return existing;
        }
        return null;
    }

    public void showHistoricMessages(boolean show) {
        this.mShowHistoricMessages = show;
        this.updateHistoricMessageVisibility();
    }

    private void updateHistoricMessageVisibility() {
        int numHistoric = this.mHistoricMessages.size();
        for (int i = 0; i < numHistoric; ++i) {
            MessagingMessage existing = this.mHistoricMessages.get(i);
            existing.setVisibility(this.mShowHistoricMessages ? 0 : 8);
        }
        int numGroups = this.mGroups.size();
        for (int i = 0; i < numGroups; ++i) {
            MessagingGroup group = this.mGroups.get(i);
            int visibleChildren = 0;
            List<MessagingMessage> messages = group.getMessages();
            int numGroupMessages = messages.size();
            for (int j = 0; j < numGroupMessages; ++j) {
                MessagingMessage message = messages.get(j);
                if (message.getVisibility() == 8) continue;
                ++visibleChildren;
            }
            if (visibleChildren > 0 && group.getVisibility() == 8) {
                group.setVisibility(0);
                continue;
            }
            if (visibleChildren != 0 || group.getVisibility() == 8) continue;
            group.setVisibility(8);
        }
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (!this.mAddedGroups.isEmpty()) {
            this.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                @Override
                public boolean onPreDraw() {
                    for (MessagingGroup group : MessagingLayout.this.mAddedGroups) {
                        if (!group.isShown()) continue;
                        MessagingPropertyAnimator.fadeIn(group.getAvatar());
                        MessagingPropertyAnimator.fadeIn(group.getSenderView());
                        MessagingPropertyAnimator.startLocalTranslationFrom(group, group.getHeight(), LINEAR_OUT_SLOW_IN);
                    }
                    MessagingLayout.this.mAddedGroups.clear();
                    MessagingLayout.this.getViewTreeObserver().removeOnPreDrawListener(this);
                    return true;
                }
            });
        }
    }

    @Override
    public MessagingLinearLayout getMessagingLinearLayout() {
        return this.mMessagingLinearLayout;
    }

    public ViewGroup getImageMessageContainer() {
        return this.mImageMessageContainer;
    }

    @Override
    public ArrayList<MessagingGroup> getMessagingGroups() {
        return this.mGroups;
    }

    @Override
    public void setMessagingClippingDisabled(boolean clippingDisabled) {
        this.mMessagingLinearLayout.setClipBounds(clippingDisabled ? null : this.mMessagingClipRect);
    }
}

