/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.BlendMode;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableWrapper;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.Icon;
import android.graphics.drawable.RippleDrawable;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.widget.Button;
import android.widget.RemoteViews;

@RemoteViews.RemoteView
public class EmphasizedNotificationButton
extends Button {
    private final RippleDrawable mRipple = (RippleDrawable)this.getBackground();
    private final GradientDrawable mBackground;
    private boolean mPriority;

    public EmphasizedNotificationButton(Context context) {
        this(context, null);
    }

    public EmphasizedNotificationButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EmphasizedNotificationButton(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public EmphasizedNotificationButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mRipple.mutate();
        DrawableWrapper inset = (DrawableWrapper)this.mRipple.getDrawable(0);
        this.mBackground = (GradientDrawable)inset.getDrawable();
    }

    @RemotableViewMethod
    public void setRippleColor(ColorStateList color2) {
        this.mRipple.setColor(color2);
        this.invalidate();
    }

    @RemotableViewMethod
    public void setButtonBackground(ColorStateList color2) {
        this.mBackground.setColor(color2);
        this.invalidate();
    }

    @RemotableViewMethod(asyncImpl="setImageIconAsync")
    public void setImageIcon(Icon icon) {
        Drawable drawable2 = icon == null ? null : icon.loadDrawable(this.mContext);
        this.setImageDrawable(drawable2);
    }

    @RemotableViewMethod
    public Runnable setImageIconAsync(Icon icon) {
        Drawable drawable2 = icon == null ? null : icon.loadDrawable(this.mContext);
        return () -> this.setImageDrawable(drawable2);
    }

    private void setImageDrawable(Drawable drawable2) {
        if (drawable2 != null) {
            drawable2.mutate();
            drawable2.setTintList(this.getTextColors());
            drawable2.setTintBlendMode(BlendMode.SRC_IN);
            int iconSize = this.mContext.getResources().getDimensionPixelSize(17105372);
            drawable2.setBounds(0, 0, iconSize, iconSize);
        }
        this.setCompoundDrawablesRelative(drawable2, null, null, null);
    }

    @RemotableViewMethod
    public void setIsPriority(boolean priority) {
        this.mPriority = priority;
    }

    public boolean isPriority() {
        return this.mPriority;
    }
}

