/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodSubtype;
import android.window.ImeOnBackInvokedDispatcher;
import com.android.internal.inputmethod.IRemoteAccessibilityInputConnection;
import com.android.internal.inputmethod.InputBindResult;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethodClient;
import java.util.ArrayList;
import java.util.List;

public interface IInputMethodManager
extends IInterface {
    public void addClient(IInputMethodClient var1, IInputContext var2, int var3) throws RemoteException;

    public List<InputMethodInfo> getInputMethodList(int var1) throws RemoteException;

    public List<InputMethodInfo> getAwareLockedInputMethodList(int var1, int var2) throws RemoteException;

    public List<InputMethodInfo> getEnabledInputMethodList(int var1) throws RemoteException;

    public List<InputMethodSubtype> getEnabledInputMethodSubtypeList(String var1, boolean var2) throws RemoteException;

    public InputMethodSubtype getLastInputMethodSubtype() throws RemoteException;

    public boolean showSoftInput(IInputMethodClient var1, IBinder var2, int var3, ResultReceiver var4, int var5) throws RemoteException;

    public boolean hideSoftInput(IInputMethodClient var1, IBinder var2, int var3, ResultReceiver var4, int var5) throws RemoteException;

    public InputBindResult startInputOrWindowGainedFocus(int var1, IInputMethodClient var2, IBinder var3, int var4, int var5, int var6, EditorInfo var7, IInputContext var8, IRemoteAccessibilityInputConnection var9, int var10, ImeOnBackInvokedDispatcher var11) throws RemoteException;

    public void showInputMethodPickerFromClient(IInputMethodClient var1, int var2) throws RemoteException;

    public void showInputMethodPickerFromSystem(IInputMethodClient var1, int var2, int var3) throws RemoteException;

    public void showInputMethodAndSubtypeEnablerFromClient(IInputMethodClient var1, String var2) throws RemoteException;

    public boolean isInputMethodPickerShownForTest() throws RemoteException;

    public InputMethodSubtype getCurrentInputMethodSubtype() throws RemoteException;

    public void setAdditionalInputMethodSubtypes(String var1, InputMethodSubtype[] var2) throws RemoteException;

    public int getInputMethodWindowVisibleHeight(IInputMethodClient var1) throws RemoteException;

    public void reportVirtualDisplayGeometryAsync(IInputMethodClient var1, int var2, float[] var3) throws RemoteException;

    public void reportPerceptibleAsync(IBinder var1, boolean var2) throws RemoteException;

    public void removeImeSurface() throws RemoteException;

    public void removeImeSurfaceFromWindowAsync(IBinder var1) throws RemoteException;

    public void startProtoDump(byte[] var1, int var2, String var3) throws RemoteException;

    public boolean isImeTraceEnabled() throws RemoteException;

    public void startImeTrace() throws RemoteException;

    public void stopImeTrace() throws RemoteException;

    public void startStylusHandwriting(IInputMethodClient var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInputMethodManager {
        public static final String DESCRIPTOR = "com.android.internal.view.IInputMethodManager";
        static final int TRANSACTION_addClient = 1;
        static final int TRANSACTION_getInputMethodList = 2;
        static final int TRANSACTION_getAwareLockedInputMethodList = 3;
        static final int TRANSACTION_getEnabledInputMethodList = 4;
        static final int TRANSACTION_getEnabledInputMethodSubtypeList = 5;
        static final int TRANSACTION_getLastInputMethodSubtype = 6;
        static final int TRANSACTION_showSoftInput = 7;
        static final int TRANSACTION_hideSoftInput = 8;
        static final int TRANSACTION_startInputOrWindowGainedFocus = 9;
        static final int TRANSACTION_showInputMethodPickerFromClient = 10;
        static final int TRANSACTION_showInputMethodPickerFromSystem = 11;
        static final int TRANSACTION_showInputMethodAndSubtypeEnablerFromClient = 12;
        static final int TRANSACTION_isInputMethodPickerShownForTest = 13;
        static final int TRANSACTION_getCurrentInputMethodSubtype = 14;
        static final int TRANSACTION_setAdditionalInputMethodSubtypes = 15;
        static final int TRANSACTION_getInputMethodWindowVisibleHeight = 16;
        static final int TRANSACTION_reportVirtualDisplayGeometryAsync = 17;
        static final int TRANSACTION_reportPerceptibleAsync = 18;
        static final int TRANSACTION_removeImeSurface = 19;
        static final int TRANSACTION_removeImeSurfaceFromWindowAsync = 20;
        static final int TRANSACTION_startProtoDump = 21;
        static final int TRANSACTION_isImeTraceEnabled = 22;
        static final int TRANSACTION_startImeTrace = 23;
        static final int TRANSACTION_stopImeTrace = 24;
        static final int TRANSACTION_startStylusHandwriting = 25;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IInputMethodManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IInputMethodManager) {
                return (IInputMethodManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "addClient";
                }
                case 2: {
                    return "getInputMethodList";
                }
                case 3: {
                    return "getAwareLockedInputMethodList";
                }
                case 4: {
                    return "getEnabledInputMethodList";
                }
                case 5: {
                    return "getEnabledInputMethodSubtypeList";
                }
                case 6: {
                    return "getLastInputMethodSubtype";
                }
                case 7: {
                    return "showSoftInput";
                }
                case 8: {
                    return "hideSoftInput";
                }
                case 9: {
                    return "startInputOrWindowGainedFocus";
                }
                case 10: {
                    return "showInputMethodPickerFromClient";
                }
                case 11: {
                    return "showInputMethodPickerFromSystem";
                }
                case 12: {
                    return "showInputMethodAndSubtypeEnablerFromClient";
                }
                case 13: {
                    return "isInputMethodPickerShownForTest";
                }
                case 14: {
                    return "getCurrentInputMethodSubtype";
                }
                case 15: {
                    return "setAdditionalInputMethodSubtypes";
                }
                case 16: {
                    return "getInputMethodWindowVisibleHeight";
                }
                case 17: {
                    return "reportVirtualDisplayGeometryAsync";
                }
                case 18: {
                    return "reportPerceptibleAsync";
                }
                case 19: {
                    return "removeImeSurface";
                }
                case 20: {
                    return "removeImeSurfaceFromWindowAsync";
                }
                case 21: {
                    return "startProtoDump";
                }
                case 22: {
                    return "isImeTraceEnabled";
                }
                case 23: {
                    return "startImeTrace";
                }
                case 24: {
                    return "stopImeTrace";
                }
                case 25: {
                    return "startStylusHandwriting";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    IInputMethodClient _arg0 = IInputMethodClient.Stub.asInterface(data.readStrongBinder());
                    IInputContext _arg1 = IInputContext.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.addClient(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<InputMethodInfo> _result = this.getInputMethodList(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    List<InputMethodInfo> _result = this.getAwareLockedInputMethodList(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<InputMethodInfo> _result = this.getEnabledInputMethodList(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    List<InputMethodSubtype> _result = this.getEnabledInputMethodSubtypeList(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 6: {
                    InputMethodSubtype _result = this.getLastInputMethodSubtype();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 7: {
                    IInputMethodClient _arg0 = IInputMethodClient.Stub.asInterface(data.readStrongBinder());
                    IBinder _arg1 = data.readStrongBinder();
                    int _arg2 = data.readInt();
                    ResultReceiver _arg3 = data.readTypedObject(ResultReceiver.CREATOR);
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.showSoftInput(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 8: {
                    IInputMethodClient _arg0 = IInputMethodClient.Stub.asInterface(data.readStrongBinder());
                    IBinder _arg1 = data.readStrongBinder();
                    int _arg2 = data.readInt();
                    ResultReceiver _arg3 = data.readTypedObject(ResultReceiver.CREATOR);
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.hideSoftInput(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    IInputMethodClient _arg1 = IInputMethodClient.Stub.asInterface(data.readStrongBinder());
                    IBinder _arg2 = data.readStrongBinder();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    EditorInfo _arg6 = data.readTypedObject(EditorInfo.CREATOR);
                    IInputContext _arg7 = IInputContext.Stub.asInterface(data.readStrongBinder());
                    IRemoteAccessibilityInputConnection _arg8 = IRemoteAccessibilityInputConnection.Stub.asInterface(data.readStrongBinder());
                    int _arg9 = data.readInt();
                    ImeOnBackInvokedDispatcher _arg10 = data.readTypedObject(ImeOnBackInvokedDispatcher.CREATOR);
                    data.enforceNoDataAvail();
                    InputBindResult _result = this.startInputOrWindowGainedFocus(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9, _arg10);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 10: {
                    IInputMethodClient _arg0 = IInputMethodClient.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.showInputMethodPickerFromClient(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    IInputMethodClient _arg0 = IInputMethodClient.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.showInputMethodPickerFromSystem(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    IInputMethodClient _arg0 = IInputMethodClient.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.showInputMethodAndSubtypeEnablerFromClient(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    boolean _result = this.isInputMethodPickerShownForTest();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 14: {
                    InputMethodSubtype _result = this.getCurrentInputMethodSubtype();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 15: {
                    String _arg0 = data.readString();
                    InputMethodSubtype[] _arg1 = data.createTypedArray(InputMethodSubtype.CREATOR);
                    data.enforceNoDataAvail();
                    this.setAdditionalInputMethodSubtypes(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    IInputMethodClient _arg0 = IInputMethodClient.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.getInputMethodWindowVisibleHeight(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 17: {
                    IInputMethodClient _arg0 = IInputMethodClient.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    float[] _arg2 = data.createFloatArray();
                    data.enforceNoDataAvail();
                    this.reportVirtualDisplayGeometryAsync(_arg0, _arg1, _arg2);
                    break;
                }
                case 18: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.reportPerceptibleAsync(_arg0, _arg1);
                    break;
                }
                case 19: {
                    this.removeImeSurface();
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.removeImeSurfaceFromWindowAsync(_arg0);
                    break;
                }
                case 21: {
                    byte[] _arg0 = data.createByteArray();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.startProtoDump(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    boolean _result = this.isImeTraceEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 23: {
                    this.startImeTrace();
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    this.stopImeTrace();
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    IInputMethodClient _arg0 = IInputMethodClient.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.startStylusHandwriting(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 24;
        }

        private static class Proxy
        implements IInputMethodManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addClient(IInputMethodClient client, IInputContext inputContext, int untrustedDisplayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeStrongInterface(inputContext);
                    _data.writeInt(untrustedDisplayId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<InputMethodInfo> getInputMethodList(int userId) throws RemoteException {
                ArrayList<InputMethodInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(InputMethodInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<InputMethodInfo> getAwareLockedInputMethodList(int userId, int directBootAwareness) throws RemoteException {
                ArrayList<InputMethodInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(directBootAwareness);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(InputMethodInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<InputMethodInfo> getEnabledInputMethodList(int userId) throws RemoteException {
                ArrayList<InputMethodInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(InputMethodInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<InputMethodSubtype> getEnabledInputMethodSubtypeList(String imiId, boolean allowsImplicitlySelectedSubtypes) throws RemoteException {
                ArrayList<InputMethodSubtype> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(imiId);
                    _data.writeBoolean(allowsImplicitlySelectedSubtypes);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(InputMethodSubtype.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public InputMethodSubtype getLastInputMethodSubtype() throws RemoteException {
                InputMethodSubtype _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(InputMethodSubtype.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean showSoftInput(IInputMethodClient client, IBinder windowToken, int flags, ResultReceiver resultReceiver, int reason) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeStrongBinder(windowToken);
                    _data.writeInt(flags);
                    _data.writeTypedObject(resultReceiver, 0);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hideSoftInput(IInputMethodClient client, IBinder windowToken, int flags, ResultReceiver resultReceiver, int reason) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeStrongBinder(windowToken);
                    _data.writeInt(flags);
                    _data.writeTypedObject(resultReceiver, 0);
                    _data.writeInt(reason);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public InputBindResult startInputOrWindowGainedFocus(int startInputReason, IInputMethodClient client, IBinder windowToken, int startInputFlags, int softInputMode, int windowFlags, EditorInfo attribute, IInputContext inputContext, IRemoteAccessibilityInputConnection remoteAccessibilityInputConnection, int unverifiedTargetSdkVersion, ImeOnBackInvokedDispatcher imeDispatcher) throws RemoteException {
                InputBindResult _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(startInputReason);
                    _data.writeStrongInterface(client);
                    _data.writeStrongBinder(windowToken);
                    _data.writeInt(startInputFlags);
                    _data.writeInt(softInputMode);
                    _data.writeInt(windowFlags);
                    _data.writeTypedObject(attribute, 0);
                    _data.writeStrongInterface(inputContext);
                    _data.writeStrongInterface(remoteAccessibilityInputConnection);
                    _data.writeInt(unverifiedTargetSdkVersion);
                    _data.writeTypedObject(imeDispatcher, 0);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(InputBindResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showInputMethodPickerFromClient(IInputMethodClient client, int auxiliarySubtypeMode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeInt(auxiliarySubtypeMode);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showInputMethodPickerFromSystem(IInputMethodClient client, int auxiliarySubtypeMode, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeInt(auxiliarySubtypeMode);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showInputMethodAndSubtypeEnablerFromClient(IInputMethodClient client, String topId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeString(topId);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isInputMethodPickerShownForTest() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public InputMethodSubtype getCurrentInputMethodSubtype() throws RemoteException {
                InputMethodSubtype _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(InputMethodSubtype.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAdditionalInputMethodSubtypes(String id2, InputMethodSubtype[] subtypes) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(id2);
                    _data.writeTypedArray(subtypes, 0);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getInputMethodWindowVisibleHeight(IInputMethodClient client) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportVirtualDisplayGeometryAsync(IInputMethodClient parentClient, int childDisplayId, float[] matrixValues) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(parentClient);
                    _data.writeInt(childDisplayId);
                    _data.writeFloatArray(matrixValues);
                    boolean bl = this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportPerceptibleAsync(IBinder windowToken, boolean perceptible) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(windowToken);
                    _data.writeBoolean(perceptible);
                    boolean bl = this.mRemote.transact(18, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeImeSurface() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeImeSurfaceFromWindowAsync(IBinder windowToken) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(windowToken);
                    boolean bl = this.mRemote.transact(20, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startProtoDump(byte[] protoDump, int source, String where) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(protoDump);
                    _data.writeInt(source);
                    _data.writeString(where);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isImeTraceEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startImeTrace() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopImeTrace() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startStylusHandwriting(IInputMethodClient client) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IInputMethodManager {
        @Override
        public void addClient(IInputMethodClient client, IInputContext inputContext, int untrustedDisplayId) throws RemoteException {
        }

        @Override
        public List<InputMethodInfo> getInputMethodList(int userId) throws RemoteException {
            return null;
        }

        @Override
        public List<InputMethodInfo> getAwareLockedInputMethodList(int userId, int directBootAwareness) throws RemoteException {
            return null;
        }

        @Override
        public List<InputMethodInfo> getEnabledInputMethodList(int userId) throws RemoteException {
            return null;
        }

        @Override
        public List<InputMethodSubtype> getEnabledInputMethodSubtypeList(String imiId, boolean allowsImplicitlySelectedSubtypes) throws RemoteException {
            return null;
        }

        @Override
        public InputMethodSubtype getLastInputMethodSubtype() throws RemoteException {
            return null;
        }

        @Override
        public boolean showSoftInput(IInputMethodClient client, IBinder windowToken, int flags, ResultReceiver resultReceiver, int reason) throws RemoteException {
            return false;
        }

        @Override
        public boolean hideSoftInput(IInputMethodClient client, IBinder windowToken, int flags, ResultReceiver resultReceiver, int reason) throws RemoteException {
            return false;
        }

        @Override
        public InputBindResult startInputOrWindowGainedFocus(int startInputReason, IInputMethodClient client, IBinder windowToken, int startInputFlags, int softInputMode, int windowFlags, EditorInfo attribute, IInputContext inputContext, IRemoteAccessibilityInputConnection remoteAccessibilityInputConnection, int unverifiedTargetSdkVersion, ImeOnBackInvokedDispatcher imeDispatcher) throws RemoteException {
            return null;
        }

        @Override
        public void showInputMethodPickerFromClient(IInputMethodClient client, int auxiliarySubtypeMode) throws RemoteException {
        }

        @Override
        public void showInputMethodPickerFromSystem(IInputMethodClient client, int auxiliarySubtypeMode, int displayId) throws RemoteException {
        }

        @Override
        public void showInputMethodAndSubtypeEnablerFromClient(IInputMethodClient client, String topId) throws RemoteException {
        }

        @Override
        public boolean isInputMethodPickerShownForTest() throws RemoteException {
            return false;
        }

        @Override
        public InputMethodSubtype getCurrentInputMethodSubtype() throws RemoteException {
            return null;
        }

        @Override
        public void setAdditionalInputMethodSubtypes(String id2, InputMethodSubtype[] subtypes) throws RemoteException {
        }

        @Override
        public int getInputMethodWindowVisibleHeight(IInputMethodClient client) throws RemoteException {
            return 0;
        }

        @Override
        public void reportVirtualDisplayGeometryAsync(IInputMethodClient parentClient, int childDisplayId, float[] matrixValues) throws RemoteException {
        }

        @Override
        public void reportPerceptibleAsync(IBinder windowToken, boolean perceptible) throws RemoteException {
        }

        @Override
        public void removeImeSurface() throws RemoteException {
        }

        @Override
        public void removeImeSurfaceFromWindowAsync(IBinder windowToken) throws RemoteException {
        }

        @Override
        public void startProtoDump(byte[] protoDump, int source, String where) throws RemoteException {
        }

        @Override
        public boolean isImeTraceEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void startImeTrace() throws RemoteException {
        }

        @Override
        public void stopImeTrace() throws RemoteException {
        }

        @Override
        public void startStylusHandwriting(IInputMethodClient client) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

