/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.view.InputChannel;
import android.view.MotionEvent;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputBinding;
import android.view.inputmethod.InputMethodSubtype;
import android.window.ImeOnBackInvokedDispatcher;
import com.android.internal.inputmethod.IInputMethodPrivilegedOperations;
import com.android.internal.view.IInlineSuggestionsRequestCallback;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethodSession;
import com.android.internal.view.IInputSessionCallback;
import com.android.internal.view.InlineSuggestionsRequestInfo;
import java.util.ArrayList;
import java.util.List;

public interface IInputMethod
extends IInterface {
    public void initializeInternal(IBinder var1, IInputMethodPrivilegedOperations var2, int var3, boolean var4, int var5) throws RemoteException;

    public void onCreateInlineSuggestionsRequest(InlineSuggestionsRequestInfo var1, IInlineSuggestionsRequestCallback var2) throws RemoteException;

    public void bindInput(InputBinding var1) throws RemoteException;

    public void unbindInput() throws RemoteException;

    public void startInput(IBinder var1, IInputContext var2, EditorInfo var3, boolean var4, int var5, ImeOnBackInvokedDispatcher var6) throws RemoteException;

    public void onNavButtonFlagsChanged(int var1) throws RemoteException;

    public void createSession(InputChannel var1, IInputSessionCallback var2) throws RemoteException;

    public void setSessionEnabled(IInputMethodSession var1, boolean var2) throws RemoteException;

    public void showSoftInput(IBinder var1, int var2, ResultReceiver var3) throws RemoteException;

    public void hideSoftInput(IBinder var1, int var2, ResultReceiver var3) throws RemoteException;

    public void changeInputMethodSubtype(InputMethodSubtype var1) throws RemoteException;

    public void canStartStylusHandwriting(int var1) throws RemoteException;

    public void startStylusHandwriting(int var1, InputChannel var2, List<MotionEvent> var3) throws RemoteException;

    public void initInkWindow() throws RemoteException;

    public void finishStylusHandwriting() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInputMethod {
        public static final String DESCRIPTOR = "com.android.internal.view.IInputMethod";
        static final int TRANSACTION_initializeInternal = 1;
        static final int TRANSACTION_onCreateInlineSuggestionsRequest = 2;
        static final int TRANSACTION_bindInput = 3;
        static final int TRANSACTION_unbindInput = 4;
        static final int TRANSACTION_startInput = 5;
        static final int TRANSACTION_onNavButtonFlagsChanged = 6;
        static final int TRANSACTION_createSession = 7;
        static final int TRANSACTION_setSessionEnabled = 8;
        static final int TRANSACTION_showSoftInput = 9;
        static final int TRANSACTION_hideSoftInput = 10;
        static final int TRANSACTION_changeInputMethodSubtype = 11;
        static final int TRANSACTION_canStartStylusHandwriting = 12;
        static final int TRANSACTION_startStylusHandwriting = 13;
        static final int TRANSACTION_initInkWindow = 14;
        static final int TRANSACTION_finishStylusHandwriting = 15;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IInputMethod asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IInputMethod) {
                return (IInputMethod)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "initializeInternal";
                }
                case 2: {
                    return "onCreateInlineSuggestionsRequest";
                }
                case 3: {
                    return "bindInput";
                }
                case 4: {
                    return "unbindInput";
                }
                case 5: {
                    return "startInput";
                }
                case 6: {
                    return "onNavButtonFlagsChanged";
                }
                case 7: {
                    return "createSession";
                }
                case 8: {
                    return "setSessionEnabled";
                }
                case 9: {
                    return "showSoftInput";
                }
                case 10: {
                    return "hideSoftInput";
                }
                case 11: {
                    return "changeInputMethodSubtype";
                }
                case 12: {
                    return "canStartStylusHandwriting";
                }
                case 13: {
                    return "startStylusHandwriting";
                }
                case 14: {
                    return "initInkWindow";
                }
                case 15: {
                    return "finishStylusHandwriting";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    IBinder _arg0 = data.readStrongBinder();
                    IInputMethodPrivilegedOperations _arg1 = IInputMethodPrivilegedOperations.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    boolean _arg3 = data.readBoolean();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.initializeInternal(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 2: {
                    InlineSuggestionsRequestInfo _arg0 = data.readTypedObject(InlineSuggestionsRequestInfo.CREATOR);
                    IInlineSuggestionsRequestCallback _arg1 = IInlineSuggestionsRequestCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.onCreateInlineSuggestionsRequest(_arg0, _arg1);
                    break;
                }
                case 3: {
                    InputBinding _arg0 = data.readTypedObject(InputBinding.CREATOR);
                    data.enforceNoDataAvail();
                    this.bindInput(_arg0);
                    break;
                }
                case 4: {
                    this.unbindInput();
                    break;
                }
                case 5: {
                    IBinder _arg0 = data.readStrongBinder();
                    IInputContext _arg1 = IInputContext.Stub.asInterface(data.readStrongBinder());
                    EditorInfo _arg2 = data.readTypedObject(EditorInfo.CREATOR);
                    boolean _arg3 = data.readBoolean();
                    int _arg4 = data.readInt();
                    ImeOnBackInvokedDispatcher _arg5 = data.readTypedObject(ImeOnBackInvokedDispatcher.CREATOR);
                    data.enforceNoDataAvail();
                    this.startInput(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onNavButtonFlagsChanged(_arg0);
                    break;
                }
                case 7: {
                    InputChannel _arg0 = data.readTypedObject(InputChannel.CREATOR);
                    IInputSessionCallback _arg1 = IInputSessionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.createSession(_arg0, _arg1);
                    break;
                }
                case 8: {
                    IInputMethodSession _arg0 = IInputMethodSession.Stub.asInterface(data.readStrongBinder());
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setSessionEnabled(_arg0, _arg1);
                    break;
                }
                case 9: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    ResultReceiver _arg2 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.showSoftInput(_arg0, _arg1, _arg2);
                    break;
                }
                case 10: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    ResultReceiver _arg2 = data.readTypedObject(ResultReceiver.CREATOR);
                    data.enforceNoDataAvail();
                    this.hideSoftInput(_arg0, _arg1, _arg2);
                    break;
                }
                case 11: {
                    InputMethodSubtype _arg0 = data.readTypedObject(InputMethodSubtype.CREATOR);
                    data.enforceNoDataAvail();
                    this.changeInputMethodSubtype(_arg0);
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.canStartStylusHandwriting(_arg0);
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    InputChannel _arg1 = data.readTypedObject(InputChannel.CREATOR);
                    ArrayList<MotionEvent> _arg2 = data.createTypedArrayList(MotionEvent.CREATOR);
                    data.enforceNoDataAvail();
                    this.startStylusHandwriting(_arg0, _arg1, _arg2);
                    break;
                }
                case 14: {
                    this.initInkWindow();
                    break;
                }
                case 15: {
                    this.finishStylusHandwriting();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 14;
        }

        private static class Proxy
        implements IInputMethod {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initializeInternal(IBinder token, IInputMethodPrivilegedOperations privOps, int configChanges, boolean stylusHwSupported, int navigationBarFlags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeStrongInterface(privOps);
                    _data.writeInt(configChanges);
                    _data.writeBoolean(stylusHwSupported);
                    _data.writeInt(navigationBarFlags);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCreateInlineSuggestionsRequest(InlineSuggestionsRequestInfo requestInfo, IInlineSuggestionsRequestCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(requestInfo, 0);
                    _data.writeStrongInterface(cb);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void bindInput(InputBinding binding) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(binding, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void unbindInput() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startInput(IBinder startInputToken, IInputContext inputContext, EditorInfo attribute, boolean restarting, int navigationBarFlags, ImeOnBackInvokedDispatcher imeDispatcher) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(startInputToken);
                    _data.writeStrongInterface(inputContext);
                    _data.writeTypedObject(attribute, 0);
                    _data.writeBoolean(restarting);
                    _data.writeInt(navigationBarFlags);
                    _data.writeTypedObject(imeDispatcher, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNavButtonFlagsChanged(int navButtonFlags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(navButtonFlags);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createSession(InputChannel channel, IInputSessionCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(channel, 0);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSessionEnabled(IInputMethodSession session, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(session);
                    _data.writeBoolean(enabled);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showSoftInput(IBinder showInputToken, int flags, ResultReceiver resultReceiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(showInputToken);
                    _data.writeInt(flags);
                    _data.writeTypedObject(resultReceiver, 0);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hideSoftInput(IBinder hideInputToken, int flags, ResultReceiver resultReceiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(hideInputToken);
                    _data.writeInt(flags);
                    _data.writeTypedObject(resultReceiver, 0);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void changeInputMethodSubtype(InputMethodSubtype subtype) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(subtype, 0);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void canStartStylusHandwriting(int requestId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(requestId);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startStylusHandwriting(int requestId, InputChannel channel, List<MotionEvent> events) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(requestId);
                    _data.writeTypedObject(channel, 0);
                    _data.writeTypedList(events);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void initInkWindow() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void finishStylusHandwriting() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IInputMethod {
        @Override
        public void initializeInternal(IBinder token, IInputMethodPrivilegedOperations privOps, int configChanges, boolean stylusHwSupported, int navigationBarFlags) throws RemoteException {
        }

        @Override
        public void onCreateInlineSuggestionsRequest(InlineSuggestionsRequestInfo requestInfo, IInlineSuggestionsRequestCallback cb) throws RemoteException {
        }

        @Override
        public void bindInput(InputBinding binding) throws RemoteException {
        }

        @Override
        public void unbindInput() throws RemoteException {
        }

        @Override
        public void startInput(IBinder startInputToken, IInputContext inputContext, EditorInfo attribute, boolean restarting, int navigationBarFlags, ImeOnBackInvokedDispatcher imeDispatcher) throws RemoteException {
        }

        @Override
        public void onNavButtonFlagsChanged(int navButtonFlags) throws RemoteException {
        }

        @Override
        public void createSession(InputChannel channel, IInputSessionCallback callback) throws RemoteException {
        }

        @Override
        public void setSessionEnabled(IInputMethodSession session, boolean enabled) throws RemoteException {
        }

        @Override
        public void showSoftInput(IBinder showInputToken, int flags, ResultReceiver resultReceiver) throws RemoteException {
        }

        @Override
        public void hideSoftInput(IBinder hideInputToken, int flags, ResultReceiver resultReceiver) throws RemoteException {
        }

        @Override
        public void changeInputMethodSubtype(InputMethodSubtype subtype) throws RemoteException {
        }

        @Override
        public void canStartStylusHandwriting(int requestId) throws RemoteException {
        }

        @Override
        public void startStylusHandwriting(int requestId, InputChannel channel, List<MotionEvent> events) throws RemoteException {
        }

        @Override
        public void initInkWindow() throws RemoteException {
        }

        @Override
        public void finishStylusHandwriting() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

