/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.power;

import android.content.res.XmlResourceParser;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseDoubleArray;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import org.xmlpull.v1.XmlPullParserException;

public class ModemPowerProfile {
    private static final String TAG = "ModemPowerProfile";
    private static final String TAG_SLEEP = "sleep";
    private static final String TAG_IDLE = "idle";
    private static final String TAG_ACTIVE = "active";
    private static final String TAG_RECEIVE = "receive";
    private static final String TAG_TRANSMIT = "transmit";
    private static final String ATTR_RAT = "rat";
    private static final String ATTR_NR_FREQUENCY = "nrFrequency";
    private static final String ATTR_LEVEL = "level";
    private final SparseDoubleArray mPowerConstants = new SparseDoubleArray();
    private static final int MODEM_DRAIN_TYPE_MASK = -268435456;
    private static final int MODEM_TX_LEVEL_MASK = 0xF000000;
    private static final int MODEM_RAT_TYPE_MASK = 0xF00000;
    private static final int MODEM_NR_FREQUENCY_RANGE_MASK = 983040;
    public static final int MODEM_DRAIN_TYPE_SLEEP = 0;
    public static final int MODEM_DRAIN_TYPE_IDLE = 0x10000000;
    public static final int MODEM_DRAIN_TYPE_RX = 0x20000000;
    public static final int MODEM_DRAIN_TYPE_TX = 0x30000000;
    private static final SparseArray<String> MODEM_DRAIN_TYPE_NAMES = new SparseArray(4);
    public static final int MODEM_TX_LEVEL_0 = 0;
    public static final int MODEM_TX_LEVEL_1 = 0x1000000;
    public static final int MODEM_TX_LEVEL_2 = 0x2000000;
    public static final int MODEM_TX_LEVEL_3 = 0x3000000;
    public static final int MODEM_TX_LEVEL_4 = 0x4000000;
    private static final int MODEM_TX_LEVEL_COUNT = 5;
    private static final SparseArray<String> MODEM_TX_LEVEL_NAMES;
    private static final int[] MODEM_TX_LEVEL_MAP;
    public static final int MODEM_RAT_TYPE_DEFAULT = 0;
    public static final int MODEM_RAT_TYPE_LTE = 0x100000;
    public static final int MODEM_RAT_TYPE_NR = 0x200000;
    private static final SparseArray<String> MODEM_RAT_TYPE_NAMES;
    public static final int MODEM_NR_FREQUENCY_RANGE_DEFAULT = 0;
    public static final int MODEM_NR_FREQUENCY_RANGE_LOW = 65536;
    public static final int MODEM_NR_FREQUENCY_RANGE_MID = 131072;
    public static final int MODEM_NR_FREQUENCY_RANGE_HIGH = 196608;
    public static final int MODEM_NR_FREQUENCY_RANGE_MMWAVE = 262144;
    private static final SparseArray<String> MODEM_NR_FREQUENCY_RANGE_NAMES;

    public void parseFromXml(XmlResourceParser parser) throws IOException, XmlPullParserException {
        int depth = parser.getDepth();
        block10: while (XmlUtils.nextElementWithin(parser, depth)) {
            String name;
            switch (name = parser.getName()) {
                case "sleep": {
                    if (parser.next() != 4) continue block10;
                    String sleepDrain = parser.getText();
                    this.setPowerConstant(0, sleepDrain);
                    continue block10;
                }
                case "idle": {
                    if (parser.next() != 4) continue block10;
                    String idleDrain = parser.getText();
                    this.setPowerConstant(0x10000000, idleDrain);
                    continue block10;
                }
                case "active": {
                    this.parseActivePowerConstantsFromXml(parser);
                    continue block10;
                }
            }
            Slog.e(TAG, "Unexpected element parsed: " + name);
        }
    }

    private void parseActivePowerConstantsFromXml(XmlResourceParser parser) throws IOException, XmlPullParserException {
        int nrfType;
        int ratType;
        try {
            ratType = ModemPowerProfile.getTypeFromAttribute(parser, ATTR_RAT, MODEM_RAT_TYPE_NAMES);
            nrfType = ratType == 0x200000 ? ModemPowerProfile.getTypeFromAttribute(parser, ATTR_NR_FREQUENCY, MODEM_NR_FREQUENCY_RANGE_NAMES) : 0;
        }
        catch (IllegalArgumentException iae) {
            Slog.e(TAG, "Failed parse to active modem power constants", iae);
            return;
        }
        int depth = parser.getDepth();
        block10: while (XmlUtils.nextElementWithin(parser, depth)) {
            String name;
            switch (name = parser.getName()) {
                case "receive": {
                    if (parser.next() != 4) continue block10;
                    String rxDrain = parser.getText();
                    int rxKey = 0x20000000 | ratType | nrfType;
                    this.setPowerConstant(rxKey, rxDrain);
                    continue block10;
                }
                case "transmit": {
                    int level = XmlUtils.readIntAttribute(parser, ATTR_LEVEL, -1);
                    if (parser.next() != 4) continue block10;
                    String txDrain = parser.getText();
                    if (level < 0 || level >= 5) {
                        Slog.e(TAG, "Unexpected tx level: " + level + ". Must be between 0 and " + 4);
                        continue block10;
                    }
                    int modemTxLevel = MODEM_TX_LEVEL_MAP[level];
                    int txKey = 0x30000000 | modemTxLevel | ratType | nrfType;
                    this.setPowerConstant(txKey, txDrain);
                    continue block10;
                }
            }
            Slog.e(TAG, "Unexpected element parsed: " + name);
        }
    }

    private static int getTypeFromAttribute(XmlResourceParser parser, String attr2, SparseArray<String> names) {
        String value = XmlUtils.readStringAttribute(parser, attr2);
        if (value == null) {
            return 0;
        }
        int index = -1;
        int size = names.size();
        for (int i = 0; i < size; ++i) {
            if (!value.equals(names.valueAt(i))) continue;
            index = i;
        }
        if (index < 0) {
            Object[] stringNames = new String[size];
            for (int i = 0; i < size; ++i) {
                stringNames[i] = names.valueAt(i);
            }
            throw new IllegalArgumentException("Unexpected " + attr2 + " value : " + value + ". Acceptable values are " + Arrays.toString(stringNames));
        }
        return names.keyAt(index);
    }

    public void setPowerConstant(int key, String value) {
        try {
            this.mPowerConstants.put(key, Double.valueOf(value));
        }
        catch (Exception e) {
            Slog.e(TAG, "Failed to set power constant 0x" + Integer.toHexString(key) + "(" + ModemPowerProfile.keyToString(key) + ") to " + value, e);
        }
    }

    public double getAverageBatteryDrainMa(int key) {
        int bestKey = key;
        double value = this.mPowerConstants.get(bestKey, Double.NaN);
        if (!Double.isNaN(value)) {
            return value;
        }
        if ((bestKey & 0xF0000) != 0) {
            bestKey &= 0xFFF0FFFF;
            value = this.mPowerConstants.get(bestKey |= 0, Double.NaN);
            if (!Double.isNaN(value)) {
                return value;
            }
        }
        if ((bestKey & 0xF00000) != 0) {
            bestKey &= 0xFF0FFFFF;
            value = this.mPowerConstants.get(bestKey |= 0, Double.NaN);
            if (!Double.isNaN(value)) {
                return value;
            }
        }
        Slog.w(TAG, "getAverageBatteryDrainMaH called with unexpected key: 0x" + Integer.toHexString(key) + ", " + ModemPowerProfile.keyToString(key));
        return Double.NaN;
    }

    private static String keyToString(int key) {
        StringBuilder sb = new StringBuilder();
        int drainType = key & 0xF0000000;
        ModemPowerProfile.appendFieldToString(sb, "drain", MODEM_DRAIN_TYPE_NAMES, drainType);
        sb.append(",");
        if (drainType == 0x30000000) {
            int txLevel = key & 0xF000000;
            ModemPowerProfile.appendFieldToString(sb, ATTR_LEVEL, MODEM_TX_LEVEL_NAMES, txLevel);
        }
        int ratType = key & 0xF00000;
        ModemPowerProfile.appendFieldToString(sb, "RAT", MODEM_RAT_TYPE_NAMES, ratType);
        if (ratType == 0x200000) {
            sb.append(",");
            int nrFreq = key & 0xF0000;
            ModemPowerProfile.appendFieldToString(sb, "nrFreq", MODEM_NR_FREQUENCY_RANGE_NAMES, nrFreq);
        }
        return sb.toString();
    }

    private static void appendFieldToString(StringBuilder sb, String fieldName, SparseArray<String> names, int key) {
        sb.append(fieldName);
        sb.append(":");
        String name = names.get(key, null);
        if (name == null) {
            sb.append("UNKNOWN(0x");
            sb.append(Integer.toHexString(key));
            sb.append(")");
        } else {
            sb.append(name);
        }
    }

    public void clear() {
        this.mPowerConstants.clear();
    }

    public void dump(PrintWriter pw) {
        int size = this.mPowerConstants.size();
        for (int i = 0; i < size; ++i) {
            pw.print(ModemPowerProfile.keyToString(this.mPowerConstants.keyAt(i)));
            pw.print("=");
            pw.println(this.mPowerConstants.valueAt(i));
        }
    }

    static {
        MODEM_DRAIN_TYPE_NAMES.put(0, "SLEEP");
        MODEM_DRAIN_TYPE_NAMES.put(0x10000000, "IDLE");
        MODEM_DRAIN_TYPE_NAMES.put(0x20000000, "RX");
        MODEM_DRAIN_TYPE_NAMES.put(0x30000000, "TX");
        MODEM_TX_LEVEL_NAMES = new SparseArray(5);
        MODEM_DRAIN_TYPE_NAMES.put(0, "0");
        MODEM_DRAIN_TYPE_NAMES.put(0x1000000, "1");
        MODEM_DRAIN_TYPE_NAMES.put(0x2000000, "2");
        MODEM_DRAIN_TYPE_NAMES.put(0x3000000, "3");
        MODEM_DRAIN_TYPE_NAMES.put(0x4000000, "4");
        MODEM_TX_LEVEL_MAP = new int[]{0, 0x1000000, 0x2000000, 0x3000000, 0x4000000};
        MODEM_RAT_TYPE_NAMES = new SparseArray(3);
        MODEM_RAT_TYPE_NAMES.put(0, "DEFAULT");
        MODEM_RAT_TYPE_NAMES.put(0x100000, "LTE");
        MODEM_RAT_TYPE_NAMES.put(0x200000, "NR");
        MODEM_NR_FREQUENCY_RANGE_NAMES = new SparseArray(5);
        MODEM_NR_FREQUENCY_RANGE_NAMES.put(0, "DEFAULT");
        MODEM_NR_FREQUENCY_RANGE_NAMES.put(65536, "LOW");
        MODEM_NR_FREQUENCY_RANGE_NAMES.put(131072, "MID");
        MODEM_NR_FREQUENCY_RANGE_NAMES.put(196608, "HIGH");
        MODEM_NR_FREQUENCY_RANGE_NAMES.put(262144, "MMWAVE");
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ModemNrFrequencyRange {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ModemRatType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ModemTxLevel {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ModemDrainType {
    }
}

