/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryConsumer;
import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.UidBatteryConsumer;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import com.android.internal.os.UsageBasedPowerEstimator;
import java.util.Arrays;

public class CpuPowerCalculator
extends PowerCalculator {
    private static final String TAG = "CpuPowerCalculator";
    private static final boolean DEBUG = false;
    private static final BatteryConsumer.Key[] UNINITIALIZED_KEYS = new BatteryConsumer.Key[0];
    private final int mNumCpuClusters;
    private final UsageBasedPowerEstimator mCpuActivePowerEstimator;
    private final UsageBasedPowerEstimator[] mPerClusterPowerEstimators;
    private final UsageBasedPowerEstimator[][] mPerCpuFreqPowerEstimatorsByCluster;
    private final UsageBasedPowerEstimator[] mPerCpuFreqPowerEstimators;

    public CpuPowerCalculator(PowerProfile profile) {
        this.mNumCpuClusters = profile.getNumCpuClusters();
        this.mCpuActivePowerEstimator = new UsageBasedPowerEstimator(profile.getAveragePower("cpu.active"));
        this.mPerClusterPowerEstimators = new UsageBasedPowerEstimator[this.mNumCpuClusters];
        for (int cluster = 0; cluster < this.mNumCpuClusters; ++cluster) {
            this.mPerClusterPowerEstimators[cluster] = new UsageBasedPowerEstimator(profile.getAveragePowerForCpuCluster(cluster));
        }
        int freqCount = 0;
        for (int cluster = 0; cluster < this.mNumCpuClusters; ++cluster) {
            freqCount += profile.getNumSpeedStepsInCpuCluster(cluster);
        }
        this.mPerCpuFreqPowerEstimatorsByCluster = new UsageBasedPowerEstimator[this.mNumCpuClusters][];
        this.mPerCpuFreqPowerEstimators = new UsageBasedPowerEstimator[freqCount];
        int index = 0;
        for (int cluster = 0; cluster < this.mNumCpuClusters; ++cluster) {
            int speedsForCluster = profile.getNumSpeedStepsInCpuCluster(cluster);
            this.mPerCpuFreqPowerEstimatorsByCluster[cluster] = new UsageBasedPowerEstimator[speedsForCluster];
            for (int speed = 0; speed < speedsForCluster; ++speed) {
                UsageBasedPowerEstimator estimator;
                this.mPerCpuFreqPowerEstimatorsByCluster[cluster][speed] = estimator = new UsageBasedPowerEstimator(profile.getAveragePowerForCpuCore(cluster, speed));
                this.mPerCpuFreqPowerEstimators[index++] = estimator;
            }
        }
    }

    @Override
    public boolean isPowerComponentSupported(int powerComponent) {
        return powerComponent == 1;
    }

    @Override
    public void calculate(BatteryUsageStats.Builder builder, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        double totalPowerMah = 0.0;
        Object keys = UNINITIALIZED_KEYS;
        Result result = new Result();
        if (query.isProcessStateDataNeeded()) {
            result.cpuFreqTimes = new long[batteryStats.getCpuFreqCount()];
        }
        SparseArray<UidBatteryConsumer.Builder> uidBatteryConsumerBuilders = builder.getUidBatteryConsumerBuilders();
        for (int i = uidBatteryConsumerBuilders.size() - 1; i >= 0; --i) {
            UidBatteryConsumer.Builder app = uidBatteryConsumerBuilders.valueAt(i);
            if (keys == UNINITIALIZED_KEYS) {
                keys = query.isProcessStateDataNeeded() ? app.getKeys(1) : null;
            }
            this.calculateApp(app, app.getBatteryStatsUid(), query, result, (BatteryConsumer.Key[])keys);
            if (app.isVirtualUid()) continue;
            totalPowerMah += result.powerMah;
        }
        long consumptionUC = batteryStats.getCpuMeasuredBatteryConsumptionUC();
        int powerModel = CpuPowerCalculator.getPowerModel(consumptionUC, query);
        builder.getAggregateBatteryConsumerBuilder(1).setConsumedPower(1, totalPowerMah);
        builder.getAggregateBatteryConsumerBuilder(0).setConsumedPower(1, powerModel == 2 ? CpuPowerCalculator.uCtoMah(consumptionUC) : totalPowerMah, powerModel);
    }

    private void calculateApp(UidBatteryConsumer.Builder app, BatteryStats.Uid u, BatteryUsageStatsQuery query, Result result, BatteryConsumer.Key[] keys) {
        long consumptionUC = u.getCpuMeasuredBatteryConsumptionUC();
        int powerModel = CpuPowerCalculator.getPowerModel(consumptionUC, query);
        this.calculatePowerAndDuration(u, powerModel, consumptionUC, 0, result);
        ((UidBatteryConsumer.Builder)((UidBatteryConsumer.Builder)app.setConsumedPower(1, result.powerMah, powerModel)).setUsageDurationMillis(1, result.durationMs)).setPackageWithHighestDrain(result.packageWithHighestDrain);
        if (query.isProcessStateDataNeeded() && keys != null) {
            switch (powerModel) {
                case 2: {
                    this.calculateMeasuredPowerPerProcessState(app, u, keys);
                    break;
                }
                case 1: {
                    this.calculateModeledPowerPerProcessState(app, u, keys, result);
                }
            }
        }
    }

    private void calculateMeasuredPowerPerProcessState(UidBatteryConsumer.Builder app, BatteryStats.Uid u, BatteryConsumer.Key[] keys) {
        for (BatteryConsumer.Key key : keys) {
            long consumptionUC;
            if (key.processState == 0 || (consumptionUC = u.getCpuMeasuredBatteryConsumptionUC(key.processState)) == 0L) continue;
            app.setConsumedPower(key, CpuPowerCalculator.uCtoMah(consumptionUC), 2);
        }
    }

    private void calculateModeledPowerPerProcessState(UidBatteryConsumer.Builder app, BatteryStats.Uid u, BatteryConsumer.Key[] keys, Result result) {
        if (result.perProcStatePowerMah == null) {
            result.perProcStatePowerMah = new double[5];
        } else {
            Arrays.fill(result.perProcStatePowerMah, 0.0);
        }
        for (int uidProcState = 0; uidProcState < 7; ++uidProcState) {
            int procState = BatteryStats.mapUidProcessStateToBatteryConsumerProcessState(uidProcState);
            if (procState == 0) continue;
            long[] cpuClusterTimes = null;
            boolean hasCpuFreqTimes = u.getCpuFreqTimes(result.cpuFreqTimes, uidProcState);
            if (cpuClusterTimes == null && !hasCpuFreqTimes) continue;
            int n = procState;
            result.perProcStatePowerMah[n] = result.perProcStatePowerMah[n] + this.calculateUidModeledPowerMah(u, 0L, cpuClusterTimes, result.cpuFreqTimes);
        }
        for (BatteryConsumer.Key key : keys) {
            if (key.processState == 0) continue;
            long cpuActiveTime = u.getCpuActiveTime(key.processState);
            double powerMah = result.perProcStatePowerMah[key.processState];
            ((UidBatteryConsumer.Builder)app.setConsumedPower(key, powerMah += this.mCpuActivePowerEstimator.calculatePower(cpuActiveTime), 1)).setUsageDurationMillis(key, cpuActiveTime);
        }
    }

    private void calculatePowerAndDuration(BatteryStats.Uid u, int powerModel, long consumptionUC, int statsType, Result result) {
        double powerMah;
        long durationMs = (u.getUserCpuTimeUs(statsType) + u.getSystemCpuTimeUs(statsType)) / 1000L;
        switch (powerModel) {
            case 2: {
                powerMah = CpuPowerCalculator.uCtoMah(consumptionUC);
                break;
            }
            default: {
                powerMah = this.calculateUidModeledPowerMah(u, statsType);
            }
        }
        double highestDrain = 0.0;
        String packageWithHighestDrain = null;
        long durationFgMs = 0L;
        ArrayMap<String, ? extends BatteryStats.Uid.Proc> processStats = u.getProcessStats();
        int processStatsCount = processStats.size();
        for (int i = 0; i < processStatsCount; ++i) {
            BatteryStats.Uid.Proc ps = processStats.valueAt(i);
            String processName = processStats.keyAt(i);
            durationFgMs += ps.getForegroundTime(statsType);
            long costValue = ps.getUserTime(statsType) + ps.getSystemTime(statsType) + ps.getForegroundTime(statsType);
            if (packageWithHighestDrain == null || packageWithHighestDrain.startsWith("*")) {
                highestDrain = costValue;
                packageWithHighestDrain = processName;
                continue;
            }
            if (!(highestDrain < (double)costValue) || processName.startsWith("*")) continue;
            highestDrain = costValue;
            packageWithHighestDrain = processName;
        }
        if (durationFgMs > durationMs) {
            durationMs = durationFgMs;
        }
        result.durationMs = durationMs;
        result.durationFgMs = durationFgMs;
        result.powerMah = powerMah;
        result.packageWithHighestDrain = packageWithHighestDrain;
    }

    public double calculateUidModeledPowerMah(BatteryStats.Uid u, int statsType) {
        return this.calculateUidModeledPowerMah(u, u.getCpuActiveTime(), u.getCpuClusterTimes(), u.getCpuFreqTimes(statsType));
    }

    private double calculateUidModeledPowerMah(BatteryStats.Uid u, long cpuActiveTime, long[] cpuClusterTimes, long[] cpuFreqTimes) {
        double powerMah = this.calculateActiveCpuPowerMah(cpuActiveTime);
        if (cpuClusterTimes != null) {
            if (cpuClusterTimes.length == this.mNumCpuClusters) {
                for (int cluster = 0; cluster < this.mNumCpuClusters; ++cluster) {
                    double power = this.mPerClusterPowerEstimators[cluster].calculatePower(cpuClusterTimes[cluster]);
                    powerMah += power;
                }
            } else {
                Log.w(TAG, "UID " + u.getUid() + " CPU cluster # mismatch: Power Profile # " + this.mNumCpuClusters + " actual # " + cpuClusterTimes.length);
            }
        }
        if (cpuFreqTimes != null) {
            if (cpuFreqTimes.length == this.mPerCpuFreqPowerEstimators.length) {
                for (int i = 0; i < cpuFreqTimes.length; ++i) {
                    powerMah += this.mPerCpuFreqPowerEstimators[i].calculatePower(cpuFreqTimes[i]);
                }
            } else {
                Log.w(TAG, "UID " + u.getUid() + " CPU freq # mismatch: Power Profile # " + this.mPerCpuFreqPowerEstimators.length + " actual # " + cpuFreqTimes.length);
            }
        }
        return powerMah;
    }

    public double calculateActiveCpuPowerMah(long durationsMs) {
        return this.mCpuActivePowerEstimator.calculatePower(durationsMs);
    }

    public double calculatePerCpuClusterPowerMah(int cluster, long clusterDurationMs) {
        return this.mPerClusterPowerEstimators[cluster].calculatePower(clusterDurationMs);
    }

    public double calculatePerCpuFreqPowerMah(int cluster, int speedStep, long clusterSpeedDurationsMs) {
        return this.mPerCpuFreqPowerEstimatorsByCluster[cluster][speedStep].calculatePower(clusterSpeedDurationsMs);
    }

    private static class Result {
        public long durationMs;
        public double powerMah;
        public long durationFgMs;
        public String packageWithHighestDrain;
        public double[] perProcStatePowerMah;
        public long[] cpuFreqTimes;

        private Result() {
        }
    }
}

