/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net.ipsec.ike.message;

import android.net.ipsec.ike.IkeManager;
import android.net.ipsec.ike.exceptions.AuthenticationFailedException;
import android.net.ipsec.ike.exceptions.ChildSaNotFoundException;
import android.net.ipsec.ike.exceptions.FailedCpRequiredException;
import android.net.ipsec.ike.exceptions.IkeProtocolException;
import android.net.ipsec.ike.exceptions.InternalAddressFailureException;
import android.net.ipsec.ike.exceptions.InvalidIkeSpiException;
import android.net.ipsec.ike.exceptions.InvalidKeException;
import android.net.ipsec.ike.exceptions.InvalidMajorVersionException;
import android.net.ipsec.ike.exceptions.InvalidMessageIdException;
import android.net.ipsec.ike.exceptions.InvalidSelectorsException;
import android.net.ipsec.ike.exceptions.InvalidSyntaxException;
import android.net.ipsec.ike.exceptions.NoAdditionalSasException;
import android.net.ipsec.ike.exceptions.NoValidProposalChosenException;
import android.net.ipsec.ike.exceptions.SinglePairRequiredException;
import android.net.ipsec.ike.exceptions.TemporaryFailureException;
import android.net.ipsec.ike.exceptions.TsUnacceptableException;
import android.net.ipsec.ike.exceptions.UnrecognizedIkeProtocolException;
import android.net.ipsec.ike.exceptions.UnsupportedCriticalPayloadException;
import android.util.ArraySet;
import android.util.SparseArray;
import com.android.internal.net.ipsec.ike.message.IkeInformationalPayload;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.util.Set;

public class IkeNotifyPayload
extends IkeInformationalPayload {
    private static final String TAG = IkeNotifyPayload.class.getSimpleName();
    public static final int NOTIFY_TYPE_INITIAL_CONTACT = 16384;
    public static final int NOTIFY_TYPE_ADDITIONAL_TS_POSSIBLE = 16386;
    public static final int NOTIFY_TYPE_IPCOMP_SUPPORTED = 16387;
    public static final int NOTIFY_TYPE_NAT_DETECTION_SOURCE_IP = 16388;
    public static final int NOTIFY_TYPE_NAT_DETECTION_DESTINATION_IP = 16389;
    public static final int NOTIFY_TYPE_COOKIE = 16390;
    public static final int NOTIFY_TYPE_USE_TRANSPORT_MODE = 16391;
    public static final int NOTIFY_TYPE_REKEY_SA = 16393;
    public static final int NOTIFY_TYPE_ESP_TFC_PADDING_NOT_SUPPORTED = 16394;
    public static final int NOTIFY_TYPE_MOBIKE_SUPPORTED = 16396;
    public static final int NOTIFY_TYPE_UPDATE_SA_ADDRESSES = 16400;
    public static final int NOTIFY_TYPE_COOKIE2 = 16401;
    public static final int NOTIFY_TYPE_EAP_ONLY_AUTHENTICATION = 16417;
    public static final int NOTIFY_TYPE_IKEV2_FRAGMENTATION_SUPPORTED = 16430;
    public static final int NOTIFY_TYPE_SIGNATURE_HASH_ALGORITHMS = 16431;
    private static final int NOTIFY_HEADER_LEN = 4;
    private static final int ERROR_NOTIFY_TYPE_MAX = 16383;
    private static final String NAT_DETECTION_DIGEST_ALGORITHM = "SHA-1";
    private static final int COOKIE_DATA_LEN_MIN = 1;
    private static final int COOKIE_DATA_LEN_MAX = 64;
    private static final int COOKIE2_DATA_LEN_MIN = 8;
    private static final int COOKIE2_DATA_LEN_MAX = 64;
    private static final Set<Integer> VALID_NOTIFY_TYPES_FOR_EXISTING_CHILD_SA = new ArraySet<Integer>();
    private static final Set<Integer> VALID_NOTIFY_TYPES_FOR_NEW_CHILD_SA;
    private static final SparseArray<String> NOTIFY_TYPE_TO_STRING;
    public final int protocolId;
    public final byte spiSize;
    public final int notifyType;
    public final int spi;
    public final byte[] notifyData;

    IkeNotifyPayload(boolean isCritical, byte[] payloadBody) throws IkeProtocolException {
        super(41, isCritical);
        ByteBuffer inputBuffer = ByteBuffer.wrap(payloadBody);
        this.protocolId = Byte.toUnsignedInt(inputBuffer.get());
        this.spiSize = inputBuffer.get();
        this.notifyType = Short.toUnsignedInt(inputBuffer.getShort());
        if (this.spiSize == 4) {
            this.validateNotifyPayloadForExistingChildSa();
            this.spi = inputBuffer.getInt();
        } else if (this.spiSize == 0) {
            this.validateNotifyPayloadForIkeAndNewChild();
            this.spi = 0;
        } else {
            throw new InvalidSyntaxException("Invalid SPI Size: " + this.spiSize);
        }
        this.notifyData = new byte[payloadBody.length - 4 - this.spiSize];
        inputBuffer.get(this.notifyData);
    }

    private void validateNotifyPayloadForExistingChildSa() throws InvalidSyntaxException {
        if (this.protocolId != 2 && this.protocolId != 3) {
            throw new InvalidSyntaxException("Expected Procotol ID AH(2) or ESP(3): Protocol ID is " + this.protocolId);
        }
        if (!VALID_NOTIFY_TYPES_FOR_EXISTING_CHILD_SA.contains(this.notifyType)) {
            throw new InvalidSyntaxException("Expected Notify Type for existing Child SA: Notify Type is " + this.notifyType);
        }
    }

    private void validateNotifyPayloadForIkeAndNewChild() throws InvalidSyntaxException {
        if (this.protocolId != 0) {
            IkeManager.getIkeLog().w(TAG, "Expected Procotol ID unset: Protocol ID is " + this.protocolId);
        }
        if (this.notifyType == 39 || this.notifyType == 44) {
            throw new InvalidSyntaxException("Expected Notify Type concerning IKE SA or new Child SA under negotiation: Notify Type is " + this.notifyType);
        }
    }

    public static byte[] generateNatDetectionData(long initiatorIkeSpi, long responderIkeSpi, InetAddress ipAddress, int port) {
        byte[] rawIpAddr = ipAddress.getAddress();
        ByteBuffer byteBuffer = ByteBuffer.allocate(16 + rawIpAddr.length + 2);
        byteBuffer.putLong(initiatorIkeSpi).putLong(responderIkeSpi).put(rawIpAddr).putShort((short)port);
        try {
            MessageDigest natDetectionDataDigest = MessageDigest.getInstance(NAT_DETECTION_DIGEST_ALGORITHM);
            return natDetectionDataDigest.digest(byteBuffer.array());
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProviderException("Failed to obtain algorithm :SHA-1", e);
        }
    }

    private static IkeNotifyPayload handleCookieAndGenerateCopy(IkeNotifyPayload cookie2Notify, int minLen, int maxLen) throws InvalidSyntaxException {
        byte[] notifyData = cookie2Notify.notifyData;
        if (notifyData.length < minLen || notifyData.length > maxLen) {
            String cookieType = cookie2Notify.notifyType == 16401 ? "COOKIE2" : "COOKIE";
            throw new InvalidSyntaxException("Invalid " + cookieType + " notification data with length " + notifyData.length);
        }
        return new IkeNotifyPayload(cookie2Notify.notifyType, notifyData);
    }

    public static IkeNotifyPayload handleCookieAndGenerateCopy(IkeNotifyPayload cookieNotify) throws InvalidSyntaxException {
        return IkeNotifyPayload.handleCookieAndGenerateCopy(cookieNotify, 1, 64);
    }

    public static IkeNotifyPayload handleCookie2AndGenerateCopy(IkeNotifyPayload cookie2Notify) throws InvalidSyntaxException {
        return IkeNotifyPayload.handleCookieAndGenerateCopy(cookie2Notify, 8, 64);
    }

    @Override
    protected void encodeToByteBuffer(int nextPayload, ByteBuffer byteBuffer) {
        IkeNotifyPayload.encodePayloadHeaderToByteBuffer(nextPayload, this.getPayloadLength(), byteBuffer);
        byteBuffer.put((byte)this.protocolId).put(this.spiSize).putShort((short)this.notifyType);
        if (this.spiSize == 4) {
            byteBuffer.putInt(this.spi);
        }
        byteBuffer.put(this.notifyData);
    }

    @Override
    protected int getPayloadLength() {
        return 8 + this.spiSize + this.notifyData.length;
    }

    protected IkeNotifyPayload(int protocolId, byte spiSize, int spi, int notifyType, byte[] notifyData) {
        super(41, false);
        this.protocolId = protocolId;
        this.spiSize = spiSize;
        this.spi = spi;
        this.notifyType = notifyType;
        this.notifyData = notifyData;
    }

    public IkeNotifyPayload(int notifyType, byte[] notifyData) {
        this(0, 0, 0, notifyType, notifyData);
        try {
            this.validateNotifyPayloadForIkeAndNewChild();
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public IkeNotifyPayload(int notifyType) {
        this(notifyType, new byte[0]);
    }

    public IkeNotifyPayload(int protocolId, int spi, int notifyType, byte[] notifyData) {
        this(protocolId, 4, spi, notifyType, notifyData);
        try {
            this.validateNotifyPayloadForExistingChildSa();
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean isErrorNotify() {
        return this.notifyType <= 16383;
    }

    public boolean isNewChildSaNotify() {
        return VALID_NOTIFY_TYPES_FOR_NEW_CHILD_SA.contains(this.notifyType);
    }

    public IkeProtocolException validateAndBuildIkeException() throws InvalidSyntaxException {
        if (!this.isErrorNotify()) {
            throw new IllegalArgumentException("Do not support building IkeException for a non-error notificaton. Notify type: " + this.notifyType);
        }
        try {
            switch (this.notifyType) {
                case 1: {
                    return new UnsupportedCriticalPayloadException(this.notifyData);
                }
                case 4: {
                    return new InvalidIkeSpiException(this.notifyData);
                }
                case 5: {
                    return new InvalidMajorVersionException(this.notifyData);
                }
                case 7: {
                    return new InvalidSyntaxException(this.notifyData);
                }
                case 9: {
                    return new InvalidMessageIdException(this.notifyData);
                }
                case 14: {
                    return new NoValidProposalChosenException(this.notifyData);
                }
                case 17: {
                    return new InvalidKeException(this.notifyData);
                }
                case 24: {
                    return new AuthenticationFailedException(this.notifyData);
                }
                case 34: {
                    return new SinglePairRequiredException(this.notifyData);
                }
                case 35: {
                    return new NoAdditionalSasException(this.notifyData);
                }
                case 36: {
                    return new InternalAddressFailureException(this.notifyData);
                }
                case 37: {
                    return new FailedCpRequiredException(this.notifyData);
                }
                case 38: {
                    return new TsUnacceptableException(this.notifyData);
                }
                case 39: {
                    return new InvalidSelectorsException(this.spi, this.notifyData);
                }
                case 43: {
                    return new TemporaryFailureException(this.notifyData);
                }
                case 44: {
                    return new ChildSaNotFoundException(this.spi, this.notifyData);
                }
            }
            return new UnrecognizedIkeProtocolException(this.notifyType, this.notifyData);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidSyntaxException(e);
        }
    }

    @Override
    public String getTypeString() {
        String notifyTypeString = NOTIFY_TYPE_TO_STRING.get(this.notifyType);
        if (notifyTypeString == null) {
            return "Notify(" + this.notifyType + ")";
        }
        return "Notify(" + notifyTypeString + ")";
    }

    static {
        VALID_NOTIFY_TYPES_FOR_EXISTING_CHILD_SA.add(39);
        VALID_NOTIFY_TYPES_FOR_EXISTING_CHILD_SA.add(44);
        VALID_NOTIFY_TYPES_FOR_EXISTING_CHILD_SA.add(16393);
        VALID_NOTIFY_TYPES_FOR_NEW_CHILD_SA = new ArraySet<Integer>();
        VALID_NOTIFY_TYPES_FOR_NEW_CHILD_SA.add(14);
        VALID_NOTIFY_TYPES_FOR_NEW_CHILD_SA.add(17);
        VALID_NOTIFY_TYPES_FOR_NEW_CHILD_SA.add(34);
        VALID_NOTIFY_TYPES_FOR_NEW_CHILD_SA.add(35);
        VALID_NOTIFY_TYPES_FOR_NEW_CHILD_SA.add(36);
        VALID_NOTIFY_TYPES_FOR_NEW_CHILD_SA.add(37);
        VALID_NOTIFY_TYPES_FOR_NEW_CHILD_SA.add(38);
        VALID_NOTIFY_TYPES_FOR_NEW_CHILD_SA.add(16386);
        VALID_NOTIFY_TYPES_FOR_NEW_CHILD_SA.add(16387);
        VALID_NOTIFY_TYPES_FOR_NEW_CHILD_SA.add(16391);
        VALID_NOTIFY_TYPES_FOR_NEW_CHILD_SA.add(16394);
        NOTIFY_TYPE_TO_STRING = new SparseArray();
        NOTIFY_TYPE_TO_STRING.put(1, "Unsupported critical payload");
        NOTIFY_TYPE_TO_STRING.put(4, "Invalid IKE SPI");
        NOTIFY_TYPE_TO_STRING.put(5, "Invalid major version");
        NOTIFY_TYPE_TO_STRING.put(7, "Invalid syntax");
        NOTIFY_TYPE_TO_STRING.put(9, "Invalid message ID");
        NOTIFY_TYPE_TO_STRING.put(14, "No proposal chosen");
        NOTIFY_TYPE_TO_STRING.put(17, "Invalid KE payload");
        NOTIFY_TYPE_TO_STRING.put(24, "Authentication failed");
        NOTIFY_TYPE_TO_STRING.put(34, "Single pair required");
        NOTIFY_TYPE_TO_STRING.put(35, "No additional SAs");
        NOTIFY_TYPE_TO_STRING.put(36, "Internal address failure");
        NOTIFY_TYPE_TO_STRING.put(37, "Failed CP required");
        NOTIFY_TYPE_TO_STRING.put(38, "TS unacceptable");
        NOTIFY_TYPE_TO_STRING.put(39, "Invalid selectors");
        NOTIFY_TYPE_TO_STRING.put(43, "Temporary failure");
        NOTIFY_TYPE_TO_STRING.put(44, "Child SA not found");
        NOTIFY_TYPE_TO_STRING.put(16386, "Additional TS possible");
        NOTIFY_TYPE_TO_STRING.put(16387, "IPCOMP supported");
        NOTIFY_TYPE_TO_STRING.put(16388, "NAT detection source IP");
        NOTIFY_TYPE_TO_STRING.put(16389, "NAT detection destination IP");
        NOTIFY_TYPE_TO_STRING.put(16390, "COOKIE");
        NOTIFY_TYPE_TO_STRING.put(16391, "Use transport mode");
        NOTIFY_TYPE_TO_STRING.put(16393, "Rekey SA");
        NOTIFY_TYPE_TO_STRING.put(16394, "ESP TFC Padding not supported");
        NOTIFY_TYPE_TO_STRING.put(16396, "MOBIKE supported");
        NOTIFY_TYPE_TO_STRING.put(16400, "UPDATE_SA_ADDRESSES");
        NOTIFY_TYPE_TO_STRING.put(16401, "COOKIE2");
        NOTIFY_TYPE_TO_STRING.put(16430, "Fragmentation supported");
        NOTIFY_TYPE_TO_STRING.put(16431, "Generic Digital Signatures supported");
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NotifyType {
    }
}

