/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.listeners;

import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public interface ListenerTransport<TListener> {
    public TListener getListener();

    public void unregister();

    default public void execute(Executor executor, Consumer<TListener> operation) {
        Objects.requireNonNull(operation);
        if (this.getListener() == null) {
            return;
        }
        executor.execute(() -> {
            TListener listener = this.getListener();
            if (listener == null) {
                return;
            }
            operation.accept(listener);
        });
    }
}

