/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.infra;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Log;
import android.util.Slog;
import com.android.internal.infra.AndroidFuture;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;

public interface ServiceConnector<I extends IInterface> {
    public boolean run(VoidJob<I> var1);

    public AndroidFuture<Void> post(VoidJob<I> var1);

    public <R> AndroidFuture<R> postForResult(Job<I, R> var1);

    public <R> AndroidFuture<R> postAsync(Job<I, CompletableFuture<R>> var1);

    public AndroidFuture<I> connect();

    public void unbind();

    public void setServiceLifecycleCallbacks(ServiceLifecycleCallbacks<I> var1);

    public static class NoOp<T extends IInterface>
    extends AndroidFuture<Object>
    implements ServiceConnector<T> {
        public NoOp() {
            this.completeExceptionally(new IllegalStateException("ServiceConnector is a no-op"));
        }

        @Override
        public boolean run(VoidJob<T> job) {
            return false;
        }

        @Override
        public AndroidFuture<Void> post(VoidJob<T> job) {
            return this;
        }

        @Override
        public <R> AndroidFuture<R> postForResult(Job<T, R> job) {
            return this;
        }

        @Override
        public <R> AndroidFuture<R> postAsync(Job<T, CompletableFuture<R>> job) {
            return this;
        }

        @Override
        public AndroidFuture<T> connect() {
            return this;
        }

        @Override
        public void unbind() {
        }

        @Override
        public void setServiceLifecycleCallbacks(ServiceLifecycleCallbacks<T> callbacks) {
        }
    }

    public static class Impl<I extends IInterface>
    extends ArrayDeque<Job<I, ?>>
    implements ServiceConnector<I>,
    ServiceConnection,
    IBinder.DeathRecipient,
    Runnable {
        static final boolean DEBUG = false;
        static final String LOG_TAG = "ServiceConnector.Impl";
        private static final long DEFAULT_DISCONNECT_TIMEOUT_MS = 15000L;
        private static final long DEFAULT_REQUEST_TIMEOUT_MS = 30000L;
        private final Queue<Job<I, ?>> mQueue = this;
        private final List<CompletionAwareJob<I, ?>> mUnfinishedJobs = new ArrayList();
        private final Handler mMainHandler = new Handler(Looper.getMainLooper());
        private final ServiceConnection mServiceConnection = this;
        private final Runnable mTimeoutDisconnect = this;
        protected final Context mContext;
        private final Intent mIntent;
        private final int mBindingFlags;
        private final Function<IBinder, I> mBinderAsInterface;
        private final Handler mHandler;
        protected final Executor mExecutor;
        private volatile ServiceLifecycleCallbacks<I> mServiceLifecycleCallbacks = null;
        private volatile I mService = null;
        private boolean mBinding = false;
        private boolean mUnbinding = false;
        private CompletionAwareJob<I, I> mServiceConnectionFutureCache = null;

        public Impl(Context context, Intent intent, int bindingFlags, int userId, Function<IBinder, I> binderAsInterface) {
            this.mContext = context.createContextAsUser(UserHandle.of(userId), 0);
            this.mIntent = intent;
            this.mBindingFlags = bindingFlags;
            this.mBinderAsInterface = binderAsInterface;
            this.mHandler = this.getJobHandler();
            this.mExecutor = new HandlerExecutor(this.mHandler);
        }

        protected Handler getJobHandler() {
            return this.mMainHandler;
        }

        protected long getAutoDisconnectTimeoutMs() {
            return 15000L;
        }

        protected long getRequestTimeoutMs() {
            return 30000L;
        }

        protected boolean bindService(ServiceConnection serviceConnection) {
            return this.mContext.bindService(this.mIntent, 1 | this.mBindingFlags, this.mExecutor, serviceConnection);
        }

        protected I binderAsInterface(IBinder service) {
            return (I)((IInterface)this.mBinderAsInterface.apply(service));
        }

        protected void onServiceUnbound() {
        }

        private void dispatchOnServiceConnectionStatusChanged(I service, boolean isConnected) {
            ServiceLifecycleCallbacks<I> serviceLifecycleCallbacks = this.mServiceLifecycleCallbacks;
            if (serviceLifecycleCallbacks != null) {
                if (isConnected) {
                    serviceLifecycleCallbacks.onConnected(service);
                } else {
                    serviceLifecycleCallbacks.onDisconnected(service);
                }
            }
            this.onServiceConnectionStatusChanged(service, isConnected);
        }

        protected void onServiceConnectionStatusChanged(I service, boolean isConnected) {
        }

        @Override
        public boolean run(VoidJob<I> job) {
            return this.enqueue(job);
        }

        @Override
        public AndroidFuture<Void> post(VoidJob<I> job) {
            return this.postForResult(job);
        }

        public <R> CompletionAwareJob<I, R> postForResult(Job<I, R> job) {
            CompletionAwareJob task = new CompletionAwareJob();
            task.mDelegate = Objects.requireNonNull(job);
            this.enqueue(task);
            return task;
        }

        @Override
        public <R> AndroidFuture<R> postAsync(Job<I, CompletableFuture<R>> job) {
            CompletionAwareJob task = new CompletionAwareJob();
            task.mDelegate = Objects.requireNonNull(job);
            task.mAsync = true;
            this.enqueue(task);
            return task;
        }

        @Override
        public synchronized AndroidFuture<I> connect() {
            if (this.mServiceConnectionFutureCache == null) {
                this.mServiceConnectionFutureCache = new CompletionAwareJob();
                this.mServiceConnectionFutureCache.mDelegate = s -> s;
                I service = this.mService;
                if (service != null) {
                    this.mServiceConnectionFutureCache.complete(service);
                } else {
                    this.enqueue(this.mServiceConnectionFutureCache);
                }
            }
            return this.mServiceConnectionFutureCache;
        }

        private void enqueue(CompletionAwareJob<I, ?> task) {
            if (!this.enqueue((Job<I, ?>)task)) {
                task.completeExceptionally(new IllegalStateException("Failed to post a job to handler. Likely " + this.mHandler.getLooper() + " is exiting"));
            }
        }

        private boolean enqueue(Job<I, ?> job) {
            this.cancelTimeout();
            return this.mHandler.post(() -> this.enqueueJobThread(job));
        }

        void enqueueJobThread(Job<I, ?> job) {
            this.cancelTimeout();
            if (this.mUnbinding) {
                this.completeExceptionally(job, new IllegalStateException("Service is unbinding. Ignoring " + job));
            } else if (!this.mQueue.offer(job)) {
                this.completeExceptionally(job, new IllegalStateException("Failed to add to queue: " + job));
            } else if (this.isBound()) {
                this.processQueue();
            } else if (!this.mBinding) {
                if (this.bindService(this.mServiceConnection)) {
                    this.mBinding = true;
                } else {
                    this.completeExceptionally(job, new IllegalStateException("Failed to bind to service " + this.mIntent));
                }
            }
        }

        private void cancelTimeout() {
            this.mMainHandler.removeCallbacks(this.mTimeoutDisconnect);
        }

        void completeExceptionally(Job<?, ?> job, Throwable ex) {
            CompletionAwareJob task = Impl.castOrNull(job, CompletionAwareJob.class);
            boolean taskChanged = false;
            if (task != null) {
                taskChanged = task.completeExceptionally(ex);
            }
            if (task == null) {
                Log.e(LOG_TAG, "Job failed: " + job, ex);
            }
        }

        static <BASE, T extends BASE> T castOrNull(BASE instance, Class<T> cls) {
            return (T)(cls.isInstance(instance) ? instance : null);
        }

        private void processQueue() {
            Job<I, ?> job;
            while ((job = this.mQueue.poll()) != null) {
                CompletionAwareJob task = Impl.castOrNull(job, CompletionAwareJob.class);
                try {
                    I service = this.mService;
                    if (service == null) {
                        return;
                    }
                    Object result = job.run(service);
                    if (task == null) continue;
                    if (task.mAsync) {
                        this.mUnfinishedJobs.add(task);
                        ((CompletionStage)result).whenComplete(task);
                        continue;
                    }
                    task.complete(result);
                }
                catch (Throwable e) {
                    this.completeExceptionally(job, e);
                }
            }
            this.maybeScheduleUnbindTimeout();
        }

        private void maybeScheduleUnbindTimeout() {
            if (this.mUnfinishedJobs.isEmpty() && this.mQueue.isEmpty()) {
                this.scheduleUnbindTimeout();
            }
        }

        private void scheduleUnbindTimeout() {
            long timeout = this.getAutoDisconnectTimeoutMs();
            if (timeout > 0L) {
                this.mMainHandler.postDelayed(this.mTimeoutDisconnect, timeout);
            }
        }

        private boolean isBound() {
            return this.mService != null;
        }

        @Override
        public void unbind() {
            this.mUnbinding = true;
            this.mHandler.post(this::unbindJobThread);
        }

        @Override
        public void setServiceLifecycleCallbacks(ServiceLifecycleCallbacks<I> callbacks) {
            this.mServiceLifecycleCallbacks = callbacks;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unbindJobThread() {
            boolean wasBound;
            this.cancelTimeout();
            I service = this.mService;
            boolean bl = wasBound = service != null;
            if (wasBound || this.mBinding) {
                try {
                    this.mContext.unbindService(this.mServiceConnection);
                }
                catch (IllegalArgumentException e) {
                    Slog.e(LOG_TAG, "Failed to unbind: " + e);
                }
            }
            if (wasBound) {
                this.dispatchOnServiceConnectionStatusChanged(service, false);
                service.asBinder().unlinkToDeath(this, 0);
                this.mService = null;
            }
            this.mBinding = false;
            this.mUnbinding = false;
            Impl impl = this;
            synchronized (impl) {
                if (this.mServiceConnectionFutureCache != null) {
                    this.mServiceConnectionFutureCache.cancel(true);
                    this.mServiceConnectionFutureCache = null;
                }
            }
            this.cancelPendingJobs();
            if (wasBound) {
                this.onServiceUnbound();
            }
        }

        protected void cancelPendingJobs() {
            Job<I, ?> job;
            while ((job = this.mQueue.poll()) != null) {
                CompletionAwareJob task = Impl.castOrNull(job, CompletionAwareJob.class);
                if (task == null) continue;
                task.cancel(false);
            }
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder binder) {
            if (this.mUnbinding) {
                Log.i(LOG_TAG, "Ignoring onServiceConnected due to ongoing unbinding: " + this);
                return;
            }
            I service = this.binderAsInterface(binder);
            this.mService = service;
            this.mBinding = false;
            try {
                binder.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                Log.e(LOG_TAG, "onServiceConnected " + name + ": ", e);
            }
            this.dispatchOnServiceConnectionStatusChanged(service, true);
            this.processQueue();
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            this.mBinding = true;
            I service = this.mService;
            if (service != null) {
                this.dispatchOnServiceConnectionStatusChanged(service, false);
                this.mService = null;
            }
        }

        @Override
        public void onBindingDied(ComponentName name) {
            this.binderDied();
        }

        @Override
        public void binderDied() {
            this.mService = null;
            this.unbind();
            this.dispatchOnBinderDied();
        }

        private void dispatchOnBinderDied() {
            ServiceLifecycleCallbacks<I> serviceLifecycleCallbacks = this.mServiceLifecycleCallbacks;
            if (serviceLifecycleCallbacks != null) {
                serviceLifecycleCallbacks.onBinderDied();
            }
        }

        @Override
        public void run() {
            this.onTimeout();
        }

        private void onTimeout() {
            this.unbind();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("ServiceConnector@").append(System.identityHashCode(this) % 1000).append("(").append(this.mIntent).append(", user: ").append(this.mContext.getUser().getIdentifier()).append(")[").append(this.stateToString());
            if (!this.mQueue.isEmpty()) {
                sb.append(", ").append(this.mQueue.size()).append(" pending job(s)");
            }
            if (!this.mUnfinishedJobs.isEmpty()) {
                sb.append(", ").append(this.mUnfinishedJobs.size()).append(" unfinished async job(s)");
            }
            return sb.append("]").toString();
        }

        public void dump(String prefix, PrintWriter pw) {
            String tab = "  ";
            pw.append(prefix).append("ServiceConnector:").println();
            pw.append(prefix).append(tab).append(String.valueOf(this.mIntent)).println();
            pw.append(prefix).append(tab).append("userId: ").append(String.valueOf(this.mContext.getUser().getIdentifier())).println();
            pw.append(prefix).append(tab).append("State: ").append(this.stateToString()).println();
            pw.append(prefix).append(tab).append("Pending jobs: ").append(String.valueOf(this.mQueue.size())).println();
            pw.append(prefix).append(tab).append("Unfinished async jobs: ").append(String.valueOf(this.mUnfinishedJobs.size())).println();
        }

        private String stateToString() {
            if (this.mBinding) {
                return "Binding...";
            }
            if (this.mUnbinding) {
                return "Unbinding...";
            }
            if (this.isBound()) {
                return "Bound";
            }
            return "Unbound";
        }

        private void logTrace() {
            Log.i(LOG_TAG, "See stacktrace", new Throwable());
        }

        class CompletionAwareJob<II, R>
        extends AndroidFuture<R>
        implements Job<II, R>,
        BiConsumer<R, Throwable> {
            Job<II, R> mDelegate;
            boolean mAsync = false;
            private String mDebugName;

            CompletionAwareJob() {
                long requestTimeout = Impl.this.getRequestTimeoutMs();
                if (requestTimeout > 0L) {
                    this.orTimeout(requestTimeout, TimeUnit.MILLISECONDS);
                }
            }

            @Override
            public R run(II service) throws Exception {
                return this.mDelegate.run(service);
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                if (mayInterruptIfRunning) {
                    Log.w(Impl.LOG_TAG, "mayInterruptIfRunning not supported - ignoring");
                }
                boolean wasRemoved = Impl.this.mQueue.remove(this);
                return super.cancel(mayInterruptIfRunning) || wasRemoved;
            }

            @Override
            public String toString() {
                return this.mDelegate + " wrapped into " + super.toString();
            }

            @Override
            public void accept(R res, Throwable err) {
                if (err != null) {
                    this.completeExceptionally(err);
                } else {
                    this.complete(res);
                }
            }

            @Override
            protected void onCompleted(R res, Throwable err) {
                super.onCompleted(res, err);
                if (Impl.this.mUnfinishedJobs.remove(this)) {
                    Impl.this.maybeScheduleUnbindTimeout();
                }
            }

            private static /* synthetic */ boolean lambda$new$0(StackTraceElement st) {
                return !st.getClassName().contains(ServiceConnector.class.getName());
            }
        }
    }

    public static interface ServiceLifecycleCallbacks<II extends IInterface> {
        default public void onConnected(II service) {
        }

        default public void onDisconnected(II service) {
        }

        default public void onBinderDied() {
        }
    }

    @FunctionalInterface
    public static interface VoidJob<II>
    extends Job<II, Void> {
        public void runNoResult(II var1) throws Exception;

        @Override
        default public Void run(II service) throws Exception {
            this.runNoResult(service);
            return null;
        }
    }

    @FunctionalInterface
    public static interface Job<II, R> {
        public R run(II var1) throws Exception;
    }
}

