/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.infra;

import android.os.AsyncTask;
import android.os.ParcelFileDescriptor;
import com.android.internal.infra.AndroidFuture;
import com.android.internal.util.FunctionalUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import libcore.io.IoUtils;

public abstract class RemoteStream<RES, IOSTREAM extends Closeable>
extends AndroidFuture<RES>
implements Runnable {
    private final FunctionalUtils.ThrowingFunction<IOSTREAM, RES> mHandleStream;
    private volatile ParcelFileDescriptor mLocalPipe;

    public static <R> AndroidFuture<R> receiveBytes(FunctionalUtils.ThrowingConsumer<ParcelFileDescriptor> ipc, FunctionalUtils.ThrowingFunction<InputStream, R> read) {
        return new RemoteStream<R, InputStream>((FunctionalUtils.ThrowingConsumer)ipc, read, AsyncTask.THREAD_POOL_EXECUTOR, true){

            @Override
            protected InputStream createStream(ParcelFileDescriptor fd) {
                return new ParcelFileDescriptor.AutoCloseInputStream(fd);
            }
        };
    }

    public static AndroidFuture<byte[]> receiveBytes(FunctionalUtils.ThrowingConsumer<ParcelFileDescriptor> ipc) {
        return RemoteStream.receiveBytes(ipc, RemoteStream::readAll);
    }

    public static byte[] readAll(InputStream inputStream) throws IOException {
        int numRead;
        ByteArrayOutputStream combinedBuffer = new ByteArrayOutputStream();
        byte[] buffer = new byte[16384];
        while ((numRead = inputStream.read(buffer)) != -1) {
            combinedBuffer.write(buffer, 0, numRead);
        }
        return combinedBuffer.toByteArray();
    }

    public static <R> AndroidFuture<R> sendBytes(FunctionalUtils.ThrowingConsumer<ParcelFileDescriptor> ipc, FunctionalUtils.ThrowingFunction<OutputStream, R> write) {
        return new RemoteStream<R, OutputStream>((FunctionalUtils.ThrowingConsumer)ipc, write, AsyncTask.THREAD_POOL_EXECUTOR, false){

            @Override
            protected OutputStream createStream(ParcelFileDescriptor fd) {
                return new ParcelFileDescriptor.AutoCloseOutputStream(fd);
            }
        };
    }

    public static AndroidFuture<Void> sendBytes(FunctionalUtils.ThrowingConsumer<ParcelFileDescriptor> ipc, FunctionalUtils.ThrowingConsumer<OutputStream> write) {
        return RemoteStream.sendBytes(ipc, (OutputStream os) -> {
            write.acceptOrThrow((OutputStream)os);
            return null;
        });
    }

    public static AndroidFuture<Void> sendBytes(FunctionalUtils.ThrowingConsumer<ParcelFileDescriptor> ipc, byte[] data) {
        return RemoteStream.sendBytes(ipc, (OutputStream os) -> {
            os.write(data);
            return null;
        });
    }

    private RemoteStream(FunctionalUtils.ThrowingConsumer<ParcelFileDescriptor> ipc, FunctionalUtils.ThrowingFunction<IOSTREAM, RES> handleStream, Executor backgroundExecutor, boolean read) {
        this.mHandleStream = handleStream;
        try {
            ParcelFileDescriptor[] pipe = ParcelFileDescriptor.createPipe();
            try (ParcelFileDescriptor remotePipe = pipe[read ? 1 : 0];){
                ipc.acceptOrThrow(remotePipe);
            }
            this.mLocalPipe = pipe[read ? 0 : 1];
            backgroundExecutor.execute(this);
            this.orTimeout(30L, TimeUnit.SECONDS);
        }
        catch (Throwable e) {
            this.completeExceptionally(e);
        }
    }

    protected abstract IOSTREAM createStream(ParcelFileDescriptor var1);

    @Override
    public void run() {
        try (IOSTREAM stream = this.createStream(this.mLocalPipe);){
            this.complete(this.mHandleStream.applyOrThrow(stream));
        }
        catch (Throwable t) {
            this.completeExceptionally(t);
        }
    }

    @Override
    protected void onCompleted(RES res, Throwable err) {
        super.onCompleted(res, err);
        IoUtils.closeQuietly(this.mLocalPipe);
    }
}

