/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.graphics.palette;

import com.android.internal.graphics.ColorUtils;
import com.android.internal.graphics.palette.Palette;
import com.android.internal.graphics.palette.Quantizer;
import com.android.internal.ml.clustering.KMeans;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class VariationalKMeansQuantizer
implements Quantizer {
    private static final String TAG = "KMeansQuantizer";
    private static final boolean DEBUG = false;
    private final float mMinClusterSqDistance;
    private final int mInitializations;
    private final KMeans mKMeans = new KMeans(new Random(0L), 30, 0.0f);
    private List<Palette.Swatch> mQuantizedColors;

    public VariationalKMeansQuantizer() {
        this(0.25f);
    }

    public VariationalKMeansQuantizer(float minClusterDistance) {
        this(minClusterDistance, 1);
    }

    public VariationalKMeansQuantizer(float minClusterDistance, int initializations) {
        this.mMinClusterSqDistance = minClusterDistance * minClusterDistance;
        this.mInitializations = initializations;
    }

    @Override
    public void quantize(int[] pixels, int maxColors) {
        float[] hsl = new float[]{0.0f, 0.0f, 0.0f};
        float[][] hslPixels = new float[pixels.length][3];
        for (int i = 0; i < pixels.length; ++i) {
            ColorUtils.colorToHSL(pixels[i], hsl);
            hslPixels[i][0] = hsl[0] / 360.0f;
            hslPixels[i][1] = hsl[1];
            hslPixels[i][2] = hsl[2];
        }
        List<KMeans.Mean> optimalMeans = this.getOptimalKMeans(maxColors, hslPixels);
        for (int i = 0; i < optimalMeans.size(); ++i) {
            KMeans.Mean current = optimalMeans.get(i);
            float[] currentCentroid = current.getCentroid();
            for (int j = i + 1; j < optimalMeans.size(); ++j) {
                KMeans.Mean compareTo = optimalMeans.get(j);
                float[] compareToCentroid = compareTo.getCentroid();
                float sqDistance = KMeans.sqDistance(currentCentroid, compareToCentroid);
                if (!(sqDistance < this.mMinClusterSqDistance)) continue;
                optimalMeans.remove(compareTo);
                current.getItems().addAll(compareTo.getItems());
                for (int k = 0; k < currentCentroid.length; ++k) {
                    int n = k;
                    currentCentroid[n] = (float)((double)currentCentroid[n] + (double)(compareToCentroid[k] - currentCentroid[k]) / 2.0);
                }
                --j;
            }
        }
        this.mQuantizedColors = new ArrayList<Palette.Swatch>();
        float[] mHsl = new float[3];
        for (KMeans.Mean mean : optimalMeans) {
            if (mean.getItems().size() == 0) continue;
            float[] centroid = mean.getCentroid();
            mHsl[0] = centroid[0] * 360.0f;
            mHsl[1] = centroid[1];
            mHsl[2] = centroid[2];
            int color2 = ColorUtils.HSLToColor(mHsl);
            this.mQuantizedColors.add(new Palette.Swatch(color2, mean.getItems().size()));
        }
    }

    private List<KMeans.Mean> getOptimalKMeans(int k, float[][] inputData) {
        List<KMeans.Mean> optimal = null;
        double optimalScore = -1.7976931348623157E308;
        for (int runs = this.mInitializations; runs > 0; --runs) {
            List<KMeans.Mean> means = this.mKMeans.predict(k, inputData);
            double score = KMeans.score(means);
            if (optimal != null && !(score > optimalScore)) continue;
            optimalScore = score;
            optimal = means;
        }
        return optimal;
    }

    @Override
    public List<Palette.Swatch> getQuantizedColors() {
        return this.mQuantizedColors;
    }
}

