/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.graphics.palette;

import android.graphics.Color;
import android.graphics.ColorSpace;
import com.android.internal.graphics.palette.PointProvider;

public class LABPointProvider
implements PointProvider {
    final ColorSpace.Connector mRgbToLab = ColorSpace.connect(ColorSpace.get(ColorSpace.Named.SRGB), ColorSpace.get(ColorSpace.Named.CIE_LAB));
    final ColorSpace.Connector mLabToRgb = ColorSpace.connect(ColorSpace.get(ColorSpace.Named.CIE_LAB), ColorSpace.get(ColorSpace.Named.SRGB));

    @Override
    public float[] fromInt(int color2) {
        float r = (float)Color.red(color2) / 255.0f;
        float g = (float)Color.green(color2) / 255.0f;
        float b = (float)Color.blue(color2) / 255.0f;
        float[] transform = this.mRgbToLab.transform(r, g, b);
        return transform;
    }

    @Override
    public int toInt(float[] centroid) {
        float[] rgb = this.mLabToRgb.transform(centroid);
        int color2 = Color.rgb(rgb[0], rgb[1], rgb[2]);
        return color2;
    }

    @Override
    public float distance(float[] a, float[] b) {
        double dL = a[0] - b[0];
        double dA = a[1] - b[1];
        double dB = a[2] - b[2];
        return (float)(dL * dL + dA * dA + dB * dB);
    }
}

