/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.graphics.cam;

import android.graphics.Color;
import com.android.internal.graphics.ColorUtils;

public class CamUtils {
    static final float[][] XYZ_TO_CAM16RGB = new float[][]{{0.401288f, 0.650173f, -0.051461f}, {-0.250268f, 1.204414f, 0.045854f}, {-0.002079f, 0.048952f, 0.953127f}};
    static final float[][] CAM16RGB_TO_XYZ = new float[][]{{1.8620678f, -1.0112547f, 0.14918678f}, {0.38752654f, 0.62144744f, -0.00897398f}, {-0.0158415f, -0.03412294f, 1.0499644f}};
    static final float[] WHITE_POINT_D65 = new float[]{95.047f, 100.0f, 108.883f};
    static final double[][] SRGB_TO_XYZ = new double[][]{{0.41233895, 0.35762064, 0.18051042}, {0.2126, 0.7152, 0.0722}, {0.01932141, 0.11916382, 0.95034478}};
    static final double[][] XYZ_TO_SRGB = new double[][]{{3.2413774792388685, -1.5376652402851851, -0.49885366846268053}, {-0.9691452513005321, 1.8758853451067872, 0.04156585616912061}, {0.05562093689691305, -0.20395524564742123, 1.0571799111220335}};

    private CamUtils() {
    }

    public static int signum(double num) {
        if (num < 0.0) {
            return -1;
        }
        if (num == 0.0) {
            return 0;
        }
        return 1;
    }

    public static int argbFromLstar(double lstar) {
        double fy;
        double fz = fy = (lstar + 16.0) / 116.0;
        double fx = fy;
        double kappa = 903.2962962962963;
        double epsilon = 0.008856451679035631;
        boolean lExceedsEpsilonKappa = lstar > 8.0;
        double y = lExceedsEpsilonKappa ? fy * fy * fy : lstar / kappa;
        boolean cubeExceedEpsilon = fy * fy * fy > epsilon;
        double x = cubeExceedEpsilon ? fx * fx * fx : lstar / kappa;
        double z = cubeExceedEpsilon ? fz * fz * fz : lstar / kappa;
        float[] whitePoint = WHITE_POINT_D65;
        return CamUtils.argbFromXyz(x * (double)whitePoint[0], y * (double)whitePoint[1], z * (double)whitePoint[2]);
    }

    public static int argbFromXyz(double x, double y, double z) {
        double[][] matrix = XYZ_TO_SRGB;
        double linearR = matrix[0][0] * x + matrix[0][1] * y + matrix[0][2] * z;
        double linearG = matrix[1][0] * x + matrix[1][1] * y + matrix[1][2] * z;
        double linearB = matrix[2][0] * x + matrix[2][1] * y + matrix[2][2] * z;
        int r = CamUtils.delinearized(linearR);
        int g = CamUtils.delinearized(linearG);
        int b = CamUtils.delinearized(linearB);
        return CamUtils.argbFromRgb(r, g, b);
    }

    public static int argbFromLinrgb(double[] linrgb) {
        int r = CamUtils.delinearized(linrgb[0]);
        int g = CamUtils.delinearized(linrgb[1]);
        int b = CamUtils.delinearized(linrgb[2]);
        return CamUtils.argbFromRgb(r, g, b);
    }

    public static int argbFromLinrgbComponents(double r, double g, double b) {
        return CamUtils.argbFromRgb(CamUtils.delinearized(r), CamUtils.delinearized(g), CamUtils.delinearized(b));
    }

    public static int delinearized(double rgbComponent) {
        double normalized = rgbComponent / 100.0;
        double delinearized = 0.0;
        delinearized = normalized <= 0.0031308 ? normalized * 12.92 : 1.055 * Math.pow(normalized, 0.4166666666666667) - 0.055;
        return CamUtils.clampInt(0, 255, (int)Math.round(delinearized * 255.0));
    }

    public static int clampInt(int min, int max, int input) {
        if (input < min) {
            return min;
        }
        if (input > max) {
            return max;
        }
        return input;
    }

    public static int argbFromRgb(int red, int green, int blue) {
        return 0xFF000000 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    static int intFromLstar(float lstar) {
        float fy;
        if (lstar < 1.0f) {
            return -16777216;
        }
        if (lstar > 99.0f) {
            return -1;
        }
        float fz = fy = (lstar + 16.0f) / 116.0f;
        float fx = fy;
        float kappa = 903.2963f;
        float epsilon = 0.008856452f;
        boolean lExceedsEpsilonKappa = lstar > 8.0f;
        float yT = lExceedsEpsilonKappa ? fy * fy * fy : lstar / kappa;
        boolean cubeExceedEpsilon = fy * fy * fy > epsilon;
        float xT = cubeExceedEpsilon ? fx * fx * fx : (116.0f * fx - 16.0f) / kappa;
        float zT = cubeExceedEpsilon ? fz * fz * fz : (116.0f * fx - 16.0f) / kappa;
        return ColorUtils.XYZToColor(xT * WHITE_POINT_D65[0], yT * WHITE_POINT_D65[1], zT * WHITE_POINT_D65[2]);
    }

    public static float lstarFromInt(int argb) {
        return CamUtils.lstarFromY(CamUtils.yFromInt(argb));
    }

    static float lstarFromY(float y) {
        y /= 100.0f;
        float e = 0.008856452f;
        if (y <= 0.008856452f) {
            return 903.2963f * y;
        }
        float yIntermediate = (float)Math.cbrt(y);
        return 116.0f * yIntermediate - 16.0f;
    }

    static float yFromInt(int argb) {
        float r = CamUtils.linearized(Color.red(argb));
        float g = CamUtils.linearized(Color.green(argb));
        float b = CamUtils.linearized(Color.blue(argb));
        double[][] matrix = SRGB_TO_XYZ;
        double y = (double)r * matrix[1][0] + (double)g * matrix[1][1] + (double)b * matrix[1][2];
        return (float)y;
    }

    static float[] xyzFromInt(int argb) {
        float r = CamUtils.linearized(Color.red(argb));
        float g = CamUtils.linearized(Color.green(argb));
        float b = CamUtils.linearized(Color.blue(argb));
        double[][] matrix = SRGB_TO_XYZ;
        double x = (double)r * matrix[0][0] + (double)g * matrix[0][1] + (double)b * matrix[0][2];
        double y = (double)r * matrix[1][0] + (double)g * matrix[1][1] + (double)b * matrix[1][2];
        double z = (double)r * matrix[2][0] + (double)g * matrix[2][1] + (double)b * matrix[2][2];
        return new float[]{(float)x, (float)y, (float)z};
    }

    public static double yFromLstar(double lstar) {
        double ke = 8.0;
        if (lstar > ke) {
            return Math.pow((lstar + 16.0) / 116.0, 3.0) * 100.0;
        }
        return lstar / 903.2962962962963 * 100.0;
    }

    static float linearized(int rgbComponent) {
        float normalized = (float)rgbComponent / 255.0f;
        if (normalized <= 0.04045f) {
            return normalized / 12.92f * 100.0f;
        }
        return (float)Math.pow((normalized + 0.055f) / 1.055f, 2.4f) * 100.0f;
    }
}

