/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.admin.DevicePolicyManager;
import android.content.Context;
import android.os.UserHandle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.AbstractMultiProfilePagerAdapter;
import com.android.internal.app.ChooserActivity;
import com.android.internal.app.ChooserListAdapter;
import com.android.internal.app.ChooserRecyclerViewAccessibilityDelegate;
import com.android.internal.app.ResolverListAdapter;
import com.android.internal.widget.GridLayoutManager;
import com.android.internal.widget.RecyclerView;

@VisibleForTesting
public class ChooserMultiProfilePagerAdapter
extends AbstractMultiProfilePagerAdapter {
    private static final int SINGLE_CELL_SPAN_SIZE = 1;
    private final ChooserProfileDescriptor[] mItems;
    private final boolean mIsSendAction;
    private int mBottomOffset;
    private int mMaxTargetsPerRow;

    ChooserMultiProfilePagerAdapter(Context context, ChooserActivity.ChooserGridAdapter adapter, UserHandle personalProfileUserHandle, UserHandle workProfileUserHandle, boolean isSendAction, int maxTargetsPerRow) {
        super(context, 0, personalProfileUserHandle, workProfileUserHandle);
        this.mItems = new ChooserProfileDescriptor[]{this.createProfileDescriptor(adapter)};
        this.mIsSendAction = isSendAction;
        this.mMaxTargetsPerRow = maxTargetsPerRow;
    }

    ChooserMultiProfilePagerAdapter(Context context, ChooserActivity.ChooserGridAdapter personalAdapter, ChooserActivity.ChooserGridAdapter workAdapter, @AbstractMultiProfilePagerAdapter.Profile int defaultProfile, UserHandle personalProfileUserHandle, UserHandle workProfileUserHandle, boolean isSendAction, int maxTargetsPerRow) {
        super(context, defaultProfile, personalProfileUserHandle, workProfileUserHandle);
        this.mItems = new ChooserProfileDescriptor[]{this.createProfileDescriptor(personalAdapter), this.createProfileDescriptor(workAdapter)};
        this.mIsSendAction = isSendAction;
        this.mMaxTargetsPerRow = maxTargetsPerRow;
    }

    private ChooserProfileDescriptor createProfileDescriptor(ChooserActivity.ChooserGridAdapter adapter) {
        LayoutInflater inflater = LayoutInflater.from(this.getContext());
        ViewGroup rootView = (ViewGroup)inflater.inflate(17367137, null, false);
        ChooserProfileDescriptor profileDescriptor = new ChooserProfileDescriptor(rootView, adapter);
        profileDescriptor.recyclerView.setAccessibilityDelegateCompat(new ChooserRecyclerViewAccessibilityDelegate(profileDescriptor.recyclerView));
        return profileDescriptor;
    }

    RecyclerView getListViewForIndex(int index) {
        return this.getItem((int)index).recyclerView;
    }

    @Override
    ChooserProfileDescriptor getItem(int pageIndex) {
        return this.mItems[pageIndex];
    }

    @Override
    int getItemCount() {
        return this.mItems.length;
    }

    @Override
    @VisibleForTesting
    public ChooserActivity.ChooserGridAdapter getAdapterForIndex(int pageIndex) {
        return this.mItems[pageIndex].chooserGridAdapter;
    }

    @Override
    ChooserListAdapter getListAdapterForUserHandle(UserHandle userHandle) {
        if (this.getActiveListAdapter().getUserHandle().equals(userHandle)) {
            return this.getActiveListAdapter();
        }
        if (this.getInactiveListAdapter() != null && this.getInactiveListAdapter().getUserHandle().equals(userHandle)) {
            return this.getInactiveListAdapter();
        }
        return null;
    }

    @Override
    void setupListAdapter(int pageIndex) {
        RecyclerView recyclerView = this.getItem((int)pageIndex).recyclerView;
        final ChooserActivity.ChooserGridAdapter chooserGridAdapter = this.getItem((int)pageIndex).chooserGridAdapter;
        final GridLayoutManager glm = (GridLayoutManager)recyclerView.getLayoutManager();
        glm.setSpanCount(this.mMaxTargetsPerRow);
        glm.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

            @Override
            public int getSpanSize(int position) {
                return chooserGridAdapter.shouldCellSpan(position) ? 1 : glm.getSpanCount();
            }
        });
    }

    @Override
    @VisibleForTesting
    public ChooserListAdapter getActiveListAdapter() {
        return this.getAdapterForIndex(this.getCurrentPage()).getListAdapter();
    }

    @Override
    @VisibleForTesting
    public ChooserListAdapter getInactiveListAdapter() {
        if (this.getCount() == 1) {
            return null;
        }
        return this.getAdapterForIndex(1 - this.getCurrentPage()).getListAdapter();
    }

    @Override
    public ResolverListAdapter getPersonalListAdapter() {
        return this.getAdapterForIndex(0).getListAdapter();
    }

    @Override
    public ResolverListAdapter getWorkListAdapter() {
        return this.getAdapterForIndex(1).getListAdapter();
    }

    @Override
    ChooserActivity.ChooserGridAdapter getCurrentRootAdapter() {
        return this.getAdapterForIndex(this.getCurrentPage());
    }

    @Override
    RecyclerView getActiveAdapterView() {
        return this.getListViewForIndex(this.getCurrentPage());
    }

    @Override
    RecyclerView getInactiveAdapterView() {
        if (this.getCount() == 1) {
            return null;
        }
        return this.getListViewForIndex(1 - this.getCurrentPage());
    }

    @Override
    String getMetricsCategory() {
        return "intent_chooser";
    }

    @Override
    protected void showWorkProfileOffEmptyState(ResolverListAdapter activeListAdapter, View.OnClickListener listener) {
        this.showEmptyState(activeListAdapter, this.getWorkAppPausedTitle(), null, listener);
    }

    @Override
    protected void showNoPersonalToWorkIntentsEmptyState(ResolverListAdapter activeListAdapter) {
        if (this.mIsSendAction) {
            this.showEmptyState(activeListAdapter, this.getCrossProfileBlockedTitle(), this.getCantShareWithWorkMessage());
        } else {
            this.showEmptyState(activeListAdapter, this.getCrossProfileBlockedTitle(), this.getCantAccessWorkMessage());
        }
    }

    @Override
    protected void showNoWorkToPersonalIntentsEmptyState(ResolverListAdapter activeListAdapter) {
        if (this.mIsSendAction) {
            this.showEmptyState(activeListAdapter, this.getCrossProfileBlockedTitle(), this.getCantShareWithPersonalMessage());
        } else {
            this.showEmptyState(activeListAdapter, this.getCrossProfileBlockedTitle(), this.getCantAccessPersonalMessage());
        }
    }

    @Override
    protected void showNoPersonalAppsAvailableEmptyState(ResolverListAdapter listAdapter) {
        this.showEmptyState(listAdapter, this.getNoPersonalAppsAvailableMessage(), null);
    }

    @Override
    protected void showNoWorkAppsAvailableEmptyState(ResolverListAdapter listAdapter) {
        this.showEmptyState(listAdapter, this.getNoWorkAppsAvailableMessage(), null);
    }

    private String getWorkAppPausedTitle() {
        return this.getContext().getSystemService(DevicePolicyManager.class).getResources().getString("Core.RESOLVER_WORK_PAUSED_TITLE", () -> this.getContext().getString(17041402));
    }

    private String getCrossProfileBlockedTitle() {
        return this.getContext().getSystemService(DevicePolicyManager.class).getResources().getString("Core.RESOLVER_CROSS_PROFILE_BLOCKED_TITLE", () -> this.getContext().getString(17041396));
    }

    private String getCantShareWithWorkMessage() {
        return this.getContext().getSystemService(DevicePolicyManager.class).getResources().getString("Core.RESOLVER_CANT_SHARE_WITH_WORK", () -> this.getContext().getString(17041395));
    }

    private String getCantShareWithPersonalMessage() {
        return this.getContext().getSystemService(DevicePolicyManager.class).getResources().getString("Core.RESOLVER_CANT_SHARE_WITH_PERSONAL", () -> this.getContext().getString(17041394));
    }

    private String getCantAccessWorkMessage() {
        return this.getContext().getSystemService(DevicePolicyManager.class).getResources().getString("Core.RESOLVER_CANT_ACCESS_WORK", () -> this.getContext().getString(17041393));
    }

    private String getCantAccessPersonalMessage() {
        return this.getContext().getSystemService(DevicePolicyManager.class).getResources().getString("Core.RESOLVER_CANT_ACCESS_PERSONAL", () -> this.getContext().getString(17041392));
    }

    private String getNoWorkAppsAvailableMessage() {
        return this.getContext().getSystemService(DevicePolicyManager.class).getResources().getString("Core.RESOLVER_NO_WORK_APPS", () -> this.getContext().getString(17041398));
    }

    private String getNoPersonalAppsAvailableMessage() {
        return this.getContext().getSystemService(DevicePolicyManager.class).getResources().getString("Core.RESOLVER_NO_PERSONAL_APPS", () -> this.getContext().getString(17041397));
    }

    void setEmptyStateBottomOffset(int bottomOffset) {
        this.mBottomOffset = bottomOffset;
    }

    @Override
    protected void setupContainerPadding(View container) {
        int initialBottomPadding = this.getContext().getResources().getDimensionPixelSize(17105492);
        container.setPadding(container.getPaddingLeft(), container.getPaddingTop(), container.getPaddingRight(), initialBottomPadding + this.mBottomOffset);
    }

    class ChooserProfileDescriptor
    extends AbstractMultiProfilePagerAdapter.ProfileDescriptor {
        private ChooserActivity.ChooserGridAdapter chooserGridAdapter;
        private RecyclerView recyclerView;

        ChooserProfileDescriptor(ViewGroup rootView, ChooserActivity.ChooserGridAdapter adapter) {
            super(rootView);
            this.chooserGridAdapter = adapter;
            this.recyclerView = (RecyclerView)rootView.findViewById(16909418);
        }
    }
}

