/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.usage.UsageStatsManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.BadParcelableException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.android.internal.app.ChooserActivityLogger;
import com.android.internal.app.ResolverActivity;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public abstract class AbstractResolverComparator
implements Comparator<ResolverActivity.ResolvedComponentInfo> {
    private static final int NUM_OF_TOP_ANNOTATIONS_TO_USE = 3;
    private static final boolean DEBUG = true;
    private static final String TAG = "AbstractResolverComp";
    protected AfterCompute mAfterCompute;
    protected final PackageManager mPm;
    protected final UsageStatsManager mUsm;
    protected String[] mAnnotations;
    protected String mContentType;
    private final boolean mHttp;
    static final int RANKER_SERVICE_RESULT = 0;
    static final int RANKER_RESULT_TIMEOUT = 1;
    private static final int WATCHDOG_TIMEOUT_MILLIS = 500;
    private final Comparator<ResolveInfo> mAzComparator;
    private ChooserActivityLogger mChooserActivityLogger;
    protected final Handler mHandler = new Handler(Looper.getMainLooper()){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    Log.d(AbstractResolverComparator.TAG, "RANKER_SERVICE_RESULT");
                    if (!AbstractResolverComparator.this.mHandler.hasMessages(1)) break;
                    AbstractResolverComparator.this.handleResultMessage(msg);
                    AbstractResolverComparator.this.mHandler.removeMessages(1);
                    AbstractResolverComparator.this.afterCompute();
                    break;
                }
                case 1: {
                    Log.d(AbstractResolverComparator.TAG, "RANKER_RESULT_TIMEOUT; unbinding services");
                    AbstractResolverComparator.this.mHandler.removeMessages(0);
                    AbstractResolverComparator.this.afterCompute();
                    if (AbstractResolverComparator.this.mChooserActivityLogger == null) break;
                    AbstractResolverComparator.this.mChooserActivityLogger.logSharesheetAppShareRankingTimeout();
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    };

    public AbstractResolverComparator(Context context, Intent intent) {
        String scheme = intent.getScheme();
        this.mHttp = "http".equals(scheme) || "https".equals(scheme);
        this.mContentType = intent.getType();
        this.getContentAnnotations(intent);
        this.mPm = context.getPackageManager();
        this.mUsm = (UsageStatsManager)context.getSystemService("usagestats");
        this.mAzComparator = new AzInfoComparator(context);
    }

    private void getContentAnnotations(Intent intent) {
        try {
            ArrayList<String> annotations = intent.getStringArrayListExtra("android.intent.extra.CONTENT_ANNOTATIONS");
            if (annotations != null) {
                int size = annotations.size();
                if (size > 3) {
                    size = 3;
                }
                this.mAnnotations = new String[size];
                for (int i = 0; i < size; ++i) {
                    this.mAnnotations[i] = annotations.get(i);
                }
            }
        }
        catch (BadParcelableException e) {
            Log.i(TAG, "Couldn't unparcel intent annotations. Ignoring.");
            this.mAnnotations = new String[0];
        }
    }

    void setCallBack(AfterCompute afterCompute) {
        this.mAfterCompute = afterCompute;
    }

    void setChooserActivityLogger(ChooserActivityLogger chooserActivityLogger) {
        this.mChooserActivityLogger = chooserActivityLogger;
    }

    ChooserActivityLogger getChooserActivityLogger() {
        return this.mChooserActivityLogger;
    }

    protected void afterCompute() {
        AfterCompute afterCompute = this.mAfterCompute;
        if (afterCompute != null) {
            afterCompute.afterCompute();
        }
    }

    @Override
    public int compare(ResolverActivity.ResolvedComponentInfo lhsp, ResolverActivity.ResolvedComponentInfo rhsp) {
        boolean rhsSpecific;
        boolean lhsSpecific;
        ResolveInfo lhs = lhsp.getResolveInfoAt(0);
        ResolveInfo rhs = rhsp.getResolveInfoAt(0);
        boolean lFixedAtTop = lhsp.isFixedAtTop();
        boolean rFixedAtTop = rhsp.isFixedAtTop();
        if (lFixedAtTop && !rFixedAtTop) {
            return -1;
        }
        if (!lFixedAtTop && rFixedAtTop) {
            return 1;
        }
        if (lhs.targetUserId != -2) {
            return rhs.targetUserId != -2 ? 0 : 1;
        }
        if (rhs.targetUserId != -2) {
            return -1;
        }
        if (this.mHttp && (lhsSpecific = ResolverActivity.isSpecificUriMatch(lhs.match)) != (rhsSpecific = ResolverActivity.isSpecificUriMatch(rhs.match))) {
            return lhsSpecific ? -1 : 1;
        }
        boolean lPinned = lhsp.isPinned();
        boolean rPinned = rhsp.isPinned();
        if (lPinned && !rPinned) {
            return -1;
        }
        if (!lPinned && rPinned) {
            return 1;
        }
        if (lPinned && rPinned) {
            return this.mAzComparator.compare(lhsp.getResolveInfoAt(0), rhsp.getResolveInfoAt(0));
        }
        return this.compare(lhs, rhs);
    }

    @Override
    abstract int compare(ResolveInfo var1, ResolveInfo var2);

    void compute(List<ResolverActivity.ResolvedComponentInfo> targets) {
        this.beforeCompute();
        this.doCompute(targets);
    }

    abstract void doCompute(List<ResolverActivity.ResolvedComponentInfo> var1);

    abstract float getScore(ComponentName var1);

    abstract void handleResultMessage(Message var1);

    void updateChooserCounts(String packageName, int userId, String action) {
        if (this.mUsm != null) {
            this.mUsm.reportChooserSelection(packageName, userId, this.mContentType, this.mAnnotations, action);
        }
    }

    void updateModel(ComponentName componentName) {
    }

    void beforeCompute() {
        Log.d(TAG, "Setting watchdog timer for 500ms");
        if (this.mHandler == null) {
            Log.d(TAG, "Error: Handler is Null; Needs to be initialized.");
            return;
        }
        this.mHandler.sendEmptyMessageDelayed(1, 500L);
    }

    void destroy() {
        this.mHandler.removeMessages(0);
        this.mHandler.removeMessages(1);
        this.afterCompute();
        this.mAfterCompute = null;
    }

    class AzInfoComparator
    implements Comparator<ResolveInfo> {
        Collator mCollator;

        AzInfoComparator(Context context) {
            this.mCollator = Collator.getInstance(context.getResources().getConfiguration().locale);
        }

        @Override
        public int compare(ResolveInfo lhsp, ResolveInfo rhsp) {
            if (lhsp == null) {
                return -1;
            }
            if (rhsp == null) {
                return 1;
            }
            return this.mCollator.compare(lhsp.activityInfo.packageName, rhsp.activityInfo.packageName);
        }
    }

    static interface AfterCompute {
        public void afterCompute();
    }
}

