/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.AppGlobals;
import android.app.admin.DevicePolicyEventLogger;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.IPackageManager;
import android.content.pm.ResolveInfo;
import android.os.AsyncTask;
import android.os.Trace;
import android.os.UserHandle;
import android.os.UserManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.IntentForwarderActivity;
import com.android.internal.app.ResolverActivity;
import com.android.internal.app.ResolverListAdapter;
import com.android.internal.widget.PagerAdapter;
import com.android.internal.widget.ViewPager;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractMultiProfilePagerAdapter
extends PagerAdapter {
    private static final String TAG = "AbstractMultiProfilePagerAdapter";
    static final int PROFILE_PERSONAL = 0;
    static final int PROFILE_WORK = 1;
    private final Context mContext;
    private int mCurrentPage;
    private OnProfileSelectedListener mOnProfileSelectedListener;
    private OnSwitchOnWorkSelectedListener mOnSwitchOnWorkSelectedListener;
    private Set<Integer> mLoadedPages;
    private final UserHandle mPersonalProfileUserHandle;
    private final UserHandle mWorkProfileUserHandle;
    private Injector mInjector;
    private boolean mIsWaitingToEnableWorkProfile;

    AbstractMultiProfilePagerAdapter(Context context, int currentPage, UserHandle personalProfileUserHandle, UserHandle workProfileUserHandle) {
        this.mContext = Objects.requireNonNull(context);
        this.mCurrentPage = currentPage;
        this.mLoadedPages = new HashSet<Integer>();
        this.mPersonalProfileUserHandle = personalProfileUserHandle;
        this.mWorkProfileUserHandle = workProfileUserHandle;
        final UserManager userManager = context.getSystemService(UserManager.class);
        this.mInjector = new Injector(){

            @Override
            public boolean hasCrossProfileIntents(List<Intent> intents, int sourceUserId, int targetUserId) {
                return AbstractMultiProfilePagerAdapter.this.hasCrossProfileIntents(intents, sourceUserId, targetUserId);
            }

            @Override
            public boolean isQuietModeEnabled(UserHandle workProfileUserHandle) {
                return userManager.isQuietModeEnabled(workProfileUserHandle);
            }

            @Override
            public void requestQuietModeEnabled(boolean enabled, UserHandle workProfileUserHandle) {
                AsyncTask.THREAD_POOL_EXECUTOR.execute(() -> userManager.requestQuietModeEnabled(enabled, workProfileUserHandle));
                AbstractMultiProfilePagerAdapter.this.mIsWaitingToEnableWorkProfile = true;
            }
        };
    }

    protected void markWorkProfileEnabledBroadcastReceived() {
        this.mIsWaitingToEnableWorkProfile = false;
    }

    protected boolean isWaitingToEnableWorkProfile() {
        return this.mIsWaitingToEnableWorkProfile;
    }

    @VisibleForTesting
    public void setInjector(Injector injector) {
        this.mInjector = injector;
    }

    protected boolean isQuietModeEnabled(UserHandle workProfileUserHandle) {
        return this.mInjector.isQuietModeEnabled(workProfileUserHandle);
    }

    void setOnProfileSelectedListener(OnProfileSelectedListener listener) {
        this.mOnProfileSelectedListener = listener;
    }

    void setOnSwitchOnWorkSelectedListener(OnSwitchOnWorkSelectedListener listener) {
        this.mOnSwitchOnWorkSelectedListener = listener;
    }

    Context getContext() {
        return this.mContext;
    }

    void setupViewPager(ViewPager viewPager) {
        viewPager.setOnPageChangeListener(new ViewPager.SimpleOnPageChangeListener(){

            @Override
            public void onPageSelected(int position) {
                AbstractMultiProfilePagerAdapter.this.mCurrentPage = position;
                if (!AbstractMultiProfilePagerAdapter.this.mLoadedPages.contains(position)) {
                    AbstractMultiProfilePagerAdapter.this.rebuildActiveTab(true);
                    AbstractMultiProfilePagerAdapter.this.mLoadedPages.add(position);
                }
                if (AbstractMultiProfilePagerAdapter.this.mOnProfileSelectedListener != null) {
                    AbstractMultiProfilePagerAdapter.this.mOnProfileSelectedListener.onProfileSelected(position);
                }
            }

            @Override
            public void onPageScrollStateChanged(int state) {
                if (AbstractMultiProfilePagerAdapter.this.mOnProfileSelectedListener != null) {
                    AbstractMultiProfilePagerAdapter.this.mOnProfileSelectedListener.onProfilePageStateChanged(state);
                }
            }
        });
        viewPager.setAdapter(this);
        viewPager.setCurrentItem(this.mCurrentPage);
        this.mLoadedPages.add(this.mCurrentPage);
    }

    void clearInactiveProfileCache() {
        if (this.mLoadedPages.size() == 1) {
            return;
        }
        this.mLoadedPages.remove(1 - this.mCurrentPage);
    }

    @Override
    public ViewGroup instantiateItem(ViewGroup container, int position) {
        ProfileDescriptor profileDescriptor = this.getItem(position);
        container.addView(profileDescriptor.rootView);
        return profileDescriptor.rootView;
    }

    @Override
    public void destroyItem(ViewGroup container, int position, Object view) {
        container.removeView((View)view);
    }

    @Override
    public int getCount() {
        return this.getItemCount();
    }

    protected int getCurrentPage() {
        return this.mCurrentPage;
    }

    @VisibleForTesting
    public UserHandle getCurrentUserHandle() {
        return this.getActiveListAdapter().mResolverListController.getUserHandle();
    }

    @Override
    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    @Override
    public CharSequence getPageTitle(int position) {
        return null;
    }

    abstract ProfileDescriptor getItem(int var1);

    abstract int getItemCount();

    abstract void setupListAdapter(int var1);

    @VisibleForTesting
    public abstract Object getAdapterForIndex(int var1);

    abstract ResolverListAdapter getListAdapterForUserHandle(UserHandle var1);

    @VisibleForTesting
    public abstract ResolverListAdapter getActiveListAdapter();

    @VisibleForTesting
    public abstract ResolverListAdapter getInactiveListAdapter();

    public abstract ResolverListAdapter getPersonalListAdapter();

    public abstract ResolverListAdapter getWorkListAdapter();

    abstract Object getCurrentRootAdapter();

    abstract ViewGroup getActiveAdapterView();

    abstract ViewGroup getInactiveAdapterView();

    abstract String getMetricsCategory();

    boolean rebuildActiveTab(boolean doPostProcessing) {
        Trace.beginSection("MultiProfilePagerAdapter#rebuildActiveTab");
        boolean result = this.rebuildTab(this.getActiveListAdapter(), doPostProcessing);
        Trace.endSection();
        return result;
    }

    boolean rebuildInactiveTab(boolean doPostProcessing) {
        Trace.beginSection("MultiProfilePagerAdapter#rebuildInactiveTab");
        if (this.getItemCount() == 1) {
            Trace.endSection();
            return false;
        }
        boolean result = this.rebuildTab(this.getInactiveListAdapter(), doPostProcessing);
        Trace.endSection();
        return result;
    }

    private int userHandleToPageIndex(UserHandle userHandle) {
        if (userHandle.equals(this.getPersonalListAdapter().mResolverListController.getUserHandle())) {
            return 0;
        }
        return 1;
    }

    private boolean rebuildTab(ResolverListAdapter activeListAdapter, boolean doPostProcessing) {
        if (this.shouldShowNoCrossProfileIntentsEmptyState(activeListAdapter)) {
            activeListAdapter.postListReadyRunnable(doPostProcessing, true);
            return false;
        }
        return activeListAdapter.rebuildList(doPostProcessing);
    }

    private boolean shouldShowNoCrossProfileIntentsEmptyState(ResolverListAdapter activeListAdapter) {
        UserHandle listUserHandle = activeListAdapter.getUserHandle();
        return UserHandle.myUserId() != listUserHandle.getIdentifier() && this.allowShowNoCrossProfileIntentsEmptyState() && !this.mInjector.hasCrossProfileIntents(activeListAdapter.getIntents(), UserHandle.myUserId(), listUserHandle.getIdentifier());
    }

    boolean allowShowNoCrossProfileIntentsEmptyState() {
        return true;
    }

    protected abstract void showWorkProfileOffEmptyState(ResolverListAdapter var1, View.OnClickListener var2);

    protected abstract void showNoPersonalToWorkIntentsEmptyState(ResolverListAdapter var1);

    protected abstract void showNoPersonalAppsAvailableEmptyState(ResolverListAdapter var1);

    protected abstract void showNoWorkAppsAvailableEmptyState(ResolverListAdapter var1);

    protected abstract void showNoWorkToPersonalIntentsEmptyState(ResolverListAdapter var1);

    void showEmptyResolverListEmptyState(ResolverListAdapter listAdapter) {
        if (this.maybeShowNoCrossProfileIntentsEmptyState(listAdapter)) {
            return;
        }
        if (this.maybeShowWorkProfileOffEmptyState(listAdapter)) {
            return;
        }
        this.maybeShowNoAppsAvailableEmptyState(listAdapter);
    }

    private boolean maybeShowNoCrossProfileIntentsEmptyState(ResolverListAdapter listAdapter) {
        if (!this.shouldShowNoCrossProfileIntentsEmptyState(listAdapter)) {
            return false;
        }
        if (listAdapter.getUserHandle().equals(this.mPersonalProfileUserHandle)) {
            DevicePolicyEventLogger.createEvent(158).setStrings(this.getMetricsCategory()).write();
            this.showNoWorkToPersonalIntentsEmptyState(listAdapter);
        } else {
            DevicePolicyEventLogger.createEvent(159).setStrings(this.getMetricsCategory()).write();
            this.showNoPersonalToWorkIntentsEmptyState(listAdapter);
        }
        return true;
    }

    private boolean maybeShowWorkProfileOffEmptyState(ResolverListAdapter listAdapter) {
        UserHandle listUserHandle = listAdapter.getUserHandle();
        if (!listUserHandle.equals(this.mWorkProfileUserHandle) || !this.mInjector.isQuietModeEnabled(this.mWorkProfileUserHandle) || listAdapter.getCount() == 0) {
            return false;
        }
        DevicePolicyEventLogger.createEvent(157).setStrings(this.getMetricsCategory()).write();
        this.showWorkProfileOffEmptyState(listAdapter, v -> {
            ProfileDescriptor descriptor = this.getItem(this.userHandleToPageIndex(listAdapter.getUserHandle()));
            this.showSpinner(descriptor.getEmptyStateView());
            if (this.mOnSwitchOnWorkSelectedListener != null) {
                this.mOnSwitchOnWorkSelectedListener.onSwitchOnWorkSelected();
            }
            this.mInjector.requestQuietModeEnabled(false, this.mWorkProfileUserHandle);
        });
        return true;
    }

    private void maybeShowNoAppsAvailableEmptyState(ResolverListAdapter listAdapter) {
        UserHandle listUserHandle = listAdapter.getUserHandle();
        if (!(this.mWorkProfileUserHandle == null || UserHandle.myUserId() != listUserHandle.getIdentifier() && this.hasAppsInOtherProfile(listAdapter))) {
            DevicePolicyEventLogger.createEvent(160).setStrings(this.getMetricsCategory()).setBoolean(listUserHandle == this.mPersonalProfileUserHandle).write();
            if (listUserHandle == this.mPersonalProfileUserHandle) {
                this.showNoPersonalAppsAvailableEmptyState(listAdapter);
            } else {
                this.showNoWorkAppsAvailableEmptyState(listAdapter);
            }
        } else if (this.mWorkProfileUserHandle == null) {
            this.showConsumerUserNoAppsAvailableEmptyState(listAdapter);
        }
    }

    protected void showEmptyState(ResolverListAdapter activeListAdapter, String title, String subtitle) {
        this.showEmptyState(activeListAdapter, title, subtitle, null);
    }

    protected void showEmptyState(ResolverListAdapter activeListAdapter, String title, String subtitle, View.OnClickListener buttonOnClick) {
        ProfileDescriptor descriptor = this.getItem(this.userHandleToPageIndex(activeListAdapter.getUserHandle()));
        ((View)descriptor.rootView.findViewById(16909418)).setVisibility(8);
        ViewGroup emptyStateView = descriptor.getEmptyStateView();
        this.resetViewVisibilitiesForWorkProfileEmptyState(emptyStateView);
        emptyStateView.setVisibility(0);
        Object container = emptyStateView.findViewById(16909413);
        this.setupContainerPadding((View)container);
        TextView titleView = (TextView)emptyStateView.findViewById(16909417);
        titleView.setText(title);
        TextView subtitleView = (TextView)emptyStateView.findViewById(16909416);
        if (subtitle != null) {
            subtitleView.setVisibility(0);
            subtitleView.setText(subtitle);
        } else {
            subtitleView.setVisibility(8);
        }
        Button button = (Button)emptyStateView.findViewById(16909412);
        button.setVisibility(buttonOnClick != null ? 0 : 8);
        button.setOnClickListener(buttonOnClick);
        activeListAdapter.markTabLoaded();
    }

    protected void setupContainerPadding(View container) {
    }

    private void showConsumerUserNoAppsAvailableEmptyState(ResolverListAdapter activeListAdapter) {
        ProfileDescriptor descriptor = this.getItem(this.userHandleToPageIndex(activeListAdapter.getUserHandle()));
        ((View)descriptor.rootView.findViewById(16909418)).setVisibility(8);
        ViewGroup emptyStateView = descriptor.getEmptyStateView();
        this.resetViewVisibilitiesForConsumerUserEmptyState(emptyStateView);
        emptyStateView.setVisibility(0);
        activeListAdapter.markTabLoaded();
    }

    private boolean isSpinnerShowing(View emptyStateView) {
        return ((View)emptyStateView.findViewById(16909415)).getVisibility() == 0;
    }

    private void showSpinner(View emptyStateView) {
        ((View)emptyStateView.findViewById(16909417)).setVisibility(4);
        ((View)emptyStateView.findViewById(16909412)).setVisibility(4);
        ((View)emptyStateView.findViewById(16909415)).setVisibility(0);
        ((View)emptyStateView.findViewById(16908292)).setVisibility(8);
    }

    private void resetViewVisibilitiesForWorkProfileEmptyState(View emptyStateView) {
        ((View)emptyStateView.findViewById(16909417)).setVisibility(0);
        ((View)emptyStateView.findViewById(16909416)).setVisibility(0);
        ((View)emptyStateView.findViewById(16909412)).setVisibility(4);
        ((View)emptyStateView.findViewById(16909415)).setVisibility(8);
        ((View)emptyStateView.findViewById(16908292)).setVisibility(8);
    }

    private void resetViewVisibilitiesForConsumerUserEmptyState(View emptyStateView) {
        ((View)emptyStateView.findViewById(16909417)).setVisibility(8);
        ((View)emptyStateView.findViewById(16909416)).setVisibility(8);
        ((View)emptyStateView.findViewById(16909412)).setVisibility(8);
        ((View)emptyStateView.findViewById(16909415)).setVisibility(8);
        ((View)emptyStateView.findViewById(16908292)).setVisibility(0);
    }

    protected void showListView(ResolverListAdapter activeListAdapter) {
        ProfileDescriptor descriptor = this.getItem(this.userHandleToPageIndex(activeListAdapter.getUserHandle()));
        ((View)descriptor.rootView.findViewById(16909418)).setVisibility(0);
        Object emptyStateView = descriptor.rootView.findViewById(16909411);
        ((View)emptyStateView).setVisibility(8);
    }

    private boolean hasCrossProfileIntents(List<Intent> intents, int source, int target) {
        IPackageManager packageManager = AppGlobals.getPackageManager();
        ContentResolver contentResolver = this.mContext.getContentResolver();
        for (Intent intent : intents) {
            if (IntentForwarderActivity.canForward(intent, source, target, packageManager, contentResolver) == null) continue;
            return true;
        }
        return false;
    }

    private boolean hasAppsInOtherProfile(ResolverListAdapter adapter) {
        if (this.mWorkProfileUserHandle == null) {
            return false;
        }
        List<ResolverActivity.ResolvedComponentInfo> resolversForIntent = adapter.getResolversForUser(UserHandle.of(UserHandle.myUserId()));
        for (ResolverActivity.ResolvedComponentInfo info : resolversForIntent) {
            ResolveInfo resolveInfo = info.getResolveInfoAt(0);
            if (resolveInfo.targetUserId == -2) continue;
            return true;
        }
        return false;
    }

    boolean shouldShowEmptyStateScreen(ResolverListAdapter listAdapter) {
        int count = listAdapter.getUnfilteredCount();
        return count == 0 && listAdapter.getPlaceholderCount() == 0 || listAdapter.getUserHandle().equals(this.mWorkProfileUserHandle) && this.isQuietModeEnabled(this.mWorkProfileUserHandle);
    }

    @VisibleForTesting
    public static interface Injector {
        public boolean hasCrossProfileIntents(List<Intent> var1, int var2, int var3);

        public boolean isQuietModeEnabled(UserHandle var1);

        public void requestQuietModeEnabled(boolean var1, UserHandle var2);
    }

    static interface OnSwitchOnWorkSelectedListener {
        public void onSwitchOnWorkSelected();
    }

    public static interface OnProfileSelectedListener {
        public void onProfileSelected(int var1);

        public void onProfilePageStateChanged(int var1);
    }

    protected class ProfileDescriptor {
        final ViewGroup rootView;
        private final ViewGroup mEmptyStateView;

        ProfileDescriptor(ViewGroup rootView) {
            this.rootView = rootView;
            this.mEmptyStateView = (ViewGroup)rootView.findViewById(16909411);
        }

        protected ViewGroup getEmptyStateView() {
            return this.mEmptyStateView;
        }
    }

    static @interface Profile {
    }
}

