/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import android.window.WindowTokenClient;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class WindowContextController {
    private static final boolean DEBUG_ATTACH = false;
    private static final String TAG = "WindowContextController";
    @VisibleForTesting
    public int mAttachedToDisplayArea = 0;
    private final WindowTokenClient mToken;

    public WindowContextController(WindowTokenClient token) {
        this.mToken = token;
    }

    public void attachToDisplayArea(int type, int displayId, Bundle options) {
        if (this.mAttachedToDisplayArea == 1) {
            throw new IllegalStateException("A Window Context can be only attached to a DisplayArea once.");
        }
        int n = this.mAttachedToDisplayArea = this.mToken.attachToDisplayArea(type, displayId, options) ? 1 : 3;
        if (this.mAttachedToDisplayArea == 3) {
            Log.w(TAG, "attachToDisplayArea fail, type:" + type + ", displayId:" + displayId);
        }
    }

    public void attachToWindowToken(IBinder windowToken) {
        if (this.mAttachedToDisplayArea != 1) {
            throw new IllegalStateException("The Window Context should have been attached to a DisplayArea. AttachToDisplayArea:" + this.mAttachedToDisplayArea);
        }
        this.mToken.attachToWindowToken(windowToken);
    }

    public void detachIfNeeded() {
        if (this.mAttachedToDisplayArea == 1) {
            this.mToken.detachFromWindowContainerIfNeeded();
            this.mAttachedToDisplayArea = 2;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AttachStatus {
        public static final int STATUS_INITIALIZED = 0;
        public static final int STATUS_ATTACHED = 1;
        public static final int STATUS_DETACHED = 2;
        public static final int STATUS_FAILED = 3;
    }
}

