/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.app.WindowConfiguration;
import android.content.res.Configuration;
import android.graphics.Point;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.window.WindowContainerToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TaskFragmentInfo
implements Parcelable {
    private final IBinder mFragmentToken;
    private final WindowContainerToken mToken;
    private final Configuration mConfiguration = new Configuration();
    private final int mRunningActivityCount;
    private final boolean mIsVisible;
    private final List<IBinder> mActivities = new ArrayList<IBinder>();
    private final Point mPositionInParent = new Point();
    private final boolean mIsTaskClearedForReuse;
    private final boolean mIsTaskFragmentClearedForPip;
    private final Point mMinimumDimensions = new Point();
    public static final Parcelable.Creator<TaskFragmentInfo> CREATOR = new Parcelable.Creator<TaskFragmentInfo>(){

        @Override
        public TaskFragmentInfo createFromParcel(Parcel in) {
            return new TaskFragmentInfo(in);
        }

        public TaskFragmentInfo[] newArray(int size) {
            return new TaskFragmentInfo[size];
        }
    };

    public TaskFragmentInfo(IBinder fragmentToken, WindowContainerToken token, Configuration configuration, int runningActivityCount, boolean isVisible, List<IBinder> activities, Point positionInParent, boolean isTaskClearedForReuse, boolean isTaskFragmentClearedForPip, Point minimumDimensions) {
        this.mFragmentToken = Objects.requireNonNull(fragmentToken);
        this.mToken = Objects.requireNonNull(token);
        this.mConfiguration.setTo(configuration);
        this.mRunningActivityCount = runningActivityCount;
        this.mIsVisible = isVisible;
        this.mActivities.addAll(activities);
        this.mPositionInParent.set(positionInParent);
        this.mIsTaskClearedForReuse = isTaskClearedForReuse;
        this.mIsTaskFragmentClearedForPip = isTaskFragmentClearedForPip;
        this.mMinimumDimensions.set(minimumDimensions);
    }

    public IBinder getFragmentToken() {
        return this.mFragmentToken;
    }

    public WindowContainerToken getToken() {
        return this.mToken;
    }

    public Configuration getConfiguration() {
        return this.mConfiguration;
    }

    public boolean isEmpty() {
        return this.mRunningActivityCount == 0;
    }

    public boolean hasRunningActivity() {
        return this.mRunningActivityCount > 0;
    }

    public int getRunningActivityCount() {
        return this.mRunningActivityCount;
    }

    public boolean isVisible() {
        return this.mIsVisible;
    }

    public List<IBinder> getActivities() {
        return this.mActivities;
    }

    public Point getPositionInParent() {
        return this.mPositionInParent;
    }

    public boolean isTaskClearedForReuse() {
        return this.mIsTaskClearedForReuse;
    }

    public boolean isTaskFragmentClearedForPip() {
        return this.mIsTaskFragmentClearedForPip;
    }

    @WindowConfiguration.WindowingMode
    public int getWindowingMode() {
        return this.mConfiguration.windowConfiguration.getWindowingMode();
    }

    public int getMinimumWidth() {
        return this.mMinimumDimensions.x;
    }

    public int getMinimumHeight() {
        return this.mMinimumDimensions.y;
    }

    public boolean equalsForTaskFragmentOrganizer(TaskFragmentInfo that) {
        if (that == null) {
            return false;
        }
        return this.mFragmentToken.equals(that.mFragmentToken) && this.mToken.equals(that.mToken) && this.mRunningActivityCount == that.mRunningActivityCount && this.mIsVisible == that.mIsVisible && this.getWindowingMode() == that.getWindowingMode() && this.mActivities.equals(that.mActivities) && this.mPositionInParent.equals(that.mPositionInParent) && this.mIsTaskClearedForReuse == that.mIsTaskClearedForReuse && this.mIsTaskFragmentClearedForPip == that.mIsTaskFragmentClearedForPip && this.mMinimumDimensions.equals(that.mMinimumDimensions);
    }

    private TaskFragmentInfo(Parcel in) {
        this.mFragmentToken = in.readStrongBinder();
        this.mToken = in.readTypedObject(WindowContainerToken.CREATOR);
        this.mConfiguration.readFromParcel(in);
        this.mRunningActivityCount = in.readInt();
        this.mIsVisible = in.readBoolean();
        in.readBinderList(this.mActivities);
        this.mPositionInParent.readFromParcel(in);
        this.mIsTaskClearedForReuse = in.readBoolean();
        this.mIsTaskFragmentClearedForPip = in.readBoolean();
        this.mMinimumDimensions.readFromParcel(in);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeStrongBinder(this.mFragmentToken);
        dest.writeTypedObject(this.mToken, flags);
        this.mConfiguration.writeToParcel(dest, flags);
        dest.writeInt(this.mRunningActivityCount);
        dest.writeBoolean(this.mIsVisible);
        dest.writeBinderList(this.mActivities);
        this.mPositionInParent.writeToParcel(dest, flags);
        dest.writeBoolean(this.mIsTaskClearedForReuse);
        dest.writeBoolean(this.mIsTaskFragmentClearedForPip);
        this.mMinimumDimensions.writeToParcel(dest, flags);
    }

    public String toString() {
        return "TaskFragmentInfo{ fragmentToken=" + this.mFragmentToken + " token=" + this.mToken + " runningActivityCount=" + this.mRunningActivityCount + " isVisible=" + this.mIsVisible + " activities=" + this.mActivities + " positionInParent=" + this.mPositionInParent + " isTaskClearedForReuse=" + this.mIsTaskClearedForReuse + " isTaskFragmentClearedForPip" + this.mIsTaskFragmentClearedForPip + " minimumDimensions" + this.mMinimumDimensions + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

