/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.os.Handler;
import android.os.Looper;
import android.util.ArraySet;
import android.util.Log;
import android.util.SparseArray;
import android.view.SurfaceControl;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewRootImpl;
import com.android.internal.annotations.GuardedBy;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class SurfaceSyncer {
    private static final String TAG = "SurfaceSyncer";
    private static final boolean DEBUG = false;
    private static Supplier<SurfaceControl.Transaction> sTransactionFactory = SurfaceControl.Transaction::new;
    private final Object mSyncSetLock = new Object();
    @GuardedBy(value={"mSyncSetLock"})
    private final SparseArray<SyncSet> mSyncSets = new SparseArray();
    @GuardedBy(value={"mSyncSetLock"})
    private int mIdCounter = 0;

    public static void setTransactionFactory(Supplier<SurfaceControl.Transaction> transactionFactory) {
        sTransactionFactory = transactionFactory;
    }

    public int setupSync(Runnable onComplete) {
        Handler handler = new Handler(Looper.myLooper());
        return this.setupSync((SurfaceControl.Transaction transaction) -> {
            transaction.apply();
            if (onComplete != null) {
                handler.post(onComplete);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setupSync(Consumer<SurfaceControl.Transaction> syncRequestComplete) {
        Object object = this.mSyncSetLock;
        synchronized (object) {
            int syncId = this.mIdCounter++;
            SyncSet syncSet = new SyncSet(syncId, transaction -> {
                Object object = this.mSyncSetLock;
                synchronized (object) {
                    this.mSyncSets.remove(syncId);
                }
                syncRequestComplete.accept((SurfaceControl.Transaction)transaction);
            });
            this.mSyncSets.put(syncId, syncSet);
            return syncId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markSyncReady(int syncId) {
        SyncSet syncSet;
        Object object = this.mSyncSetLock;
        synchronized (object) {
            syncSet = this.mSyncSets.get(syncId);
        }
        if (syncSet == null) {
            Log.e(TAG, "Failed to find syncSet for syncId=" + syncId);
            return;
        }
        syncSet.markSyncReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(int syncId, int otherSyncId, SurfaceSyncer otherSurfaceSyncer) {
        SyncSet syncSet;
        Object object = this.mSyncSetLock;
        synchronized (object) {
            syncSet = this.mSyncSets.get(syncId);
        }
        SyncSet otherSyncSet = otherSurfaceSyncer.getAndValidateSyncSet(otherSyncId);
        if (otherSyncSet == null) {
            return;
        }
        syncSet.merge(otherSyncSet);
    }

    public boolean addToSync(int syncId, SurfaceView surfaceView, Consumer<SurfaceViewFrameCallback> frameCallbackConsumer) {
        return this.addToSync(syncId, new SurfaceViewSyncTarget(surfaceView, frameCallbackConsumer));
    }

    public boolean addToSync(int syncId, View view) {
        ViewRootImpl viewRoot = view.getViewRootImpl();
        if (viewRoot == null) {
            return false;
        }
        return this.addToSync(syncId, viewRoot.mSyncTarget);
    }

    public boolean addToSync(int syncId, SyncTarget syncTarget) {
        SyncSet syncSet = this.getAndValidateSyncSet(syncId);
        if (syncSet == null) {
            return false;
        }
        return syncSet.addSyncableSurface(syncTarget);
    }

    public void addTransactionToSync(int syncId, SurfaceControl.Transaction t) {
        SyncSet syncSet = this.getAndValidateSyncSet(syncId);
        if (syncSet != null) {
            syncSet.addTransactionToSync(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SyncSet getAndValidateSyncSet(int syncId) {
        SyncSet syncSet;
        Object object = this.mSyncSetLock;
        synchronized (object) {
            syncSet = this.mSyncSets.get(syncId);
        }
        if (syncSet == null) {
            Log.e(TAG, "Failed to find sync for id=" + syncId);
            return null;
        }
        return syncSet;
    }

    public static interface SurfaceViewFrameCallback {
        public void onFrameStarted();
    }

    private static class SurfaceViewSyncTarget
    implements SyncTarget {
        private final SurfaceView mSurfaceView;
        private final Consumer<SurfaceViewFrameCallback> mFrameCallbackConsumer;

        SurfaceViewSyncTarget(SurfaceView surfaceView, Consumer<SurfaceViewFrameCallback> frameCallbackConsumer) {
            this.mSurfaceView = surfaceView;
            this.mFrameCallbackConsumer = frameCallbackConsumer;
        }

        @Override
        public void onReadyToSync(SyncBufferCallback syncBufferCallback) {
            this.mFrameCallbackConsumer.accept(() -> this.mSurfaceView.syncNextFrame(syncBufferCallback::onBufferReady));
        }
    }

    private static class SyncSet {
        private final Object mLock = new Object();
        @GuardedBy(value={"mLock"})
        private final Set<Integer> mPendingSyncs = new ArraySet<Integer>();
        @GuardedBy(value={"mLock"})
        private final SurfaceControl.Transaction mTransaction = sTransactionFactory.get();
        @GuardedBy(value={"mLock"})
        private boolean mSyncReady;
        @GuardedBy(value={"mLock"})
        private final Set<SyncTarget> mSyncTargets = new ArraySet<SyncTarget>();
        private final int mSyncId;
        @GuardedBy(value={"mLock"})
        private Consumer<SurfaceControl.Transaction> mSyncRequestCompleteCallback;
        @GuardedBy(value={"mLock"})
        private final Set<SyncSet> mMergedSyncSets = new ArraySet<SyncSet>();
        @GuardedBy(value={"mLock"})
        private boolean mFinished;

        private SyncSet(int syncId, Consumer<SurfaceControl.Transaction> syncRequestComplete) {
            this.mSyncId = syncId;
            this.mSyncRequestCompleteCallback = syncRequestComplete;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean addSyncableSurface(SyncTarget syncTarget) {
            SyncBufferCallback syncBufferCallback = new SyncBufferCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onBufferReady(SurfaceControl.Transaction t) {
                    Object object = mLock;
                    synchronized (object) {
                        if (t != null) {
                            mTransaction.merge(t);
                        }
                        mPendingSyncs.remove(this.hashCode());
                        this.checkIfSyncIsComplete();
                    }
                }
            };
            Object object = this.mLock;
            synchronized (object) {
                if (this.mSyncReady) {
                    Log.e(SurfaceSyncer.TAG, "Sync " + this.mSyncId + " was already marked as ready. No more SyncTargets can be added.");
                    return false;
                }
                this.mPendingSyncs.add(syncBufferCallback.hashCode());
                this.mSyncTargets.add(syncTarget);
            }
            syncTarget.onReadyToSync(syncBufferCallback);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void markSyncReady() {
            Object object = this.mLock;
            synchronized (object) {
                this.mSyncReady = true;
                this.checkIfSyncIsComplete();
            }
        }

        @GuardedBy(value={"mLock"})
        private void checkIfSyncIsComplete() {
            if (!(this.mSyncReady && this.mPendingSyncs.isEmpty() && this.mMergedSyncSets.isEmpty())) {
                return;
            }
            for (SyncTarget syncTarget : this.mSyncTargets) {
                syncTarget.onSyncComplete();
            }
            this.mSyncTargets.clear();
            this.mSyncRequestCompleteCallback.accept(this.mTransaction);
            this.mFinished = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addTransactionToSync(SurfaceControl.Transaction t) {
            Object object = this.mLock;
            synchronized (object) {
                this.mTransaction.merge(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateCallback(Consumer<SurfaceControl.Transaction> transactionConsumer) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mFinished) {
                    Log.e(SurfaceSyncer.TAG, "Attempting to merge SyncSet " + this.mSyncId + " when sync is already complete");
                    transactionConsumer.accept(new SurfaceControl.Transaction());
                }
                Consumer<SurfaceControl.Transaction> oldCallback = this.mSyncRequestCompleteCallback;
                this.mSyncRequestCompleteCallback = transaction -> {
                    oldCallback.accept(new SurfaceControl.Transaction());
                    transactionConsumer.accept((SurfaceControl.Transaction)transaction);
                };
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void merge(SyncSet otherSyncSet) {
            Object object = this.mLock;
            synchronized (object) {
                this.mMergedSyncSets.add(otherSyncSet);
            }
            otherSyncSet.updateCallback(transaction -> {
                Object object = this.mLock;
                synchronized (object) {
                    this.mMergedSyncSets.remove(otherSyncSet);
                    this.mTransaction.merge((SurfaceControl.Transaction)transaction);
                    this.checkIfSyncIsComplete();
                }
            });
        }
    }

    public static interface SyncBufferCallback {
        public void onBufferReady(SurfaceControl.Transaction var1);
    }

    public static interface SyncTarget {
        public void onReadyToSync(SyncBufferCallback var1);

        default public void onSyncComplete() {
        }
    }
}

