/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TextAttribute
implements Parcelable {
    private final List<String> mTextConversionSuggestions;
    private final PersistableBundle mExtras;
    public static final Parcelable.Creator<TextAttribute> CREATOR = new Parcelable.Creator<TextAttribute>(){

        @Override
        public TextAttribute createFromParcel(Parcel source) {
            return new TextAttribute(source);
        }

        public TextAttribute[] newArray(int size) {
            return new TextAttribute[size];
        }
    };

    private TextAttribute(Builder builder) {
        this.mTextConversionSuggestions = builder.mTextConversionSuggestions;
        this.mExtras = builder.mExtras;
    }

    private TextAttribute(Parcel source) {
        this.mTextConversionSuggestions = source.createStringArrayList();
        this.mExtras = source.readPersistableBundle();
    }

    public List<String> getTextConversionSuggestions() {
        return this.mTextConversionSuggestions;
    }

    public PersistableBundle getExtras() {
        return this.mExtras;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeStringList(this.mTextConversionSuggestions);
        dest.writePersistableBundle(this.mExtras);
    }

    public static class Builder {
        private List<String> mTextConversionSuggestions = new ArrayList<String>();
        private PersistableBundle mExtras = new PersistableBundle();

        public Builder setTextConversionSuggestions(List<String> textConversionSuggestions) {
            this.mTextConversionSuggestions = Collections.unmodifiableList(textConversionSuggestions);
            return this;
        }

        public Builder setExtras(PersistableBundle extras) {
            this.mExtras = extras;
            return this;
        }

        public TextAttribute build() {
            return new TextAttribute(this);
        }
    }
}

