/*
 * Decompiled with CFR 0.152.
 */
package android.view.displayhash;

import android.annotation.CurrentTimeMillisLong;
import android.annotation.NonNull;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;

public class VerifiedDisplayHash
implements Parcelable {
    private final long mTimeMillis;
    private final Rect mBoundsInWindow;
    private final String mHashAlgorithm;
    private final byte[] mImageHash;
    public static final Parcelable.Creator<VerifiedDisplayHash> CREATOR = new Parcelable.Creator<VerifiedDisplayHash>(){

        public VerifiedDisplayHash[] newArray(int size) {
            return new VerifiedDisplayHash[size];
        }

        @Override
        public VerifiedDisplayHash createFromParcel(Parcel in) {
            return new VerifiedDisplayHash(in);
        }
    };

    private String imageHashToString() {
        return this.byteArrayToString(this.mImageHash);
    }

    private String byteArrayToString(byte[] byteArray) {
        if (byteArray == null) {
            return "null";
        }
        int iMax = byteArray.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            String formatted = String.format("%02X", byteArray[i] & 0xFF);
            b.append(formatted);
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public VerifiedDisplayHash(long timeMillis, Rect boundsInWindow, String hashAlgorithm, byte[] imageHash) {
        this.mTimeMillis = timeMillis;
        AnnotationValidations.validate(CurrentTimeMillisLong.class, null, this.mTimeMillis);
        this.mBoundsInWindow = boundsInWindow;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mBoundsInWindow);
        this.mHashAlgorithm = hashAlgorithm;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mHashAlgorithm);
        this.mImageHash = imageHash;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mImageHash);
    }

    public long getTimeMillis() {
        return this.mTimeMillis;
    }

    public Rect getBoundsInWindow() {
        return this.mBoundsInWindow;
    }

    public String getHashAlgorithm() {
        return this.mHashAlgorithm;
    }

    public byte[] getImageHash() {
        return this.mImageHash;
    }

    public String toString() {
        return "VerifiedDisplayHash { timeMillis = " + this.mTimeMillis + ", boundsInWindow = " + this.mBoundsInWindow + ", hashAlgorithm = " + this.mHashAlgorithm + ", imageHash = " + this.imageHashToString() + " }";
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mTimeMillis);
        dest.writeTypedObject(this.mBoundsInWindow, flags);
        dest.writeString(this.mHashAlgorithm);
        dest.writeByteArray(this.mImageHash);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    VerifiedDisplayHash(Parcel in) {
        long timeMillis = in.readLong();
        Rect boundsInWindow = in.readTypedObject(Rect.CREATOR);
        String hashAlgorithm = in.readString();
        byte[] imageHash = in.createByteArray();
        this.mTimeMillis = timeMillis;
        AnnotationValidations.validate(CurrentTimeMillisLong.class, null, this.mTimeMillis);
        this.mBoundsInWindow = boundsInWindow;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mBoundsInWindow);
        this.mHashAlgorithm = hashAlgorithm;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mHashAlgorithm);
        this.mImageHash = imageHash;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mImageHash);
    }

    @Deprecated
    private void __metadata() {
    }
}

