/*
 * Decompiled with CFR 0.152.
 */
package android.view.contentcapture;

import android.annotation.SystemApi;
import android.graphics.Insets;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableString;
import android.util.Log;
import android.view.autofill.AutofillId;
import android.view.contentcapture.ContentCaptureContext;
import android.view.contentcapture.ContentCaptureHelper;
import android.view.contentcapture.ViewNode;
import android.view.inputmethod.BaseInputConnection;
import com.android.internal.lang.System_Delegate;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@SystemApi
public class ContentCaptureEvent
implements Parcelable {
    private static final String TAG = ContentCaptureEvent.class.getSimpleName();
    public static final int TYPE_SESSION_FINISHED = -2;
    public static final int TYPE_SESSION_STARTED = -1;
    public static final int TYPE_VIEW_APPEARED = 1;
    public static final int TYPE_VIEW_DISAPPEARED = 2;
    public static final int TYPE_VIEW_TEXT_CHANGED = 3;
    public static final int TYPE_VIEW_TREE_APPEARING = 4;
    public static final int TYPE_VIEW_TREE_APPEARED = 5;
    public static final int TYPE_CONTEXT_UPDATED = 6;
    public static final int TYPE_SESSION_RESUMED = 7;
    public static final int TYPE_SESSION_PAUSED = 8;
    public static final int TYPE_VIEW_INSETS_CHANGED = 9;
    public static final int TYPE_WINDOW_BOUNDS_CHANGED = 10;
    public static final int MAX_INVALID_VALUE = -1;
    private final int mSessionId;
    private final int mType;
    private final long mEventTime;
    private AutofillId mId;
    private ArrayList<AutofillId> mIds;
    private ViewNode mNode;
    private CharSequence mText;
    private int mParentSessionId = 0;
    private ContentCaptureContext mClientContext;
    private Insets mInsets;
    private Rect mBounds;
    private int mComposingStart = -1;
    private int mComposingEnd = -1;
    private int mSelectionStartIndex = -1;
    private int mSelectionEndIndex = -1;
    private boolean mTextHasComposingSpan;
    public static final Parcelable.Creator<ContentCaptureEvent> CREATOR = new Parcelable.Creator<ContentCaptureEvent>(){

        @Override
        public ContentCaptureEvent createFromParcel(Parcel parcel) {
            ViewNode node;
            ArrayList<AutofillId> ids;
            int sessionId = parcel.readInt();
            int type = parcel.readInt();
            long eventTime = parcel.readLong();
            ContentCaptureEvent event = new ContentCaptureEvent(sessionId, type, eventTime);
            AutofillId id2 = parcel.readParcelable(null, AutofillId.class);
            if (id2 != null) {
                event.setAutofillId(id2);
            }
            if ((ids = parcel.createTypedArrayList(AutofillId.CREATOR)) != null) {
                event.setAutofillIds(ids);
            }
            if ((node = ViewNode.readFromParcel(parcel)) != null) {
                event.setViewNode(node);
            }
            event.setText(parcel.readCharSequence());
            if (type == -1 || type == -2) {
                event.setParentSessionId(parcel.readInt());
            }
            if (type == -1 || type == 6) {
                event.setClientContext(parcel.readParcelable(null, ContentCaptureContext.class));
            }
            if (type == 9) {
                event.setInsets(parcel.readParcelable(null, Insets.class));
            }
            if (type == 10) {
                event.setBounds(parcel.readParcelable(null, Rect.class));
            }
            if (type == 3) {
                event.setComposingIndex(parcel.readInt(), parcel.readInt());
                event.restoreComposingSpan();
                event.setSelectionIndex(parcel.readInt(), parcel.readInt());
                event.restoreSelectionSpans();
            }
            return event;
        }

        public ContentCaptureEvent[] newArray(int size) {
            return new ContentCaptureEvent[size];
        }
    };

    public ContentCaptureEvent(int sessionId, int type, long eventTime) {
        this.mSessionId = sessionId;
        this.mType = type;
        this.mEventTime = eventTime;
    }

    public ContentCaptureEvent(int sessionId, int type) {
        this(sessionId, type, System_Delegate.currentTimeMillis());
    }

    public ContentCaptureEvent setAutofillId(AutofillId id2) {
        this.mId = Objects.requireNonNull(id2);
        return this;
    }

    public ContentCaptureEvent setAutofillIds(ArrayList<AutofillId> ids) {
        this.mIds = Objects.requireNonNull(ids);
        return this;
    }

    public ContentCaptureEvent addAutofillId(AutofillId id2) {
        Objects.requireNonNull(id2);
        if (this.mIds == null) {
            this.mIds = new ArrayList();
            if (this.mId == null) {
                Log.w(TAG, "addAutofillId(" + id2 + ") called without an initial id");
            } else {
                this.mIds.add(this.mId);
                this.mId = null;
            }
        }
        this.mIds.add(id2);
        return this;
    }

    public ContentCaptureEvent setParentSessionId(int parentSessionId) {
        this.mParentSessionId = parentSessionId;
        return this;
    }

    public ContentCaptureEvent setClientContext(ContentCaptureContext clientContext) {
        this.mClientContext = clientContext;
        return this;
    }

    public int getSessionId() {
        return this.mSessionId;
    }

    public int getParentSessionId() {
        return this.mParentSessionId;
    }

    public ContentCaptureContext getContentCaptureContext() {
        return this.mClientContext;
    }

    public ContentCaptureEvent setViewNode(ViewNode node) {
        this.mNode = Objects.requireNonNull(node);
        return this;
    }

    public ContentCaptureEvent setText(CharSequence text) {
        this.mText = text;
        return this;
    }

    public ContentCaptureEvent setComposingIndex(int start, int end) {
        this.mComposingStart = start;
        this.mComposingEnd = end;
        return this;
    }

    public boolean hasComposingSpan() {
        return this.mComposingStart > -1;
    }

    public ContentCaptureEvent setSelectionIndex(int start, int end) {
        this.mSelectionStartIndex = start;
        this.mSelectionEndIndex = end;
        return this;
    }

    boolean hasSameComposingSpan(ContentCaptureEvent other) {
        return this.mComposingStart == other.mComposingStart && this.mComposingEnd == other.mComposingEnd;
    }

    boolean hasSameSelectionSpan(ContentCaptureEvent other) {
        return this.mSelectionStartIndex == other.mSelectionStartIndex && this.mSelectionEndIndex == other.mSelectionEndIndex;
    }

    private int getComposingStart() {
        return this.mComposingStart;
    }

    private int getComposingEnd() {
        return this.mComposingEnd;
    }

    private int getSelectionStart() {
        return this.mSelectionStartIndex;
    }

    private int getSelectionEnd() {
        return this.mSelectionEndIndex;
    }

    private void restoreComposingSpan() {
        if (this.mComposingStart <= -1 || this.mComposingEnd <= -1) {
            return;
        }
        if (this.mText instanceof Spannable) {
            BaseInputConnection.setComposingSpans((Spannable)this.mText, this.mComposingStart, this.mComposingEnd);
        } else {
            Log.w(TAG, "Text is not a Spannable.");
        }
    }

    private void restoreSelectionSpans() {
        if (this.mSelectionStartIndex <= -1 || this.mSelectionEndIndex <= -1) {
            return;
        }
        if (this.mText instanceof SpannableString) {
            SpannableString ss = (SpannableString)this.mText;
            ss.setSpan(Selection.SELECTION_START, this.mSelectionStartIndex, this.mSelectionStartIndex, 0);
            ss.setSpan(Selection.SELECTION_END, this.mSelectionEndIndex, this.mSelectionEndIndex, 0);
        } else {
            Log.w(TAG, "Text is not a SpannableString.");
        }
    }

    public ContentCaptureEvent setInsets(Insets insets) {
        this.mInsets = insets;
        return this;
    }

    public ContentCaptureEvent setBounds(Rect bounds) {
        this.mBounds = bounds;
        return this;
    }

    public int getType() {
        return this.mType;
    }

    public long getEventTime() {
        return this.mEventTime;
    }

    public ViewNode getViewNode() {
        return this.mNode;
    }

    public AutofillId getId() {
        return this.mId;
    }

    public List<AutofillId> getIds() {
        return this.mIds;
    }

    public CharSequence getText() {
        return this.mText;
    }

    public Insets getInsets() {
        return this.mInsets;
    }

    public Rect getBounds() {
        return this.mBounds;
    }

    public void mergeEvent(ContentCaptureEvent event) {
        Objects.requireNonNull(event);
        int eventType = event.getType();
        if (this.mType != eventType) {
            Log.e(TAG, "mergeEvent(" + ContentCaptureEvent.getTypeAsString(eventType) + ") cannot be merged with different eventType=" + ContentCaptureEvent.getTypeAsString(this.mType));
            return;
        }
        if (eventType == 2) {
            List<AutofillId> ids = event.getIds();
            AutofillId id2 = event.getId();
            if (ids != null) {
                if (id2 != null) {
                    Log.w(TAG, "got TYPE_VIEW_DISAPPEARED event with both id and ids: " + event);
                }
                for (int i = 0; i < ids.size(); ++i) {
                    this.addAutofillId(ids.get(i));
                }
                return;
            }
            if (id2 != null) {
                this.addAutofillId(id2);
                return;
            }
            throw new IllegalArgumentException("mergeEvent(): got TYPE_VIEW_DISAPPEARED event with neither id or ids: " + event);
        }
        if (eventType == 3) {
            this.setText(event.getText());
            this.setComposingIndex(event.getComposingStart(), event.getComposingEnd());
            this.setSelectionIndex(event.getSelectionStart(), event.getSelectionEnd());
        } else {
            Log.e(TAG, "mergeEvent(" + ContentCaptureEvent.getTypeAsString(eventType) + ") does not support this event type.");
        }
    }

    public void dump(PrintWriter pw) {
        pw.print("type=");
        pw.print(ContentCaptureEvent.getTypeAsString(this.mType));
        pw.print(", time=");
        pw.print(this.mEventTime);
        if (this.mId != null) {
            pw.print(", id=");
            pw.print(this.mId);
        }
        if (this.mIds != null) {
            pw.print(", ids=");
            pw.print(this.mIds);
        }
        if (this.mNode != null) {
            pw.print(", mNode.id=");
            pw.print(this.mNode.getAutofillId());
        }
        if (this.mSessionId != 0) {
            pw.print(", sessionId=");
            pw.print(this.mSessionId);
        }
        if (this.mParentSessionId != 0) {
            pw.print(", parentSessionId=");
            pw.print(this.mParentSessionId);
        }
        if (this.mText != null) {
            pw.print(", text=");
            pw.println(ContentCaptureHelper.getSanitizedString(this.mText));
        }
        if (this.mClientContext != null) {
            pw.print(", context=");
            this.mClientContext.dump(pw);
            pw.println();
        }
        if (this.mInsets != null) {
            pw.print(", insets=");
            pw.println(this.mInsets);
        }
        if (this.mBounds != null) {
            pw.print(", bounds=");
            pw.println(this.mBounds);
        }
        if (this.mComposingStart > -1) {
            pw.print(", composing(");
            pw.print(this.mComposingStart);
            pw.print(", ");
            pw.print(this.mComposingEnd);
            pw.print(")");
        }
        if (this.mSelectionStartIndex > -1) {
            pw.print(", selection(");
            pw.print(this.mSelectionStartIndex);
            pw.print(", ");
            pw.print(this.mSelectionEndIndex);
            pw.print(")");
        }
    }

    public String toString() {
        StringBuilder string2 = new StringBuilder("ContentCaptureEvent[type=").append(ContentCaptureEvent.getTypeAsString(this.mType));
        string2.append(", session=").append(this.mSessionId);
        if (this.mType == -1 && this.mParentSessionId != 0) {
            string2.append(", parent=").append(this.mParentSessionId);
        }
        if (this.mId != null) {
            string2.append(", id=").append(this.mId);
        }
        if (this.mIds != null) {
            string2.append(", ids=").append(this.mIds);
        }
        if (this.mNode != null) {
            String className = this.mNode.getClassName();
            string2.append(", class=").append(className);
            string2.append(", id=").append(this.mNode.getAutofillId());
            if (this.mNode.getText() != null) {
                string2.append(", text=").append((CharSequence)ContentCaptureHelper.getSanitizedString(this.mNode.getText()));
            }
        }
        if (this.mText != null) {
            string2.append(", text=").append((CharSequence)ContentCaptureHelper.getSanitizedString(this.mText));
        }
        if (this.mClientContext != null) {
            string2.append(", context=").append(this.mClientContext);
        }
        if (this.mInsets != null) {
            string2.append(", insets=").append(this.mInsets);
        }
        if (this.mBounds != null) {
            string2.append(", bounds=").append(this.mBounds);
        }
        if (this.mComposingStart > -1) {
            string2.append(", composing=[").append(this.mComposingStart).append(",").append(this.mComposingEnd).append("]");
        }
        if (this.mSelectionStartIndex > -1) {
            string2.append(", selection=[").append(this.mSelectionStartIndex).append(",").append(this.mSelectionEndIndex).append("]");
        }
        return string2.append(']').toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mSessionId);
        parcel.writeInt(this.mType);
        parcel.writeLong(this.mEventTime);
        parcel.writeParcelable(this.mId, flags);
        parcel.writeTypedList(this.mIds);
        ViewNode.writeToParcel(parcel, this.mNode, flags);
        parcel.writeCharSequence(this.mText);
        if (this.mType == -1 || this.mType == -2) {
            parcel.writeInt(this.mParentSessionId);
        }
        if (this.mType == -1 || this.mType == 6) {
            parcel.writeParcelable(this.mClientContext, flags);
        }
        if (this.mType == 9) {
            parcel.writeParcelable(this.mInsets, flags);
        }
        if (this.mType == 10) {
            parcel.writeParcelable(this.mBounds, flags);
        }
        if (this.mType == 3) {
            parcel.writeInt(this.mComposingStart);
            parcel.writeInt(this.mComposingEnd);
            parcel.writeInt(this.mSelectionStartIndex);
            parcel.writeInt(this.mSelectionEndIndex);
        }
    }

    public static String getTypeAsString(int type) {
        switch (type) {
            case -1: {
                return "SESSION_STARTED";
            }
            case -2: {
                return "SESSION_FINISHED";
            }
            case 7: {
                return "SESSION_RESUMED";
            }
            case 8: {
                return "SESSION_PAUSED";
            }
            case 1: {
                return "VIEW_APPEARED";
            }
            case 2: {
                return "VIEW_DISAPPEARED";
            }
            case 3: {
                return "VIEW_TEXT_CHANGED";
            }
            case 4: {
                return "VIEW_TREE_APPEARING";
            }
            case 5: {
                return "VIEW_TREE_APPEARED";
            }
            case 6: {
                return "CONTEXT_UPDATED";
            }
            case 9: {
                return "VIEW_INSETS_CHANGED";
            }
            case 10: {
                return "TYPE_WINDOW_BOUNDS_CHANGED";
            }
        }
        return "UKNOWN_TYPE: " + type;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EventType {
    }
}

