/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.List;

public class AnimationSet
extends Animation {
    private static final int PROPERTY_FILL_AFTER_MASK = 1;
    private static final int PROPERTY_FILL_BEFORE_MASK = 2;
    private static final int PROPERTY_REPEAT_MODE_MASK = 4;
    private static final int PROPERTY_START_OFFSET_MASK = 8;
    private static final int PROPERTY_SHARE_INTERPOLATOR_MASK = 16;
    private static final int PROPERTY_DURATION_MASK = 32;
    private static final int PROPERTY_MORPH_MATRIX_MASK = 64;
    private static final int PROPERTY_CHANGE_BOUNDS_MASK = 128;
    private int mFlags = 0;
    private boolean mDirty;
    private boolean mHasAlpha;
    private ArrayList<Animation> mAnimations = new ArrayList();
    private Transformation mTempTransformation = new Transformation();
    private long mLastEnd;
    private long[] mStoredOffsets;

    public AnimationSet(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AnimationSet);
        this.setFlag(16, a.getBoolean(1, true));
        this.init();
        if (context.getApplicationInfo().targetSdkVersion >= 14) {
            if (a.hasValue(0)) {
                this.mFlags |= 0x20;
            }
            if (a.hasValue(2)) {
                this.mFlags |= 2;
            }
            if (a.hasValue(3)) {
                this.mFlags |= 1;
            }
            if (a.hasValue(5)) {
                this.mFlags |= 4;
            }
            if (a.hasValue(4)) {
                this.mFlags |= 8;
            }
        }
        a.recycle();
    }

    public AnimationSet(boolean shareInterpolator) {
        this.setFlag(16, shareInterpolator);
        this.init();
    }

    @Override
    protected AnimationSet clone() throws CloneNotSupportedException {
        AnimationSet animation = (AnimationSet)super.clone();
        animation.mTempTransformation = new Transformation();
        animation.mAnimations = new ArrayList();
        int count = this.mAnimations.size();
        ArrayList<Animation> animations = this.mAnimations;
        for (int i = 0; i < count; ++i) {
            animation.mAnimations.add(animations.get(i).clone());
        }
        return animation;
    }

    private void setFlag(int mask, boolean value) {
        this.mFlags = value ? (this.mFlags |= mask) : (this.mFlags &= ~mask);
    }

    private void init() {
        this.mStartTime = 0L;
    }

    @Override
    public void setFillAfter(boolean fillAfter) {
        this.mFlags |= 1;
        super.setFillAfter(fillAfter);
    }

    @Override
    public void setFillBefore(boolean fillBefore) {
        this.mFlags |= 2;
        super.setFillBefore(fillBefore);
    }

    @Override
    public void setRepeatMode(int repeatMode) {
        this.mFlags |= 4;
        super.setRepeatMode(repeatMode);
    }

    @Override
    public void setStartOffset(long startOffset) {
        this.mFlags |= 8;
        super.setStartOffset(startOffset);
    }

    @Override
    public boolean hasAlpha() {
        if (this.mDirty) {
            this.mHasAlpha = false;
            this.mDirty = false;
            int count = this.mAnimations.size();
            ArrayList<Animation> animations = this.mAnimations;
            for (int i = 0; i < count; ++i) {
                if (!animations.get(i).hasAlpha()) continue;
                this.mHasAlpha = true;
                break;
            }
        }
        return this.mHasAlpha;
    }

    @Override
    public void setDuration(long durationMillis) {
        this.mFlags |= 0x20;
        super.setDuration(durationMillis);
        this.mLastEnd = this.mStartOffset + this.mDuration;
    }

    public void addAnimation(Animation a) {
        boolean changeBounds;
        boolean noMatrix;
        this.mAnimations.add(a);
        boolean bl = noMatrix = (this.mFlags & 0x40) == 0;
        if (noMatrix && a.willChangeTransformationMatrix()) {
            this.mFlags |= 0x40;
        }
        boolean bl2 = changeBounds = (this.mFlags & 0x80) == 0;
        if (changeBounds && a.willChangeBounds()) {
            this.mFlags |= 0x80;
        }
        if ((this.mFlags & 0x20) == 32) {
            this.mLastEnd = this.mStartOffset + this.mDuration;
        } else if (this.mAnimations.size() == 1) {
            this.mDuration = a.getStartOffset() + a.getDuration();
            this.mLastEnd = this.mStartOffset + this.mDuration;
        } else {
            this.mLastEnd = Math.max(this.mLastEnd, this.mStartOffset + a.getStartOffset() + a.getDuration());
            this.mDuration = this.mLastEnd - this.mStartOffset;
        }
        this.mDirty = true;
    }

    @Override
    public void setStartTime(long startTimeMillis) {
        super.setStartTime(startTimeMillis);
        int count = this.mAnimations.size();
        ArrayList<Animation> animations = this.mAnimations;
        for (int i = 0; i < count; ++i) {
            Animation a = animations.get(i);
            a.setStartTime(startTimeMillis);
        }
    }

    @Override
    public long getStartTime() {
        long startTime = Long.MAX_VALUE;
        int count = this.mAnimations.size();
        ArrayList<Animation> animations = this.mAnimations;
        for (int i = 0; i < count; ++i) {
            Animation a = animations.get(i);
            startTime = Math.min(startTime, a.getStartTime());
        }
        return startTime;
    }

    @Override
    public void restrictDuration(long durationMillis) {
        super.restrictDuration(durationMillis);
        ArrayList<Animation> animations = this.mAnimations;
        int count = animations.size();
        for (int i = 0; i < count; ++i) {
            animations.get(i).restrictDuration(durationMillis);
        }
    }

    @Override
    public long getDuration() {
        boolean durationSet;
        ArrayList<Animation> animations = this.mAnimations;
        int count = animations.size();
        long duration = 0L;
        boolean bl = durationSet = (this.mFlags & 0x20) == 32;
        if (durationSet) {
            duration = this.mDuration;
        } else {
            for (int i = 0; i < count; ++i) {
                duration = Math.max(duration, animations.get(i).getDuration());
            }
        }
        return duration;
    }

    @Override
    public long computeDurationHint() {
        long duration = 0L;
        int count = this.mAnimations.size();
        ArrayList<Animation> animations = this.mAnimations;
        for (int i = count - 1; i >= 0; --i) {
            long d = animations.get(i).computeDurationHint();
            if (d <= duration) continue;
            duration = d;
        }
        return duration;
    }

    @Override
    public void initializeInvalidateRegion(int left, int top, int right, int bottom) {
        RectF region = this.mPreviousRegion;
        region.set(left, top, right, bottom);
        region.inset(-1.0f, -1.0f);
        if (this.mFillBefore) {
            int count = this.mAnimations.size();
            ArrayList<Animation> animations = this.mAnimations;
            Transformation temp = this.mTempTransformation;
            Transformation previousTransformation = this.mPreviousTransformation;
            for (int i = count - 1; i >= 0; --i) {
                Animation a = animations.get(i);
                if (a.isFillEnabled() && !a.getFillBefore() && a.getStartOffset() != 0L) continue;
                temp.clear();
                Interpolator interpolator2 = a.mInterpolator;
                a.applyTransformation(interpolator2 != null ? interpolator2.getInterpolation(0.0f) : 0.0f, temp);
                previousTransformation.compose(temp);
            }
        }
    }

    @Override
    public void getTransformationAt(float interpolatedTime, Transformation t) {
        Transformation temp = this.mTempTransformation;
        for (int i = this.mAnimations.size() - 1; i >= 0; --i) {
            Animation a = this.mAnimations.get(i);
            temp.clear();
            a.getTransformationAt(interpolatedTime, t);
            t.compose(temp);
        }
    }

    @Override
    public boolean getTransformation(long currentTime, Transformation t) {
        int count = this.mAnimations.size();
        ArrayList<Animation> animations = this.mAnimations;
        Transformation temp = this.mTempTransformation;
        boolean more = false;
        boolean started = false;
        boolean ended = true;
        t.clear();
        for (int i = count - 1; i >= 0; --i) {
            Animation a = animations.get(i);
            temp.clear();
            more = a.getTransformation(currentTime, temp, this.getScaleFactor()) || more;
            t.compose(temp);
            started = started || a.hasStarted();
            ended = a.hasEnded() && ended;
        }
        if (started && !this.mStarted) {
            this.dispatchAnimationStart();
            this.mStarted = true;
        }
        if (ended != this.mEnded) {
            this.dispatchAnimationEnd();
            this.mEnded = ended;
        }
        return more;
    }

    @Override
    public void scaleCurrentDuration(float scale) {
        ArrayList<Animation> animations = this.mAnimations;
        int count = animations.size();
        for (int i = 0; i < count; ++i) {
            animations.get(i).scaleCurrentDuration(scale);
        }
    }

    @Override
    public void initialize(int width, int height, int parentWidth, int parentHeight) {
        boolean startOffsetSet;
        super.initialize(width, height, parentWidth, parentHeight);
        boolean durationSet = (this.mFlags & 0x20) == 32;
        boolean fillAfterSet = (this.mFlags & 1) == 1;
        boolean fillBeforeSet = (this.mFlags & 2) == 2;
        boolean repeatModeSet = (this.mFlags & 4) == 4;
        boolean shareInterpolator = (this.mFlags & 0x10) == 16;
        boolean bl = startOffsetSet = (this.mFlags & 8) == 8;
        if (shareInterpolator) {
            this.ensureInterpolator();
        }
        ArrayList<Animation> children = this.mAnimations;
        int count = children.size();
        long duration = this.mDuration;
        boolean fillAfter = this.mFillAfter;
        boolean fillBefore = this.mFillBefore;
        int repeatMode = this.mRepeatMode;
        Interpolator interpolator2 = this.mInterpolator;
        long startOffset = this.mStartOffset;
        long[] storedOffsets = this.mStoredOffsets;
        if (startOffsetSet) {
            if (storedOffsets == null || storedOffsets.length != count) {
                storedOffsets = this.mStoredOffsets = new long[count];
            }
        } else if (storedOffsets != null) {
            this.mStoredOffsets = null;
            storedOffsets = null;
        }
        for (int i = 0; i < count; ++i) {
            Animation a = children.get(i);
            if (durationSet) {
                a.setDuration(duration);
            }
            if (fillAfterSet) {
                a.setFillAfter(fillAfter);
            }
            if (fillBeforeSet) {
                a.setFillBefore(fillBefore);
            }
            if (repeatModeSet) {
                a.setRepeatMode(repeatMode);
            }
            if (shareInterpolator) {
                a.setInterpolator(interpolator2);
            }
            if (startOffsetSet) {
                long offset = a.getStartOffset();
                a.setStartOffset(offset + startOffset);
                storedOffsets[i] = offset;
            }
            a.initialize(width, height, parentWidth, parentHeight);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.restoreChildrenStartOffset();
    }

    void restoreChildrenStartOffset() {
        long[] offsets = this.mStoredOffsets;
        if (offsets == null) {
            return;
        }
        ArrayList<Animation> children = this.mAnimations;
        int count = children.size();
        for (int i = 0; i < count; ++i) {
            children.get(i).setStartOffset(offsets[i]);
        }
    }

    public List<Animation> getAnimations() {
        return this.mAnimations;
    }

    @Override
    public boolean willChangeTransformationMatrix() {
        return (this.mFlags & 0x40) == 64;
    }

    @Override
    public boolean willChangeBounds() {
        return (this.mFlags & 0x80) == 128;
    }

    @Override
    public boolean hasExtension() {
        for (Animation animation : this.mAnimations) {
            if (!animation.hasExtension()) continue;
            return true;
        }
        return false;
    }
}

