/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.accessibility.IRemoteMagnificationAnimationCallback;
import android.view.accessibility.IWindowMagnificationConnectionCallback;

public interface IWindowMagnificationConnection
extends IInterface {
    public static final String DESCRIPTOR = "android.view.accessibility.IWindowMagnificationConnection";

    public void enableWindowMagnification(int var1, float var2, float var3, float var4, float var5, float var6, IRemoteMagnificationAnimationCallback var7) throws RemoteException;

    public void setScale(int var1, float var2) throws RemoteException;

    public void disableWindowMagnification(int var1, IRemoteMagnificationAnimationCallback var2) throws RemoteException;

    public void moveWindowMagnifier(int var1, float var2, float var3) throws RemoteException;

    public void moveWindowMagnifierToPosition(int var1, float var2, float var3, IRemoteMagnificationAnimationCallback var4) throws RemoteException;

    public void showMagnificationButton(int var1, int var2) throws RemoteException;

    public void removeMagnificationButton(int var1) throws RemoteException;

    public void setConnectionCallback(IWindowMagnificationConnectionCallback var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWindowMagnificationConnection {
        static final int TRANSACTION_enableWindowMagnification = 1;
        static final int TRANSACTION_setScale = 2;
        static final int TRANSACTION_disableWindowMagnification = 3;
        static final int TRANSACTION_moveWindowMagnifier = 4;
        static final int TRANSACTION_moveWindowMagnifierToPosition = 5;
        static final int TRANSACTION_showMagnificationButton = 6;
        static final int TRANSACTION_removeMagnificationButton = 7;
        static final int TRANSACTION_setConnectionCallback = 8;

        public Stub() {
            this.attachInterface(this, IWindowMagnificationConnection.DESCRIPTOR);
        }

        public static IWindowMagnificationConnection asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IWindowMagnificationConnection.DESCRIPTOR);
            if (iin != null && iin instanceof IWindowMagnificationConnection) {
                return (IWindowMagnificationConnection)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "enableWindowMagnification";
                }
                case 2: {
                    return "setScale";
                }
                case 3: {
                    return "disableWindowMagnification";
                }
                case 4: {
                    return "moveWindowMagnifier";
                }
                case 5: {
                    return "moveWindowMagnifierToPosition";
                }
                case 6: {
                    return "showMagnificationButton";
                }
                case 7: {
                    return "removeMagnificationButton";
                }
                case 8: {
                    return "setConnectionCallback";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IWindowMagnificationConnection.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    float _arg1 = data.readFloat();
                    float _arg2 = data.readFloat();
                    float _arg3 = data.readFloat();
                    float _arg4 = data.readFloat();
                    float _arg5 = data.readFloat();
                    IRemoteMagnificationAnimationCallback _arg6 = IRemoteMagnificationAnimationCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.enableWindowMagnification(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    float _arg1 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setScale(_arg0, _arg1);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    IRemoteMagnificationAnimationCallback _arg1 = IRemoteMagnificationAnimationCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.disableWindowMagnification(_arg0, _arg1);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    float _arg1 = data.readFloat();
                    float _arg2 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.moveWindowMagnifier(_arg0, _arg1, _arg2);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    float _arg1 = data.readFloat();
                    float _arg2 = data.readFloat();
                    IRemoteMagnificationAnimationCallback _arg3 = IRemoteMagnificationAnimationCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.moveWindowMagnifierToPosition(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.showMagnificationButton(_arg0, _arg1);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.removeMagnificationButton(_arg0);
                    break;
                }
                case 8: {
                    IWindowMagnificationConnectionCallback _arg0 = IWindowMagnificationConnectionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setConnectionCallback(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 7;
        }

        private static class Proxy
        implements IWindowMagnificationConnection {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IWindowMagnificationConnection.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableWindowMagnification(int displayId, float scale, float centerX, float centerY, float magnificationFrameOffsetRatioX, float magnificationFrameOffsetRatioY, IRemoteMagnificationAnimationCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowMagnificationConnection.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeFloat(scale);
                    _data.writeFloat(centerX);
                    _data.writeFloat(centerY);
                    _data.writeFloat(magnificationFrameOffsetRatioX);
                    _data.writeFloat(magnificationFrameOffsetRatioY);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setScale(int displayId, float scale) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowMagnificationConnection.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeFloat(scale);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableWindowMagnification(int displayId, IRemoteMagnificationAnimationCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowMagnificationConnection.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void moveWindowMagnifier(int displayId, float offsetX, float offsetY) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowMagnificationConnection.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeFloat(offsetX);
                    _data.writeFloat(offsetY);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void moveWindowMagnifierToPosition(int displayId, float positionX, float positionY, IRemoteMagnificationAnimationCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowMagnificationConnection.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeFloat(positionX);
                    _data.writeFloat(positionY);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showMagnificationButton(int displayId, int magnificationMode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowMagnificationConnection.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(magnificationMode);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeMagnificationButton(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowMagnificationConnection.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setConnectionCallback(IWindowMagnificationConnectionCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IWindowMagnificationConnection.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWindowMagnificationConnection {
        @Override
        public void enableWindowMagnification(int displayId, float scale, float centerX, float centerY, float magnificationFrameOffsetRatioX, float magnificationFrameOffsetRatioY, IRemoteMagnificationAnimationCallback callback) throws RemoteException {
        }

        @Override
        public void setScale(int displayId, float scale) throws RemoteException {
        }

        @Override
        public void disableWindowMagnification(int displayId, IRemoteMagnificationAnimationCallback callback) throws RemoteException {
        }

        @Override
        public void moveWindowMagnifier(int displayId, float offsetX, float offsetY) throws RemoteException {
        }

        @Override
        public void moveWindowMagnifierToPosition(int displayId, float positionX, float positionY, IRemoteMagnificationAnimationCallback callback) throws RemoteException {
        }

        @Override
        public void showMagnificationButton(int displayId, int magnificationMode) throws RemoteException {
        }

        @Override
        public void removeMagnificationButton(int displayId) throws RemoteException {
        }

        @Override
        public void setConnectionCallback(IWindowMagnificationConnectionCallback callback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

