/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.accessibilityservice.IAccessibilityServiceConnection;
import android.graphics.Matrix;
import android.graphics.Region;
import android.os.Bundle;
import android.os.Process;
import android.os.RemoteException;
import android.view.MagnificationSpec;
import android.view.accessibility.IAccessibilityInteractionConnection;
import android.view.accessibility.IAccessibilityInteractionConnectionCallback;

class DirectAccessibilityConnection
extends IAccessibilityServiceConnection.Default {
    private final IAccessibilityInteractionConnection mAccessibilityInteractionConnection;
    private static final int FETCH_FLAGS = 384;
    private static final MagnificationSpec MAGNIFICATION_SPEC = new MagnificationSpec();
    private static final int PID = Process.myPid();
    private static final Region INTERACTIVE_REGION = null;
    private static final float[] TRANSFORM_MATRIX = new float[9];

    DirectAccessibilityConnection(IAccessibilityInteractionConnection accessibilityInteractionConnection) {
        this.mAccessibilityInteractionConnection = accessibilityInteractionConnection;
    }

    @Override
    public String[] findAccessibilityNodeInfoByAccessibilityId(int accessibilityWindowId, long accessibilityNodeId, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, long threadId, Bundle arguments) throws RemoteException {
        this.mAccessibilityInteractionConnection.findAccessibilityNodeInfoByAccessibilityId(accessibilityNodeId, INTERACTIVE_REGION, interactionId, callback, 384, PID, threadId, MAGNIFICATION_SPEC, TRANSFORM_MATRIX, arguments);
        return new String[0];
    }

    @Override
    public String[] findAccessibilityNodeInfosByText(int accessibilityWindowId, long accessibilityNodeId, String text, int interactionId, IAccessibilityInteractionConnectionCallback callback, long threadId) throws RemoteException {
        this.mAccessibilityInteractionConnection.findAccessibilityNodeInfosByText(accessibilityNodeId, text, INTERACTIVE_REGION, interactionId, callback, 384, PID, threadId, MAGNIFICATION_SPEC, TRANSFORM_MATRIX);
        return new String[0];
    }

    @Override
    public String[] findAccessibilityNodeInfosByViewId(int accessibilityWindowId, long accessibilityNodeId, String viewId, int interactionId, IAccessibilityInteractionConnectionCallback callback, long threadId) throws RemoteException {
        this.mAccessibilityInteractionConnection.findAccessibilityNodeInfosByViewId(accessibilityNodeId, viewId, INTERACTIVE_REGION, interactionId, callback, 384, PID, threadId, MAGNIFICATION_SPEC, TRANSFORM_MATRIX);
        return new String[0];
    }

    @Override
    public String[] findFocus(int accessibilityWindowId, long accessibilityNodeId, int focusType, int interactionId, IAccessibilityInteractionConnectionCallback callback, long threadId) throws RemoteException {
        this.mAccessibilityInteractionConnection.findFocus(accessibilityNodeId, focusType, INTERACTIVE_REGION, interactionId, callback, 384, PID, threadId, MAGNIFICATION_SPEC, TRANSFORM_MATRIX);
        return new String[0];
    }

    @Override
    public String[] focusSearch(int accessibilityWindowId, long accessibilityNodeId, int direction, int interactionId, IAccessibilityInteractionConnectionCallback callback, long threadId) throws RemoteException {
        this.mAccessibilityInteractionConnection.focusSearch(accessibilityNodeId, direction, INTERACTIVE_REGION, interactionId, callback, 384, PID, threadId, MAGNIFICATION_SPEC, TRANSFORM_MATRIX);
        return new String[0];
    }

    @Override
    public boolean performAccessibilityAction(int accessibilityWindowId, long accessibilityNodeId, int action, Bundle arguments, int interactionId, IAccessibilityInteractionConnectionCallback callback, long threadId) throws RemoteException {
        this.mAccessibilityInteractionConnection.performAccessibilityAction(accessibilityNodeId, action, arguments, interactionId, callback, 384, PID, threadId);
        return true;
    }

    static {
        Matrix.IDENTITY_MATRIX.getValues(TRANSFORM_MATRIX);
    }
}

