/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.ClipData;
import android.content.res.Configuration;
import android.graphics.PixelFormat;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.util.Log;
import android.util.MergedConfiguration;
import android.view.IWindow;
import android.view.IWindowId;
import android.view.IWindowSession;
import android.view.InputChannel;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.InsetsVisibilities;
import android.view.SurfaceControl;
import android.view.SurfaceSession;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import android.window.ClientWindowFrames;
import android.window.OnBackInvokedCallbackInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class WindowlessWindowManager
implements IWindowSession {
    private static final String TAG = "WindowlessWindowManager";
    final HashMap<IBinder, State> mStateForWindow = new HashMap();
    final HashMap<IBinder, ResizeCompleteCallback> mResizeCompletionForWindow = new HashMap();
    private final SurfaceSession mSurfaceSession = new SurfaceSession();
    protected final SurfaceControl mRootSurface;
    private final Configuration mConfiguration;
    private final IWindowSession mRealWm;
    private final IBinder mHostInputToken;
    private final IBinder mFocusGrantToken = new Binder();
    private InsetsState mInsetsState;
    private final ClientWindowFrames mTmpFrames = new ClientWindowFrames();
    private final MergedConfiguration mTmpConfig = new MergedConfiguration();

    public WindowlessWindowManager(Configuration c, SurfaceControl rootSurface, IBinder hostInputToken) {
        this.mRootSurface = rootSurface;
        this.mConfiguration = new Configuration(c);
        this.mRealWm = WindowManagerGlobal.getWindowSession();
        this.mHostInputToken = hostInputToken;
    }

    public void setConfiguration(Configuration configuration) {
        this.mConfiguration.setTo(configuration);
    }

    IBinder getFocusGrantToken() {
        return this.mFocusGrantToken;
    }

    void setCompletionCallback(IBinder window, ResizeCompleteCallback callback) {
        if (this.mResizeCompletionForWindow.get(window) != null) {
            Log.w(TAG, "Unsupported overlapping resizes");
        }
        this.mResizeCompletionForWindow.put(window, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTouchRegion(IBinder window, Region region) {
        WindowlessWindowManager windowlessWindowManager = this;
        synchronized (windowlessWindowManager) {
            State state = this.mStateForWindow.get(window);
            if (state == null) {
                return;
            }
            if (Objects.equals(region, state.mInputRegion)) {
                return;
            }
            Region region2 = state.mInputRegion = region != null ? new Region(region) : null;
            if (state.mInputChannelToken != null) {
                try {
                    this.mRealWm.updateInputChannel(state.mInputChannelToken, state.mDisplayId, state.mSurfaceControl, state.mParams.flags, state.mParams.privateFlags, state.mInputRegion);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Failed to update surface input channel: ", e);
                }
            }
        }
    }

    protected void attachToParentSurface(IWindow window, SurfaceControl.Builder b) {
        b.setParent(this.mRootSurface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addToDisplay(IWindow window, WindowManager.LayoutParams attrs, int viewVisibility, int displayId, InsetsVisibilities requestedVisibilities, InputChannel outInputChannel, InsetsState outInsetsState, InsetsSourceControl[] outActiveControls) {
        SurfaceControl.Builder b = new SurfaceControl.Builder(this.mSurfaceSession).setFormat(attrs.format).setBLASTLayer().setName(attrs.getTitle().toString()).setCallsite("WindowlessWindowManager.addToDisplay");
        this.attachToParentSurface(window, b);
        SurfaceControl sc = b.build();
        if ((attrs.inputFeatures & 1) == 0) {
            try {
                if (this.mRealWm instanceof IWindowSession.Stub) {
                    this.mRealWm.grantInputChannel(displayId, new SurfaceControl(sc, "WindowlessWindowManager.addToDisplay"), window, this.mHostInputToken, attrs.flags, attrs.privateFlags, attrs.type, this.mFocusGrantToken, attrs.getTitle().toString(), outInputChannel);
                } else {
                    this.mRealWm.grantInputChannel(displayId, sc, window, this.mHostInputToken, attrs.flags, attrs.privateFlags, attrs.type, this.mFocusGrantToken, attrs.getTitle().toString(), outInputChannel);
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to grant input to surface: ", e);
            }
        }
        State state = new State(sc, attrs, displayId, outInputChannel != null ? outInputChannel.getToken() : null, window);
        WindowlessWindowManager windowlessWindowManager = this;
        synchronized (windowlessWindowManager) {
            this.mStateForWindow.put(window.asBinder(), state);
        }
        int res = 10;
        return this.isInTouchMode() ? 11 : 10;
    }

    @Override
    public int addToDisplayAsUser(IWindow window, WindowManager.LayoutParams attrs, int viewVisibility, int displayId, int userId, InsetsVisibilities requestedVisibilities, InputChannel outInputChannel, InsetsState outInsetsState, InsetsSourceControl[] outActiveControls) {
        return this.addToDisplay(window, attrs, viewVisibility, displayId, requestedVisibilities, outInputChannel, outInsetsState, outActiveControls);
    }

    @Override
    public int addToDisplayWithoutInputChannel(IWindow window, WindowManager.LayoutParams attrs, int viewVisibility, int layerStackId, InsetsState insetsState) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(IWindow window) throws RemoteException {
        State state;
        this.mRealWm.remove(window);
        WindowlessWindowManager windowlessWindowManager = this;
        synchronized (windowlessWindowManager) {
            state = this.mStateForWindow.remove(window.asBinder());
        }
        if (state == null) {
            throw new IllegalArgumentException("Invalid window token (never added or removed already)");
        }
        this.removeSurface(state.mSurfaceControl);
    }

    protected void removeSurface(SurfaceControl sc) {
        try (SurfaceControl.Transaction t = new SurfaceControl.Transaction();){
            t.remove(sc).apply();
        }
    }

    private boolean isOpaque(WindowManager.LayoutParams attrs) {
        if (attrs.surfaceInsets != null && attrs.surfaceInsets.left != 0 || attrs.surfaceInsets.top != 0 || attrs.surfaceInsets.right != 0 || attrs.surfaceInsets.bottom != 0) {
            return false;
        }
        return !PixelFormat.formatHasAlpha(attrs.format);
    }

    private boolean isInTouchMode() {
        try {
            return WindowManagerGlobal.getWindowSession().getInTouchMode();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to check if the window is in touch mode", e);
            return false;
        }
    }

    protected IBinder getWindowBinder(View rootView) {
        ViewRootImpl root = rootView.getViewRootImpl();
        if (root == null) {
            return null;
        }
        return root.mWindow.asBinder();
    }

    protected SurfaceControl getSurfaceControl(View rootView) {
        ViewRootImpl root = rootView.getViewRootImpl();
        if (root == null) {
            return null;
        }
        return this.getSurfaceControl(root.mWindow);
    }

    protected SurfaceControl getSurfaceControl(IWindow window) {
        State s = this.mStateForWindow.get(window.asBinder());
        if (s == null) {
            return null;
        }
        return s.mSurfaceControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int relayout(IWindow window, WindowManager.LayoutParams inAttrs, int requestedWidth, int requestedHeight, int viewFlags, int flags, ClientWindowFrames outFrames, MergedConfiguration mergedConfiguration, SurfaceControl outSurfaceControl, InsetsState outInsetsState, InsetsSourceControl[] outActiveControls, Bundle outSyncSeqIdBundle) {
        State state;
        WindowlessWindowManager windowlessWindowManager = this;
        synchronized (windowlessWindowManager) {
            state = this.mStateForWindow.get(window.asBinder());
        }
        if (state == null) {
            throw new IllegalArgumentException("Invalid window token (never added or removed already)");
        }
        SurfaceControl sc = state.mSurfaceControl;
        SurfaceControl.Transaction t = new SurfaceControl.Transaction();
        int attrChanges = 0;
        if (inAttrs != null) {
            attrChanges = state.mParams.copyFrom(inAttrs);
        }
        WindowManager.LayoutParams attrs = state.mParams;
        if (viewFlags == 0) {
            t.setOpaque(sc, this.isOpaque(attrs)).show(sc).apply();
            outSurfaceControl.copyFrom(sc, "WindowlessWindowManager.relayout");
        } else {
            t.hide(sc).apply();
            outSurfaceControl.release();
        }
        outFrames.frame.set(0, 0, attrs.width, attrs.height);
        outFrames.displayFrame.set(outFrames.frame);
        mergedConfiguration.setConfiguration(this.mConfiguration, this.mConfiguration);
        if ((attrChanges & 4) != 0 && state.mInputChannelToken != null) {
            try {
                if (this.mRealWm instanceof IWindowSession.Stub) {
                    this.mRealWm.updateInputChannel(state.mInputChannelToken, state.mDisplayId, new SurfaceControl(sc, "WindowlessWindowManager.relayout"), attrs.flags, attrs.privateFlags, state.mInputRegion);
                } else {
                    this.mRealWm.updateInputChannel(state.mInputChannelToken, state.mDisplayId, sc, attrs.flags, attrs.privateFlags, state.mInputRegion);
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, "Failed to update surface input channel: ", e);
            }
        }
        if (this.mInsetsState != null) {
            outInsetsState.set(this.mInsetsState);
        }
        return 0;
    }

    @Override
    public int updateVisibility(IWindow window, WindowManager.LayoutParams inAttrs, int viewVisibility, MergedConfiguration outMergedConfiguration, SurfaceControl outSurfaceControl, InsetsState outInsetsState, InsetsSourceControl[] outActiveControls) {
        return 0;
    }

    @Override
    public void updateLayout(IWindow window, WindowManager.LayoutParams inAttrs, int flags, ClientWindowFrames clientWindowFrames, int requestedWidth, int requestedHeight) {
    }

    @Override
    public void prepareToReplaceWindows(IBinder appToken, boolean childrenOnly) {
    }

    @Override
    public boolean outOfMemory(IWindow window) {
        return false;
    }

    @Override
    public void setInsets(IWindow window, int touchableInsets, Rect contentInsets, Rect visibleInsets, Region touchableRegion) {
        this.setTouchRegion(window.asBinder(), touchableRegion);
    }

    @Override
    public void clearTouchableRegion(IWindow window) {
        this.setTouchRegion(window.asBinder(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishDrawing(IWindow window, SurfaceControl.Transaction postDrawTransaction, int seqId) {
        WindowlessWindowManager windowlessWindowManager = this;
        synchronized (windowlessWindowManager) {
            ResizeCompleteCallback c = this.mResizeCompletionForWindow.get(window.asBinder());
            if (c == null) {
                postDrawTransaction.apply();
                return;
            }
            c.finished(postDrawTransaction);
            this.mResizeCompletionForWindow.remove(window.asBinder());
        }
    }

    @Override
    public void setInTouchMode(boolean showFocus) {
    }

    @Override
    public boolean getInTouchMode() {
        return false;
    }

    @Override
    public boolean performHapticFeedback(int effectId, boolean always) {
        return false;
    }

    @Override
    public IBinder performDrag(IWindow window, int flags, SurfaceControl surface, int touchSource, float touchX, float touchY, float thumbCenterX, float thumbCenterY, ClipData data) {
        return null;
    }

    @Override
    public void reportDropResult(IWindow window, boolean consumed) {
    }

    @Override
    public void cancelDragAndDrop(IBinder dragToken, boolean skipAnimation) {
    }

    @Override
    public void dragRecipientEntered(IWindow window) {
    }

    @Override
    public void dragRecipientExited(IWindow window) {
    }

    @Override
    public void setWallpaperPosition(IBinder windowToken, float x, float y, float xstep, float ystep) {
    }

    @Override
    public void setWallpaperZoomOut(IBinder windowToken, float zoom) {
    }

    @Override
    public void setShouldZoomOutWallpaper(IBinder windowToken, boolean shouldZoom) {
    }

    @Override
    public void wallpaperOffsetsComplete(IBinder window) {
    }

    @Override
    public void setWallpaperDisplayOffset(IBinder windowToken, int x, int y) {
    }

    @Override
    public Bundle sendWallpaperCommand(IBinder window, String action, int x, int y, int z, Bundle extras, boolean sync) {
        return null;
    }

    @Override
    public void wallpaperCommandComplete(IBinder window, Bundle result) {
    }

    @Override
    public void onRectangleOnScreenRequested(IBinder token, Rect rectangle) {
    }

    @Override
    public IWindowId getWindowId(IBinder window) {
        return null;
    }

    @Override
    public void pokeDrawLock(IBinder window) {
    }

    @Override
    public boolean startMovingTask(IWindow window, float startX, float startY) {
        return false;
    }

    @Override
    public void finishMovingTask(IWindow window) {
    }

    @Override
    public void updatePointerIcon(IWindow window) {
    }

    @Override
    public void updateTapExcludeRegion(IWindow window, Region region) {
    }

    @Override
    public void updateRequestedVisibilities(IWindow window, InsetsVisibilities visibilities) {
    }

    @Override
    public void reportSystemGestureExclusionChanged(IWindow window, List<Rect> exclusionRects) {
    }

    @Override
    public void reportKeepClearAreasChanged(IWindow window, List<Rect> restrictedRects, List<Rect> unrestrictedRects) {
    }

    @Override
    public void grantInputChannel(int displayId, SurfaceControl surface, IWindow window, IBinder hostInputToken, int flags, int privateFlags, int type, IBinder focusGrantToken, String inputHandleName, InputChannel outInputChannel) {
    }

    @Override
    public void updateInputChannel(IBinder channelToken, int displayId, SurfaceControl surface, int flags, int privateFlags, Region region) {
    }

    @Override
    public IBinder asBinder() {
        return null;
    }

    @Override
    public void grantEmbeddedWindowFocus(IWindow callingWindow, IBinder targetInputToken, boolean grantFocus) {
    }

    @Override
    public void generateDisplayHash(IWindow window, Rect boundsInWindow, String hashAlgorithm, RemoteCallback callback) {
    }

    @Override
    public void setOnBackInvokedCallbackInfo(IWindow iWindow, OnBackInvokedCallbackInfo callbackInfo) throws RemoteException {
    }

    @Override
    public boolean dropForAccessibility(IWindow window, int x, int y) {
        return false;
    }

    public void setInsetsState(InsetsState state) {
        this.mInsetsState = state;
        for (State s : this.mStateForWindow.values()) {
            try {
                this.mTmpFrames.frame.set(0, 0, s.mParams.width, s.mParams.height);
                this.mTmpFrames.displayFrame.set(this.mTmpFrames.frame);
                this.mTmpConfig.setConfiguration(this.mConfiguration, this.mConfiguration);
                s.mClient.resized(this.mTmpFrames, false, this.mTmpConfig, state, false, false, s.mDisplayId, Integer.MAX_VALUE, -1);
            }
            catch (RemoteException remoteException) {}
        }
    }

    public static interface ResizeCompleteCallback {
        public void finished(SurfaceControl.Transaction var1);
    }

    private class State {
        SurfaceControl mSurfaceControl;
        WindowManager.LayoutParams mParams = new WindowManager.LayoutParams();
        int mDisplayId;
        IBinder mInputChannelToken;
        Region mInputRegion;
        IWindow mClient;

        State(SurfaceControl sc, WindowManager.LayoutParams p, int displayId, IBinder inputChannelToken, IWindow client) {
            this.mSurfaceControl = sc;
            this.mParams.copyFrom(p);
            this.mDisplayId = displayId;
            this.mInputChannelToken = inputChannelToken;
            this.mClient = client;
        }
    }
}

