/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.RequiresPermission;
import android.os.IBinder;
import android.util.ArrayMap;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.Objects;
import libcore.util.NativeAllocationRegistry;

public abstract class SurfaceControlHdrLayerInfoListener {
    private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(SurfaceControlHdrLayerInfoListener.class.getClassLoader(), SurfaceControlHdrLayerInfoListener.nGetDestructor());
    private ArrayMap<IBinder, Runnable> mRegisteredListeners = new ArrayMap();

    public abstract void onHdrInfoChanged(IBinder var1, int var2, int var3, int var4, int var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.CONTROL_DISPLAY_BRIGHTNESS")
    public void register(IBinder displayToken) {
        Objects.requireNonNull(displayToken);
        SurfaceControlHdrLayerInfoListener surfaceControlHdrLayerInfoListener = this;
        synchronized (surfaceControlHdrLayerInfoListener) {
            if (this.mRegisteredListeners.containsKey(displayToken)) {
                return;
            }
            long nativePtr = this.nRegister(displayToken);
            Runnable destructor = sRegistry.registerNativeAllocation(this, nativePtr);
            this.mRegisteredListeners.put(displayToken, destructor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.CONTROL_DISPLAY_BRIGHTNESS")
    public void unregister(IBinder displayToken) {
        Runnable destructor;
        Objects.requireNonNull(displayToken);
        SurfaceControlHdrLayerInfoListener surfaceControlHdrLayerInfoListener = this;
        synchronized (surfaceControlHdrLayerInfoListener) {
            destructor = this.mRegisteredListeners.remove(displayToken);
        }
        if (destructor != null) {
            destructor.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.CONTROL_DISPLAY_BRIGHTNESS")
    public void unregisterAll() {
        ArrayMap<IBinder, Runnable> toDestroy;
        SurfaceControlHdrLayerInfoListener surfaceControlHdrLayerInfoListener = this;
        synchronized (surfaceControlHdrLayerInfoListener) {
            toDestroy = this.mRegisteredListeners;
            this.mRegisteredListeners = new ArrayMap();
        }
        for (Runnable destructor : toDestroy.values()) {
            destructor.run();
        }
    }

    private static long nGetDestructor() {
        return OverrideMethod.invokeL("android.view.SurfaceControlHdrLayerInfoListener#nGetDestructor()J", true, null);
    }

    private long nRegister(IBinder iBinder) {
        return OverrideMethod.invokeL("android.view.SurfaceControlHdrLayerInfoListener#nRegister(Landroid/os/IBinder;)J", true, this);
    }
}

