/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.hardware.display.DisplayManager;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.util.SparseArray;
import android.view.PointerIcon_Delegate;
import com.android.internal.R;
import com.android.internal.util.XmlUtils;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

public class PointerIcon
implements Parcelable {
    private static final String TAG = "PointerIcon";
    public static final int TYPE_CUSTOM = -1;
    public static final int TYPE_NULL = 0;
    public static final int TYPE_NOT_SPECIFIED = 1;
    public static final int TYPE_ARROW = 1000;
    public static final int TYPE_SPOT_HOVER = 2000;
    public static final int TYPE_SPOT_TOUCH = 2001;
    public static final int TYPE_SPOT_ANCHOR = 2002;
    public static final int TYPE_CONTEXT_MENU = 1001;
    public static final int TYPE_HAND = 1002;
    public static final int TYPE_HELP = 1003;
    public static final int TYPE_WAIT = 1004;
    public static final int TYPE_CELL = 1006;
    public static final int TYPE_CROSSHAIR = 1007;
    public static final int TYPE_TEXT = 1008;
    public static final int TYPE_VERTICAL_TEXT = 1009;
    public static final int TYPE_ALIAS = 1010;
    public static final int TYPE_COPY = 1011;
    public static final int TYPE_NO_DROP = 1012;
    public static final int TYPE_ALL_SCROLL = 1013;
    public static final int TYPE_HORIZONTAL_DOUBLE_ARROW = 1014;
    public static final int TYPE_VERTICAL_DOUBLE_ARROW = 1015;
    public static final int TYPE_TOP_RIGHT_DIAGONAL_DOUBLE_ARROW = 1016;
    public static final int TYPE_TOP_LEFT_DIAGONAL_DOUBLE_ARROW = 1017;
    public static final int TYPE_ZOOM_IN = 1018;
    public static final int TYPE_ZOOM_OUT = 1019;
    public static final int TYPE_GRAB = 1020;
    public static final int TYPE_GRABBING = 1021;
    private static final int TYPE_OEM_FIRST = 10000;
    public static final int TYPE_DEFAULT = 1000;
    private static final PointerIcon gNullIcon = new PointerIcon(0);
    private static final SparseArray<SparseArray<PointerIcon>> gSystemIconsByDisplay = new SparseArray();
    private static boolean sUseLargeIcons = false;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private final int mType;
    private int mSystemIconResourceId;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private Bitmap mBitmap;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private float mHotSpotX;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private float mHotSpotY;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private Bitmap[] mBitmapFrames;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private int mDurationPerFrame;
    private static DisplayManager.DisplayListener sDisplayListener;
    public static final Parcelable.Creator<PointerIcon> CREATOR;

    private PointerIcon(int type) {
        this.mType = type;
    }

    public static PointerIcon getNullIcon() {
        return gNullIcon;
    }

    public static PointerIcon getDefaultIcon(Context context) {
        return PointerIcon.getSystemIcon(context, 1000);
    }

    public static PointerIcon getSystemIcon(Context context, int type) {
        PointerIcon icon;
        int displayId;
        SparseArray<PointerIcon> systemIcons;
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        if (type == 0) {
            return gNullIcon;
        }
        if (sDisplayListener == null) {
            PointerIcon.registerDisplayListener(context);
        }
        if ((systemIcons = gSystemIconsByDisplay.get(displayId = context.getDisplayId())) == null) {
            systemIcons = new SparseArray();
            gSystemIconsByDisplay.put(displayId, systemIcons);
        }
        if ((icon = systemIcons.get(type)) != null) {
            return icon;
        }
        int typeIndex = PointerIcon.getSystemIconTypeIndex(type);
        if (typeIndex == 0) {
            typeIndex = PointerIcon.getSystemIconTypeIndex(1000);
        }
        int defStyle = sUseLargeIcons ? 16974645 : 16974655;
        TypedArray a = context.obtainStyledAttributes(null, R.styleable.Pointer, 0, defStyle);
        int resourceId = a.getResourceId(typeIndex, -1);
        a.recycle();
        if (resourceId == -1) {
            Log.w(TAG, "Missing theme resources for pointer icon type " + type);
            return type == 1000 ? gNullIcon : PointerIcon.getSystemIcon(context, 1000);
        }
        icon = new PointerIcon(type);
        if ((resourceId & 0xFF000000) == 0x1000000) {
            icon.mSystemIconResourceId = resourceId;
        } else {
            icon.loadResource(context, context.getResources(), resourceId);
        }
        systemIcons.append(type, icon);
        return icon;
    }

    public static void setUseLargeIcons(boolean use) {
        sUseLargeIcons = use;
        gSystemIconsByDisplay.clear();
    }

    public static PointerIcon create(Bitmap bitmap, float hotSpotX, float hotSpotY) {
        if (bitmap == null) {
            throw new IllegalArgumentException("bitmap must not be null");
        }
        PointerIcon.validateHotSpot(bitmap, hotSpotX, hotSpotY);
        PointerIcon icon = new PointerIcon(-1);
        icon.mBitmap = bitmap;
        icon.mHotSpotX = hotSpotX;
        icon.mHotSpotY = hotSpotY;
        return icon;
    }

    public static PointerIcon load(Resources resources, int resourceId) {
        if (resources == null) {
            throw new IllegalArgumentException("resources must not be null");
        }
        PointerIcon icon = new PointerIcon(-1);
        icon.loadResource(null, resources, resourceId);
        return icon;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public PointerIcon load(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        if (this.mSystemIconResourceId == 0 || this.mBitmap != null) {
            return this;
        }
        PointerIcon result = new PointerIcon(this.mType);
        result.mSystemIconResourceId = this.mSystemIconResourceId;
        result.loadResource(context, context.getResources(), this.mSystemIconResourceId);
        return result;
    }

    public int getType() {
        return this.mType;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mType);
        if (this.mType != 0) {
            out.writeInt(this.mSystemIconResourceId);
            if (this.mSystemIconResourceId == 0) {
                this.mBitmap.writeToParcel(out, flags);
                out.writeFloat(this.mHotSpotX);
                out.writeFloat(this.mHotSpotY);
            }
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof PointerIcon)) {
            return false;
        }
        PointerIcon otherIcon = (PointerIcon)other;
        if (this.mType != otherIcon.mType || this.mSystemIconResourceId != otherIcon.mSystemIconResourceId) {
            return false;
        }
        return this.mSystemIconResourceId != 0 || this.mBitmap == otherIcon.mBitmap && this.mHotSpotX == otherIcon.mHotSpotX && this.mHotSpotY == otherIcon.mHotSpotY;
    }

    private Bitmap getBitmapFromDrawable(BitmapDrawable bitmapDrawable) {
        Bitmap bitmap = bitmapDrawable.getBitmap();
        int scaledWidth = bitmapDrawable.getIntrinsicWidth();
        int scaledHeight = bitmapDrawable.getIntrinsicHeight();
        if (scaledWidth == bitmap.getWidth() && scaledHeight == bitmap.getHeight()) {
            return bitmap;
        }
        Rect src = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        RectF dst = new RectF(0.0f, 0.0f, scaledWidth, scaledHeight);
        Bitmap scaled = Bitmap.createBitmap(scaledWidth, scaledHeight, bitmap.getConfig());
        Canvas canvas = new Canvas(scaled);
        Paint paint = new Paint();
        paint.setFilterBitmap(true);
        canvas.drawBitmap(bitmap, src, dst, paint);
        return scaled;
    }

    void loadResource_Original(Context context, Resources resources, int resourceId) {
        float hotSpotY;
        float hotSpotX;
        int bitmapRes;
        try (XmlResourceParser parser = resources.getXml(resourceId);){
            XmlUtils.beginDocument(parser, "pointer-icon");
            TypedArray a = resources.obtainAttributes(parser, R.styleable.PointerIcon);
            bitmapRes = a.getResourceId(0, 0);
            hotSpotX = a.getDimension(1, 0.0f);
            hotSpotY = a.getDimension(2, 0.0f);
            a.recycle();
        }
        if (bitmapRes == 0) {
            throw new IllegalArgumentException("<pointer-icon> is missing bitmap attribute.");
        }
        Drawable drawable2 = context == null ? resources.getDrawable(bitmapRes) : context.getDrawable(bitmapRes);
        if (drawable2 instanceof AnimationDrawable) {
            AnimationDrawable animationDrawable = (AnimationDrawable)drawable2;
            int frames = animationDrawable.getNumberOfFrames();
            drawable2 = animationDrawable.getFrame(0);
            if (frames == 1) {
                Log.w(TAG, "Animation icon with single frame -- simply treating the first frame as a normal bitmap icon.");
            } else {
                this.mDurationPerFrame = animationDrawable.getDuration(0);
                this.mBitmapFrames = new Bitmap[frames - 1];
                int width = drawable2.getIntrinsicWidth();
                int height = drawable2.getIntrinsicHeight();
                for (int i = 1; i < frames; ++i) {
                    Drawable drawableFrame = animationDrawable.getFrame(i);
                    if (!(drawableFrame instanceof BitmapDrawable)) {
                        throw new IllegalArgumentException("Frame of an animated pointer icon must refer to a bitmap drawable.");
                    }
                    if (drawableFrame.getIntrinsicWidth() != width || drawableFrame.getIntrinsicHeight() != height) {
                        throw new IllegalArgumentException("The bitmap size of " + i + "-th frame is different. All frames should have the exact same size and share the same hotspot.");
                    }
                    BitmapDrawable bitmapDrawableFrame = (BitmapDrawable)drawableFrame;
                    this.mBitmapFrames[i - 1] = this.getBitmapFromDrawable(bitmapDrawableFrame);
                }
            }
        }
        if (!(drawable2 instanceof BitmapDrawable)) {
            throw new IllegalArgumentException("<pointer-icon> bitmap attribute must refer to a bitmap drawable.");
        }
        BitmapDrawable bitmapDrawable = (BitmapDrawable)drawable2;
        Bitmap bitmap = this.getBitmapFromDrawable(bitmapDrawable);
        PointerIcon.validateHotSpot(bitmap, hotSpotX, hotSpotY);
        this.mBitmap = bitmap;
        this.mHotSpotX = hotSpotX;
        this.mHotSpotY = hotSpotY;
    }

    @LayoutlibDelegate
    private void loadResource(Context context, Resources resources, int n) {
        PointerIcon_Delegate.loadResource(this, context, resources, n);
    }

    private static void validateHotSpot(Bitmap bitmap, float hotSpotX, float hotSpotY) {
        if (hotSpotX < 0.0f || hotSpotX >= (float)bitmap.getWidth()) {
            throw new IllegalArgumentException("x hotspot lies outside of the bitmap area");
        }
        if (hotSpotY < 0.0f || hotSpotY >= (float)bitmap.getHeight()) {
            throw new IllegalArgumentException("y hotspot lies outside of the bitmap area");
        }
    }

    private static int getSystemIconTypeIndex(int type) {
        switch (type) {
            case 1000: {
                return 2;
            }
            case 2000: {
                return 14;
            }
            case 2001: {
                return 15;
            }
            case 2002: {
                return 13;
            }
            case 1002: {
                return 9;
            }
            case 1001: {
                return 4;
            }
            case 1003: {
                return 10;
            }
            case 1004: {
                return 21;
            }
            case 1006: {
                return 3;
            }
            case 1007: {
                return 6;
            }
            case 1008: {
                return 16;
            }
            case 1009: {
                return 20;
            }
            case 1010: {
                return 0;
            }
            case 1011: {
                return 5;
            }
            case 1013: {
                return 1;
            }
            case 1012: {
                return 12;
            }
            case 1014: {
                return 11;
            }
            case 1015: {
                return 19;
            }
            case 1016: {
                return 18;
            }
            case 1017: {
                return 17;
            }
            case 1018: {
                return 22;
            }
            case 1019: {
                return 23;
            }
            case 1020: {
                return 7;
            }
            case 1021: {
                return 8;
            }
        }
        return 0;
    }

    static void registerDisplayListener_Original(Context context) {
        sDisplayListener = new DisplayManager.DisplayListener(){

            @Override
            public void onDisplayAdded(int displayId) {
            }

            @Override
            public void onDisplayRemoved(int displayId) {
                gSystemIconsByDisplay.remove(displayId);
            }

            @Override
            public void onDisplayChanged(int displayId) {
                gSystemIconsByDisplay.remove(displayId);
            }
        };
        DisplayManager displayManager = context.getSystemService(DisplayManager.class);
        displayManager.registerDisplayListener(sDisplayListener, null);
    }

    @LayoutlibDelegate
    private static void registerDisplayListener(Context context) {
        PointerIcon_Delegate.registerDisplayListener(context);
    }

    static {
        CREATOR = new Parcelable.Creator<PointerIcon>(){

            @Override
            public PointerIcon createFromParcel(Parcel in) {
                int type = in.readInt();
                if (type == 0) {
                    return PointerIcon.getNullIcon();
                }
                int systemIconResourceId = in.readInt();
                if (systemIconResourceId != 0) {
                    PointerIcon icon = new PointerIcon(type);
                    icon.mSystemIconResourceId = systemIconResourceId;
                    return icon;
                }
                Bitmap bitmap = Bitmap.CREATOR.createFromParcel(in);
                float hotSpotX = in.readFloat();
                float hotSpotY = in.readFloat();
                return PointerIcon.create(bitmap, hotSpotX, hotSpotY);
            }

            public PointerIcon[] newArray(int size) {
                return new PointerIcon[size];
            }
        };
    }
}

