/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Parcel;
import android.os.Parcelable;

public class MagnificationSpec
implements Parcelable {
    public float scale = 1.0f;
    public float offsetX;
    public float offsetY;
    public static final Parcelable.Creator<MagnificationSpec> CREATOR = new Parcelable.Creator<MagnificationSpec>(){

        public MagnificationSpec[] newArray(int size) {
            return new MagnificationSpec[size];
        }

        @Override
        public MagnificationSpec createFromParcel(Parcel parcel) {
            MagnificationSpec spec = new MagnificationSpec();
            spec.initFromParcel(parcel);
            return spec;
        }
    };

    public void initialize(float scale, float offsetX, float offsetY) {
        if (scale < 1.0f) {
            throw new IllegalArgumentException("Scale must be greater than or equal to one!");
        }
        this.scale = scale;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public boolean isNop() {
        return this.scale == 1.0f && this.offsetX == 0.0f && this.offsetY == 0.0f;
    }

    public void clear() {
        this.scale = 1.0f;
        this.offsetX = 0.0f;
        this.offsetY = 0.0f;
    }

    public void setTo(MagnificationSpec other) {
        this.scale = other.scale;
        this.offsetX = other.offsetX;
        this.offsetY = other.offsetY;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeFloat(this.scale);
        parcel.writeFloat(this.offsetX);
        parcel.writeFloat(this.offsetY);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MagnificationSpec s = (MagnificationSpec)other;
        return this.scale == s.scale && this.offsetX == s.offsetX && this.offsetY == s.offsetY;
    }

    public int hashCode() {
        int result = this.scale != 0.0f ? Float.floatToIntBits(this.scale) : 0;
        result = 31 * result + (this.offsetX != 0.0f ? Float.floatToIntBits(this.offsetX) : 0);
        result = 31 * result + (this.offsetY != 0.0f ? Float.floatToIntBits(this.offsetY) : 0);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<scale:");
        builder.append(Float.toString(this.scale));
        builder.append(",offsetX:");
        builder.append(Float.toString(this.offsetX));
        builder.append(",offsetY:");
        builder.append(Float.toString(this.offsetY));
        builder.append(">");
        return builder.toString();
    }

    private void initFromParcel(Parcel parcel) {
        this.scale = parcel.readFloat();
        this.offsetX = parcel.readFloat();
        this.offsetY = parcel.readFloat();
    }
}

