/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.RequiresPermission;
import android.app.IAssistDataReceiver;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.IRemoteCallback;
import android.os.Parcel;
import android.os.RemoteException;
import android.text.TextUtils;
import android.view.DisplayInfo;
import android.view.IAppTransitionAnimationSpecsFuture;
import android.view.ICrossWindowBlurEnabledListener;
import android.view.IDisplayFoldListener;
import android.view.IDisplayWindowInsetsController;
import android.view.IDisplayWindowListener;
import android.view.IDisplayWindowRotationController;
import android.view.IOnKeyguardExitResult;
import android.view.IPinnedTaskListener;
import android.view.IRotationWatcher;
import android.view.IScrollCaptureResponseListener;
import android.view.ISystemGestureExclusionListener;
import android.view.IWallpaperVisibilityListener;
import android.view.IWindow;
import android.view.IWindowSession;
import android.view.IWindowSessionCallback;
import android.view.InputChannel;
import android.view.InsetsState;
import android.view.InsetsVisibilities;
import android.view.RemoteAnimationAdapter;
import android.view.SurfaceControl;
import android.view.TaskTransitionSpec;
import android.view.WindowContentFrameStats;
import android.view.WindowManager;
import android.view.displayhash.DisplayHash;
import android.view.displayhash.VerifiedDisplayHash;
import android.window.ITaskFpsCallback;
import com.android.internal.os.IResultReceiver;
import com.android.internal.policy.IKeyguardDismissCallback;
import com.android.internal.policy.IKeyguardLockedStateListener;
import com.android.internal.policy.IShortcutService;
import java.util.ArrayList;
import java.util.List;

public interface IWindowManager
extends IInterface {
    public static final int FIXED_TO_USER_ROTATION_DEFAULT = 0;
    public static final int FIXED_TO_USER_ROTATION_DISABLED = 1;
    public static final int FIXED_TO_USER_ROTATION_ENABLED = 2;

    public boolean startViewServer(int var1) throws RemoteException;

    public boolean stopViewServer() throws RemoteException;

    public boolean isViewServerRunning() throws RemoteException;

    public IWindowSession openSession(IWindowSessionCallback var1) throws RemoteException;

    public boolean useBLAST() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:108:1:108:25")
    public void getInitialDisplaySize(int var1, Point var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:110:1:110:25")
    public void getBaseDisplaySize(int var1, Point var2) throws RemoteException;

    public void setForcedDisplaySize(int var1, int var2, int var3) throws RemoteException;

    public void clearForcedDisplaySize(int var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:114:1:114:25")
    public int getInitialDisplayDensity(int var1) throws RemoteException;

    public int getBaseDisplayDensity(int var1) throws RemoteException;

    public void setForcedDisplayDensityForUser(int var1, int var2, int var3) throws RemoteException;

    public void clearForcedDisplayDensityForUser(int var1, int var2) throws RemoteException;

    public void setForcedDisplayScalingMode(int var1, int var2) throws RemoteException;

    public void setEventDispatching(boolean var1) throws RemoteException;

    public boolean isWindowToken(IBinder var1) throws RemoteException;

    public void addWindowToken(IBinder var1, int var2, int var3, Bundle var4) throws RemoteException;

    public void removeWindowToken(IBinder var1, int var2) throws RemoteException;

    public void setDisplayWindowRotationController(IDisplayWindowRotationController var1) throws RemoteException;

    public SurfaceControl addShellRoot(int var1, IWindow var2, int var3) throws RemoteException;

    public void setShellRootAccessibilityWindow(int var1, int var2, IWindow var3) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:173:1:173:25")
    public void overridePendingAppTransitionMultiThumbFuture(IAppTransitionAnimationSpecsFuture var1, IRemoteCallback var2, boolean var3, int var4) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:177:1:177:25")
    public void overridePendingAppTransitionRemote(RemoteAnimationAdapter var1, int var2) throws RemoteException;

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:185:1:185:69")
    public void endProlongedAnimations() throws RemoteException;

    public void startFreezingScreen(int var1, int var2) throws RemoteException;

    public void stopFreezingScreen() throws RemoteException;

    @Deprecated
    public void disableKeyguard(IBinder var1, String var2, int var3) throws RemoteException;

    @Deprecated
    public void reenableKeyguard(IBinder var1, int var2) throws RemoteException;

    public void exitKeyguardSecurely(IOnKeyguardExitResult var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:197:1:197:25")
    public boolean isKeyguardLocked() throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:199:1:199:69")
    public boolean isKeyguardSecure(int var1) throws RemoteException;

    public void dismissKeyguard(IKeyguardDismissCallback var1, CharSequence var2) throws RemoteException;

    @RequiresPermission(value="android.permission.SUBSCRIBE_TO_KEYGUARD_LOCKED_STATE")
    public void addKeyguardLockedStateListener(IKeyguardLockedStateListener var1) throws RemoteException;

    @RequiresPermission(value="android.permission.SUBSCRIBE_TO_KEYGUARD_LOCKED_STATE")
    public void removeKeyguardLockedStateListener(IKeyguardLockedStateListener var1) throws RemoteException;

    public void setSwitchingUser(boolean var1) throws RemoteException;

    public void closeSystemDialogs(String var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:217:1:217:25")
    public float getAnimationScale(int var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:219:1:219:69")
    public float[] getAnimationScales() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:221:1:221:25")
    public void setAnimationScale(int var1, float var2) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:223:1:223:69")
    public void setAnimationScales(float[] var1) throws RemoteException;

    public float getCurrentAnimatorScale() throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=28, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:229:1:229:44")
    public void setInTouchMode(boolean var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=28, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:237:1:237:44")
    public void showStrictModeViolation(boolean var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:244:1:244:69")
    public void setStrictModeVisualIndicatorPreference(String var1) throws RemoteException;

    public void refreshScreenCaptureDisabled() throws RemoteException;

    public void updateRotation(boolean var1, boolean var2) throws RemoteException;

    public int getDefaultDisplayRotation() throws RemoteException;

    public int watchRotation(IRotationWatcher var1, int var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:283:1:283:25")
    public void removeRotationWatcher(IRotationWatcher var1) throws RemoteException;

    public int getPreferredOptionsPanelGravity(int var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:299:1:299:25")
    public void freezeRotation(int var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:306:1:306:25")
    public void thawRotation() throws RemoteException;

    public boolean isRotationFrozen() throws RemoteException;

    public void freezeDisplayRotation(int var1, int var2) throws RemoteException;

    public void thawDisplayRotation(int var1) throws RemoteException;

    public boolean isDisplayRotationFrozen(int var1) throws RemoteException;

    public void setFixedToUserRotation(int var1, int var2) throws RemoteException;

    public void setIgnoreOrientationRequest(int var1, boolean var2) throws RemoteException;

    public Bitmap screenshotWallpaper() throws RemoteException;

    public SurfaceControl mirrorWallpaperSurface(int var1) throws RemoteException;

    public boolean registerWallpaperVisibilityListener(IWallpaperVisibilityListener var1, int var2) throws RemoteException;

    public void unregisterWallpaperVisibilityListener(IWallpaperVisibilityListener var1, int var2) throws RemoteException;

    public void registerSystemGestureExclusionListener(ISystemGestureExclusionListener var1, int var2) throws RemoteException;

    public void unregisterSystemGestureExclusionListener(ISystemGestureExclusionListener var1, int var2) throws RemoteException;

    public boolean requestAssistScreenshot(IAssistDataReceiver var1) throws RemoteException;

    public void hideTransientBars(int var1) throws RemoteException;

    public void setRecentsVisibility(boolean var1) throws RemoteException;

    public void updateStaticPrivacyIndicatorBounds(int var1, Rect[] var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:416:1:416:25")
    public void setNavBarVirtualKeyHapticFeedbackEnabled(boolean var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:424:1:424:25")
    public boolean hasNavigationBar(int var1) throws RemoteException;

    public int getNavBarPosition(int var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:435:1:435:69")
    public void lockNow(Bundle var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:441:1:441:25")
    public boolean isSafeModeEnabled() throws RemoteException;

    public void enableScreenIfNeeded() throws RemoteException;

    public boolean clearWindowContentFrameStats(IBinder var1) throws RemoteException;

    public WindowContentFrameStats getWindowContentFrameStats(IBinder var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:468:1:468:25")
    public int getDockedStackSide() throws RemoteException;

    public void setDockedTaskDividerTouchRegion(Rect var1) throws RemoteException;

    public void registerPinnedTaskListener(int var1, IPinnedTaskListener var2) throws RemoteException;

    public void requestAppKeyboardShortcuts(IResultReceiver var1, int var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:492:1:492:25")
    public void getStableInsets(int var1, Rect var2) throws RemoteException;

    public void registerShortcutKey(long var1, IShortcutService var3) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:505:1:505:25")
    public void createInputConsumer(IBinder var1, String var2, int var3, InputChannel var4) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:513:1:513:25")
    public boolean destroyInputConsumer(String var1, int var2) throws RemoteException;

    public Region getCurrentImeTouchRegion() throws RemoteException;

    public void registerDisplayFoldListener(IDisplayFoldListener var1) throws RemoteException;

    public void unregisterDisplayFoldListener(IDisplayFoldListener var1) throws RemoteException;

    public int[] registerDisplayWindowListener(IDisplayWindowListener var1) throws RemoteException;

    public void unregisterDisplayWindowListener(IDisplayWindowListener var1) throws RemoteException;

    public void startWindowTrace() throws RemoteException;

    public void stopWindowTrace() throws RemoteException;

    public void saveWindowTraceToFile() throws RemoteException;

    public boolean isWindowTraceEnabled() throws RemoteException;

    public int getWindowingMode(int var1) throws RemoteException;

    public void setWindowingMode(int var1, int var2) throws RemoteException;

    public int getRemoveContentMode(int var1) throws RemoteException;

    public void setRemoveContentMode(int var1, int var2) throws RemoteException;

    public boolean shouldShowWithInsecureKeyguard(int var1) throws RemoteException;

    public void setShouldShowWithInsecureKeyguard(int var1, boolean var2) throws RemoteException;

    public boolean shouldShowSystemDecors(int var1) throws RemoteException;

    public void setShouldShowSystemDecors(int var1, boolean var2) throws RemoteException;

    public int getDisplayImePolicy(int var1) throws RemoteException;

    public void setDisplayImePolicy(int var1, int var2) throws RemoteException;

    public void syncInputTransactions(boolean var1) throws RemoteException;

    public boolean isLayerTracing() throws RemoteException;

    public void setLayerTracing(boolean var1) throws RemoteException;

    public boolean mirrorDisplay(int var1, SurfaceControl var2) throws RemoteException;

    public void setDisplayWindowInsetsController(int var1, IDisplayWindowInsetsController var2) throws RemoteException;

    public void updateDisplayWindowRequestedVisibilities(int var1, InsetsVisibilities var2) throws RemoteException;

    public boolean getWindowInsets(WindowManager.LayoutParams var1, int var2, InsetsState var3) throws RemoteException;

    public List<DisplayInfo> getPossibleDisplayInfo(int var1, String var2) throws RemoteException;

    public void showGlobalActions() throws RemoteException;

    public void setLayerTracingFlags(int var1) throws RemoteException;

    public void requestScrollCapture(int var1, IBinder var2, int var3, IScrollCaptureResponseListener var4) throws RemoteException;

    public void holdLock(IBinder var1, int var2) throws RemoteException;

    public String[] getSupportedDisplayHashAlgorithms() throws RemoteException;

    public VerifiedDisplayHash verifyDisplayHash(DisplayHash var1) throws RemoteException;

    public void setDisplayHashThrottlingEnabled(boolean var1) throws RemoteException;

    public Configuration attachWindowContextToDisplayArea(IBinder var1, int var2, int var3, Bundle var4) throws RemoteException;

    public void attachWindowContextToWindowToken(IBinder var1, IBinder var2) throws RemoteException;

    public Configuration attachToDisplayContent(IBinder var1, int var2) throws RemoteException;

    public void detachWindowContextFromWindowContainer(IBinder var1) throws RemoteException;

    public boolean registerCrossWindowBlurEnabledListener(ICrossWindowBlurEnabledListener var1) throws RemoteException;

    public void unregisterCrossWindowBlurEnabledListener(ICrossWindowBlurEnabledListener var1) throws RemoteException;

    public boolean isTaskSnapshotSupported() throws RemoteException;

    public int getImeDisplayId() throws RemoteException;

    public void setTaskSnapshotEnabled(boolean var1) throws RemoteException;

    public void setTaskTransitionSpec(TaskTransitionSpec var1) throws RemoteException;

    public void clearTaskTransitionSpec() throws RemoteException;

    public void registerTaskFpsCallback(int var1, ITaskFpsCallback var2) throws RemoteException;

    public void unregisterTaskFpsCallback(ITaskFpsCallback var1) throws RemoteException;

    public Bitmap snapshotTaskForRecents(int var1) throws RemoteException;

    public void setRecentsAppBehindSystemBars(boolean var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWindowManager {
        public static final String DESCRIPTOR = "android.view.IWindowManager";
        static final int TRANSACTION_startViewServer = 1;
        static final int TRANSACTION_stopViewServer = 2;
        static final int TRANSACTION_isViewServerRunning = 3;
        static final int TRANSACTION_openSession = 4;
        static final int TRANSACTION_useBLAST = 5;
        static final int TRANSACTION_getInitialDisplaySize = 6;
        static final int TRANSACTION_getBaseDisplaySize = 7;
        static final int TRANSACTION_setForcedDisplaySize = 8;
        static final int TRANSACTION_clearForcedDisplaySize = 9;
        static final int TRANSACTION_getInitialDisplayDensity = 10;
        static final int TRANSACTION_getBaseDisplayDensity = 11;
        static final int TRANSACTION_setForcedDisplayDensityForUser = 12;
        static final int TRANSACTION_clearForcedDisplayDensityForUser = 13;
        static final int TRANSACTION_setForcedDisplayScalingMode = 14;
        static final int TRANSACTION_setEventDispatching = 15;
        static final int TRANSACTION_isWindowToken = 16;
        static final int TRANSACTION_addWindowToken = 17;
        static final int TRANSACTION_removeWindowToken = 18;
        static final int TRANSACTION_setDisplayWindowRotationController = 19;
        static final int TRANSACTION_addShellRoot = 20;
        static final int TRANSACTION_setShellRootAccessibilityWindow = 21;
        static final int TRANSACTION_overridePendingAppTransitionMultiThumbFuture = 22;
        static final int TRANSACTION_overridePendingAppTransitionRemote = 23;
        static final int TRANSACTION_endProlongedAnimations = 24;
        static final int TRANSACTION_startFreezingScreen = 25;
        static final int TRANSACTION_stopFreezingScreen = 26;
        static final int TRANSACTION_disableKeyguard = 27;
        static final int TRANSACTION_reenableKeyguard = 28;
        static final int TRANSACTION_exitKeyguardSecurely = 29;
        static final int TRANSACTION_isKeyguardLocked = 30;
        static final int TRANSACTION_isKeyguardSecure = 31;
        static final int TRANSACTION_dismissKeyguard = 32;
        static final int TRANSACTION_addKeyguardLockedStateListener = 33;
        static final int TRANSACTION_removeKeyguardLockedStateListener = 34;
        static final int TRANSACTION_setSwitchingUser = 35;
        static final int TRANSACTION_closeSystemDialogs = 36;
        static final int TRANSACTION_getAnimationScale = 37;
        static final int TRANSACTION_getAnimationScales = 38;
        static final int TRANSACTION_setAnimationScale = 39;
        static final int TRANSACTION_setAnimationScales = 40;
        static final int TRANSACTION_getCurrentAnimatorScale = 41;
        static final int TRANSACTION_setInTouchMode = 42;
        static final int TRANSACTION_showStrictModeViolation = 43;
        static final int TRANSACTION_setStrictModeVisualIndicatorPreference = 44;
        static final int TRANSACTION_refreshScreenCaptureDisabled = 45;
        static final int TRANSACTION_updateRotation = 46;
        static final int TRANSACTION_getDefaultDisplayRotation = 47;
        static final int TRANSACTION_watchRotation = 48;
        static final int TRANSACTION_removeRotationWatcher = 49;
        static final int TRANSACTION_getPreferredOptionsPanelGravity = 50;
        static final int TRANSACTION_freezeRotation = 51;
        static final int TRANSACTION_thawRotation = 52;
        static final int TRANSACTION_isRotationFrozen = 53;
        static final int TRANSACTION_freezeDisplayRotation = 54;
        static final int TRANSACTION_thawDisplayRotation = 55;
        static final int TRANSACTION_isDisplayRotationFrozen = 56;
        static final int TRANSACTION_setFixedToUserRotation = 57;
        static final int TRANSACTION_setIgnoreOrientationRequest = 58;
        static final int TRANSACTION_screenshotWallpaper = 59;
        static final int TRANSACTION_mirrorWallpaperSurface = 60;
        static final int TRANSACTION_registerWallpaperVisibilityListener = 61;
        static final int TRANSACTION_unregisterWallpaperVisibilityListener = 62;
        static final int TRANSACTION_registerSystemGestureExclusionListener = 63;
        static final int TRANSACTION_unregisterSystemGestureExclusionListener = 64;
        static final int TRANSACTION_requestAssistScreenshot = 65;
        static final int TRANSACTION_hideTransientBars = 66;
        static final int TRANSACTION_setRecentsVisibility = 67;
        static final int TRANSACTION_updateStaticPrivacyIndicatorBounds = 68;
        static final int TRANSACTION_setNavBarVirtualKeyHapticFeedbackEnabled = 69;
        static final int TRANSACTION_hasNavigationBar = 70;
        static final int TRANSACTION_getNavBarPosition = 71;
        static final int TRANSACTION_lockNow = 72;
        static final int TRANSACTION_isSafeModeEnabled = 73;
        static final int TRANSACTION_enableScreenIfNeeded = 74;
        static final int TRANSACTION_clearWindowContentFrameStats = 75;
        static final int TRANSACTION_getWindowContentFrameStats = 76;
        static final int TRANSACTION_getDockedStackSide = 77;
        static final int TRANSACTION_setDockedTaskDividerTouchRegion = 78;
        static final int TRANSACTION_registerPinnedTaskListener = 79;
        static final int TRANSACTION_requestAppKeyboardShortcuts = 80;
        static final int TRANSACTION_getStableInsets = 81;
        static final int TRANSACTION_registerShortcutKey = 82;
        static final int TRANSACTION_createInputConsumer = 83;
        static final int TRANSACTION_destroyInputConsumer = 84;
        static final int TRANSACTION_getCurrentImeTouchRegion = 85;
        static final int TRANSACTION_registerDisplayFoldListener = 86;
        static final int TRANSACTION_unregisterDisplayFoldListener = 87;
        static final int TRANSACTION_registerDisplayWindowListener = 88;
        static final int TRANSACTION_unregisterDisplayWindowListener = 89;
        static final int TRANSACTION_startWindowTrace = 90;
        static final int TRANSACTION_stopWindowTrace = 91;
        static final int TRANSACTION_saveWindowTraceToFile = 92;
        static final int TRANSACTION_isWindowTraceEnabled = 93;
        static final int TRANSACTION_getWindowingMode = 94;
        static final int TRANSACTION_setWindowingMode = 95;
        static final int TRANSACTION_getRemoveContentMode = 96;
        static final int TRANSACTION_setRemoveContentMode = 97;
        static final int TRANSACTION_shouldShowWithInsecureKeyguard = 98;
        static final int TRANSACTION_setShouldShowWithInsecureKeyguard = 99;
        static final int TRANSACTION_shouldShowSystemDecors = 100;
        static final int TRANSACTION_setShouldShowSystemDecors = 101;
        static final int TRANSACTION_getDisplayImePolicy = 102;
        static final int TRANSACTION_setDisplayImePolicy = 103;
        static final int TRANSACTION_syncInputTransactions = 104;
        static final int TRANSACTION_isLayerTracing = 105;
        static final int TRANSACTION_setLayerTracing = 106;
        static final int TRANSACTION_mirrorDisplay = 107;
        static final int TRANSACTION_setDisplayWindowInsetsController = 108;
        static final int TRANSACTION_updateDisplayWindowRequestedVisibilities = 109;
        static final int TRANSACTION_getWindowInsets = 110;
        static final int TRANSACTION_getPossibleDisplayInfo = 111;
        static final int TRANSACTION_showGlobalActions = 112;
        static final int TRANSACTION_setLayerTracingFlags = 113;
        static final int TRANSACTION_requestScrollCapture = 114;
        static final int TRANSACTION_holdLock = 115;
        static final int TRANSACTION_getSupportedDisplayHashAlgorithms = 116;
        static final int TRANSACTION_verifyDisplayHash = 117;
        static final int TRANSACTION_setDisplayHashThrottlingEnabled = 118;
        static final int TRANSACTION_attachWindowContextToDisplayArea = 119;
        static final int TRANSACTION_attachWindowContextToWindowToken = 120;
        static final int TRANSACTION_attachToDisplayContent = 121;
        static final int TRANSACTION_detachWindowContextFromWindowContainer = 122;
        static final int TRANSACTION_registerCrossWindowBlurEnabledListener = 123;
        static final int TRANSACTION_unregisterCrossWindowBlurEnabledListener = 124;
        static final int TRANSACTION_isTaskSnapshotSupported = 125;
        static final int TRANSACTION_getImeDisplayId = 126;
        static final int TRANSACTION_setTaskSnapshotEnabled = 127;
        static final int TRANSACTION_setTaskTransitionSpec = 128;
        static final int TRANSACTION_clearTaskTransitionSpec = 129;
        static final int TRANSACTION_registerTaskFpsCallback = 130;
        static final int TRANSACTION_unregisterTaskFpsCallback = 131;
        static final int TRANSACTION_snapshotTaskForRecents = 132;
        static final int TRANSACTION_setRecentsAppBehindSystemBars = 133;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWindowManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IWindowManager) {
                return (IWindowManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "startViewServer";
                }
                case 2: {
                    return "stopViewServer";
                }
                case 3: {
                    return "isViewServerRunning";
                }
                case 4: {
                    return "openSession";
                }
                case 5: {
                    return "useBLAST";
                }
                case 6: {
                    return "getInitialDisplaySize";
                }
                case 7: {
                    return "getBaseDisplaySize";
                }
                case 8: {
                    return "setForcedDisplaySize";
                }
                case 9: {
                    return "clearForcedDisplaySize";
                }
                case 10: {
                    return "getInitialDisplayDensity";
                }
                case 11: {
                    return "getBaseDisplayDensity";
                }
                case 12: {
                    return "setForcedDisplayDensityForUser";
                }
                case 13: {
                    return "clearForcedDisplayDensityForUser";
                }
                case 14: {
                    return "setForcedDisplayScalingMode";
                }
                case 15: {
                    return "setEventDispatching";
                }
                case 16: {
                    return "isWindowToken";
                }
                case 17: {
                    return "addWindowToken";
                }
                case 18: {
                    return "removeWindowToken";
                }
                case 19: {
                    return "setDisplayWindowRotationController";
                }
                case 20: {
                    return "addShellRoot";
                }
                case 21: {
                    return "setShellRootAccessibilityWindow";
                }
                case 22: {
                    return "overridePendingAppTransitionMultiThumbFuture";
                }
                case 23: {
                    return "overridePendingAppTransitionRemote";
                }
                case 24: {
                    return "endProlongedAnimations";
                }
                case 25: {
                    return "startFreezingScreen";
                }
                case 26: {
                    return "stopFreezingScreen";
                }
                case 27: {
                    return "disableKeyguard";
                }
                case 28: {
                    return "reenableKeyguard";
                }
                case 29: {
                    return "exitKeyguardSecurely";
                }
                case 30: {
                    return "isKeyguardLocked";
                }
                case 31: {
                    return "isKeyguardSecure";
                }
                case 32: {
                    return "dismissKeyguard";
                }
                case 33: {
                    return "addKeyguardLockedStateListener";
                }
                case 34: {
                    return "removeKeyguardLockedStateListener";
                }
                case 35: {
                    return "setSwitchingUser";
                }
                case 36: {
                    return "closeSystemDialogs";
                }
                case 37: {
                    return "getAnimationScale";
                }
                case 38: {
                    return "getAnimationScales";
                }
                case 39: {
                    return "setAnimationScale";
                }
                case 40: {
                    return "setAnimationScales";
                }
                case 41: {
                    return "getCurrentAnimatorScale";
                }
                case 42: {
                    return "setInTouchMode";
                }
                case 43: {
                    return "showStrictModeViolation";
                }
                case 44: {
                    return "setStrictModeVisualIndicatorPreference";
                }
                case 45: {
                    return "refreshScreenCaptureDisabled";
                }
                case 46: {
                    return "updateRotation";
                }
                case 47: {
                    return "getDefaultDisplayRotation";
                }
                case 48: {
                    return "watchRotation";
                }
                case 49: {
                    return "removeRotationWatcher";
                }
                case 50: {
                    return "getPreferredOptionsPanelGravity";
                }
                case 51: {
                    return "freezeRotation";
                }
                case 52: {
                    return "thawRotation";
                }
                case 53: {
                    return "isRotationFrozen";
                }
                case 54: {
                    return "freezeDisplayRotation";
                }
                case 55: {
                    return "thawDisplayRotation";
                }
                case 56: {
                    return "isDisplayRotationFrozen";
                }
                case 57: {
                    return "setFixedToUserRotation";
                }
                case 58: {
                    return "setIgnoreOrientationRequest";
                }
                case 59: {
                    return "screenshotWallpaper";
                }
                case 60: {
                    return "mirrorWallpaperSurface";
                }
                case 61: {
                    return "registerWallpaperVisibilityListener";
                }
                case 62: {
                    return "unregisterWallpaperVisibilityListener";
                }
                case 63: {
                    return "registerSystemGestureExclusionListener";
                }
                case 64: {
                    return "unregisterSystemGestureExclusionListener";
                }
                case 65: {
                    return "requestAssistScreenshot";
                }
                case 66: {
                    return "hideTransientBars";
                }
                case 67: {
                    return "setRecentsVisibility";
                }
                case 68: {
                    return "updateStaticPrivacyIndicatorBounds";
                }
                case 69: {
                    return "setNavBarVirtualKeyHapticFeedbackEnabled";
                }
                case 70: {
                    return "hasNavigationBar";
                }
                case 71: {
                    return "getNavBarPosition";
                }
                case 72: {
                    return "lockNow";
                }
                case 73: {
                    return "isSafeModeEnabled";
                }
                case 74: {
                    return "enableScreenIfNeeded";
                }
                case 75: {
                    return "clearWindowContentFrameStats";
                }
                case 76: {
                    return "getWindowContentFrameStats";
                }
                case 77: {
                    return "getDockedStackSide";
                }
                case 78: {
                    return "setDockedTaskDividerTouchRegion";
                }
                case 79: {
                    return "registerPinnedTaskListener";
                }
                case 80: {
                    return "requestAppKeyboardShortcuts";
                }
                case 81: {
                    return "getStableInsets";
                }
                case 82: {
                    return "registerShortcutKey";
                }
                case 83: {
                    return "createInputConsumer";
                }
                case 84: {
                    return "destroyInputConsumer";
                }
                case 85: {
                    return "getCurrentImeTouchRegion";
                }
                case 86: {
                    return "registerDisplayFoldListener";
                }
                case 87: {
                    return "unregisterDisplayFoldListener";
                }
                case 88: {
                    return "registerDisplayWindowListener";
                }
                case 89: {
                    return "unregisterDisplayWindowListener";
                }
                case 90: {
                    return "startWindowTrace";
                }
                case 91: {
                    return "stopWindowTrace";
                }
                case 92: {
                    return "saveWindowTraceToFile";
                }
                case 93: {
                    return "isWindowTraceEnabled";
                }
                case 94: {
                    return "getWindowingMode";
                }
                case 95: {
                    return "setWindowingMode";
                }
                case 96: {
                    return "getRemoveContentMode";
                }
                case 97: {
                    return "setRemoveContentMode";
                }
                case 98: {
                    return "shouldShowWithInsecureKeyguard";
                }
                case 99: {
                    return "setShouldShowWithInsecureKeyguard";
                }
                case 100: {
                    return "shouldShowSystemDecors";
                }
                case 101: {
                    return "setShouldShowSystemDecors";
                }
                case 102: {
                    return "getDisplayImePolicy";
                }
                case 103: {
                    return "setDisplayImePolicy";
                }
                case 104: {
                    return "syncInputTransactions";
                }
                case 105: {
                    return "isLayerTracing";
                }
                case 106: {
                    return "setLayerTracing";
                }
                case 107: {
                    return "mirrorDisplay";
                }
                case 108: {
                    return "setDisplayWindowInsetsController";
                }
                case 109: {
                    return "updateDisplayWindowRequestedVisibilities";
                }
                case 110: {
                    return "getWindowInsets";
                }
                case 111: {
                    return "getPossibleDisplayInfo";
                }
                case 112: {
                    return "showGlobalActions";
                }
                case 113: {
                    return "setLayerTracingFlags";
                }
                case 114: {
                    return "requestScrollCapture";
                }
                case 115: {
                    return "holdLock";
                }
                case 116: {
                    return "getSupportedDisplayHashAlgorithms";
                }
                case 117: {
                    return "verifyDisplayHash";
                }
                case 118: {
                    return "setDisplayHashThrottlingEnabled";
                }
                case 119: {
                    return "attachWindowContextToDisplayArea";
                }
                case 120: {
                    return "attachWindowContextToWindowToken";
                }
                case 121: {
                    return "attachToDisplayContent";
                }
                case 122: {
                    return "detachWindowContextFromWindowContainer";
                }
                case 123: {
                    return "registerCrossWindowBlurEnabledListener";
                }
                case 124: {
                    return "unregisterCrossWindowBlurEnabledListener";
                }
                case 125: {
                    return "isTaskSnapshotSupported";
                }
                case 126: {
                    return "getImeDisplayId";
                }
                case 127: {
                    return "setTaskSnapshotEnabled";
                }
                case 128: {
                    return "setTaskTransitionSpec";
                }
                case 129: {
                    return "clearTaskTransitionSpec";
                }
                case 130: {
                    return "registerTaskFpsCallback";
                }
                case 131: {
                    return "unregisterTaskFpsCallback";
                }
                case 132: {
                    return "snapshotTaskForRecents";
                }
                case 133: {
                    return "setRecentsAppBehindSystemBars";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.startViewServer(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 2: {
                    boolean _result = this.stopViewServer();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 3: {
                    boolean _result = this.isViewServerRunning();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 4: {
                    IWindowSessionCallback _arg0 = IWindowSessionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    IWindowSession _result = this.openSession(_arg0);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 5: {
                    boolean _result = this.useBLAST();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    Point _arg1 = new Point();
                    data.enforceNoDataAvail();
                    this.getInitialDisplaySize(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_arg1, 1);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    Point _arg1 = new Point();
                    data.enforceNoDataAvail();
                    this.getBaseDisplaySize(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_arg1, 1);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setForcedDisplaySize(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.clearForcedDisplaySize(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getInitialDisplayDensity(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getBaseDisplayDensity(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setForcedDisplayDensityForUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.clearForcedDisplayDensityForUser(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setForcedDisplayScalingMode(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setEventDispatching(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    boolean _result = this.isWindowToken(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 17: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    Bundle _arg3 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.addWindowToken(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.removeWindowToken(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    IDisplayWindowRotationController _arg0 = IDisplayWindowRotationController.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setDisplayWindowRotationController(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    int _arg0 = data.readInt();
                    IWindow _arg1 = IWindow.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    SurfaceControl _result = this.addShellRoot(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 21: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    IWindow _arg2 = IWindow.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setShellRootAccessibilityWindow(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    IAppTransitionAnimationSpecsFuture _arg0 = IAppTransitionAnimationSpecsFuture.Stub.asInterface(data.readStrongBinder());
                    IRemoteCallback _arg1 = IRemoteCallback.Stub.asInterface(data.readStrongBinder());
                    boolean _arg2 = data.readBoolean();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.overridePendingAppTransitionMultiThumbFuture(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    RemoteAnimationAdapter _arg0 = data.readTypedObject(RemoteAnimationAdapter.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.overridePendingAppTransitionRemote(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    this.endProlongedAnimations();
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.startFreezingScreen(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    this.stopFreezingScreen();
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.disableKeyguard(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.reenableKeyguard(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    IOnKeyguardExitResult _arg0 = IOnKeyguardExitResult.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.exitKeyguardSecurely(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    boolean _result = this.isKeyguardLocked();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 31: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isKeyguardSecure(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 32: {
                    IKeyguardDismissCallback _arg0 = IKeyguardDismissCallback.Stub.asInterface(data.readStrongBinder());
                    CharSequence _arg1 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    data.enforceNoDataAvail();
                    this.dismissKeyguard(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 33: {
                    IKeyguardLockedStateListener _arg0 = IKeyguardLockedStateListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addKeyguardLockedStateListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    IKeyguardLockedStateListener _arg0 = IKeyguardLockedStateListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeKeyguardLockedStateListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 35: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setSwitchingUser(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 36: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.closeSystemDialogs(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 37: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    float _result = this.getAnimationScale(_arg0);
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    break;
                }
                case 38: {
                    float[] _result = this.getAnimationScales();
                    reply.writeNoException();
                    reply.writeFloatArray(_result);
                    break;
                }
                case 39: {
                    int _arg0 = data.readInt();
                    float _arg1 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setAnimationScale(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 40: {
                    float[] _arg0 = data.createFloatArray();
                    data.enforceNoDataAvail();
                    this.setAnimationScales(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 41: {
                    float _result = this.getCurrentAnimatorScale();
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    break;
                }
                case 42: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setInTouchMode(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 43: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.showStrictModeViolation(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 44: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.setStrictModeVisualIndicatorPreference(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 45: {
                    this.refreshScreenCaptureDisabled();
                    reply.writeNoException();
                    break;
                }
                case 46: {
                    boolean _arg0 = data.readBoolean();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.updateRotation(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 47: {
                    int _result = this.getDefaultDisplayRotation();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 48: {
                    IRotationWatcher _arg0 = IRotationWatcher.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.watchRotation(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 49: {
                    IRotationWatcher _arg0 = IRotationWatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeRotationWatcher(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 50: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getPreferredOptionsPanelGravity(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 51: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.freezeRotation(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 52: {
                    this.thawRotation();
                    reply.writeNoException();
                    break;
                }
                case 53: {
                    boolean _result = this.isRotationFrozen();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 54: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.freezeDisplayRotation(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 55: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.thawDisplayRotation(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 56: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isDisplayRotationFrozen(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 57: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setFixedToUserRotation(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 58: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setIgnoreOrientationRequest(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 59: {
                    Bitmap _result = this.screenshotWallpaper();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 60: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    SurfaceControl _result = this.mirrorWallpaperSurface(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 61: {
                    IWallpaperVisibilityListener _arg0 = IWallpaperVisibilityListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.registerWallpaperVisibilityListener(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 62: {
                    IWallpaperVisibilityListener _arg0 = IWallpaperVisibilityListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.unregisterWallpaperVisibilityListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 63: {
                    ISystemGestureExclusionListener _arg0 = ISystemGestureExclusionListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.registerSystemGestureExclusionListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 64: {
                    ISystemGestureExclusionListener _arg0 = ISystemGestureExclusionListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.unregisterSystemGestureExclusionListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 65: {
                    IAssistDataReceiver _arg0 = IAssistDataReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.requestAssistScreenshot(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 66: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.hideTransientBars(_arg0);
                    break;
                }
                case 67: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setRecentsVisibility(_arg0);
                    break;
                }
                case 68: {
                    int _arg0 = data.readInt();
                    Rect[] _arg1 = data.createTypedArray(Rect.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateStaticPrivacyIndicatorBounds(_arg0, _arg1);
                    break;
                }
                case 69: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setNavBarVirtualKeyHapticFeedbackEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 70: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasNavigationBar(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 71: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getNavBarPosition(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 72: {
                    Bundle _arg0 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.lockNow(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 73: {
                    boolean _result = this.isSafeModeEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 74: {
                    this.enableScreenIfNeeded();
                    reply.writeNoException();
                    break;
                }
                case 75: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    boolean _result = this.clearWindowContentFrameStats(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 76: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    WindowContentFrameStats _result = this.getWindowContentFrameStats(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 77: {
                    int _result = this.getDockedStackSide();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 78: {
                    Rect _arg0 = data.readTypedObject(Rect.CREATOR);
                    data.enforceNoDataAvail();
                    this.setDockedTaskDividerTouchRegion(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 79: {
                    int _arg0 = data.readInt();
                    IPinnedTaskListener _arg1 = IPinnedTaskListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerPinnedTaskListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 80: {
                    IResultReceiver _arg0 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.requestAppKeyboardShortcuts(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 81: {
                    int _arg0 = data.readInt();
                    Rect _arg1 = new Rect();
                    data.enforceNoDataAvail();
                    this.getStableInsets(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_arg1, 1);
                    break;
                }
                case 82: {
                    long _arg0 = data.readLong();
                    IShortcutService _arg1 = IShortcutService.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerShortcutKey(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 83: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    InputChannel _arg3 = new InputChannel();
                    data.enforceNoDataAvail();
                    this.createInputConsumer(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_arg3, 1);
                    break;
                }
                case 84: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.destroyInputConsumer(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 85: {
                    Region _result = this.getCurrentImeTouchRegion();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 86: {
                    IDisplayFoldListener _arg0 = IDisplayFoldListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerDisplayFoldListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 87: {
                    IDisplayFoldListener _arg0 = IDisplayFoldListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterDisplayFoldListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 88: {
                    IDisplayWindowListener _arg0 = IDisplayWindowListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int[] _result = this.registerDisplayWindowListener(_arg0);
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 89: {
                    IDisplayWindowListener _arg0 = IDisplayWindowListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterDisplayWindowListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 90: {
                    this.startWindowTrace();
                    reply.writeNoException();
                    break;
                }
                case 91: {
                    this.stopWindowTrace();
                    reply.writeNoException();
                    break;
                }
                case 92: {
                    this.saveWindowTraceToFile();
                    reply.writeNoException();
                    break;
                }
                case 93: {
                    boolean _result = this.isWindowTraceEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 94: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getWindowingMode(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 95: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setWindowingMode(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 96: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getRemoveContentMode(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 97: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setRemoveContentMode(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 98: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.shouldShowWithInsecureKeyguard(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 99: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setShouldShowWithInsecureKeyguard(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 100: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.shouldShowSystemDecors(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 101: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setShouldShowSystemDecors(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 102: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getDisplayImePolicy(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 103: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setDisplayImePolicy(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 104: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.syncInputTransactions(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 105: {
                    boolean _result = this.isLayerTracing();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 106: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setLayerTracing(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 107: {
                    int _arg0 = data.readInt();
                    SurfaceControl _arg1 = new SurfaceControl();
                    data.enforceNoDataAvail();
                    boolean _result = this.mirrorDisplay(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    reply.writeTypedObject(_arg1, 1);
                    break;
                }
                case 108: {
                    int _arg0 = data.readInt();
                    IDisplayWindowInsetsController _arg1 = IDisplayWindowInsetsController.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setDisplayWindowInsetsController(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 109: {
                    int _arg0 = data.readInt();
                    InsetsVisibilities _arg1 = data.readTypedObject(InsetsVisibilities.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateDisplayWindowRequestedVisibilities(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 110: {
                    WindowManager.LayoutParams _arg0 = data.readTypedObject(WindowManager.LayoutParams.CREATOR);
                    int _arg1 = data.readInt();
                    InsetsState _arg2 = new InsetsState();
                    data.enforceNoDataAvail();
                    boolean _result = this.getWindowInsets(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    reply.writeTypedObject(_arg2, 1);
                    break;
                }
                case 111: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    List<DisplayInfo> _result = this.getPossibleDisplayInfo(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 112: {
                    this.showGlobalActions();
                    reply.writeNoException();
                    break;
                }
                case 113: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setLayerTracingFlags(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 114: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    int _arg2 = data.readInt();
                    IScrollCaptureResponseListener _arg3 = IScrollCaptureResponseListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.requestScrollCapture(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 115: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.holdLock(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 116: {
                    String[] _result = this.getSupportedDisplayHashAlgorithms();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 117: {
                    DisplayHash _arg0 = data.readTypedObject(DisplayHash.CREATOR);
                    data.enforceNoDataAvail();
                    VerifiedDisplayHash _result = this.verifyDisplayHash(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 118: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setDisplayHashThrottlingEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 119: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    Bundle _arg3 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    Configuration _result = this.attachWindowContextToDisplayArea(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 120: {
                    IBinder _arg0 = data.readStrongBinder();
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.attachWindowContextToWindowToken(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 121: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    Configuration _result = this.attachToDisplayContent(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 122: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.detachWindowContextFromWindowContainer(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 123: {
                    ICrossWindowBlurEnabledListener _arg0 = ICrossWindowBlurEnabledListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.registerCrossWindowBlurEnabledListener(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 124: {
                    ICrossWindowBlurEnabledListener _arg0 = ICrossWindowBlurEnabledListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterCrossWindowBlurEnabledListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 125: {
                    boolean _result = this.isTaskSnapshotSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 126: {
                    int _result = this.getImeDisplayId();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 127: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setTaskSnapshotEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 128: {
                    TaskTransitionSpec _arg0 = data.readTypedObject(TaskTransitionSpec.CREATOR);
                    data.enforceNoDataAvail();
                    this.setTaskTransitionSpec(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 129: {
                    this.clearTaskTransitionSpec();
                    reply.writeNoException();
                    break;
                }
                case 130: {
                    int _arg0 = data.readInt();
                    ITaskFpsCallback _arg1 = ITaskFpsCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerTaskFpsCallback(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 131: {
                    ITaskFpsCallback _arg0 = ITaskFpsCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterTaskFpsCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 132: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    Bitmap _result = this.snapshotTaskForRecents(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 133: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setRecentsAppBehindSystemBars(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 132;
        }

        private static class Proxy
        implements IWindowManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean startViewServer(int port) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(port);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean stopViewServer() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isViewServerRunning() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IWindowSession openSession(IWindowSessionCallback callback) throws RemoteException {
                IWindowSession _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = IWindowSession.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean useBLAST() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getInitialDisplaySize(int displayId, Point size) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        size.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getBaseDisplaySize(int displayId, Point size) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        size.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setForcedDisplaySize(int displayId, int width, int height) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(width);
                    _data.writeInt(height);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearForcedDisplaySize(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getInitialDisplayDensity(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getBaseDisplayDensity(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setForcedDisplayDensityForUser(int displayId, int density, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(density);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearForcedDisplayDensityForUser(int displayId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setForcedDisplayScalingMode(int displayId, int mode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setEventDispatching(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isWindowToken(IBinder binder) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(binder);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addWindowToken(IBinder token, int type, int displayId, Bundle options) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(type);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(options, 0);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeWindowToken(IBinder token, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDisplayWindowRotationController(IDisplayWindowRotationController controller) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(controller);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SurfaceControl addShellRoot(int displayId, IWindow client, int shellRootLayer) throws RemoteException {
                SurfaceControl _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeStrongInterface(client);
                    _data.writeInt(shellRootLayer);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SurfaceControl.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setShellRootAccessibilityWindow(int displayId, int shellRootLayer, IWindow target) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(shellRootLayer);
                    _data.writeStrongInterface(target);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void overridePendingAppTransitionMultiThumbFuture(IAppTransitionAnimationSpecsFuture specsFuture, IRemoteCallback startedCallback, boolean scaleUp, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(specsFuture);
                    _data.writeStrongInterface(startedCallback);
                    _data.writeBoolean(scaleUp);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void overridePendingAppTransitionRemote(RemoteAnimationAdapter remoteAnimationAdapter, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(remoteAnimationAdapter, 0);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void endProlongedAnimations() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startFreezingScreen(int exitAnim, int enterAnim) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(exitAnim);
                    _data.writeInt(enterAnim);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopFreezingScreen() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableKeyguard(IBinder token, String tag, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeString(tag);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reenableKeyguard(IBinder token, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void exitKeyguardSecurely(IOnKeyguardExitResult callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isKeyguardLocked() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isKeyguardSecure(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dismissKeyguard(IKeyguardDismissCallback callback, CharSequence message) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    if (message != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(message, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addKeyguardLockedStateListener(IKeyguardLockedStateListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeKeyguardLockedStateListener(IKeyguardLockedStateListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSwitchingUser(boolean switching) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(switching);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void closeSystemDialogs(String reason) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(reason);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getAnimationScale(int which) throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(which);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float[] getAnimationScales() throws RemoteException {
                float[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createFloatArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAnimationScale(int which, float scale) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(which);
                    _data.writeFloat(scale);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAnimationScales(float[] scales) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloatArray(scales);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getCurrentAnimatorScale() throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInTouchMode(boolean showFocus) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(showFocus);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showStrictModeViolation(boolean on) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(on);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setStrictModeVisualIndicatorPreference(String enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(enabled);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void refreshScreenCaptureDisabled() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateRotation(boolean alwaysSendConfiguration, boolean forceRelayout) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(alwaysSendConfiguration);
                    _data.writeBoolean(forceRelayout);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDefaultDisplayRotation() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int watchRotation(IRotationWatcher watcher, int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(watcher);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeRotationWatcher(IRotationWatcher watcher) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(watcher);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getPreferredOptionsPanelGravity(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void freezeRotation(int rotation) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(rotation);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void thawRotation() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isRotationFrozen() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void freezeDisplayRotation(int displayId, int rotation) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(rotation);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void thawDisplayRotation(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDisplayRotationFrozen(int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFixedToUserRotation(int displayId, int fixedToUserRotation) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(fixedToUserRotation);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setIgnoreOrientationRequest(int displayId, boolean ignoreOrientationRequest) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeBoolean(ignoreOrientationRequest);
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bitmap screenshotWallpaper() throws RemoteException {
                Bitmap _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(59, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Bitmap.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SurfaceControl mirrorWallpaperSurface(int displayId) throws RemoteException {
                SurfaceControl _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(60, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SurfaceControl.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean registerWallpaperVisibilityListener(IWallpaperVisibilityListener listener, int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(61, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterWallpaperVisibilityListener(IWallpaperVisibilityListener listener, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(62, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSystemGestureExclusionListener(ISystemGestureExclusionListener listener, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(63, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSystemGestureExclusionListener(ISystemGestureExclusionListener listener, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(64, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean requestAssistScreenshot(IAssistDataReceiver receiver) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(receiver);
                    boolean _status = this.mRemote.transact(65, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hideTransientBars(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(66, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRecentsVisibility(boolean visible) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(visible);
                    boolean bl = this.mRemote.transact(67, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateStaticPrivacyIndicatorBounds(int displayId, Rect[] staticBounds) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeTypedArray(staticBounds, 0);
                    boolean bl = this.mRemote.transact(68, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNavBarVirtualKeyHapticFeedbackEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(69, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNavigationBar(int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(70, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getNavBarPosition(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(71, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void lockNow(Bundle options) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(options, 0);
                    boolean _status = this.mRemote.transact(72, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSafeModeEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(73, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableScreenIfNeeded() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(74, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean clearWindowContentFrameStats(IBinder token) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(75, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WindowContentFrameStats getWindowContentFrameStats(IBinder token) throws RemoteException {
                WindowContentFrameStats _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(76, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(WindowContentFrameStats.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDockedStackSide() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(77, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDockedTaskDividerTouchRegion(Rect touchableRegion) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(touchableRegion, 0);
                    boolean _status = this.mRemote.transact(78, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerPinnedTaskListener(int displayId, IPinnedTaskListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(79, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestAppKeyboardShortcuts(IResultReceiver receiver, int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(receiver);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(80, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getStableInsets(int displayId, Rect outInsets) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(81, _data, _reply, 0);
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        outInsets.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerShortcutKey(long shortcutCode, IShortcutService keySubscriber) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(shortcutCode);
                    _data.writeStrongInterface(keySubscriber);
                    boolean _status = this.mRemote.transact(82, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createInputConsumer(IBinder token, String name, int displayId, InputChannel inputChannel) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeString(name);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(83, _data, _reply, 0);
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        inputChannel.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean destroyInputConsumer(String name, int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(84, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Region getCurrentImeTouchRegion() throws RemoteException {
                Region _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(85, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Region.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerDisplayFoldListener(IDisplayFoldListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(86, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterDisplayFoldListener(IDisplayFoldListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(87, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] registerDisplayWindowListener(IDisplayWindowListener listener) throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(88, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterDisplayWindowListener(IDisplayWindowListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(89, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startWindowTrace() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(90, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopWindowTrace() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(91, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void saveWindowTraceToFile() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(92, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isWindowTraceEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(93, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getWindowingMode(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(94, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWindowingMode(int displayId, int mode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(95, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRemoveContentMode(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(96, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRemoveContentMode(int displayId, int mode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(97, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean shouldShowWithInsecureKeyguard(int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(98, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setShouldShowWithInsecureKeyguard(int displayId, boolean shouldShow) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeBoolean(shouldShow);
                    boolean _status = this.mRemote.transact(99, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean shouldShowSystemDecors(int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(100, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setShouldShowSystemDecors(int displayId, boolean shouldShow) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeBoolean(shouldShow);
                    boolean _status = this.mRemote.transact(101, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDisplayImePolicy(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(102, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDisplayImePolicy(int displayId, int imePolicy) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(imePolicy);
                    boolean _status = this.mRemote.transact(103, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void syncInputTransactions(boolean waitForAnimations) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(waitForAnimations);
                    boolean _status = this.mRemote.transact(104, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isLayerTracing() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(105, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLayerTracing(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(106, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean mirrorDisplay(int displayId, SurfaceControl outSurfaceControl) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(107, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                    if (0 != _reply.readInt()) {
                        outSurfaceControl.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDisplayWindowInsetsController(int displayId, IDisplayWindowInsetsController displayWindowInsetsController) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeStrongInterface(displayWindowInsetsController);
                    boolean _status = this.mRemote.transact(108, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateDisplayWindowRequestedVisibilities(int displayId, InsetsVisibilities vis) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(vis, 0);
                    boolean _status = this.mRemote.transact(109, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getWindowInsets(WindowManager.LayoutParams attrs, int displayId, InsetsState outInsetsState) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(attrs, 0);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(110, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                    if (0 != _reply.readInt()) {
                        outInsetsState.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<DisplayInfo> getPossibleDisplayInfo(int displayId, String packageName) throws RemoteException {
                ArrayList<DisplayInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(111, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(DisplayInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showGlobalActions() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(112, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLayerTracingFlags(int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(113, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestScrollCapture(int displayId, IBinder behindClient, int taskId, IScrollCaptureResponseListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeStrongBinder(behindClient);
                    _data.writeInt(taskId);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(114, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void holdLock(IBinder token, int durationMs) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(durationMs);
                    boolean _status = this.mRemote.transact(115, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getSupportedDisplayHashAlgorithms() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(116, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VerifiedDisplayHash verifyDisplayHash(DisplayHash displayHash) throws RemoteException {
                VerifiedDisplayHash _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(displayHash, 0);
                    boolean _status = this.mRemote.transact(117, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(VerifiedDisplayHash.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDisplayHashThrottlingEnabled(boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(118, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Configuration attachWindowContextToDisplayArea(IBinder clientToken, int type, int displayId, Bundle options) throws RemoteException {
                Configuration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(clientToken);
                    _data.writeInt(type);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(options, 0);
                    boolean _status = this.mRemote.transact(119, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Configuration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void attachWindowContextToWindowToken(IBinder clientToken, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(clientToken);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(120, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Configuration attachToDisplayContent(IBinder clientToken, int displayId) throws RemoteException {
                Configuration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(clientToken);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(121, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Configuration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void detachWindowContextFromWindowContainer(IBinder clientToken) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(clientToken);
                    boolean _status = this.mRemote.transact(122, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean registerCrossWindowBlurEnabledListener(ICrossWindowBlurEnabledListener listener) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(123, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterCrossWindowBlurEnabledListener(ICrossWindowBlurEnabledListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(124, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isTaskSnapshotSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(125, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getImeDisplayId() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(126, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTaskSnapshotEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(127, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTaskTransitionSpec(TaskTransitionSpec spec) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(spec, 0);
                    boolean _status = this.mRemote.transact(128, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearTaskTransitionSpec() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(129, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerTaskFpsCallback(int taskId, ITaskFpsCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(taskId);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(130, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterTaskFpsCallback(ITaskFpsCallback listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(131, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bitmap snapshotTaskForRecents(int taskId) throws RemoteException {
                Bitmap _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(taskId);
                    boolean _status = this.mRemote.transact(132, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Bitmap.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRecentsAppBehindSystemBars(boolean behindSystemBars) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(behindSystemBars);
                    boolean _status = this.mRemote.transact(133, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWindowManager {
        @Override
        public boolean startViewServer(int port) throws RemoteException {
            return false;
        }

        @Override
        public boolean stopViewServer() throws RemoteException {
            return false;
        }

        @Override
        public boolean isViewServerRunning() throws RemoteException {
            return false;
        }

        @Override
        public IWindowSession openSession(IWindowSessionCallback callback) throws RemoteException {
            return null;
        }

        @Override
        public boolean useBLAST() throws RemoteException {
            return false;
        }

        @Override
        public void getInitialDisplaySize(int displayId, Point size) throws RemoteException {
        }

        @Override
        public void getBaseDisplaySize(int displayId, Point size) throws RemoteException {
        }

        @Override
        public void setForcedDisplaySize(int displayId, int width, int height) throws RemoteException {
        }

        @Override
        public void clearForcedDisplaySize(int displayId) throws RemoteException {
        }

        @Override
        public int getInitialDisplayDensity(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public int getBaseDisplayDensity(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public void setForcedDisplayDensityForUser(int displayId, int density, int userId) throws RemoteException {
        }

        @Override
        public void clearForcedDisplayDensityForUser(int displayId, int userId) throws RemoteException {
        }

        @Override
        public void setForcedDisplayScalingMode(int displayId, int mode) throws RemoteException {
        }

        @Override
        public void setEventDispatching(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean isWindowToken(IBinder binder) throws RemoteException {
            return false;
        }

        @Override
        public void addWindowToken(IBinder token, int type, int displayId, Bundle options) throws RemoteException {
        }

        @Override
        public void removeWindowToken(IBinder token, int displayId) throws RemoteException {
        }

        @Override
        public void setDisplayWindowRotationController(IDisplayWindowRotationController controller) throws RemoteException {
        }

        @Override
        public SurfaceControl addShellRoot(int displayId, IWindow client, int shellRootLayer) throws RemoteException {
            return null;
        }

        @Override
        public void setShellRootAccessibilityWindow(int displayId, int shellRootLayer, IWindow target) throws RemoteException {
        }

        @Override
        public void overridePendingAppTransitionMultiThumbFuture(IAppTransitionAnimationSpecsFuture specsFuture, IRemoteCallback startedCallback, boolean scaleUp, int displayId) throws RemoteException {
        }

        @Override
        public void overridePendingAppTransitionRemote(RemoteAnimationAdapter remoteAnimationAdapter, int displayId) throws RemoteException {
        }

        @Override
        public void endProlongedAnimations() throws RemoteException {
        }

        @Override
        public void startFreezingScreen(int exitAnim, int enterAnim) throws RemoteException {
        }

        @Override
        public void stopFreezingScreen() throws RemoteException {
        }

        @Override
        public void disableKeyguard(IBinder token, String tag, int userId) throws RemoteException {
        }

        @Override
        public void reenableKeyguard(IBinder token, int userId) throws RemoteException {
        }

        @Override
        public void exitKeyguardSecurely(IOnKeyguardExitResult callback) throws RemoteException {
        }

        @Override
        public boolean isKeyguardLocked() throws RemoteException {
            return false;
        }

        @Override
        public boolean isKeyguardSecure(int userId) throws RemoteException {
            return false;
        }

        @Override
        public void dismissKeyguard(IKeyguardDismissCallback callback, CharSequence message) throws RemoteException {
        }

        @Override
        public void addKeyguardLockedStateListener(IKeyguardLockedStateListener listener) throws RemoteException {
        }

        @Override
        public void removeKeyguardLockedStateListener(IKeyguardLockedStateListener listener) throws RemoteException {
        }

        @Override
        public void setSwitchingUser(boolean switching) throws RemoteException {
        }

        @Override
        public void closeSystemDialogs(String reason) throws RemoteException {
        }

        @Override
        public float getAnimationScale(int which) throws RemoteException {
            return 0.0f;
        }

        @Override
        public float[] getAnimationScales() throws RemoteException {
            return null;
        }

        @Override
        public void setAnimationScale(int which, float scale) throws RemoteException {
        }

        @Override
        public void setAnimationScales(float[] scales) throws RemoteException {
        }

        @Override
        public float getCurrentAnimatorScale() throws RemoteException {
            return 0.0f;
        }

        @Override
        public void setInTouchMode(boolean showFocus) throws RemoteException {
        }

        @Override
        public void showStrictModeViolation(boolean on) throws RemoteException {
        }

        @Override
        public void setStrictModeVisualIndicatorPreference(String enabled) throws RemoteException {
        }

        @Override
        public void refreshScreenCaptureDisabled() throws RemoteException {
        }

        @Override
        public void updateRotation(boolean alwaysSendConfiguration, boolean forceRelayout) throws RemoteException {
        }

        @Override
        public int getDefaultDisplayRotation() throws RemoteException {
            return 0;
        }

        @Override
        public int watchRotation(IRotationWatcher watcher, int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public void removeRotationWatcher(IRotationWatcher watcher) throws RemoteException {
        }

        @Override
        public int getPreferredOptionsPanelGravity(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public void freezeRotation(int rotation) throws RemoteException {
        }

        @Override
        public void thawRotation() throws RemoteException {
        }

        @Override
        public boolean isRotationFrozen() throws RemoteException {
            return false;
        }

        @Override
        public void freezeDisplayRotation(int displayId, int rotation) throws RemoteException {
        }

        @Override
        public void thawDisplayRotation(int displayId) throws RemoteException {
        }

        @Override
        public boolean isDisplayRotationFrozen(int displayId) throws RemoteException {
            return false;
        }

        @Override
        public void setFixedToUserRotation(int displayId, int fixedToUserRotation) throws RemoteException {
        }

        @Override
        public void setIgnoreOrientationRequest(int displayId, boolean ignoreOrientationRequest) throws RemoteException {
        }

        @Override
        public Bitmap screenshotWallpaper() throws RemoteException {
            return null;
        }

        @Override
        public SurfaceControl mirrorWallpaperSurface(int displayId) throws RemoteException {
            return null;
        }

        @Override
        public boolean registerWallpaperVisibilityListener(IWallpaperVisibilityListener listener, int displayId) throws RemoteException {
            return false;
        }

        @Override
        public void unregisterWallpaperVisibilityListener(IWallpaperVisibilityListener listener, int displayId) throws RemoteException {
        }

        @Override
        public void registerSystemGestureExclusionListener(ISystemGestureExclusionListener listener, int displayId) throws RemoteException {
        }

        @Override
        public void unregisterSystemGestureExclusionListener(ISystemGestureExclusionListener listener, int displayId) throws RemoteException {
        }

        @Override
        public boolean requestAssistScreenshot(IAssistDataReceiver receiver) throws RemoteException {
            return false;
        }

        @Override
        public void hideTransientBars(int displayId) throws RemoteException {
        }

        @Override
        public void setRecentsVisibility(boolean visible) throws RemoteException {
        }

        @Override
        public void updateStaticPrivacyIndicatorBounds(int displayId, Rect[] staticBounds) throws RemoteException {
        }

        @Override
        public void setNavBarVirtualKeyHapticFeedbackEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean hasNavigationBar(int displayId) throws RemoteException {
            return false;
        }

        @Override
        public int getNavBarPosition(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public void lockNow(Bundle options) throws RemoteException {
        }

        @Override
        public boolean isSafeModeEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void enableScreenIfNeeded() throws RemoteException {
        }

        @Override
        public boolean clearWindowContentFrameStats(IBinder token) throws RemoteException {
            return false;
        }

        @Override
        public WindowContentFrameStats getWindowContentFrameStats(IBinder token) throws RemoteException {
            return null;
        }

        @Override
        public int getDockedStackSide() throws RemoteException {
            return 0;
        }

        @Override
        public void setDockedTaskDividerTouchRegion(Rect touchableRegion) throws RemoteException {
        }

        @Override
        public void registerPinnedTaskListener(int displayId, IPinnedTaskListener listener) throws RemoteException {
        }

        @Override
        public void requestAppKeyboardShortcuts(IResultReceiver receiver, int deviceId) throws RemoteException {
        }

        @Override
        public void getStableInsets(int displayId, Rect outInsets) throws RemoteException {
        }

        @Override
        public void registerShortcutKey(long shortcutCode, IShortcutService keySubscriber) throws RemoteException {
        }

        @Override
        public void createInputConsumer(IBinder token, String name, int displayId, InputChannel inputChannel) throws RemoteException {
        }

        @Override
        public boolean destroyInputConsumer(String name, int displayId) throws RemoteException {
            return false;
        }

        @Override
        public Region getCurrentImeTouchRegion() throws RemoteException {
            return null;
        }

        @Override
        public void registerDisplayFoldListener(IDisplayFoldListener listener) throws RemoteException {
        }

        @Override
        public void unregisterDisplayFoldListener(IDisplayFoldListener listener) throws RemoteException {
        }

        @Override
        public int[] registerDisplayWindowListener(IDisplayWindowListener listener) throws RemoteException {
            return null;
        }

        @Override
        public void unregisterDisplayWindowListener(IDisplayWindowListener listener) throws RemoteException {
        }

        @Override
        public void startWindowTrace() throws RemoteException {
        }

        @Override
        public void stopWindowTrace() throws RemoteException {
        }

        @Override
        public void saveWindowTraceToFile() throws RemoteException {
        }

        @Override
        public boolean isWindowTraceEnabled() throws RemoteException {
            return false;
        }

        @Override
        public int getWindowingMode(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public void setWindowingMode(int displayId, int mode) throws RemoteException {
        }

        @Override
        public int getRemoveContentMode(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public void setRemoveContentMode(int displayId, int mode) throws RemoteException {
        }

        @Override
        public boolean shouldShowWithInsecureKeyguard(int displayId) throws RemoteException {
            return false;
        }

        @Override
        public void setShouldShowWithInsecureKeyguard(int displayId, boolean shouldShow) throws RemoteException {
        }

        @Override
        public boolean shouldShowSystemDecors(int displayId) throws RemoteException {
            return false;
        }

        @Override
        public void setShouldShowSystemDecors(int displayId, boolean shouldShow) throws RemoteException {
        }

        @Override
        public int getDisplayImePolicy(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public void setDisplayImePolicy(int displayId, int imePolicy) throws RemoteException {
        }

        @Override
        public void syncInputTransactions(boolean waitForAnimations) throws RemoteException {
        }

        @Override
        public boolean isLayerTracing() throws RemoteException {
            return false;
        }

        @Override
        public void setLayerTracing(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean mirrorDisplay(int displayId, SurfaceControl outSurfaceControl) throws RemoteException {
            return false;
        }

        @Override
        public void setDisplayWindowInsetsController(int displayId, IDisplayWindowInsetsController displayWindowInsetsController) throws RemoteException {
        }

        @Override
        public void updateDisplayWindowRequestedVisibilities(int displayId, InsetsVisibilities vis) throws RemoteException {
        }

        @Override
        public boolean getWindowInsets(WindowManager.LayoutParams attrs, int displayId, InsetsState outInsetsState) throws RemoteException {
            return false;
        }

        @Override
        public List<DisplayInfo> getPossibleDisplayInfo(int displayId, String packageName) throws RemoteException {
            return null;
        }

        @Override
        public void showGlobalActions() throws RemoteException {
        }

        @Override
        public void setLayerTracingFlags(int flags) throws RemoteException {
        }

        @Override
        public void requestScrollCapture(int displayId, IBinder behindClient, int taskId, IScrollCaptureResponseListener listener) throws RemoteException {
        }

        @Override
        public void holdLock(IBinder token, int durationMs) throws RemoteException {
        }

        @Override
        public String[] getSupportedDisplayHashAlgorithms() throws RemoteException {
            return null;
        }

        @Override
        public VerifiedDisplayHash verifyDisplayHash(DisplayHash displayHash) throws RemoteException {
            return null;
        }

        @Override
        public void setDisplayHashThrottlingEnabled(boolean enable) throws RemoteException {
        }

        @Override
        public Configuration attachWindowContextToDisplayArea(IBinder clientToken, int type, int displayId, Bundle options) throws RemoteException {
            return null;
        }

        @Override
        public void attachWindowContextToWindowToken(IBinder clientToken, IBinder token) throws RemoteException {
        }

        @Override
        public Configuration attachToDisplayContent(IBinder clientToken, int displayId) throws RemoteException {
            return null;
        }

        @Override
        public void detachWindowContextFromWindowContainer(IBinder clientToken) throws RemoteException {
        }

        @Override
        public boolean registerCrossWindowBlurEnabledListener(ICrossWindowBlurEnabledListener listener) throws RemoteException {
            return false;
        }

        @Override
        public void unregisterCrossWindowBlurEnabledListener(ICrossWindowBlurEnabledListener listener) throws RemoteException {
        }

        @Override
        public boolean isTaskSnapshotSupported() throws RemoteException {
            return false;
        }

        @Override
        public int getImeDisplayId() throws RemoteException {
            return 0;
        }

        @Override
        public void setTaskSnapshotEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public void setTaskTransitionSpec(TaskTransitionSpec spec) throws RemoteException {
        }

        @Override
        public void clearTaskTransitionSpec() throws RemoteException {
        }

        @Override
        public void registerTaskFpsCallback(int taskId, ITaskFpsCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterTaskFpsCallback(ITaskFpsCallback listener) throws RemoteException {
        }

        @Override
        public Bitmap snapshotTaskForRecents(int taskId) throws RemoteException {
            return null;
        }

        @Override
        public void setRecentsAppBehindSystemBars(boolean behindSystemBars) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

