/*
 * Decompiled with CFR 0.152.
 */
package android.uwb;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.uwb.RangingMeasurement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@SystemApi
public class RangingReport
implements Parcelable {
    private final List<RangingMeasurement> mRangingMeasurements;
    public static final Parcelable.Creator<RangingReport> CREATOR = new Parcelable.Creator<RangingReport>(){

        @Override
        public RangingReport createFromParcel(Parcel in) {
            Builder builder = new Builder();
            builder.addMeasurements(in.createTypedArrayList(RangingMeasurement.CREATOR));
            return builder.build();
        }

        public RangingReport[] newArray(int size) {
            return new RangingReport[size];
        }
    };

    private RangingReport(List<RangingMeasurement> rangingMeasurements) {
        this.mRangingMeasurements = rangingMeasurements;
    }

    public List<RangingMeasurement> getMeasurements() {
        return this.mRangingMeasurements;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RangingReport) {
            RangingReport other = (RangingReport)obj;
            return this.mRangingMeasurements.equals(other.getMeasurements());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mRangingMeasurements);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedList(this.mRangingMeasurements);
    }

    public String toString() {
        return "RangingReport[measurements: " + this.mRangingMeasurements + "]";
    }

    public static class Builder {
        List<RangingMeasurement> mMeasurements = new ArrayList<RangingMeasurement>();

        public Builder addMeasurement(RangingMeasurement rangingMeasurement) {
            this.mMeasurements.add(rangingMeasurement);
            return this;
        }

        public Builder addMeasurements(List<RangingMeasurement> rangingMeasurements) {
            this.mMeasurements.addAll(rangingMeasurements);
            return this;
        }

        public RangingReport build() {
            RangingMeasurement prevMeasurement = null;
            for (int curIndex = 0; curIndex < this.mMeasurements.size(); ++curIndex) {
                RangingMeasurement curMeasurement = this.mMeasurements.get(curIndex);
                if (prevMeasurement != null && prevMeasurement.getElapsedRealtimeNanos() > curMeasurement.getElapsedRealtimeNanos()) {
                    throw new IllegalStateException("Timestamp (" + curMeasurement.getElapsedRealtimeNanos() + ") at index " + curIndex + " is less than previous timestamp (" + prevMeasurement.getElapsedRealtimeNanos() + ")");
                }
                prevMeasurement = curMeasurement;
            }
            return new RangingReport(this.mMeasurements);
        }
    }
}

