/*
 * Decompiled with CFR 0.152.
 */
package android.uwb;

import android.content.AttributionSource;
import android.os.CancellationSignal;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.util.Log;
import android.uwb.IUwbAdapter;
import android.uwb.IUwbRangingCallbacks;
import android.uwb.RangingChangeReason;
import android.uwb.RangingReport;
import android.uwb.RangingSession;
import android.uwb.SessionHandle;
import android.uwb.UwbAddress;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Executor;

public class RangingManager
extends IUwbRangingCallbacks.Stub {
    private static final String TAG = "Uwb.RangingManager";
    private final IUwbAdapter mAdapter;
    private final Hashtable<SessionHandle, RangingSession> mRangingSessionTable = new Hashtable();
    private int mNextSessionId = 1;

    public RangingManager(IUwbAdapter adapter) {
        this.mAdapter = adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CancellationSignal openSession(AttributionSource attributionSource, PersistableBundle params, Executor executor, RangingSession.Callback callbacks, String chipId) {
        if (chipId != null) {
            try {
                List<String> validChipIds = this.mAdapter.getChipIds();
                if (!validChipIds.contains(chipId)) {
                    throw new IllegalArgumentException("openSession - received invalid chipId: " + chipId);
                }
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            SessionHandle sessionHandle = new SessionHandle(this.mNextSessionId++);
            RangingSession session = new RangingSession(executor, callbacks, this.mAdapter, sessionHandle, chipId);
            this.mRangingSessionTable.put(sessionHandle, session);
            try {
                this.mAdapter.openRanging(attributionSource, sessionHandle, this, params, chipId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            CancellationSignal cancellationSignal = new CancellationSignal();
            cancellationSignal.setOnCancelListener(() -> session.close());
            return cancellationSignal;
        }
    }

    private boolean hasSession(SessionHandle sessionHandle) {
        return this.mRangingSessionTable.containsKey(sessionHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingOpened(SessionHandle sessionHandle) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onRangingOpened - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingOpened();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingOpenFailed(SessionHandle sessionHandle, @RangingChangeReason int reason, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onRangingOpenedFailed - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingOpenFailed(RangingManager.convertToReason(reason), parameters);
            this.mRangingSessionTable.remove(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingReconfigured(SessionHandle sessionHandle, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onRangingReconfigured - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingReconfigured(parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingReconfigureFailed(SessionHandle sessionHandle, @RangingChangeReason int reason, PersistableBundle params) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onRangingReconfigureFailed - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingReconfigureFailed(RangingManager.convertToReason(reason), params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingStarted(SessionHandle sessionHandle, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onRangingStarted - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingStarted(parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingStartFailed(SessionHandle sessionHandle, @RangingChangeReason int reason, PersistableBundle params) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onRangingStartFailed - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingStartFailed(RangingManager.convertToReason(reason), params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingStopped(SessionHandle sessionHandle, @RangingChangeReason int reason, PersistableBundle params) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onRangingStopped - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingStopped(RangingManager.convertToReason(reason), params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingStopFailed(SessionHandle sessionHandle, @RangingChangeReason int reason, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onRangingStopFailed - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingStopFailed(RangingManager.convertToReason(reason), parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingClosed(SessionHandle sessionHandle, @RangingChangeReason int reason, PersistableBundle params) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onRangingClosed - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingClosed(RangingManager.convertToReason(reason), params);
            this.mRangingSessionTable.remove(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingResult(SessionHandle sessionHandle, RangingReport result) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onRangingResult - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingResult(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onControleeAdded(SessionHandle sessionHandle, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onControleeAdded - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onControleeAdded(parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onControleeAddFailed(SessionHandle sessionHandle, @RangingChangeReason int reason, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onControleeAddFailed - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onControleeAddFailed(reason, parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onControleeRemoved(SessionHandle sessionHandle, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onControleeRemoved - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onControleeRemoved(parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onControleeRemoveFailed(SessionHandle sessionHandle, @RangingChangeReason int reason, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onControleeRemoveFailed - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onControleeRemoveFailed(reason, parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingPaused(SessionHandle sessionHandle, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onRangingPaused - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingPaused(parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingPauseFailed(SessionHandle sessionHandle, @RangingChangeReason int reason, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onRangingPauseFailed - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingPauseFailed(reason, parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingResumed(SessionHandle sessionHandle, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onRangingResumed - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingResumed(parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRangingResumeFailed(SessionHandle sessionHandle, @RangingChangeReason int reason, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onRangingResumeFailed - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onRangingResumeFailed(reason, parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataSent(SessionHandle sessionHandle, UwbAddress remoteDeviceAddress, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onDataSent - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onDataSent(remoteDeviceAddress, parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataSendFailed(SessionHandle sessionHandle, UwbAddress remoteDeviceAddress, @RangingChangeReason int reason, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onDataSendFailed - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onDataSendFailed(remoteDeviceAddress, reason, parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataReceived(SessionHandle sessionHandle, UwbAddress remoteDeviceAddress, PersistableBundle parameters, byte[] data) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onDataReceived - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onDataReceived(remoteDeviceAddress, parameters, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataReceiveFailed(SessionHandle sessionHandle, UwbAddress remoteDeviceAddress, @RangingChangeReason int reason, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onDataReceiveFailed - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onDataReceiveFailed(remoteDeviceAddress, reason, parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceDiscovered(SessionHandle sessionHandle, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onServiceDiscovered - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onServiceDiscovered(parameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceConnected(SessionHandle sessionHandle, PersistableBundle parameters) {
        RangingManager rangingManager = this;
        synchronized (rangingManager) {
            if (!this.hasSession(sessionHandle)) {
                Log.w(TAG, "onServiceConnected - received unexpected SessionHandle: " + sessionHandle);
                return;
            }
            RangingSession session = this.mRangingSessionTable.get(sessionHandle);
            session.onServiceConnected(parameters);
        }
    }

    private static int convertToReason(@RangingChangeReason int reason) {
        switch (reason) {
            case 1: {
                return 1;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 6;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 7;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 9;
            }
        }
        return 0;
    }
}

