/*
 * Decompiled with CFR 0.152.
 */
package android.util.apk;

import android.os._Original_Build;
import android.util.ArrayMap;
import android.util.Pair;
import android.util.apk.ApkSigningBlockUtils;
import android.util.apk.ByteBufferFactory;
import android.util.apk.SignatureInfo;
import android.util.apk.SignatureNotFoundException;
import android.util.apk.VerbatimX509Certificate;
import android.util.apk.VerityBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;

public class ApkSignatureSchemeV3Verifier {
    public static final int SF_ATTRIBUTE_ANDROID_APK_SIGNED_ID = 3;
    static final int APK_SIGNATURE_SCHEME_V3_BLOCK_ID = -262969152;
    static final int APK_SIGNATURE_SCHEME_V31_BLOCK_ID = 462663009;
    private final RandomAccessFile mApk;
    private final boolean mVerifyIntegrity;
    private OptionalInt mOptionalRotationMinSdkVersion = OptionalInt.empty();
    private int mSignerMinSdkVersion;
    private int mBlockId;
    private static final int PROOF_OF_ROTATION_ATTR_ID = 1000370060;
    private static final int ROTATION_MIN_SDK_VERSION_ATTR_ID = 1436519170;
    private static final int ROTATION_ON_DEV_RELEASE_ATTR_ID = -1029262406;

    public static boolean hasSignature(String apkFile) throws IOException {
        boolean bl;
        RandomAccessFile apk = new RandomAccessFile(apkFile, "r");
        try {
            ApkSignatureSchemeV3Verifier.findSignature(apk);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    apk.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SignatureNotFoundException e) {
                return false;
            }
        }
        apk.close();
        return bl;
    }

    public static VerifiedSigner verify(String apkFile) throws SignatureNotFoundException, SecurityException, IOException {
        return ApkSignatureSchemeV3Verifier.verify(apkFile, true);
    }

    public static VerifiedSigner unsafeGetCertsWithoutVerification(String apkFile) throws SignatureNotFoundException, SecurityException, IOException {
        return ApkSignatureSchemeV3Verifier.verify(apkFile, false);
    }

    private static VerifiedSigner verify(String apkFile, boolean verifyIntegrity) throws SignatureNotFoundException, SecurityException, IOException {
        try (RandomAccessFile apk = new RandomAccessFile(apkFile, "r");){
            VerifiedSigner verifiedSigner = ApkSignatureSchemeV3Verifier.verify(apk, verifyIntegrity);
            return verifiedSigner;
        }
    }

    private static VerifiedSigner verify(RandomAccessFile apk, boolean verifyIntegrity) throws SignatureNotFoundException, SecurityException, IOException {
        ApkSignatureSchemeV3Verifier verifier = new ApkSignatureSchemeV3Verifier(apk, verifyIntegrity);
        try {
            SignatureInfo signatureInfo = ApkSignatureSchemeV3Verifier.findSignature(apk, 462663009);
            return verifier.verify(signatureInfo, 462663009);
        }
        catch (SignatureNotFoundException signatureInfo) {
        }
        catch (PlatformNotSupportedException signatureInfo) {
            // empty catch block
        }
        try {
            SignatureInfo signatureInfo = ApkSignatureSchemeV3Verifier.findSignature(apk, -262969152);
            return verifier.verify(signatureInfo, -262969152);
        }
        catch (PlatformNotSupportedException e) {
            throw new SecurityException(e);
        }
    }

    public static SignatureInfo findSignature(RandomAccessFile apk) throws IOException, SignatureNotFoundException {
        return ApkSignatureSchemeV3Verifier.findSignature(apk, -262969152);
    }

    private static SignatureInfo findSignature(RandomAccessFile apk, int blockId) throws IOException, SignatureNotFoundException {
        return ApkSigningBlockUtils.findSignature(apk, blockId);
    }

    private ApkSignatureSchemeV3Verifier(RandomAccessFile apk, boolean verifyIntegrity) {
        this.mApk = apk;
        this.mVerifyIntegrity = verifyIntegrity;
    }

    private VerifiedSigner verify(SignatureInfo signatureInfo, int blockId) throws SecurityException, IOException, PlatformNotSupportedException {
        ByteBuffer signers;
        CertificateFactory certFactory;
        this.mBlockId = blockId;
        int signerCount = 0;
        ArrayMap<Integer, byte[]> contentDigests = new ArrayMap<Integer, byte[]>();
        Pair<X509Certificate[], ApkSigningBlockUtils.VerifiedProofOfRotation> result = null;
        try {
            certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Failed to obtain X.509 CertificateFactory", e);
        }
        try {
            signers = ApkSigningBlockUtils.getLengthPrefixedSlice(signatureInfo.signatureBlock);
        }
        catch (IOException e) {
            throw new SecurityException("Failed to read list of signers", e);
        }
        while (signers.hasRemaining()) {
            try {
                ByteBuffer signer = ApkSigningBlockUtils.getLengthPrefixedSlice(signers);
                result = this.verifySigner(signer, contentDigests, certFactory);
                ++signerCount;
            }
            catch (PlatformNotSupportedException e) {
            }
            catch (IOException | SecurityException | BufferUnderflowException e) {
                throw new SecurityException("Failed to parse/verify signer #" + signerCount + " block", e);
            }
        }
        if (signerCount < 1 || result == null) {
            if (blockId == -262969152) {
                throw new SecurityException("No signers found");
            }
            throw new PlatformNotSupportedException("None of the signers support the current platform version");
        }
        if (signerCount != 1) {
            throw new SecurityException("APK Signature Scheme V3 only supports one signer: multiple signers found.");
        }
        if (contentDigests.isEmpty()) {
            throw new SecurityException("No content digests found");
        }
        if (this.mVerifyIntegrity) {
            ApkSigningBlockUtils.verifyIntegrity(contentDigests, this.mApk, signatureInfo);
        }
        byte[] verityRootHash = null;
        if (contentDigests.containsKey(3)) {
            byte[] verityDigest = (byte[])contentDigests.get(3);
            verityRootHash = ApkSigningBlockUtils.parseVerityDigestAndVerifySourceLength(verityDigest, this.mApk.getChannel().size(), signatureInfo);
        }
        return new VerifiedSigner((X509Certificate[])result.first, (ApkSigningBlockUtils.VerifiedProofOfRotation)result.second, verityRootHash, contentDigests, blockId);
    }

    private Pair<X509Certificate[], ApkSigningBlockUtils.VerifiedProofOfRotation> verifySigner(ByteBuffer signerBlock, Map<Integer, byte[]> contentDigests, CertificateFactory certFactory) throws SecurityException, IOException, PlatformNotSupportedException {
        boolean sigVerified;
        ByteBuffer signedData = ApkSigningBlockUtils.getLengthPrefixedSlice(signerBlock);
        int minSdkVersion = signerBlock.getInt();
        int maxSdkVersion = signerBlock.getInt();
        if (_Original_Build.VERSION.SDK_INT < minSdkVersion || _Original_Build.VERSION.SDK_INT > maxSdkVersion) {
            if (!(this.mBlockId != 462663009 || this.mOptionalRotationMinSdkVersion.isPresent() && this.mOptionalRotationMinSdkVersion.getAsInt() <= minSdkVersion)) {
                this.mOptionalRotationMinSdkVersion = OptionalInt.of(minSdkVersion);
            }
            throw new PlatformNotSupportedException("Signer not supported by this platform version. This platform: " + _Original_Build.VERSION.SDK_INT + ", signer minSdkVersion: " + minSdkVersion + ", maxSdkVersion: " + maxSdkVersion);
        }
        ByteBuffer signatures = ApkSigningBlockUtils.getLengthPrefixedSlice(signerBlock);
        byte[] publicKeyBytes = ApkSigningBlockUtils.readLengthPrefixedByteArray(signerBlock);
        int signatureCount = 0;
        int bestSigAlgorithm = -1;
        byte[] bestSigAlgorithmSignatureBytes = null;
        ArrayList<Integer> signaturesSigAlgorithms = new ArrayList<Integer>();
        while (signatures.hasRemaining()) {
            ++signatureCount;
            try {
                ByteBuffer signature = ApkSigningBlockUtils.getLengthPrefixedSlice(signatures);
                if (signature.remaining() < 8) {
                    throw new SecurityException("Signature record too short");
                }
                int sigAlgorithm = signature.getInt();
                signaturesSigAlgorithms.add(sigAlgorithm);
                if (!ApkSigningBlockUtils.isSupportedSignatureAlgorithm(sigAlgorithm) || bestSigAlgorithm != -1 && ApkSigningBlockUtils.compareSignatureAlgorithm(sigAlgorithm, bestSigAlgorithm) <= 0) continue;
                bestSigAlgorithm = sigAlgorithm;
                bestSigAlgorithmSignatureBytes = ApkSigningBlockUtils.readLengthPrefixedByteArray(signature);
            }
            catch (IOException | BufferUnderflowException e) {
                throw new SecurityException("Failed to parse signature record #" + signatureCount, e);
            }
        }
        if (bestSigAlgorithm == -1) {
            if (signatureCount == 0) {
                throw new SecurityException("No signatures found");
            }
            throw new SecurityException("No supported signatures found");
        }
        String keyAlgorithm = ApkSigningBlockUtils.getSignatureAlgorithmJcaKeyAlgorithm(bestSigAlgorithm);
        Pair<String, ? extends AlgorithmParameterSpec> signatureAlgorithmParams = ApkSigningBlockUtils.getSignatureAlgorithmJcaSignatureAlgorithm(bestSigAlgorithm);
        String jcaSignatureAlgorithm = (String)signatureAlgorithmParams.first;
        AlgorithmParameterSpec jcaSignatureAlgorithmParams = (AlgorithmParameterSpec)signatureAlgorithmParams.second;
        try {
            PublicKey publicKey = KeyFactory.getInstance(keyAlgorithm).generatePublic(new X509EncodedKeySpec(publicKeyBytes));
            Signature sig = Signature.getInstance(jcaSignatureAlgorithm);
            sig.initVerify(publicKey);
            if (jcaSignatureAlgorithmParams != null) {
                sig.setParameter(jcaSignatureAlgorithmParams);
            }
            sig.update(signedData);
            sigVerified = sig.verify(bestSigAlgorithmSignatureBytes);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            throw new SecurityException("Failed to verify " + jcaSignatureAlgorithm + " signature", e);
        }
        if (!sigVerified) {
            throw new SecurityException(jcaSignatureAlgorithm + " signature did not verify");
        }
        byte[] contentDigest = null;
        signedData.clear();
        ByteBuffer digests = ApkSigningBlockUtils.getLengthPrefixedSlice(signedData);
        ArrayList<Integer> digestsSigAlgorithms = new ArrayList<Integer>();
        int digestCount = 0;
        while (digests.hasRemaining()) {
            ++digestCount;
            try {
                ByteBuffer digest = ApkSigningBlockUtils.getLengthPrefixedSlice(digests);
                if (digest.remaining() < 8) {
                    throw new IOException("Record too short");
                }
                int sigAlgorithm = digest.getInt();
                digestsSigAlgorithms.add(sigAlgorithm);
                if (sigAlgorithm != bestSigAlgorithm) continue;
                contentDigest = ApkSigningBlockUtils.readLengthPrefixedByteArray(digest);
            }
            catch (IOException | BufferUnderflowException e) {
                throw new IOException("Failed to parse digest record #" + digestCount, e);
            }
        }
        if (!signaturesSigAlgorithms.equals(digestsSigAlgorithms)) {
            throw new SecurityException("Signature algorithms don't match between digests and signatures records");
        }
        int digestAlgorithm = ApkSigningBlockUtils.getSignatureAlgorithmContentDigestAlgorithm(bestSigAlgorithm);
        byte[] previousSignerDigest = contentDigests.put(digestAlgorithm, contentDigest);
        if (previousSignerDigest != null && !MessageDigest.isEqual(previousSignerDigest, contentDigest)) {
            throw new SecurityException(ApkSigningBlockUtils.getContentDigestAlgorithmJcaDigestAlgorithm(digestAlgorithm) + " contents digest does not match the digest specified by a preceding signer");
        }
        ByteBuffer certificates = ApkSigningBlockUtils.getLengthPrefixedSlice(signedData);
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        int certificateCount = 0;
        while (certificates.hasRemaining()) {
            X509Certificate certificate;
            ++certificateCount;
            byte[] encodedCert = ApkSigningBlockUtils.readLengthPrefixedByteArray(certificates);
            try {
                certificate = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(encodedCert));
            }
            catch (CertificateException e) {
                throw new SecurityException("Failed to decode certificate #" + certificateCount, e);
            }
            certificate = new VerbatimX509Certificate(certificate, encodedCert);
            certs.add(certificate);
        }
        if (certs.isEmpty()) {
            throw new SecurityException("No certificates listed");
        }
        X509Certificate mainCertificate = (X509Certificate)certs.get(0);
        byte[] certificatePublicKeyBytes = mainCertificate.getPublicKey().getEncoded();
        if (!Arrays.equals(publicKeyBytes, certificatePublicKeyBytes)) {
            throw new SecurityException("Public key mismatch between certificate and signature record");
        }
        int signedMinSDK = signedData.getInt();
        if (signedMinSDK != minSdkVersion) {
            throw new SecurityException("minSdkVersion mismatch between signed and unsigned in v3 signer block.");
        }
        this.mSignerMinSdkVersion = signedMinSDK;
        int signedMaxSDK = signedData.getInt();
        if (signedMaxSDK != maxSdkVersion) {
            throw new SecurityException("maxSdkVersion mismatch between signed and unsigned in v3 signer block.");
        }
        ByteBuffer additionalAttrs = ApkSigningBlockUtils.getLengthPrefixedSlice(signedData);
        return this.verifyAdditionalAttributes(additionalAttrs, certs, certFactory);
    }

    private Pair<X509Certificate[], ApkSigningBlockUtils.VerifiedProofOfRotation> verifyAdditionalAttributes(ByteBuffer attrs, List<X509Certificate> certs, CertificateFactory certFactory) throws IOException, PlatformNotSupportedException {
        X509Certificate[] certChain = certs.toArray(new X509Certificate[certs.size()]);
        ApkSigningBlockUtils.VerifiedProofOfRotation por = null;
        block7: while (attrs.hasRemaining()) {
            ByteBuffer attr2 = ApkSigningBlockUtils.getLengthPrefixedSlice(attrs);
            if (attr2.remaining() < 4) {
                throw new IOException("Remaining buffer too short to contain additional attribute ID. Remaining: " + attr2.remaining());
            }
            int id2 = attr2.getInt();
            switch (id2) {
                case 1000370060: {
                    if (por != null) {
                        throw new SecurityException("Encountered multiple Proof-of-rotation records when verifying APK Signature Scheme v3 signature");
                    }
                    por = ApkSigningBlockUtils.verifyProofOfRotationStruct(attr2, certFactory);
                    try {
                        if (por.certs.size() <= 0 || Arrays.equals(por.certs.get(por.certs.size() - 1).getEncoded(), certChain[0].getEncoded())) continue block7;
                        throw new SecurityException("Terminal certificate in Proof-of-rotation record does not match APK signing certificate");
                    }
                    catch (CertificateEncodingException e) {
                        throw new SecurityException("Failed to encode certificate when comparing Proof-of-rotation record and signing certificate", e);
                    }
                }
                case 1436519170: {
                    if (attr2.remaining() < 4) {
                        throw new IOException("Remaining buffer too short to contain rotation minSdkVersion value. Remaining: " + attr2.remaining());
                    }
                    int attrRotationMinSdkVersion = attr2.getInt();
                    if (!this.mOptionalRotationMinSdkVersion.isPresent()) {
                        throw new SecurityException("Expected a v3.1 signing block targeting SDK version " + attrRotationMinSdkVersion + ", but a v3.1 block was not found");
                    }
                    int rotationMinSdkVersion = this.mOptionalRotationMinSdkVersion.getAsInt();
                    if (rotationMinSdkVersion == attrRotationMinSdkVersion) break;
                    throw new SecurityException("Expected a v3.1 signing block targeting SDK version " + attrRotationMinSdkVersion + ", but the v3.1 block was targeting " + rotationMinSdkVersion);
                }
                case -1029262406: {
                    if (this.mBlockId != 462663009 || _Original_Build.VERSION.SDK_INT != this.mSignerMinSdkVersion || !"REL".equals(_Original_Build.VERSION.CODENAME)) break;
                    this.mOptionalRotationMinSdkVersion = OptionalInt.of(this.mSignerMinSdkVersion);
                    throw new PlatformNotSupportedException("The device is running a release version of " + this.mSignerMinSdkVersion + ", but the signer is targeting a dev release");
                }
            }
        }
        return Pair.create(certChain, por);
    }

    static byte[] getVerityRootHash(String apkPath) throws IOException, SignatureNotFoundException, SecurityException {
        try (RandomAccessFile apk = new RandomAccessFile(apkPath, "r");){
            SignatureInfo signatureInfo = ApkSignatureSchemeV3Verifier.findSignature(apk);
            VerifiedSigner vSigner = ApkSignatureSchemeV3Verifier.verify(apk, false);
            byte[] byArray = vSigner.verityRootHash;
            return byArray;
        }
    }

    static byte[] generateApkVerity(String apkPath, ByteBufferFactory bufferFactory) throws IOException, SignatureNotFoundException, SecurityException, DigestException, NoSuchAlgorithmException {
        try (RandomAccessFile apk = new RandomAccessFile(apkPath, "r");){
            SignatureInfo signatureInfo = ApkSignatureSchemeV3Verifier.findSignature(apk);
            byte[] byArray = VerityBuilder.generateApkVerity(apkPath, bufferFactory, signatureInfo);
            return byArray;
        }
    }

    private static class PlatformNotSupportedException
    extends Exception {
        PlatformNotSupportedException(String s) {
            super(s);
        }
    }

    public static class VerifiedSigner {
        public final X509Certificate[] certs;
        public final ApkSigningBlockUtils.VerifiedProofOfRotation por;
        public final byte[] verityRootHash;
        public final Map<Integer, byte[]> contentDigests;
        public final int blockId;

        public VerifiedSigner(X509Certificate[] certs, ApkSigningBlockUtils.VerifiedProofOfRotation por, byte[] verityRootHash, Map<Integer, byte[]> contentDigests, int blockId) {
            this.certs = certs;
            this.por = por;
            this.verityRootHash = verityRootHash;
            this.contentDigests = contentDigests;
            this.blockId = blockId;
        }
    }
}

