/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.graphics.Insets;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.view.SurfaceControl;

public class RotationUtils {
    public static Insets rotateInsets(Insets insets, int rotation) {
        Insets rotated;
        if (insets == null || insets == Insets.NONE) {
            return insets;
        }
        switch (rotation) {
            case 0: {
                rotated = insets;
                break;
            }
            case 1: {
                rotated = Insets.of(insets.top, insets.right, insets.bottom, insets.left);
                break;
            }
            case 2: {
                rotated = Insets.of(insets.right, insets.bottom, insets.left, insets.top);
                break;
            }
            case 3: {
                rotated = Insets.of(insets.bottom, insets.left, insets.top, insets.right);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown rotation: " + rotation);
            }
        }
        return rotated;
    }

    public static void rotateBounds(Rect inOutBounds, Rect parentBounds, int oldRotation, int newRotation) {
        RotationUtils.rotateBounds(inOutBounds, parentBounds, RotationUtils.deltaRotation(oldRotation, newRotation));
    }

    public static void rotateBounds(Rect inOutBounds, int parentWidth, int parentHeight, int rotation) {
        int origLeft = inOutBounds.left;
        int origTop = inOutBounds.top;
        switch (rotation) {
            case 0: {
                return;
            }
            case 1: {
                inOutBounds.left = inOutBounds.top;
                inOutBounds.top = parentWidth - inOutBounds.right;
                inOutBounds.right = inOutBounds.bottom;
                inOutBounds.bottom = parentWidth - origLeft;
                return;
            }
            case 2: {
                inOutBounds.left = parentWidth - inOutBounds.right;
                inOutBounds.right = parentWidth - origLeft;
                inOutBounds.top = parentHeight - inOutBounds.bottom;
                inOutBounds.bottom = parentHeight - origTop;
                return;
            }
            case 3: {
                inOutBounds.left = parentHeight - inOutBounds.bottom;
                inOutBounds.bottom = inOutBounds.right;
                inOutBounds.right = parentHeight - inOutBounds.top;
                inOutBounds.top = origLeft;
            }
        }
    }

    public static void rotateBounds(Rect inOutBounds, Rect parentBounds, int rotation) {
        RotationUtils.rotateBounds(inOutBounds, parentBounds.right, parentBounds.bottom, rotation);
    }

    public static int deltaRotation(int oldRotation, int newRotation) {
        int delta = newRotation - oldRotation;
        if (delta < 0) {
            delta += 4;
        }
        return delta;
    }

    public static void rotateSurface(SurfaceControl.Transaction t, SurfaceControl sc, int rotation) {
        switch (rotation) {
            case 0: {
                t.setMatrix(sc, 1.0f, 0.0f, 0.0f, 1.0f);
                break;
            }
            case 1: {
                t.setMatrix(sc, 0.0f, -1.0f, 1.0f, 0.0f);
                break;
            }
            case 2: {
                t.setMatrix(sc, -1.0f, 0.0f, 0.0f, -1.0f);
                break;
            }
            case 3: {
                t.setMatrix(sc, 0.0f, 1.0f, -1.0f, 0.0f);
            }
        }
    }

    public static void rotatePoint(Point inOutPoint, int rotation, int parentW, int parentH) {
        int origX = inOutPoint.x;
        switch (rotation) {
            case 0: {
                return;
            }
            case 1: {
                inOutPoint.x = inOutPoint.y;
                inOutPoint.y = parentW - origX;
                return;
            }
            case 2: {
                inOutPoint.x = parentW - inOutPoint.x;
                inOutPoint.y = parentH - inOutPoint.y;
                return;
            }
            case 3: {
                inOutPoint.x = parentH - inOutPoint.y;
                inOutPoint.y = origX;
            }
        }
    }

    public static void transformPhysicalToLogicalCoordinates(int rotation, int physicalWidth, int physicalHeight, Matrix out) {
        switch (rotation) {
            case 0: {
                out.reset();
                break;
            }
            case 1: {
                out.setRotate(270.0f);
                out.postTranslate(0.0f, physicalWidth);
                break;
            }
            case 2: {
                out.setRotate(180.0f);
                out.postTranslate(physicalWidth, physicalHeight);
                break;
            }
            case 3: {
                out.setRotate(90.0f);
                out.postTranslate(physicalHeight, 0.0f);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown rotation: " + rotation);
            }
        }
    }
}

