/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.fonts.FontStyle;
import android.graphics.fonts.FontVariationAxis;
import android.os.LocaleList;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@SystemApi
public class FontConfig
implements Parcelable {
    private final List<FontFamily> mFamilies;
    private final List<Alias> mAliases;
    private final long mLastModifiedTimeMillis;
    private final int mConfigVersion;
    public static final Parcelable.Creator<FontConfig> CREATOR = new Parcelable.Creator<FontConfig>(){

        @Override
        public FontConfig createFromParcel(Parcel source) {
            List<FontFamily> families = source.readParcelableList(new ArrayList(), FontFamily.class.getClassLoader(), FontFamily.class);
            List<Alias> aliases = source.readParcelableList(new ArrayList(), Alias.class.getClassLoader(), Alias.class);
            long lastModifiedDate = source.readLong();
            int configVersion = source.readInt();
            return new FontConfig(families, aliases, lastModifiedDate, configVersion);
        }

        public FontConfig[] newArray(int size) {
            return new FontConfig[size];
        }
    };

    public FontConfig(List<FontFamily> families, List<Alias> aliases, long lastModifiedTimeMillis, int configVersion) {
        this.mFamilies = families;
        this.mAliases = aliases;
        this.mLastModifiedTimeMillis = lastModifiedTimeMillis;
        this.mConfigVersion = configVersion;
    }

    public List<FontFamily> getFontFamilies() {
        return this.mFamilies;
    }

    public List<Alias> getAliases() {
        return this.mAliases;
    }

    public long getLastModifiedTimeMillis() {
        return this.mLastModifiedTimeMillis;
    }

    public int getConfigVersion() {
        return this.mConfigVersion;
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public FontFamily[] getFamilies() {
        return this.mFamilies.toArray(new FontFamily[0]);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelableList(this.mFamilies, flags);
        dest.writeParcelableList(this.mAliases, flags);
        dest.writeLong(this.mLastModifiedTimeMillis);
        dest.writeInt(this.mConfigVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FontConfig that = (FontConfig)o;
        return this.mLastModifiedTimeMillis == that.mLastModifiedTimeMillis && this.mConfigVersion == that.mConfigVersion && Objects.equals(this.mFamilies, that.mFamilies) && Objects.equals(this.mAliases, that.mAliases);
    }

    public int hashCode() {
        return Objects.hash(this.mFamilies, this.mAliases, this.mLastModifiedTimeMillis, this.mConfigVersion);
    }

    public String toString() {
        return "FontConfig{mFamilies=" + this.mFamilies + ", mAliases=" + this.mAliases + ", mLastModifiedTimeMillis=" + this.mLastModifiedTimeMillis + ", mConfigVersion=" + this.mConfigVersion + '}';
    }

    public static class FontFamily
    implements Parcelable {
        private final List<Font> mFonts;
        private final String mName;
        private final LocaleList mLocaleList;
        private final int mVariant;
        public static final int VARIANT_DEFAULT = 0;
        public static final int VARIANT_COMPACT = 1;
        public static final int VARIANT_ELEGANT = 2;
        public static final Parcelable.Creator<FontFamily> CREATOR = new Parcelable.Creator<FontFamily>(){

            @Override
            public FontFamily createFromParcel(Parcel source) {
                List<Font> fonts = source.readParcelableList(new ArrayList(), Font.class.getClassLoader(), Font.class);
                String name = source.readString8();
                String langTags = source.readString8();
                int variant = source.readInt();
                return new FontFamily(fonts, name, LocaleList.forLanguageTags(langTags), variant);
            }

            public FontFamily[] newArray(int size) {
                return new FontFamily[size];
            }
        };

        public FontFamily(List<Font> fonts, String name, LocaleList localeList, int variant) {
            this.mFonts = fonts;
            this.mName = name;
            this.mLocaleList = localeList;
            this.mVariant = variant;
        }

        public List<Font> getFontList() {
            return this.mFonts;
        }

        public String getName() {
            return this.mName;
        }

        public LocaleList getLocaleList() {
            return this.mLocaleList;
        }

        public int getVariant() {
            return this.mVariant;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeParcelableList(this.mFonts, flags);
            dest.writeString8(this.mName);
            dest.writeString8(this.mLocaleList.toLanguageTags());
            dest.writeInt(this.mVariant);
        }

        @Deprecated
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public Font[] getFonts() {
            return this.mFonts.toArray(new Font[0]);
        }

        @Deprecated
        public String getLanguages() {
            return this.mLocaleList.toLanguageTags();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FontFamily that = (FontFamily)o;
            return this.mVariant == that.mVariant && Objects.equals(this.mFonts, that.mFonts) && Objects.equals(this.mName, that.mName) && Objects.equals(this.mLocaleList, that.mLocaleList);
        }

        public int hashCode() {
            return Objects.hash(this.mFonts, this.mName, this.mLocaleList, this.mVariant);
        }

        public String toString() {
            return "FontFamily{mFonts=" + this.mFonts + ", mName='" + this.mName + '\'' + ", mLocaleList=" + this.mLocaleList + ", mVariant=" + this.mVariant + '}';
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Variant {
        }
    }

    public static class Alias
    implements Parcelable {
        private final String mName;
        private final String mOriginal;
        private final int mWeight;
        public static final Parcelable.Creator<Alias> CREATOR = new Parcelable.Creator<Alias>(){

            @Override
            public Alias createFromParcel(Parcel source) {
                String alias = source.readString8();
                String referName = source.readString8();
                int weight = source.readInt();
                return new Alias(alias, referName, weight);
            }

            public Alias[] newArray(int size) {
                return new Alias[size];
            }
        };

        public Alias(String name, String original, int weight) {
            this.mName = name;
            this.mOriginal = original;
            this.mWeight = weight;
        }

        public String getName() {
            return this.mName;
        }

        public String getOriginal() {
            return this.mOriginal;
        }

        public int getWeight() {
            return this.mWeight;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString8(this.mName);
            dest.writeString8(this.mOriginal);
            dest.writeInt(this.mWeight);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Alias alias = (Alias)o;
            return this.mWeight == alias.mWeight && Objects.equals(this.mName, alias.mName) && Objects.equals(this.mOriginal, alias.mOriginal);
        }

        public int hashCode() {
            return Objects.hash(this.mName, this.mOriginal, this.mWeight);
        }

        public String toString() {
            return "Alias{mName='" + this.mName + '\'' + ", mOriginal='" + this.mOriginal + '\'' + ", mWeight=" + this.mWeight + '}';
        }
    }

    public static class Font
    implements Parcelable {
        private final File mFile;
        private final File mOriginalFile;
        private final String mPostScriptName;
        private final FontStyle mStyle;
        private final int mIndex;
        private final String mFontVariationSettings;
        private final String mFontFamilyName;
        public static final Parcelable.Creator<Font> CREATOR = new Parcelable.Creator<Font>(){

            @Override
            public Font createFromParcel(Parcel source) {
                File path = new File(source.readString8());
                String originalPathStr = source.readString8();
                File originalPath = originalPathStr == null ? null : new File(originalPathStr);
                String postScriptName = source.readString8();
                int weight = source.readInt();
                int slant = source.readInt();
                int index = source.readInt();
                String varSettings = source.readString8();
                String fallback = source.readString8();
                return new Font(path, originalPath, postScriptName, new FontStyle(weight, slant), index, varSettings, fallback);
            }

            public Font[] newArray(int size) {
                return new Font[size];
            }
        };

        public Font(File file, File originalFile, String postScriptName, FontStyle style2, int index, String fontVariationSettings, String fontFamilyName) {
            this.mFile = file;
            this.mOriginalFile = originalFile;
            this.mPostScriptName = postScriptName;
            this.mStyle = style2;
            this.mIndex = index;
            this.mFontVariationSettings = fontVariationSettings;
            this.mFontFamilyName = fontFamilyName;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString8(this.mFile.getAbsolutePath());
            dest.writeString8(this.mOriginalFile == null ? null : this.mOriginalFile.getAbsolutePath());
            dest.writeString8(this.mPostScriptName);
            dest.writeInt(this.mStyle.getWeight());
            dest.writeInt(this.mStyle.getSlant());
            dest.writeInt(this.mIndex);
            dest.writeString8(this.mFontVariationSettings);
            dest.writeString8(this.mFontFamilyName);
        }

        public File getFile() {
            return this.mFile;
        }

        public File getOriginalFile() {
            return this.mOriginalFile;
        }

        public FontStyle getStyle() {
            return this.mStyle;
        }

        public String getFontVariationSettings() {
            return this.mFontVariationSettings;
        }

        public String getFontFamilyName() {
            return this.mFontFamilyName;
        }

        public int getTtcIndex() {
            return this.mIndex;
        }

        public String getPostScriptName() {
            return this.mPostScriptName;
        }

        @Deprecated
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public FontVariationAxis[] getAxes() {
            return FontVariationAxis.fromFontVariationSettings(this.mFontVariationSettings);
        }

        @Deprecated
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public int getWeight() {
            return this.getStyle().getWeight();
        }

        @Deprecated
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public boolean isItalic() {
            return this.getStyle().getSlant() == 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Font font = (Font)o;
            return this.mIndex == font.mIndex && Objects.equals(this.mFile, font.mFile) && Objects.equals(this.mOriginalFile, font.mOriginalFile) && Objects.equals(this.mStyle, font.mStyle) && Objects.equals(this.mFontVariationSettings, font.mFontVariationSettings) && Objects.equals(this.mFontFamilyName, font.mFontFamilyName);
        }

        public int hashCode() {
            return Objects.hash(this.mFile, this.mOriginalFile, this.mStyle, this.mIndex, this.mFontVariationSettings, this.mFontFamilyName);
        }

        public String toString() {
            return "Font{mFile=" + this.mFile + ", mOriginalFile=" + this.mOriginalFile + ", mStyle=" + this.mStyle + ", mIndex=" + this.mIndex + ", mFontVariationSettings='" + this.mFontVariationSettings + '\'' + ", mFontFamilyName='" + this.mFontFamilyName + '\'' + '}';
        }
    }
}

