/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.aidl;

import android.net.Uri;
import android.os.RemoteException;
import android.telephony.ims.ImsException;
import android.telephony.ims.RcsContactTerminatedReason;
import android.telephony.ims.aidl.ISubscribeResponseCallback;
import android.telephony.ims.stub.RcsCapabilityExchangeImplBase;
import android.util.Pair;
import java.util.ArrayList;
import java.util.List;

public class RcsSubscribeResponseAidlWrapper
implements RcsCapabilityExchangeImplBase.SubscribeResponseCallback {
    private final ISubscribeResponseCallback mResponseBinder;

    public RcsSubscribeResponseAidlWrapper(ISubscribeResponseCallback responseBinder) {
        this.mResponseBinder = responseBinder;
    }

    @Override
    public void onCommandError(int code) throws ImsException {
        try {
            this.mResponseBinder.onCommandError(code);
        }
        catch (RemoteException e) {
            throw new ImsException(e.getMessage(), 1);
        }
    }

    @Override
    public void onNetworkResponse(int code, String reason) throws ImsException {
        try {
            this.mResponseBinder.onNetworkResponse(code, reason);
        }
        catch (RemoteException e) {
            throw new ImsException(e.getMessage(), 1);
        }
    }

    @Override
    public void onNetworkResponse(int code, String reasonPhrase, int reasonHeaderCause, String reasonHeaderText) throws ImsException {
        try {
            this.mResponseBinder.onNetworkRespHeader(code, reasonPhrase, reasonHeaderCause, reasonHeaderText);
        }
        catch (RemoteException e) {
            throw new ImsException(e.getMessage(), 1);
        }
    }

    @Override
    public void onNotifyCapabilitiesUpdate(List<String> pidfXmls) throws ImsException {
        try {
            this.mResponseBinder.onNotifyCapabilitiesUpdate(pidfXmls);
        }
        catch (RemoteException e) {
            throw new ImsException(e.getMessage(), 1);
        }
    }

    @Override
    public void onResourceTerminated(List<Pair<Uri, String>> uriTerminatedReason) throws ImsException {
        try {
            this.mResponseBinder.onResourceTerminated(this.getTerminatedReasonList(uriTerminatedReason));
        }
        catch (RemoteException e) {
            throw new ImsException(e.getMessage(), 1);
        }
    }

    private List<RcsContactTerminatedReason> getTerminatedReasonList(List<Pair<Uri, String>> uriTerminatedReason) {
        ArrayList<RcsContactTerminatedReason> uriTerminatedReasonList = new ArrayList<RcsContactTerminatedReason>();
        if (uriTerminatedReason != null) {
            for (Pair<Uri, String> pair : uriTerminatedReason) {
                RcsContactTerminatedReason reason = new RcsContactTerminatedReason((Uri)pair.first, (String)pair.second);
                uriTerminatedReasonList.add(reason);
            }
        }
        return uriTerminatedReasonList;
    }

    @Override
    public void onTerminated(String reason, long retryAfterMilliseconds) throws ImsException {
        try {
            this.mResponseBinder.onTerminated(reason, retryAfterMilliseconds);
        }
        catch (RemoteException e) {
            throw new ImsException(e.getMessage(), 1);
        }
    }
}

