/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.RequiresPermission;
import android.compat.Compatibility;
import android.content.Context;
import android.os.Binder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.BarringInfo;
import android.telephony.CallQuality;
import android.telephony.CellIdentity;
import android.telephony.CellInfo;
import android.telephony.LinkCapacityEstimate;
import android.telephony.PhoneCapability;
import android.telephony.PhoneStateListener;
import android.telephony.PhysicalChannelConfig;
import android.telephony.PreciseDataConnectionState;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyCallback;
import android.telephony.TelephonyDisplayInfo;
import android.telephony.TelephonyManager;
import android.telephony.emergency.EmergencyNumber;
import android.telephony.ims.ImsReasonInfo;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.listeners.ListenerExecutor;
import com.android.internal.telephony.ICarrierPrivilegesCallback;
import com.android.internal.telephony.IOnSubscriptionsChangedListener;
import com.android.internal.telephony.ITelephonyRegistry;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

public class TelephonyRegistryManager {
    private static final String TAG = "TelephonyRegistryManager";
    private static ITelephonyRegistry sRegistry;
    private final Context mContext;
    private final Map<SubscriptionManager.OnSubscriptionsChangedListener, IOnSubscriptionsChangedListener> mSubscriptionChangedListenerMap = new HashMap<SubscriptionManager.OnSubscriptionsChangedListener, IOnSubscriptionsChangedListener>();
    private final Map<SubscriptionManager.OnOpportunisticSubscriptionsChangedListener, IOnSubscriptionsChangedListener> mOpportunisticSubscriptionChangedListenerMap = new HashMap<SubscriptionManager.OnOpportunisticSubscriptionsChangedListener, IOnSubscriptionsChangedListener>();
    private static final long LISTEN_CODE_CHANGE = 147600208L;
    public static final int SIM_ACTIVATION_TYPE_VOICE = 0;
    public static final int SIM_ACTIVATION_TYPE_DATA = 1;
    @GuardedBy(value={"sCarrierPrivilegeCallbacks"})
    private static final WeakHashMap<TelephonyManager.CarrierPrivilegesCallback, WeakReference<CarrierPrivilegesCallbackWrapper>> sCarrierPrivilegeCallbacks;

    public TelephonyRegistryManager(Context context) {
        this.mContext = context;
        if (sRegistry == null) {
            sRegistry = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
        }
    }

    public void addOnSubscriptionsChangedListener(final SubscriptionManager.OnSubscriptionsChangedListener listener, final Executor executor) {
        if (this.mSubscriptionChangedListenerMap.get(listener) != null) {
            Log.d(TAG, "addOnSubscriptionsChangedListener listener already present");
            return;
        }
        IOnSubscriptionsChangedListener.Stub callback = new IOnSubscriptionsChangedListener.Stub(){

            @Override
            public void onSubscriptionsChanged() {
                long identity = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> listener.onSubscriptionsChanged());
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        };
        this.mSubscriptionChangedListenerMap.put(listener, callback);
        try {
            sRegistry.addOnSubscriptionsChangedListener(this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), callback);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void removeOnSubscriptionsChangedListener(SubscriptionManager.OnSubscriptionsChangedListener listener) {
        if (this.mSubscriptionChangedListenerMap.get(listener) == null) {
            return;
        }
        try {
            sRegistry.removeOnSubscriptionsChangedListener(this.mContext.getOpPackageName(), this.mSubscriptionChangedListenerMap.get(listener));
            this.mSubscriptionChangedListenerMap.remove(listener);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void addOnOpportunisticSubscriptionsChangedListener(final SubscriptionManager.OnOpportunisticSubscriptionsChangedListener listener, final Executor executor) {
        if (this.mOpportunisticSubscriptionChangedListenerMap.get(listener) != null) {
            Log.d(TAG, "addOnOpportunisticSubscriptionsChangedListener listener already present");
            return;
        }
        IOnSubscriptionsChangedListener.Stub callback = new IOnSubscriptionsChangedListener.Stub(){

            @Override
            public void onSubscriptionsChanged() {
                long identity = Binder.clearCallingIdentity();
                try {
                    Log.d(TelephonyRegistryManager.TAG, "onOpportunisticSubscriptionsChanged callback received.");
                    executor.execute(() -> listener.onOpportunisticSubscriptionsChanged());
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        };
        this.mOpportunisticSubscriptionChangedListenerMap.put(listener, callback);
        try {
            sRegistry.addOnOpportunisticSubscriptionsChangedListener(this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), callback);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void removeOnOpportunisticSubscriptionsChangedListener(SubscriptionManager.OnOpportunisticSubscriptionsChangedListener listener) {
        if (this.mOpportunisticSubscriptionChangedListenerMap.get(listener) == null) {
            return;
        }
        try {
            sRegistry.removeOnSubscriptionsChangedListener(this.mContext.getOpPackageName(), this.mOpportunisticSubscriptionChangedListenerMap.get(listener));
            this.mOpportunisticSubscriptionChangedListenerMap.remove(listener);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void listenFromListener(int subId, boolean renounceFineLocationAccess, boolean renounceCoarseLocationAccess, String pkg, String featureId, PhoneStateListener listener, int events, boolean notifyNow) {
        if (listener == null) {
            throw new IllegalStateException("telephony service is null.");
        }
        try {
            int[] eventsList = this.getEventsFromBitmask(events).stream().mapToInt(i -> i).toArray();
            if (Compatibility.isChangeEnabled(147600208L)) {
                listener.mSubId = eventsList.length == 0 ? -1 : subId;
            } else if (listener.mSubId != null) {
                subId = listener.mSubId;
            }
            sRegistry.listenWithEventList(renounceFineLocationAccess, renounceCoarseLocationAccess, subId, pkg, featureId, listener.callback, eventsList, notifyNow);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void listenFromCallback(boolean renounceFineLocationAccess, boolean renounceCoarseLocationAccess, int subId, String pkg, String featureId, TelephonyCallback telephonyCallback, int[] events, boolean notifyNow) {
        try {
            sRegistry.listenWithEventList(renounceFineLocationAccess, renounceCoarseLocationAccess, subId, pkg, featureId, telephonyCallback.callback, events, notifyNow);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void notifyCarrierNetworkChange(boolean active) {
        try {
            sRegistry.notifyCarrierNetworkChange(active);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyCarrierNetworkChange(int subscriptionId, boolean active) {
        try {
            sRegistry.notifyCarrierNetworkChangeWithSubId(subscriptionId, active);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyCallStateChanged(int slotIndex, int subId, int state, String incomingNumber) {
        try {
            sRegistry.notifyCallState(slotIndex, subId, state, incomingNumber);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MODIFY_PHONE_STATE")
    public void notifyCallStateChangedForAllSubscriptions(int state, String incomingNumber) {
        try {
            sRegistry.notifyCallStateForAllSubs(state, incomingNumber);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifySubscriptionInfoChanged() {
        try {
            sRegistry.notifySubscriptionInfoChanged();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyOpportunisticSubscriptionInfoChanged() {
        try {
            sRegistry.notifyOpportunisticSubscriptionInfoChanged();
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyServiceStateChanged(int slotIndex, int subId, ServiceState state) {
        try {
            sRegistry.notifyServiceStateForPhoneId(slotIndex, subId, state);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifySignalStrengthChanged(int slotIndex, int subId, SignalStrength signalStrength) {
        try {
            sRegistry.notifySignalStrengthForPhoneId(slotIndex, subId, signalStrength);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyMessageWaitingChanged(int slotIndex, int subId, boolean msgWaitingInd) {
        try {
            sRegistry.notifyMessageWaitingChangedForPhoneId(slotIndex, subId, msgWaitingInd);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyCallForwardingChanged(int subId, boolean callForwardInd) {
        try {
            sRegistry.notifyCallForwardingChangedForSubscriber(subId, callForwardInd);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyDataActivityChanged(int subId, int dataActivityType) {
        try {
            sRegistry.notifyDataActivityForSubscriber(subId, dataActivityType);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyDataConnectionForSubscriber(int slotIndex, int subId, PreciseDataConnectionState preciseState) {
        try {
            sRegistry.notifyDataConnectionForSubscriber(slotIndex, subId, preciseState);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyCallQualityChanged(int slotIndex, int subId, CallQuality callQuality, int networkType) {
        try {
            sRegistry.notifyCallQualityChanged(callQuality, slotIndex, subId, networkType);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyEmergencyNumberList(int slotIndex, int subId) {
        try {
            sRegistry.notifyEmergencyNumberList(slotIndex, subId);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyOutgoingEmergencyCall(int phoneId, int subId, EmergencyNumber emergencyNumber) {
        try {
            sRegistry.notifyOutgoingEmergencyCall(phoneId, subId, emergencyNumber);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyOutgoingEmergencySms(int phoneId, int subId, EmergencyNumber emergencyNumber) {
        try {
            sRegistry.notifyOutgoingEmergencySms(phoneId, subId, emergencyNumber);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyRadioPowerStateChanged(int slotIndex, int subId, int radioPowerState) {
        try {
            sRegistry.notifyRadioPowerStateChanged(slotIndex, subId, radioPowerState);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyPhoneCapabilityChanged(PhoneCapability phoneCapability) {
        try {
            sRegistry.notifyPhoneCapabilityChanged(phoneCapability);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyDataActivationStateChanged(int slotIndex, int subId, int activationState) {
        try {
            sRegistry.notifySimActivationStateChangedForPhoneId(slotIndex, subId, 1, activationState);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyVoiceActivationStateChanged(int slotIndex, int subId, int activationState) {
        try {
            sRegistry.notifySimActivationStateChangedForPhoneId(slotIndex, subId, 0, activationState);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyUserMobileDataStateChanged(int slotIndex, int subId, boolean state) {
        try {
            sRegistry.notifyUserMobileDataStateChangedForPhoneId(slotIndex, subId, state);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyDisplayInfoChanged(int slotIndex, int subscriptionId, TelephonyDisplayInfo telephonyDisplayInfo) {
        try {
            sRegistry.notifyDisplayInfoChanged(slotIndex, subscriptionId, telephonyDisplayInfo);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyImsDisconnectCause(int subId, ImsReasonInfo imsReasonInfo) {
        try {
            sRegistry.notifyImsDisconnectCause(subId, imsReasonInfo);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifySrvccStateChanged(int subId, int state) {
        try {
            sRegistry.notifySrvccStateChanged(subId, state);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyPreciseCallState(int slotIndex, int subId, int ringCallPreciseState, int foregroundCallPreciseState, int backgroundCallPreciseState) {
        try {
            sRegistry.notifyPreciseCallState(slotIndex, subId, ringCallPreciseState, foregroundCallPreciseState, backgroundCallPreciseState);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyDisconnectCause(int slotIndex, int subId, int cause, int preciseCause) {
        try {
            sRegistry.notifyDisconnectCause(slotIndex, subId, cause, preciseCause);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyCellLocation(int subId, CellIdentity cellLocation) {
        try {
            sRegistry.notifyCellLocationForSubscriber(subId, cellLocation);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyCellInfoChanged(int subId, List<CellInfo> cellInfo) {
        try {
            sRegistry.notifyCellInfoForSubscriber(subId, cellInfo);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyActiveDataSubIdChanged(int activeDataSubId) {
        try {
            sRegistry.notifyActiveDataSubIdChanged(activeDataSubId);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyRegistrationFailed(int slotIndex, int subId, CellIdentity cellIdentity, String chosenPlmn, int domain, int causeCode, int additionalCauseCode) {
        try {
            sRegistry.notifyRegistrationFailed(slotIndex, subId, cellIdentity, chosenPlmn, domain, causeCode, additionalCauseCode);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyBarringInfoChanged(int slotIndex, int subId, BarringInfo barringInfo) {
        try {
            sRegistry.notifyBarringInfoChanged(slotIndex, subId, barringInfo);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyPhysicalChannelConfigForSubscriber(int slotIndex, int subId, List<PhysicalChannelConfig> configs) {
        try {
            sRegistry.notifyPhysicalChannelConfigForSubscriber(slotIndex, subId, configs);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyDataEnabled(int slotIndex, int subId, boolean enabled, int reason) {
        try {
            sRegistry.notifyDataEnabled(slotIndex, subId, enabled, reason);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyAllowedNetworkTypesChanged(int slotIndex, int subId, int reason, long allowedNetworkType) {
        try {
            sRegistry.notifyAllowedNetworkTypesChanged(slotIndex, subId, reason, allowedNetworkType);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public void notifyLinkCapacityEstimateChanged(int slotIndex, int subId, List<LinkCapacityEstimate> linkCapacityEstimateList) {
        try {
            sRegistry.notifyLinkCapacityEstimateChanged(slotIndex, subId, linkCapacityEstimateList);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    public Set<Integer> getEventsFromCallback(TelephonyCallback telephonyCallback) {
        ArraySet<Integer> eventList = new ArraySet<Integer>();
        if (telephonyCallback instanceof TelephonyCallback.ServiceStateListener) {
            eventList.add(1);
        }
        if (telephonyCallback instanceof TelephonyCallback.MessageWaitingIndicatorListener) {
            eventList.add(3);
        }
        if (telephonyCallback instanceof TelephonyCallback.CallForwardingIndicatorListener) {
            eventList.add(4);
        }
        if (telephonyCallback instanceof TelephonyCallback.CellLocationListener) {
            eventList.add(5);
        }
        if (telephonyCallback instanceof TelephonyCallback.CallStateListener) {
            eventList.add(6);
        }
        if (telephonyCallback instanceof TelephonyCallback.DataConnectionStateListener) {
            eventList.add(7);
        }
        if (telephonyCallback instanceof TelephonyCallback.DataActivityListener) {
            eventList.add(8);
        }
        if (telephonyCallback instanceof TelephonyCallback.SignalStrengthsListener) {
            eventList.add(9);
        }
        if (telephonyCallback instanceof TelephonyCallback.CellInfoListener) {
            eventList.add(11);
        }
        if (telephonyCallback instanceof TelephonyCallback.PreciseCallStateListener) {
            eventList.add(12);
        }
        if (telephonyCallback instanceof TelephonyCallback.CallDisconnectCauseListener) {
            eventList.add(26);
        }
        if (telephonyCallback instanceof TelephonyCallback.ImsCallDisconnectCauseListener) {
            eventList.add(28);
        }
        if (telephonyCallback instanceof TelephonyCallback.PreciseDataConnectionStateListener) {
            eventList.add(13);
        }
        if (telephonyCallback instanceof TelephonyCallback.SrvccStateListener) {
            eventList.add(16);
        }
        if (telephonyCallback instanceof TelephonyCallback.VoiceActivationStateListener) {
            eventList.add(18);
        }
        if (telephonyCallback instanceof TelephonyCallback.DataActivationStateListener) {
            eventList.add(19);
        }
        if (telephonyCallback instanceof TelephonyCallback.UserMobileDataStateListener) {
            eventList.add(20);
        }
        if (telephonyCallback instanceof TelephonyCallback.DisplayInfoListener) {
            eventList.add(21);
        }
        if (telephonyCallback instanceof TelephonyCallback.EmergencyNumberListListener) {
            eventList.add(25);
        }
        if (telephonyCallback instanceof TelephonyCallback.OutgoingEmergencyCallListener) {
            eventList.add(29);
        }
        if (telephonyCallback instanceof TelephonyCallback.OutgoingEmergencySmsListener) {
            eventList.add(30);
        }
        if (telephonyCallback instanceof TelephonyCallback.PhoneCapabilityListener) {
            eventList.add(22);
        }
        if (telephonyCallback instanceof TelephonyCallback.ActiveDataSubscriptionIdListener) {
            eventList.add(23);
        }
        if (telephonyCallback instanceof TelephonyCallback.RadioPowerStateListener) {
            eventList.add(24);
        }
        if (telephonyCallback instanceof TelephonyCallback.CarrierNetworkListener) {
            eventList.add(17);
        }
        if (telephonyCallback instanceof TelephonyCallback.RegistrationFailedListener) {
            eventList.add(31);
        }
        if (telephonyCallback instanceof TelephonyCallback.CallAttributesListener) {
            eventList.add(27);
        }
        if (telephonyCallback instanceof TelephonyCallback.BarringInfoListener) {
            eventList.add(32);
        }
        if (telephonyCallback instanceof TelephonyCallback.PhysicalChannelConfigListener) {
            eventList.add(33);
        }
        if (telephonyCallback instanceof TelephonyCallback.DataEnabledListener) {
            eventList.add(34);
        }
        if (telephonyCallback instanceof TelephonyCallback.AllowedNetworkTypesListener) {
            eventList.add(35);
        }
        if (telephonyCallback instanceof TelephonyCallback.LinkCapacityEstimateChangedListener) {
            eventList.add(37);
        }
        return eventList;
    }

    private Set<Integer> getEventsFromBitmask(int eventMask) {
        ArraySet<Integer> eventList = new ArraySet<Integer>();
        if ((eventMask & 1) != 0) {
            eventList.add(1);
        }
        if ((eventMask & 2) != 0) {
            eventList.add(2);
        }
        if ((eventMask & 4) != 0) {
            eventList.add(3);
        }
        if ((eventMask & 8) != 0) {
            eventList.add(4);
        }
        if ((eventMask & 0x10) != 0) {
            eventList.add(5);
        }
        if ((eventMask & 0x20) != 0) {
            eventList.add(36);
        }
        if ((eventMask & 0x40) != 0) {
            eventList.add(7);
        }
        if ((eventMask & 0x80) != 0) {
            eventList.add(8);
        }
        if ((eventMask & 0x100) != 0) {
            eventList.add(9);
        }
        if ((eventMask & 0x400) != 0) {
            eventList.add(11);
        }
        if ((eventMask & 0x800) != 0) {
            eventList.add(12);
        }
        if ((eventMask & 0x1000) != 0) {
            eventList.add(13);
        }
        if ((eventMask & 0x2000) != 0) {
            eventList.add(14);
        }
        if ((eventMask & 0x8000) != 0) {
            eventList.add(15);
        }
        if ((eventMask & 0x4000) != 0) {
            eventList.add(16);
        }
        if ((eventMask & 0x10000) != 0) {
            eventList.add(17);
        }
        if ((eventMask & 0x20000) != 0) {
            eventList.add(18);
        }
        if ((eventMask & 0x40000) != 0) {
            eventList.add(19);
        }
        if ((eventMask & 0x80000) != 0) {
            eventList.add(20);
        }
        if ((eventMask & 0x100000) != 0) {
            eventList.add(21);
        }
        if ((eventMask & 0x200000) != 0) {
            eventList.add(22);
        }
        if ((eventMask & 0x400000) != 0) {
            eventList.add(23);
        }
        if ((eventMask & 0x800000) != 0) {
            eventList.add(24);
        }
        if ((eventMask & 0x1000000) != 0) {
            eventList.add(25);
        }
        if ((eventMask & 0x2000000) != 0) {
            eventList.add(26);
        }
        if ((eventMask & 0x4000000) != 0) {
            eventList.add(27);
        }
        if ((eventMask & 0x8000000) != 0) {
            eventList.add(28);
        }
        if ((eventMask & 0x10000000) != 0) {
            eventList.add(29);
        }
        if ((eventMask & 0x20000000) != 0) {
            eventList.add(30);
        }
        if ((eventMask & 0x40000000) != 0) {
            eventList.add(31);
        }
        if ((eventMask & Integer.MIN_VALUE) != 0) {
            eventList.add(32);
        }
        return eventList;
    }

    public void registerTelephonyCallback(boolean renounceFineLocationAccess, boolean renounceCoarseLocationAccess, Executor executor, int subId, String pkgName, String attributionTag, TelephonyCallback callback, boolean notifyNow) {
        if (callback == null) {
            throw new IllegalStateException("telephony service is null.");
        }
        callback.init(executor);
        this.listenFromCallback(renounceFineLocationAccess, renounceCoarseLocationAccess, subId, pkgName, attributionTag, callback, this.getEventsFromCallback(callback).stream().mapToInt(i -> i).toArray(), notifyNow);
    }

    public void unregisterTelephonyCallback(int subId, String pkgName, String attributionTag, TelephonyCallback callback, boolean notifyNow) {
        this.listenFromCallback(false, false, subId, pkgName, attributionTag, callback, new int[0], notifyNow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCarrierPrivilegesCallback(int logicalSlotIndex, Executor executor, TelephonyManager.CarrierPrivilegesCallback callback) {
        if (callback == null || executor == null) {
            throw new IllegalArgumentException("callback and executor must be non-null");
        }
        WeakHashMap<TelephonyManager.CarrierPrivilegesCallback, WeakReference<CarrierPrivilegesCallbackWrapper>> weakHashMap = sCarrierPrivilegeCallbacks;
        synchronized (weakHashMap) {
            WeakReference<CarrierPrivilegesCallbackWrapper> existing = sCarrierPrivilegeCallbacks.get(callback);
            if (existing != null && existing.get() != null) {
                Log.d(TAG, "addCarrierPrivilegesCallback: callback already registered");
                return;
            }
            CarrierPrivilegesCallbackWrapper wrapper = new CarrierPrivilegesCallbackWrapper(callback, executor);
            sCarrierPrivilegeCallbacks.put(callback, new WeakReference<CarrierPrivilegesCallbackWrapper>(wrapper));
            try {
                sRegistry.addCarrierPrivilegesCallback(logicalSlotIndex, wrapper, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCarrierPrivilegesCallback(TelephonyManager.CarrierPrivilegesCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("listener must be non-null");
        }
        WeakHashMap<TelephonyManager.CarrierPrivilegesCallback, WeakReference<CarrierPrivilegesCallbackWrapper>> weakHashMap = sCarrierPrivilegeCallbacks;
        synchronized (weakHashMap) {
            WeakReference<CarrierPrivilegesCallbackWrapper> ref = sCarrierPrivilegeCallbacks.remove(callback);
            if (ref == null) {
                return;
            }
            CarrierPrivilegesCallbackWrapper wrapper = (CarrierPrivilegesCallbackWrapper)ref.get();
            if (wrapper == null) {
                return;
            }
            try {
                sRegistry.removeCarrierPrivilegesCallback(wrapper, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void notifyCarrierPrivilegesChanged(int logicalSlotIndex, Set<String> privilegedPackageNames, Set<Integer> privilegedUids) {
        if (privilegedPackageNames == null || privilegedUids == null) {
            throw new IllegalArgumentException("privilegedPackageNames and privilegedUids must be non-null");
        }
        try {
            List<String> pkgList = List.copyOf(privilegedPackageNames);
            int[] uids = privilegedUids.stream().mapToInt(Number::intValue).toArray();
            sRegistry.notifyCarrierPrivilegesChanged(logicalSlotIndex, pkgList, uids);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void notifyCarrierServiceChanged(int logicalSlotIndex, String packageName, int uid) {
        try {
            sRegistry.notifyCarrierServiceChanged(logicalSlotIndex, packageName, uid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static {
        sCarrierPrivilegeCallbacks = new WeakHashMap();
    }

    private static class CarrierPrivilegesCallbackWrapper
    extends ICarrierPrivilegesCallback.Stub
    implements ListenerExecutor {
        private final WeakReference<TelephonyManager.CarrierPrivilegesCallback> mCallback;
        private final Executor mExecutor;

        CarrierPrivilegesCallbackWrapper(TelephonyManager.CarrierPrivilegesCallback callback, Executor executor) {
            this.mCallback = new WeakReference<TelephonyManager.CarrierPrivilegesCallback>(callback);
            this.mExecutor = executor;
        }

        @Override
        public void onCarrierPrivilegesChanged(List<String> privilegedPackageNames, int[] privilegedUids) {
            Set<String> privilegedPkgNamesSet = Set.copyOf(privilegedPackageNames);
            Set privilegedUidsSet = Arrays.stream(privilegedUids).boxed().collect(Collectors.toSet());
            Binder.withCleanCallingIdentity(() -> this.executeSafely(this.mExecutor, this.mCallback::get, cpc -> cpc.onCarrierPrivilegesChanged(privilegedPkgNamesSet, privilegedUidsSet)));
        }

        @Override
        public void onCarrierServiceChanged(String packageName, int uid) {
            Binder.withCleanCallingIdentity(() -> this.executeSafely(this.mExecutor, this.mCallback::get, cpc -> cpc.onCarrierServiceChanged(packageName, uid)));
        }
    }
}

