/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.telephony.UiccAccessRule;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import com.android.internal.telephony.util.TelephonyUtils;
import com.android.telephony.Rlog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SubscriptionInfo
implements Parcelable {
    private static final int TEXT_SIZE = 16;
    private int mId;
    private String mIccId;
    private int mSimSlotIndex;
    private CharSequence mDisplayName;
    private CharSequence mCarrierName;
    private int mCarrierId;
    private int mNameSource;
    private int mIconTint;
    private String mNumber;
    private int mDataRoaming;
    private Bitmap mIconBitmap;
    private String mMcc;
    private String mMnc;
    private String[] mEhplmns;
    private String[] mHplmns;
    private String mCountryIso;
    private boolean mIsEmbedded;
    private UiccAccessRule[] mNativeAccessRules;
    private UiccAccessRule[] mCarrierConfigAccessRules;
    private String mCardString;
    private int mCardId;
    private boolean mIsOpportunistic;
    private ParcelUuid mGroupUUID;
    private String mGroupOwner;
    private boolean mIsGroupDisabled = false;
    private int mProfileClass;
    private int mSubscriptionType;
    private boolean mAreUiccApplicationsEnabled = true;
    private final int mPortIndex;
    private int mUsageSetting = -1;
    public static final Parcelable.Creator<SubscriptionInfo> CREATOR = new Parcelable.Creator<SubscriptionInfo>(){

        @Override
        public SubscriptionInfo createFromParcel(Parcel source) {
            int id2 = source.readInt();
            String iccId = source.readString();
            int simSlotIndex = source.readInt();
            CharSequence displayName = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
            CharSequence carrierName = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
            int nameSource = source.readInt();
            int iconTint = source.readInt();
            String number = source.readString();
            int dataRoaming = source.readInt();
            String mcc = source.readString();
            String mnc = source.readString();
            String countryIso = source.readString();
            boolean isEmbedded = source.readBoolean();
            UiccAccessRule[] nativeAccessRules = source.createTypedArray(UiccAccessRule.CREATOR);
            String cardString = source.readString();
            int cardId = source.readInt();
            int portId = source.readInt();
            boolean isOpportunistic = source.readBoolean();
            String groupUUID = source.readString();
            boolean isGroupDisabled = source.readBoolean();
            int carrierid = source.readInt();
            int profileClass = source.readInt();
            int subType = source.readInt();
            String[] ehplmns = source.createStringArray();
            String[] hplmns = source.createStringArray();
            String groupOwner = source.readString();
            UiccAccessRule[] carrierConfigAccessRules = source.createTypedArray(UiccAccessRule.CREATOR);
            boolean areUiccApplicationsEnabled = source.readBoolean();
            int usageSetting = source.readInt();
            SubscriptionInfo info = new SubscriptionInfo(id2, iccId, simSlotIndex, displayName, carrierName, nameSource, iconTint, number, dataRoaming, null, mcc, mnc, countryIso, isEmbedded, nativeAccessRules, cardString, cardId, isOpportunistic, groupUUID, isGroupDisabled, carrierid, profileClass, subType, groupOwner, carrierConfigAccessRules, areUiccApplicationsEnabled, portId, usageSetting);
            info.setAssociatedPlmns(ehplmns, hplmns);
            return info;
        }

        public SubscriptionInfo[] newArray(int size) {
            return new SubscriptionInfo[size];
        }
    };

    public SubscriptionInfo(SubscriptionInfo info) {
        this(info.mId, info.mIccId, info.mSimSlotIndex, info.mDisplayName, info.mCarrierName, info.mNameSource, info.mIconTint, info.mNumber, info.mDataRoaming, info.mIconBitmap, info.mMcc, info.mMnc, info.mCountryIso, info.mIsEmbedded, info.mNativeAccessRules, info.mCardString, info.mCardId, info.mIsOpportunistic, info.mGroupUUID == null ? null : info.mGroupUUID.toString(), info.mIsGroupDisabled, info.mCarrierId, info.mProfileClass, info.mSubscriptionType, info.mGroupOwner, info.mCarrierConfigAccessRules, info.mAreUiccApplicationsEnabled);
    }

    public SubscriptionInfo(int id2, String iccId, int simSlotIndex, CharSequence displayName, CharSequence carrierName, int nameSource, int iconTint, String number, int roaming, Bitmap icon, String mcc, String mnc, String countryIso, boolean isEmbedded, UiccAccessRule[] nativeAccessRules, String cardString) {
        this(id2, iccId, simSlotIndex, displayName, carrierName, nameSource, iconTint, number, roaming, icon, mcc, mnc, countryIso, isEmbedded, nativeAccessRules, cardString, -1, false, null, false, -1, -1, 0, null, null, true);
    }

    public SubscriptionInfo(int id2, String iccId, int simSlotIndex, CharSequence displayName, CharSequence carrierName, int nameSource, int iconTint, String number, int roaming, Bitmap icon, String mcc, String mnc, String countryIso, boolean isEmbedded, UiccAccessRule[] nativeAccessRules, String cardString, boolean isOpportunistic, String groupUUID, int carrierId, int profileClass) {
        this(id2, iccId, simSlotIndex, displayName, carrierName, nameSource, iconTint, number, roaming, icon, mcc, mnc, countryIso, isEmbedded, nativeAccessRules, cardString, -1, isOpportunistic, groupUUID, false, carrierId, profileClass, 0, null, null, true);
    }

    public SubscriptionInfo(int id2, String iccId, int simSlotIndex, CharSequence displayName, CharSequence carrierName, int nameSource, int iconTint, String number, int roaming, Bitmap icon, String mcc, String mnc, String countryIso, boolean isEmbedded, UiccAccessRule[] nativeAccessRules, String cardString, int cardId, boolean isOpportunistic, String groupUUID, boolean isGroupDisabled, int carrierId, int profileClass, int subType, String groupOwner, UiccAccessRule[] carrierConfigAccessRules, boolean areUiccApplicationsEnabled) {
        this(id2, iccId, simSlotIndex, displayName, carrierName, nameSource, iconTint, number, roaming, icon, mcc, mnc, countryIso, isEmbedded, nativeAccessRules, cardString, cardId, isOpportunistic, groupUUID, isGroupDisabled, carrierId, profileClass, subType, groupOwner, carrierConfigAccessRules, areUiccApplicationsEnabled, 0);
    }

    public SubscriptionInfo(int id2, String iccId, int simSlotIndex, CharSequence displayName, CharSequence carrierName, int nameSource, int iconTint, String number, int roaming, Bitmap icon, String mcc, String mnc, String countryIso, boolean isEmbedded, UiccAccessRule[] nativeAccessRules, String cardString, int cardId, boolean isOpportunistic, String groupUUID, boolean isGroupDisabled, int carrierId, int profileClass, int subType, String groupOwner, UiccAccessRule[] carrierConfigAccessRules, boolean areUiccApplicationsEnabled, int portIndex) {
        this(id2, iccId, simSlotIndex, displayName, carrierName, nameSource, iconTint, number, roaming, icon, mcc, mnc, countryIso, isEmbedded, nativeAccessRules, cardString, cardId, isOpportunistic, groupUUID, isGroupDisabled, carrierId, profileClass, subType, groupOwner, carrierConfigAccessRules, areUiccApplicationsEnabled, portIndex, 0);
    }

    public SubscriptionInfo(int id2, String iccId, int simSlotIndex, CharSequence displayName, CharSequence carrierName, int nameSource, int iconTint, String number, int roaming, Bitmap icon, String mcc, String mnc, String countryIso, boolean isEmbedded, UiccAccessRule[] nativeAccessRules, String cardString, int cardId, boolean isOpportunistic, String groupUUID, boolean isGroupDisabled, int carrierId, int profileClass, int subType, String groupOwner, UiccAccessRule[] carrierConfigAccessRules, boolean areUiccApplicationsEnabled, int portIndex, int usageSetting) {
        this.mId = id2;
        this.mIccId = iccId;
        this.mSimSlotIndex = simSlotIndex;
        this.mDisplayName = displayName;
        this.mCarrierName = carrierName;
        this.mNameSource = nameSource;
        this.mIconTint = iconTint;
        this.mNumber = number;
        this.mDataRoaming = roaming;
        this.mIconBitmap = icon;
        this.mMcc = mcc;
        this.mMnc = mnc;
        this.mCountryIso = countryIso;
        this.mIsEmbedded = isEmbedded;
        this.mNativeAccessRules = nativeAccessRules;
        this.mCardString = cardString;
        this.mCardId = cardId;
        this.mIsOpportunistic = isOpportunistic;
        this.mGroupUUID = groupUUID == null ? null : ParcelUuid.fromString(groupUUID);
        this.mIsGroupDisabled = isGroupDisabled;
        this.mCarrierId = carrierId;
        this.mProfileClass = profileClass;
        this.mSubscriptionType = subType;
        this.mGroupOwner = groupOwner;
        this.mCarrierConfigAccessRules = carrierConfigAccessRules;
        this.mAreUiccApplicationsEnabled = areUiccApplicationsEnabled;
        this.mPortIndex = portIndex;
        this.mUsageSetting = usageSetting;
    }

    public int getSubscriptionId() {
        return this.mId;
    }

    public String getIccId() {
        return this.mIccId;
    }

    public void clearIccId() {
        this.mIccId = "";
    }

    public int getSimSlotIndex() {
        return this.mSimSlotIndex;
    }

    public int getCarrierId() {
        return this.mCarrierId;
    }

    public CharSequence getDisplayName() {
        return this.mDisplayName;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setDisplayName(CharSequence name) {
        this.mDisplayName = name;
    }

    public CharSequence getCarrierName() {
        return this.mCarrierName;
    }

    public void setCarrierName(CharSequence name) {
        this.mCarrierName = name;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int getNameSource() {
        return this.mNameSource;
    }

    public void setAssociatedPlmns(String[] ehplmns, String[] hplmns) {
        this.mEhplmns = ehplmns;
        this.mHplmns = hplmns;
    }

    public Bitmap createIconBitmap(Context context) {
        if (this.mIconBitmap == null) {
            this.mIconBitmap = BitmapFactory.decodeResource(context.getResources(), 17302866);
        }
        int width = this.mIconBitmap.getWidth();
        int height = this.mIconBitmap.getHeight();
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        Bitmap workingBitmap = Bitmap.createBitmap(metrics, width, height, this.mIconBitmap.getConfig());
        Canvas canvas = new Canvas(workingBitmap);
        Paint paint = new Paint();
        paint.setColorFilter(new PorterDuffColorFilter(this.mIconTint, PorterDuff.Mode.SRC_ATOP));
        canvas.drawBitmap(this.mIconBitmap, 0.0f, 0.0f, paint);
        paint.setColorFilter(null);
        paint.setAntiAlias(true);
        paint.setTypeface(Typeface.create("sans-serif", 0));
        paint.setColor(-1);
        paint.setTextSize(16.0f * metrics.density);
        String index = TextUtils.formatSimple("%d", this.mSimSlotIndex + 1);
        Rect textBound = new Rect();
        paint.getTextBounds(index, 0, 1, textBound);
        float xOffset = (float)width / 2.0f - (float)textBound.centerX();
        float yOffset = (float)height / 2.0f - (float)textBound.centerY();
        canvas.drawText(index, xOffset, yOffset, paint);
        return workingBitmap;
    }

    public int getIconTint() {
        return this.mIconTint;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setIconTint(int iconTint) {
        this.mIconTint = iconTint;
    }

    @Deprecated
    public String getNumber() {
        return this.mNumber;
    }

    public void clearNumber() {
        this.mNumber = "";
    }

    public int getDataRoaming() {
        return this.mDataRoaming;
    }

    @Deprecated
    public int getMcc() {
        try {
            return this.mMcc == null ? 0 : Integer.valueOf(this.mMcc);
        }
        catch (NumberFormatException e) {
            Log.w(SubscriptionInfo.class.getSimpleName(), "MCC string is not a number");
            return 0;
        }
    }

    @Deprecated
    public int getMnc() {
        try {
            return this.mMnc == null ? 0 : Integer.valueOf(this.mMnc);
        }
        catch (NumberFormatException e) {
            Log.w(SubscriptionInfo.class.getSimpleName(), "MNC string is not a number");
            return 0;
        }
    }

    public String getMccString() {
        return this.mMcc;
    }

    public String getMncString() {
        return this.mMnc;
    }

    public String getCountryIso() {
        return this.mCountryIso;
    }

    public boolean isEmbedded() {
        return this.mIsEmbedded;
    }

    public boolean isOpportunistic() {
        return this.mIsOpportunistic;
    }

    public ParcelUuid getGroupUuid() {
        return this.mGroupUUID;
    }

    public void clearGroupUuid() {
        this.mGroupUUID = null;
    }

    public List<String> getEhplmns() {
        return this.mEhplmns == null ? Collections.emptyList() : Arrays.asList(this.mEhplmns);
    }

    public List<String> getHplmns() {
        return this.mHplmns == null ? Collections.emptyList() : Arrays.asList(this.mHplmns);
    }

    public String getGroupOwner() {
        return this.mGroupOwner;
    }

    @SystemApi
    public int getProfileClass() {
        return this.mProfileClass;
    }

    public int getSubscriptionType() {
        return this.mSubscriptionType;
    }

    @Deprecated
    public boolean canManageSubscription(Context context) {
        return this.canManageSubscription(context, context.getPackageName());
    }

    @Deprecated
    public boolean canManageSubscription(Context context, String packageName) {
        PackageInfo packageInfo;
        List<UiccAccessRule> allAccessRules = this.getAllAccessRules();
        if (allAccessRules == null) {
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        try {
            packageInfo = packageManager.getPackageInfo(packageName, 0x8000000);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.d("SubscriptionInfo", "canManageSubscription: Unknown package: " + packageName, e);
            return false;
        }
        for (UiccAccessRule rule : allAccessRules) {
            if (rule.getCarrierPrivilegeStatus(packageInfo) != 1) continue;
            return true;
        }
        return false;
    }

    @SystemApi
    public List<UiccAccessRule> getAccessRules() {
        if (this.mNativeAccessRules == null) {
            return null;
        }
        return Arrays.asList(this.mNativeAccessRules);
    }

    public List<UiccAccessRule> getAllAccessRules() {
        ArrayList<UiccAccessRule> merged = new ArrayList<UiccAccessRule>();
        if (this.mNativeAccessRules != null) {
            merged.addAll(this.getAccessRules());
        }
        if (this.mCarrierConfigAccessRules != null) {
            merged.addAll(Arrays.asList(this.mCarrierConfigAccessRules));
        }
        return merged.isEmpty() ? null : merged;
    }

    public String getCardString() {
        return this.mCardString;
    }

    public void clearCardString() {
        this.mCardString = "";
    }

    public int getCardId() {
        return this.mCardId;
    }

    public int getPortIndex() {
        return this.mPortIndex;
    }

    public void setGroupDisabled(boolean isGroupDisabled) {
        this.mIsGroupDisabled = isGroupDisabled;
    }

    @SystemApi
    public boolean isGroupDisabled() {
        return this.mIsGroupDisabled;
    }

    @SystemApi
    public boolean areUiccApplicationsEnabled() {
        return this.mAreUiccApplicationsEnabled;
    }

    public int getUsageSetting() {
        return this.mUsageSetting;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mId);
        dest.writeString(this.mIccId);
        dest.writeInt(this.mSimSlotIndex);
        TextUtils.writeToParcel(this.mDisplayName, dest, 0);
        TextUtils.writeToParcel(this.mCarrierName, dest, 0);
        dest.writeInt(this.mNameSource);
        dest.writeInt(this.mIconTint);
        dest.writeString(this.mNumber);
        dest.writeInt(this.mDataRoaming);
        dest.writeString(this.mMcc);
        dest.writeString(this.mMnc);
        dest.writeString(this.mCountryIso);
        dest.writeBoolean(this.mIsEmbedded);
        dest.writeTypedArray(this.mNativeAccessRules, flags);
        dest.writeString(this.mCardString);
        dest.writeInt(this.mCardId);
        dest.writeInt(this.mPortIndex);
        dest.writeBoolean(this.mIsOpportunistic);
        dest.writeString(this.mGroupUUID == null ? null : this.mGroupUUID.toString());
        dest.writeBoolean(this.mIsGroupDisabled);
        dest.writeInt(this.mCarrierId);
        dest.writeInt(this.mProfileClass);
        dest.writeInt(this.mSubscriptionType);
        dest.writeStringArray(this.mEhplmns);
        dest.writeStringArray(this.mHplmns);
        dest.writeString(this.mGroupOwner);
        dest.writeTypedArray(this.mCarrierConfigAccessRules, flags);
        dest.writeBoolean(this.mAreUiccApplicationsEnabled);
        dest.writeInt(this.mUsageSetting);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static String givePrintableIccid(String iccId) {
        String iccIdToPrint = null;
        if (iccId != null) {
            iccIdToPrint = iccId.length() > 9 && !TelephonyUtils.IS_DEBUGGABLE ? iccId.substring(0, 9) + Rlog.pii(false, (Object)iccId.substring(9)) : iccId;
        }
        return iccIdToPrint;
    }

    public String toString() {
        String iccIdToPrint = SubscriptionInfo.givePrintableIccid(this.mIccId);
        String cardStringToPrint = SubscriptionInfo.givePrintableIccid(this.mCardString);
        return "{id=" + this.mId + " iccId=" + iccIdToPrint + " simSlotIndex=" + this.mSimSlotIndex + " carrierId=" + this.mCarrierId + " displayName=" + this.mDisplayName + " carrierName=" + this.mCarrierName + " nameSource=" + this.mNameSource + " iconTint=" + this.mIconTint + " number=" + Rlog.pii(TelephonyUtils.IS_DEBUGGABLE, (Object)this.mNumber) + " dataRoaming=" + this.mDataRoaming + " iconBitmap=" + this.mIconBitmap + " mcc=" + this.mMcc + " mnc=" + this.mMnc + " countryIso=" + this.mCountryIso + " isEmbedded=" + this.mIsEmbedded + " nativeAccessRules=" + Arrays.toString(this.mNativeAccessRules) + " cardString=" + cardStringToPrint + " cardId=" + this.mCardId + " portIndex=" + this.mPortIndex + " isOpportunistic=" + this.mIsOpportunistic + " groupUUID=" + this.mGroupUUID + " isGroupDisabled=" + this.mIsGroupDisabled + " profileClass=" + this.mProfileClass + " ehplmns=" + Arrays.toString(this.mEhplmns) + " hplmns=" + Arrays.toString(this.mHplmns) + " subscriptionType=" + this.mSubscriptionType + " groupOwner=" + this.mGroupOwner + " carrierConfigAccessRules=" + Arrays.toString(this.mCarrierConfigAccessRules) + " areUiccApplicationsEnabled=" + this.mAreUiccApplicationsEnabled + " usageSetting=" + this.mUsageSetting + "}";
    }

    public int hashCode() {
        return Objects.hash(this.mId, this.mSimSlotIndex, this.mNameSource, this.mIconTint, this.mDataRoaming, this.mIsEmbedded, this.mIsOpportunistic, this.mGroupUUID, this.mIccId, this.mNumber, this.mMcc, this.mMnc, this.mCountryIso, this.mCardString, this.mCardId, this.mDisplayName, this.mCarrierName, this.mNativeAccessRules, this.mIsGroupDisabled, this.mCarrierId, this.mProfileClass, this.mGroupOwner, this.mAreUiccApplicationsEnabled, this.mPortIndex, this.mUsageSetting);
    }

    public boolean equals(Object obj) {
        SubscriptionInfo toCompare;
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        try {
            toCompare = (SubscriptionInfo)obj;
        }
        catch (ClassCastException ex) {
            return false;
        }
        return this.mId == toCompare.mId && this.mSimSlotIndex == toCompare.mSimSlotIndex && this.mNameSource == toCompare.mNameSource && this.mIconTint == toCompare.mIconTint && this.mDataRoaming == toCompare.mDataRoaming && this.mIsEmbedded == toCompare.mIsEmbedded && this.mIsOpportunistic == toCompare.mIsOpportunistic && this.mIsGroupDisabled == toCompare.mIsGroupDisabled && this.mAreUiccApplicationsEnabled == toCompare.mAreUiccApplicationsEnabled && this.mCarrierId == toCompare.mCarrierId && Objects.equals(this.mGroupUUID, toCompare.mGroupUUID) && Objects.equals(this.mIccId, toCompare.mIccId) && Objects.equals(this.mNumber, toCompare.mNumber) && Objects.equals(this.mMcc, toCompare.mMcc) && Objects.equals(this.mMnc, toCompare.mMnc) && Objects.equals(this.mCountryIso, toCompare.mCountryIso) && Objects.equals(this.mCardString, toCompare.mCardString) && Objects.equals(this.mCardId, toCompare.mCardId) && this.mPortIndex == toCompare.mPortIndex && Objects.equals(this.mGroupOwner, toCompare.mGroupOwner) && TextUtils.equals(this.mDisplayName, toCompare.mDisplayName) && TextUtils.equals(this.mCarrierName, toCompare.mCarrierName) && Arrays.equals(this.mNativeAccessRules, toCompare.mNativeAccessRules) && this.mProfileClass == toCompare.mProfileClass && Arrays.equals(this.mEhplmns, toCompare.mEhplmns) && Arrays.equals(this.mHplmns, toCompare.mHplmns) && this.mUsageSetting == toCompare.mUsageSetting;
    }
}

